10 '***************************************************************************
12 '*	PLOT.BAS							      *
13 '*									      *
14 '*	AUTHOR:	D. H. Freese Jr.					      *
15 '*		Clermont Computer Consultants				      *
16 '*									      *
17 '***************************************************************************
18 '
19 '
100 CLEAR 400
110 BS=&H8100		' base address of plotting routines
120 DEF USR0=BS+&H152	' draw line
130 DEF USR1=BS+&HE7	' draw data mark
140 DEF USR2=BS+&H73	' draw pixel
150 DEF USR3=BS+&H65	' initialize plot image
160 DEF USR4=BS+&H633	' transfer image to printer
170 DEF USR5=BS+&H45F	' draw axis
180 DEF USR6=BS+&H24D	' draw circle
190 '
200 ' Definition of variables used in PLOT
210 '	XA - x minimum
220 '	XB - x maximum
230 '	YA - y minimum
240 '	YB - y maximum
250 '	XT - minor tick interval on x axis
260 '	YT - minor tick interval on y axis
270 '	XM - # of minor ticks between major ticks on x axis
280 '	YM - # of minor ticks between major ticks on y axis
290 '	X0,Y0 - axis center values
300 '	X1,X2,Y1,Y2 - x and y data values
310 '	R   - radius of circle
320 '	GR - flag for plotting grid marks on image
330 '
340 X0=0:Y0=0:XT=2:YT=2:XM=10:YM=10:XA=-200:XB=200:YA=-200:YB=200:GR=1:

     GOSUB 710:' default values
350 '
360 ' Scaling functions to convert (X,Y) values to integer

	X and Y may take on values in the following ranges:

		XA <= X <= XB

		YA <= Y <= YB.
370 DEF FNXP%(X)=SGN((X-XA)*XS)*INT(ABS((X-XA)*XS) + .5)
380 DEF FNYP%(Y)=SGN((Y-YA)*YS)*INT(ABS((Y-YA)*YS) + .5)
390 '
400 ' Functions used to extend the USR call with a list of passed
410 ' parameters contained in a string variable.  The string is formed
420 ' by concatenating bytes using the MKI$ function in a manner similar
430 ' to that used in random file data storage.
440 ' plot a pixel at the scaled position (x,y)
450 DEF FNPL(X,Y)=LEN(USR2(MKI$(FNXP%(X))+MKI$(FNYP%(Y))))
460 '
470 ' plot a data mark at the scaled position (x,y)
480 DEF FNCH(X,Y)= LEN(USR1(MKI$(FNXP%(X)) + MKI$(FNYP%(Y))))
490 '
500 ' draw a line between the scaled positions (x1,y1) and (x2,y2)
510 DEF FNLN(X1,Y1,X2,Y2)=

	LEN(USR0(MKI$(FNXP%(X1)) + MKI$(FNYP%(Y1)) +

		 MKI$(FNXP%(X2)) + MKI$(FNYP%(Y2))))
520 '
530 ' clear the plotting image -- all pixels off
540 DEF FNCL=USR3(0)
550 '
560 ' transfer the image to the printer
570 DEF FNTR=USR4(0)
580 '
590 ' Draw axis centered at scaled positon (X0,Y0)

	with minor ticks at intervals XT and YT

	and major ticks at intervals XM and YM.

	Plot grid marks if GR<>0
600 DEF FNAX(X0,Y0,XT,YT,XM,YM,GR)=

	LEN(USR5(MKI$(FNXP%(X0)) + MKI$(FNYP%(Y0)) +

		 MKI$(CINT(XT*XS)) + MKI$(CINT(YT*YS)) +

        	 MKI$(XM*CINT(XT*XS)) + MKI$(YM*CINT(YT*YS)) +

		 MKI$(GR)))
610 '
620 ' Plot a circle centered at (X1,Y1) with radius R

	using the X scale for both ordinated
630 DEF FNCR(X1,Y1,R)=

	LEN(USR6(MKI$(FNXP%(X1)) + MKI$(FNXP%(Y1)) + MKI$(FNXP%(R)))
640 '
650 ' Commonly used H89 screen escape sequences and functions
660 ES$=CHR$(27):  CL$=ES$+"E":  ER$=ES$+"K":

    DEF FNXY$(X,Y)=ES$+"Y"+CHR$(31+X)+CHR$(31+Y):

    DEF FNCN$(D$,L)=FNXY$(L,40-LEN(D$)/2)+D$
670 '
680 GOTO 1000
690 '
700 ' Subroutine to evaluate the scaling values XS and YS
710 XS=400/(XB-XA): YS=400/(YB-YA)
720 IF XT<>0 THEN XS=SGN(XT*XS)*INT(ABS(XT*XS) + .5)/XT
730 IF YT<>0 THEN YS=SGN(YT*YS)*INT(ABS(YT*YS) + .5)/YT
740 RETURN
750 '
1000 ' Plot a bullseye test pattern on the graphics printer.
1010 '
1020 PRINT "Clearing image"
1030	Z=FNCL
1040 PRINT "Plotting axis"
1050	Z=FNAX(X0,Y0,XT,YT,XM,YM,GR)
1060 PRINT "Plotting cross hair lines"
1070	Z=FNLN(-190,-190,190,190)
1080	Z=FNLN(-190,190,190,-190)
1090 PRINT "Plotting data marks on line ends"
1100	Z=FNCH(-190,-190)
1110	Z=FNCH(-190,190)
1120	Z=FNCH(190,190)
1130	Z=FNCH(190,-190)
1140 PRINT "Plotting concentric circles"
1150 FOR I=1 TO 8
1160	Z=FNCR(0,0,25*I)
1170 NEXT I
1180 PRINT "Transfering image to printer"
1190	Z=FNTR
1200 END
les"
1150 FOR I=1 TO 8
1160	Z=FNCR(0,0,25*I)
1170 NEXT I
1180 PRINT "Tra