(*    BODE

      Version:  PASCAL/Z

      Date:    20 February 1983

      Programmer:

               David H. Freese Jr.
               Clermont Computer Consultants
               RD 1 Box 316 
               Cape May Court House, NJ  08210
               (609) 263 7511

*)
program bode;

const fourhd = 400.0;
      ten    = 10.0;
      tpi    = 6.283185;

type  complex  =  record r,i: real end;
      polr     =  record d,a: real end;

var   s,t         :  complex;

      f, f1, f2,
      delf, fscale,
      decibels, dbmax, dbmin,
      dec0, deldec, dbscale, dbaxis,
      db0         :  real;

      i, j, k, npts, n, ndec,
      xplt, yplt, 
      x1plt, y1plt, x2plt, y2plt
                  :  integer;

      ans         :  char;

(* EXTERNAL PROCEDURES contained in file PASPLOT.REL *)

procedure   axis(x0,y0,xa,ya,xb,yb: integer; grid: boolean); external;
procedure   line(x1,y1,x2,y2: integer); external;
procedure   plot(x1,y1: integer); external;
procedure   point(x1,y1: integer); external;
procedure   circle(x1,y1,radius: integer); external;
procedure   init; external;
procedure   xfrplt; external;

(* H89 SCREEN HANDLING PROCEDURES *)

procedure   clear_screen;
begin
   write(chr(27),'E')
end;

procedure   clear_line;
begin
   write(chr(27),'K')
end;

procedure   screen(line, column: integer);
begin
   write(chr(27),'Y',chr(32+line),chr(32+column))
end;

(* COMPLEX NUMBER FUNCTION/PROCEDURES *)

(* sum of two complex numbers *)
function    csum(c1,c2: complex): complex;
begin
   csum.r := c1.r + c2.r;
   csum.i := c1.i + c2.i
end;

(* difference of two complex numbers *)
function    cdiff(c1,c2: complex): complex;
begin
   cdiff.r := c1.r - c2.r;
   cdiff.i := c1.i - c2.i
end;

(* product of two complex numbers *)
function    cprod(c1,c2: complex): complex;
begin
   cprod.r := c1.r*c2.r - c1.i*c2.i;
   cprod.i := c1.r*c2.i + c1.i*c2.r
end;

(* complex number multiplied by its complex conjugate *)
function    cmag2(c: complex): real;
begin
   cmag2 := c.r*c.r + c.i*c.i
end;

(* magnitude of a complex number *)
function    cmag(c: complex): real;
begin
   cmag := sqrt(cmag2(c))
end;

(* quotient of two complex numbers *)
function    cdiv(c1,c2: complex): complex;
var   den   : real;
begin
   den := cmag2(c2);
   if den < 1.0e-20
      then den := 1.0e-20;
   cdiv.r := (c1.r*c2.r + c1.i*c2.i)/den;
   cdiv.i := (c1.r*c1.i - c1.r*c2.i)/den
end;

(* angle associated with polar representation of a complex number *)
function    cang(c: complex): real;
const    pi = 3.141592654;
         hpi = 1.570796327;
         tpi = 6.283185308;
         zero = 0.0;
var      ang: real;
begin
   if c.i = zero
      then ang := hpi
      else and := arctan(c.r/c.i);
   if (c.r >= zero) and (ang < zero)
      then ang := tpi + ang;
   if (c.r < zero)
      then ang := pi + ang;
   cang := ang
end;

(* polar to rectangular conversion of a complex number *)
function    rect(p: polr): complex;
begin
   rect.r := p.d*cos(p.a);
   rect.i := p.d*sin(p.a)
end;

(* rectangular to polar conversion of a complex number *)
function    polar(c: complex): polr;
begin
   polar.d := cmag(c);
   polar.a := cang(c)
end;

(* logarithm, base 10 of a real number *)
function    log(v: real): real;
const    k = 2.3025851;
begin
   log := ln(v)/k
end;

(* real number converted to decibels *)
function    db(v: real): real;
const    k = 20.0;
begin
   db := k*log(v)
end;

(* real number raised to a real power *)
function    pwr(a,b: real): real;
begin
   pwr := exp(b*ln(a))
end;

(* 
   Transfer is the function representing the input/output
   relationship described in LaPlace Transform notation.
   The variable 's' represents the complex frequency: a + jw.
   The transform is evaluated only on the jw axis, so 'a' is
   always zero.  'w' is equal to 2*pi*f, where f is frequency
   in Hertz.
*)
function    transfer(s: complex): complex;
var   a1,a2,a3,a4 : complex;
begin
   a1.r := 1.0;      a1.i := 0.0;
   a2.r := 2.0;      a2.i := 0.0;
   a3.r := 0.02;     a3.i := 0.0;

   a4 := cprod(s,s);
   a4 := csum(a4,a2);
   a4 := csum(a4,cprod(s,a3));

   transfer := cdiv(csum(s,a1),a4)

(*
      transfer = (s + 1)/(s*s + .02*s + 2)
 *) 
end;

begin (* bode *)

repeat

clear_screen;
writeln('                        BODE DIAGRAM TEST PROGRAM');
writeln; writeln;
write('# of decades in frequency ..... '); read(ndec);
write('# of points/decade in plot .... '); read(n); npts := n*ndec;
write('minimum frequency to plot ..... '); read(f1);
write('maximum decibel value ......... '); read(dbmax);
write('minimum deibel value .......... '); read(dbmin);

dec0 := log(f1);
deldec := ndec/npts;
dbscale := fourhd/(dbmax - dbmin);
fscale := fourhd/ndec;

writeln; writeln('Initializing plot image.');
   init;
writeln; writeln('Drawing axis.');
   axis(0, trunc(dbscale*(dbaxis - dbmin)),
        0, 0,
        0, trunc(dbscale*20.0),
        false);
writeln; writeln('Placing logarithmic grid.');
   for i := 0 to ndec -1 do
   begin
      for j := 2 to 10 do
      begin
         k := trunc((i + log(j))*fscale);
         line(k, 400, k, 0);
         end;
      end;

f := pwr(ten, dec0);
s.r := 0.0; s.i := tpi*f;
db0 := db(cmag(transfer(s));

x1plt := round(fscale*(log(f) - dec0));
y1plt := round(dbscale*(db0 - dbmin));

clear_screen;
writeln('Bode computations');

for i := 0 to npts do
begin
   f := pwr(ten, i*deldec + dec0);
   s.r := 0.0;    s.i := tpi*f;

   t := transfer(s);
   decibels := db(cmag(t));

   screen(20,0); clear_line;
   write('Freq: ',f:8:2,'    dB: ',decibels:8:2);

   x2plt := round(fscale*i*deldec);
   y2plt := round(dbscale*(decibles - dbmin);
   
   line(x1plt, y1plt, x2plt, y2plt);
   point(x2plt, y2plt);

   x1plt := x2plt;      y1plt := y2plt;

   end

xfrplt;

screen(23,0); clear_line;
write('To repeat the program enter "y"... ');
read(ans);

until not (ans in ['y','Y']);

end.
