;
; *** Listing 13-15 ***
;
; Copies a zero-terminated string to another string,
; optionally converting characters to uppercase. The
; decision as to whether to convert to uppercase is made
; once at the beginning of the subroutine, with separate
; code executed depending on whether conversion is desired
; or not.
;
	jmp	Skip
;
SourceString	label	byte
	db	'This is a sample string, consisting of '
	db	'both uppercase and lowercase characters.'
	db	0
DestinationString	label	byte
	db	100 dup (?)
;
; Copies a zero-terminated string to another string,
; optionally converting characters to uppercase.
;
; Input:
;	DL = 1 if conversion to uppercase during copying is
;		desired, 0 otherwise
;	DS:SI = source string
;	ES:DI = destination string
;
; Output: none
;
; Registers altered: AL, SI, DI
;
; Direction flag cleared
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
CopyAndConvert:
	cld
	and	dl,dl		;is conversion desired?
	jz	CopyLoop	;no, so just copy the string
;
; Copy the string, converting to uppercase.
;
CopyAndConvertLoop:
	lodsb				;get the next byte
					; to check
	cmp	al,'a'			;less than 'a'?
	jb	CopyAndConvertUC	;yes, not lowercase
	cmp	al,'z'			;greater than 'z'?
	ja	CopyAndConvertUC	;yes, not lowercase
	and	al,not 20h		;make it uppercase
CopyAndConvertUC:
	stosb				;put the byte in the
					; destination string
	and	al,al			;was that the
					; terminating zero?
	jnz	CopyAndConvertLoop	;no, do next byte
	ret
;
; Copy the string without conversion to uppercase.
;
CopyLoop:
	lodsb			;get the next byte to check
	stosb			;copy the byte
	and	al,al		;was that the terminating 0?
	jnz	CopyLoop	;no, do next byte
	ret
;
Skip:
	call	ZTimerOn
;
; First, copy without converting to uppercase.
;
	mov	di,seg DestinationString
	mov	es,di
	mov	di,offset DestinationString
			;ES:DI points to the destination
	mov	si,offset SourceString
			;DS:SI points to the source
	sub	dl,dl	;don't convert to uppercase
	call	CopyAndConvert	;copy without converting
				; to uppercase
;
; Now copy and convert to uppercase.
;
	mov	di,offset DestinationString
			;ES:DI points to the destination
	mov	si,offset SourceString
			;DS:SI points to the source
	mov	dl,1	;convert to uppercase this time
	call	CopyAndConvert	;copy and convert to
				; uppercase
	call	ZTimerOff
