;
; *** Listing 11-20 ***
;
; Tests whether several characters are in the set
; {A,Z,3,!} by using the compare-and-jump approach.
;
	jmp	Skip
;
; Determines whether a given character is in the set
; {A,Z,3,!}.
;
; Input:
;	AL = character to check for inclusion in the set
;
; Output:
;	Z if character is in TestSet, NZ otherwise
;
; Registers altered: none
;
CheckTestSetInclusion:
	cmp	al,'A'	;is it 'A'?
	jz	CheckTestSetInclusionDone ;yes, we're done
	cmp	al,'Z'	;is it 'Z'?
	jz	CheckTestSetInclusionDone ;yes, we're done
	cmp	al,'3'	;is it '3'?
	jz	CheckTestSetInclusionDone ;yes, we're done
	cmp	al,'!'	;is it '!'?
CheckTestSetInclusionDone:
	ret		;the success status is already in
			; the Zero flag
;
Skip:
	call	ZTimerOn
	mov	al,'A'
	call	CheckTestSetInclusion	;check 'A'
	mov	al,'Z'
	call	CheckTestSetInclusion	;check 'Z'
	mov	al,'3'
	call	CheckTestSetInclusion	;check '3'
	mov	al,'!'
	call	CheckTestSetInclusion	;check '!'
	mov	al,' '
	call	CheckTestSetInclusion	;check space, so
					; we get a failed
					; search
	call	ZTimerOff
