;
; *** Listing 11-12 ***
;
; Finds the first occurrence of the letter 'z' in
; a zero-terminated string, using REPNZ SCASB in a
; double-search approach, first finding the terminating
; zero to determine the string length, and then searching
; for the desired byte.
;
	jmp	Skip
;
TestString	label	byte
	db	'This is a test string that is '
	db	'z'
	db	'terminated with a zero byte...',0
;
; Finds the first occurrence of the specified byte in the
; specified zero-terminated string.
;
; Input:
;	AL = byte to find
;	DS:SI = zero-terminated string to search
;
; Output:
;	SI = pointer to first occurrence of byte in string,
;		or 0 if the byte wasn't found
;
; Registers altered: AH, CX, SI, DI, ES
;
; Direction flag cleared
;
; Note: Do not pass a string that starts at offset 0 (SI=0),
;	since a match on the first byte and failure to find
;	the byte would be indistinguishable.
;
; Note: If the search value is 0, will not find the
;	terminating zero in a string that is exactly 64K
;	bytes long. Does not handle strings that are longer
;	than 64K bytes or cross segment boundaries.
;
FindCharInString:
	mov	ah,al	;set aside the byte to be found
	sub	al,al	;we'll search for zero
	push	ds
	pop	es
	mov	di,si	;SCAS uses ES:DI
	mov	cx,0ffffh ;long enough to handle any string
			; up to 64K-1 bytes in length, and
			; will handle 64K case except when
			; the search value is the terminating
			; zero
	cld
	repnz	scasb	;find the terminating zero
	not	cx	;length of string in bytes, including
			; the terminating zero except in the
			; case of a string that's exactly 64K
			; long including the terminating zero
	mov	al,ah	;get back the byte to be found
	mov	di,si	;point to the start of the string again
	repnz	scasb	;search for the byte of interest
	jnz	FindCharInStringNotFound
			;the byte isn't present in the string
	dec	di	;we've found the desired value. Point
			; back to the matching location
	mov	si,di	;return the pointer in SI
	ret
FindCharInStringNotFound:
	sub	si,si	;return a 0 pointer indicating that
			; no match was found
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'z'		;byte value to find
	mov	si,offset TestString
				;string to search
	call	FindCharInString ;search for the byte
	call	ZTimerOff
