;
; *** Listing 7-13 ***
;
; Adds up the elements of a byte-sized array using
; base-only addressing inside the loop, and using
; a memory operand with ADC.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
TestArray	db	ARRAY_LENGTH dup (1)
TEST_START_OFFSET equ	200	;we'll add elements 200-299
TEST_LENGTH	equ	100	; of TestArray
MemZero		db	0	;the constant value 0
;
Skip:
	call	ZTimerOn
	mov	bx,offset TestArray+TEST_START_OFFSET
				;build the array start
				; offset right into the
				; base so we can use
				; base+index addressing,
				; with no displacement
	sub	ax,ax		;initialize sum
	mov	cx,TEST_LENGTH	;# of bytes to add
SumArrayLoop:
	add	al,[bx]		;add in the next byte
	adc	ah,[MemZero]	; to the 16-bit sum
	inc	bx		;point to next byte 
	loop	SumArrayLoop
	call	ZTimerOff
