/*
 * diskette.h
 *
 * Diskette base class.
 * All member functions are pure virtual.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#ifndef _DISKETTE
#define _DISKETTE

#include "file_t.h"
#include "ercode.h"

class diskette {

public:
   virtual void print_directory() = 0;
   // effects: Prints the full directory for the diskette,
   // constrained by the destination, to cout.
   
   virtual void setdest(char *) = 0;
   // effects: Sets the destination file description for this diskette.
   
   // virtual ercode copy(diskette_t) = 0;
   // effects: Copies the source file(s) from the argument to this diskette.
   // returns: Error code.
};
#endif
