
(* J.W. 23.04.90/28.08.90
   Programm formatiert CP/M 86 SS oder DS Format unter Hilfe von
   Dos FORMAT.COM
*)

MODULE CPMFrm;

FROM SYSTEM IMPORT FLAT,PTR,ADR,ADDRESS,WORD,ASSEMBLER;
FROM Loader IMPORT Execute;
FROM System IMPORT GetArg,Terminate,GetEnv;
FROM InOut IMPORT WriteString,WriteLn,Write;
FROM Strings IMPORT CompareStr,Concat;
FROM DiskOps IMPORT DefSeg,poke,ReadSect,WritSect;

CONST EXITCODE=1;

VAR e:CARDINAL;
    p:ARRAY [0..511] OF CHAR;
    ComSpec,cmd:ARRAY [0..31] OF CHAR;
    done,doubleSided:BOOLEAN;
    drv:CARDINAL;

PROCEDURE ExitUsage;
BEGIN
       WriteLn;
       WriteString("CPMFRM Vers 1.1   (C) 1990 by Jrgen Weber");WriteLn;
       WriteLn;
       WriteString("usage: CPMFRM drive [option]");WriteLn;
       WriteString("where drive is A: or B:");WriteLn;
       WriteString("      option is /1 for CP/M 86 Single Sided");
       WriteString(" (default is CP/M 86 Double Sided)");
       WriteLn;WriteLn;
       WriteString("COMMAND.COM must be named in COMSPEC and FORMAT.COM");WriteLn;
       WriteString("must be in a directory named in the PATH.");
       WriteLn;
       WriteString("DO only format ONE disk at a time as the CP/M disk");WriteLn;
       WriteString("will be initialised after calling FORMAT.COM");
       WriteLn;
       Terminate(EXITCODE);
END ExitUsage;

PROCEDURE ExitRWErr;
BEGIN
     WriteString("Disk Error initialising CP/M Area");WriteLn;
     Terminate(EXITCODE);
END ExitRWErr;
PROCEDURE SetFormatByte(FrmByte:CARDINAL);
VAR p1:ADDRESS;
    p2:POINTER TO ADDRESS;
    i:CARDINAL;
    w:WORD;
BEGIN
     p2:=PTR(LONG(4*1EH)); (* Zeiger auf Disk Parameter Table *)
     p1:=p2^;
     INC(p1,8); (* 9.ter Eintrag der Tabelle *)
     w:=p1^;

     (* (w AND 0F0H) OR FrmByte *)
     w:=WORD((BITSET(w) * {8..15}) + BITSET(FrmByte));
     p1^:=w;
END SetFormatByte;


BEGIN (* MAIN *)
    GetEnv("COMSPEC",ComSpec);
    GetArg(p,e);
    cmd:="/C FORMAT ";
    IF (CompareStr(p,"A:")=0) OR (CompareStr(p,"a:")=0) THEN
       Concat(cmd,"A: ",cmd);
       drv:=0;
    ELSIF (CompareStr(p,"B:")=0) OR (CompareStr(p,"b:")=0) THEN
       Concat(cmd,"B: ",cmd);
       drv:=1;
    ELSE
       ExitUsage;
    END;
    GetArg(p,e);
    doubleSided:=TRUE;
    IF (e>0) THEN
       IF (CompareStr(p,"/1")#0)  THEN
          ExitUsage;
       ELSE
          Concat(cmd,"/1 ",cmd);
          doubleSided:=FALSE;
       END;
    END;
    Concat(cmd,"/8 ",cmd);

     SetFormatByte(0E5H);
     WriteString("FORMATTING disc in drive ");IF drv=0 THEN Write('A')
                                                       ELSE Write('B') END;
     WriteString(": !!");WriteLn;                                               
     Execute(ComSpec,cmd,e);
     SetFormatByte(0F6H);
     WriteLn;
     IF e=2 THEN
        WriteString('Could not find \COMMAND.COM');WriteLn;
        ExitUsage;
     END;
(* Dos Plus Zeichen SS/DS eintragen *)
     e:=ReadSect(ADR(p),drv,0,0,1);
     IF e>0 THEN
        ExitRWErr;
     END;
     DefSeg(ADR(p));
     IF doubleSided THEN
        poke(511,1C);
     ELSE
        poke(511,0C);
     END;
     e:=WritSect(ADR(p),drv,0,0,1);
     IF e>0 THEN
        ExitRWErr;
     END;

(* Dos Plus Zeichen CP/M 86 eintragen *)
     e:=ReadSect(ADR(p),drv,0,0,2);
     IF e>0 THEN
        ExitRWErr;
     END;
     poke(0,CHR(0F6H));
     poke(1,CHR(0F6H));
     poke(2,CHR(0F6H));
     e:=WritSect(ADR(p),drv,0,0,2);
     IF e>0 THEN
        ExitRWErr;
     END;

END CPMFrm.
