      SUBROUTINE NN3AL(E,W,COSL,X,C,ELT)
C
      DIMENSION X(3),C(3)
      COMMON /MASS/ RM1,RM2,RM3,RM4,RM2A,QQ,RM5,RM6
      COMMON /ENG/ U
C
      EXTERNAL ENGDIS
C
C  START OF NN3AL --------------------------------------------------
C  SIMULATES THE REACTION N+C--N+THREE ALPHAS
C  PHASE SPACE ENERGY DISTRIBUTION OF OUTGOING NEUTRON ASSUMED.
C
      WCM=E*.923+QQ
      IF(WCM) 2,2,15004
    2 W =E
      COSL=1.
      GOTO 9500
C
C  MAXIMUM NEUTRON ENERGY IN CM
C
15004 TM=.923*WCM
C
C  SIMULATE PHASE SPECE DISTRIBUTION FOR OUTGOING NEUTRON
C
      U=FNCRAN()
      X3=.01
      IF(U .LE. .01) GO TO 3
      CALL RTNI(X3,FN,DV,ENGDIS,.5,.001,20,IER)
      IF(IER .NE. 0) WRITE(6,15001) IER,X3,FN,DV
15001 FORMAT (' ','ERRNN3AL ',I3,3E12.4)
    3 T=TM*X3
      IF(T .LE. 0.) T=0.
C
C  FIND THE LAB ENERGY EN AND COSINE COSL OF THE LAB ASCATTERING ANGLE
C  FOR THE OUTGOING NEUTRON
C
      PCM=SQRT(2.*RM1*T)
      VB=SQRT(2.*RM1*E)/(RM1+RM2)
C
C  ISOTROPIC CM ANGULAR DISTRIBUTION OF THE NEUTRON IS ASSUMED.
C
      COSCM=-1.+2.*FNCRAN()
      W =T+PCM*VB*COSCM+.5*RM1*VB**2
      IF(W  .LE. 0.) W =0.
      PN=SQRT(2.*RM1*W )
      COSL=(PCM*COSCM+RM1*VB)/PN
      TR=E-W +QQ
      DO 15 I =1,2
      TA=TR*FNCRAN()
      ELT=EEQUIV(TA,X,C,FNCRAN(),4)+ELT
   15 TR=TR-TA
      ELT=EEQUIV(TR,X,C,FNCRAN(),4)+ELT
 9500 RETURN
C
C      END OF NN3AL-----------------------------------------------------
C
      END

