C
C----------------------------------------------------------------
C
C     RELATIVISTIC KINEMATICS FOR TWO BODY SCATTERING PROBLEM
C
C     ADAPTED FROM J. B. MARION AND J. L. FOWLER
C     "FAST NEUTRON PHYSICS, PART 1", PAGES 51-55, VOL 4 OF
C     INTERSCIENCE MONOGRAPHS AND TEXTS IN PHY.+ASTRO., 1960 NY.NY.
C
C-------------------------------------------------------------------
C
      SUBROUTINE KINNR(EM1,EM2,EM3,EM4,T1,CSCM,VB,WCM,PCM,CSL,T3)
C
      P1=SQRT(T1*(T1+2.*EM1))
      W1=T1+EM1
      WCM=.5*(EM1*EM1+EM2*EM2+EM3*EM3-EM4*EM4+2.*EM2*W1)
      IF(WCM.LE.0.0) GOTO 10
      WCM=WCM/SQRT(EM1*EM1+EM2*EM2+2.*EM2*W1)
      IF (WCM.LE.EM3) GOTO 10
      PCM=SQRT(WCM*WCM-EM3*EM3)
      B0=P1/(W1+EM2)
      G0=1./SQRT(1.-B0*B0)
      T3=G0*(WCM+B0*PCM*CSCM)-EM3
      IF (T3 .LT. .001)  T3=.001
      CSL=G0*(PCM*CSCM+B0*WCM)/SQRT(T3*(T3+2.*EM3))
      IF (CSL .GT. 1.0)  CSL=1.0
      VB=PCM/(G0*EM3)
      RETURN
   10 WCM=0.
      PCM=0.
      T3=0.
      VB=0.
      CSL=1.
      RETURN
      END
