      SUBROUTINE FOLGAM(X,C,E,EMIN,ELIGHT)
C
C  MONTE CARLO GAMMA RAY TRACER
C  GIVEN A GAMMA-RAY OF ENERGY E AT POSITION X(I), MOVING ALONG DIRECTION
C  COSINES C(I), FOLGAM FOLLOWS THE GAMMA THRU SUCCESSIVE COMPTON
C  COLLISIONS UNTIL IT ESCAPES FROM THE SCINTILLATOR OR ITS ENERGY FALLS
C  BELOW EMIN. FOLGAM RETURNS ELIGHT, SUM OF ELECTRON REAL ENERGIES
C
      DIMENSION X(3),C(3)
      COMMON /SCIN/ DHYD,DCARB,IGEO,XB,YB,ZB
C
      ELIGHT=0.
      NSMAX=10
      NS=0
C
C  CMPSCT(0,E,SIGT,Y,Y,Y) RETURNS THE TOTAL COMPTON SCATTERING CROSS
C  SECTION SIGT (BARNS) PER ELECTRON FOR A GAMMA OF ENERGY E.
C  Y IS A DUMMY. DHYD AND 6.*DCARB ARE THE NUMBER OF HYDROGEN AND
C  CARBON ELECTRONS PER BARN-INCH
C
 1000 CALL CMPSCT(0,E,SIGT,Y,Y,Y)
      PATH=1./(SIGT*(DHYD+6.*DCARB))
C
C  PROPAGATE GAMMA A DISTANCE D TO NEXT SCATTER
C
      D=-PATH*ALOG(FNCRAN())
      DO 20 I=1,3
   20 X(I)=X(I)+C(I)*D
C
C  IS GAMMA STILL IN SCINTILLATOR
C
      IF(INBNDS(X) .LE. 0) GOTO 30
      NS=NS+1
      IF(NS .GT. NSMAX) GOTO 30
C
C  SIMULATE A COMPTON COLLISION
C
      CALL CMPSCT(1,E,SIGT,EEL,E,COSGAM)
      ELIGHT=ELIGHT+EEL
      IF(E .LE. EMIN) GOTO 30
      PHI=6.2832*FNCRAN()
C
C  FIND NEW DIRECTION COSINES
C
      CALL SCATTR(C,COSGAM,PHI,C)
      GO TO 1000
   30 RETURN
      END

