/* ds8pst.c */

/*
 * Modified from i51pst.c
 * Bill McKinnon
 * w_mckinnon@conknet.com
 *
 * (C) Copyright 1998-2002
 * All Rights Reserved
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 *
 *   This Assember Ported by
 *	John L. Hartman	(JLH)
 *	jhartman@compuserve.com
 *
 */

#include <stdio.h>
#include <setjmp.h>
#include "asxxxx.h"
#include "ds8.h"

struct	mne	mne[] = {

	/* machine */
    {	NULL,	".DS8XCXXX",	X_PTYPE,	0,	DS8xCxxx	},
    {	NULL,	".DS80C310",	X_PTYPE,	0,	DS80C310	},
    {	NULL,	".DS80C320",	X_PTYPE,	0,	DS80C320	},
    {	NULL,	".DS80C323",	X_PTYPE,	0,	DS80C323	},
    {	NULL,	".DS80C390",	X_PTYPE,	0,	DS80C390	},
    {	NULL,	".DS83C520",	X_PTYPE,	0,	DS83C520	},
    {	NULL,	".DS83C530",	X_PTYPE,	0,	DS83C530	},
    {	NULL,	".DS83C550",	X_PTYPE,	0,	DS83C550	},
    {	NULL,	".DS87C520",	X_PTYPE,	0,	DS87C520	},
    {	NULL,	".DS87C530",	X_PTYPE,	0,	DS87C530	},
    {	NULL,	".DS87C550",	X_PTYPE,	0,	DS87C550	},

    {	NULL,	".amode",	X_AMODE,	0,	0	},

	/* system */

    {	NULL,	"CON",		S_ATYP,		0,	A_CON	},
    {	NULL,	"OVR",		S_ATYP,		0,	A_OVR	},
    {	NULL,	"REL",		S_ATYP,		0,	A_REL	},
    {	NULL,	"ABS",		S_ATYP,		0,	A_ABS|A_OVR	},
    {	NULL,	"NOPAG",	S_ATYP,		0,	A_NOPAG	},
    {	NULL,	"PAG",		S_ATYP,		0,	A_PAG	},

    {	NULL,	".byte",	S_DATA,		0,	1	},
    {	NULL,	".db",		S_DATA,		0,	1	},
    {	NULL,	".word",	S_DATA,		0,	2	},
    {	NULL,	".dw",		S_DATA,		0,	2	},
    {	NULL,	".3byte",	S_DATA,		0,	3	},
    {	NULL,	".ascii",	S_ASCII,	0,	0	},
    {	NULL,	".asciz",	S_ASCIZ,	0,	0	},
    {	NULL,	".blkb",	S_BLK,		0,	1	},
    {	NULL,	".ds",		S_BLK,		0,	1	},
    {	NULL,	".blkw",	S_BLK,		0,	2	},
    {	NULL,	".blk3",	S_BLK,		0,	3	},
    {	NULL,	".page",	S_PAGE,		0,	0	},
    {	NULL,	".title",	S_TITLE,	0,	0	},
    {	NULL,	".sbttl",	S_SBTL,		0,	0	},
    {	NULL,	".globl",	S_GLOBL,	0,	0	},
    {	NULL,	".area",	S_DAREA,	0,	0	},
    {	NULL,	".even",	S_EVEN,		0,	0	},
    {	NULL,	".odd",		S_ODD,		0,	0	},
    {	NULL,	".if",		S_IF,		0,	0	},
    {	NULL,	".else",	S_ELSE,		0,	0	},
    {	NULL,	".endif",	S_ENDIF,	0,	0	},
    {	NULL,	".include",	S_INCL,		0,	0	},
    {	NULL,	".radix",	S_RADIX,	0,	0	},
    {	NULL,	".org",		S_ORG,		0,	0	},
    {	NULL,	".module",	S_MODUL,	0,	0	},
    {	NULL,	".ascis",	S_ASCIS,	0,	0	},
    {	NULL,	".assume",	S_ERROR,	0,	0	},
    {	NULL,	".error",	S_ERROR,	0,	1	},
    {	NULL,	".16bit",	S_BITS,		0,	2	},
    {	NULL,	".24bit",	S_BITS,		0,	3	},
    {	NULL,	".32bit",	S_BITS,		0,	4	},

    	/* machine */
    {	NULL,	"a",		S_A,		0,	A	},
    {	NULL,	"ab",		S_AB,		0,	0	},
    {	NULL,	"dptr",		S_DPTR,		0,	DPTR	},
    {	NULL,	"pc",		S_PC,		0,	PC	},
    {	NULL,	"r0",		S_REG,		0,	R0	},
    {	NULL,	"r1",		S_REG,		0,	R1	},
    {	NULL,	"r2",		S_REG,		0,	R2	},
    {	NULL,	"r3",		S_REG,		0,	R3	},
    {	NULL,	"r4",		S_REG,		0,	R4	},
    {	NULL,	"r5",		S_REG,		0,	R5	},
    {	NULL,	"r6",		S_REG,		0,	R6	},
    {	NULL,	"r7",		S_REG,		0,	R7	},

    {	NULL,	"nop",		S_INH,		0,	0x00	},
    {	NULL,	"ret",		S_INH,		0,	0x22	},
    {	NULL,	"reti",		S_INH,		0,	0x32	},

    {	NULL,	"ajmp",		S_JMP11,	0,	0x01	},
    {	NULL,	"acall",	S_JMP11,	0,	0x11	},
    {	NULL,	"ljmp",		S_JMP16,	0,	0x02	},
    {	NULL,	"lcall",	S_JMP16,	0,	0x12	},

    {	NULL,	"rr",		S_ACC,		0,	0x03	},
    {	NULL,	"rrc",		S_ACC,		0,	0x13	},
    {	NULL,	"rl",		S_ACC,		0,	0x23	},
    {	NULL,	"rlc",		S_ACC,		0,	0x33	},
    {	NULL,	"swap",		S_ACC,		0,	0xC4	},
    {	NULL,	"da",		S_ACC,		0,	0xD4	},

    {	NULL,	"inc",		S_TYP1,		0,	0x00	},
    {	NULL,	"dec",		S_TYP1,		0,	0x10	},

    {	NULL,	"add",		S_TYP2,		0,	0x20	},
    {	NULL,	"addc",		S_TYP2,		0,	0x30	},
    {	NULL,	"subb",		S_TYP2,		0,	0x90	},

    {	NULL,	"orl",		S_TYP3,		0,	0x40	},
    {	NULL,	"anl",		S_TYP3,		0,	0x50	},
    {	NULL,	"xrl",		S_TYP3,		0,	0x60	},

    {	NULL,	"xch",		S_TYP4,		0,	0xC0	},

    {	NULL,	"mov",		S_MOV,		0,	0x00	},

    {	NULL,	"jbc",		S_BITBR,	0,	0x10	},
    {	NULL,	"jb",		S_BITBR,	0,	0x20	},
    {	NULL,	"jnb",		S_BITBR,	0,	0x30	},

    {	NULL,	"jc",		S_BR,		0,	0x40	},
    {	NULL,	"jnc",		S_BR,		0,	0x50	},
    {	NULL,	"jz",		S_BR,		0,	0x60	},
    {	NULL,	"jnz",		S_BR,		0,	0x70	},
    {	NULL,	"sjmp",		S_BR,		0,	0x80	},

    {	NULL,	"cjne",		S_CJNE,		0,	0xB0	},
    {	NULL,	"djnz",		S_DJNZ,		0,	0xD0	},
    {	NULL,	"jmp",		S_JMP,		0,	0x73	},
    {	NULL,	"movc",		S_MOVC,		0,	0x83	},
    {	NULL,	"movx",		S_MOVX,		0,	0x00	},
    {	NULL,	"div",		S_AB,		0,	0x84	},
    {	NULL,	"mul",		S_AB,		0,	0xA4	},
    {	NULL,	"clr",		S_ACBIT,	0,	0xC2	},
    {	NULL,	"cpl",		S_ACBIT,	0,	0xB2	},
    {	NULL,	"setb",		S_SETB,		0,	0xD2	},
    {	NULL,	"push",		S_DIRECT,	0,	0xC0	},
    {	NULL,	"pop",		S_DIRECT,	0,	0xD0	},
    {	NULL,	"xchd",		S_XCHD,		S_END,	0xD6	}
};


/*
 * PreDefined Symbols For Processors
 */

/*
#define	CXXX	DS8xCxxx
#define	C310	DS80C310
#define	C320	DS80C320
#define	C323	DS80C323
#define	C390	DS80C390
#define	C520	DS83C520|DS87C520
#define	C530	DS83C530|DS87C530
#define	C550	DS83C550|DS87C550
*/

struct PreDef preDef[] = {

{	"PORT0",	0x0080,	C520|C530|C550	},
{	"P0",		0x0080,	C520|C530|C550	},
   {	"P0.0",		0x0080,	C520|C530|C550	},
   {	"P0.1",		0x0081,	C520|C530|C550	},
   {	"P0.2",		0x0082,	C520|C530|C550	},
   {	"P0.3",		0x0083,	C520|C530|C550	},
   {	"P0.4",		0x0084,	C520|C530|C550	},
   {	"P0.5",		0x0085,	C520|C530|C550	},
   {	"P0.6",		0x0086,	C520|C530|C550	},
   {	"P0.7",		0x0087,	C520|C530|C550	},

{	"PORT4",	0x0080,	C390	},
{	"P4",		0x0080,	C390	},
   {	"P4.0",		0x0080,	C390	},
   {	"P4.1",		0x0081,	C390	},
   {	"P4.2",		0x0082,	C390	},
   {	"P4.3",		0x0083,	C390	},
   {	"P4.4",		0x0084,	C390	},
   {	"P4.5",		0x0085,	C390	},
   {	"P4.6",		0x0086,	C390	},
   {	"P4.7",		0x0087,	C390	},

{	"SP",		0x0081,	CXXX|C310|C320|C323|C390|C520|C530|C520|C530|C550	},
{	"DPL",		0x0082,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"DPH",		0x0083,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"DPL1",		0x0084, C310|C320|C323|C390|C520|C530|C550	},
{	"DPH1",		0x0085, C310|C320|C323|C390|C520|C530|C550	},
{	"DPS",		0x0086, C310|C320|C323|C390|C520|C530|C550	},
   {	"ID1",		0x80,	SFR_BITS|C390|C550	},
   {	"ID0",		0x40,	SFR_BITS|C390|C550	},
   {	"TSL",		0x20,	SFR_BITS|C390|C550	},
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
/* {	"",		0x02,	SFR_BITS	}, */
   {	"SEL",		0x01,	SFR_BITS|C310|C320|C323|C390|520|C530|C550	},
{	"PCON",		0x0087,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SMOD",		0x80,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},
   {	"SMOD_0",	0x80,	SFR_BITS|C320|C323|C390|520|C530|C550	},
   {	"SMOD0",	0x40,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},
   {	"OFDF",		0x20,	SFR_BITS|C390|C550	},
   {	"OFDE",		0x10,	SFR_BITS|C390|C550	},
   {	"GF1",		0x08,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},
   {	"GF0",		0x04,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},
   {	"STOP",		0x02,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},
   {	"IDLE",		0x01,	SFR_BITS|CXXX|C310|C320|C323|C390|520|C530|C550	},

{	"TCON",		0x0088,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.0",	0x0088,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.1",	0x0089,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.2",	0x008A,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.3",	0x008B,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.4",	0x008C,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.5",	0x008D,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.6",	0x008E,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TCON.7",	0x008F,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IT0",		0x0088,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE0",		0x0089,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IT1",		0x008A,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE1",		0x008B,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TR0",		0x008C,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TF0",		0x008D,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TR1",		0x008E,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TF1",	 	0x008F,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"TMOD",		0x0089,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T1GATE",	0x80,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T1C_T",	0x40,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T1M1",		0x20,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T1M0",		0x10,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T0GATE",	0x08,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T0C_T",	0x04,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T0M1",		0x02,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T0M0",		0x01,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"TL0",		0x008A,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"TL1",		0x008B,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"TH0",		0x008C,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"TH1",		0x008D,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"CKCON",	0x008E, C310|C320|C323|C390|C520|C530|C550	},
   {	"WD1",		0x80,	SFR_BITS|C320|C323|C390|C520|C530|C550	},
   {	"WD0",		0x40,	SFR_BITS|C320|C323|C390|C520|C530|C550	},
   {	"T2M",		0x20,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},
   {	"T1M",		0x10,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},
   {	"T0M",		0x08,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},
   {	"MD2",		0x04,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},
   {	"MD1",		0x02,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},
   {	"MD0",		0x01,	SFR_BITS|C310|C320|C323|C390|C520|C530|C550	},

{	"PORT1",	0x0090,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"P1",		0x0090,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.0",		0x0090,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.1",		0x0091,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.2",		0x0092,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.3",		0x0093,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.4",		0x0094,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.5",		0x0095,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.6",		0x0096,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P1.7",		0x0097,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"T2",		0x0090,	C390	},
   {	"T2EX",		0x0091,	C390	},
   {	"RXD1",		0x0092,	C390	},
   {	"TXD1",		0x0093,	C390	},
   {	"INT2",		0x0094,	C390	},
   {	"INT3",		0x0095,	C390	},
   {	"INT4",		0x0096,	C390	},
   {	"INT5",		0x0097,	C390	},

{	"EXIF",		0x0091, C310|C320|C323|C390|C520|C530	},
   {	"IE5",		0x80,	SFR_BITS|C310|C320|C323|C390|C520|C530	},
   {	"IE4",		0x40,	SFR_BITS|C310|C320|C323|C390|C520|C530	},
   {	"IE3",		0x20,	SFR_BITS|C310|C320|C323|C390|C520|C530	},
   {	"IE2",		0x10,	SFR_BITS|C310|C320|C323|C390|C520|C530	},
   {	"CKRY",		0x08,	SFR_BITS|C390	},
   {	"XT_RG",	0x08,	SFR_BITS|C520|C530	},
   {	"RGMD",		0x04,	SFR_BITS|C320|C323|C390|C520|C530	},
   {	"RGSL",		0x02,	SFR_BITS|C320|C323|C390|C520|C530	},
   {	"BGS",		0x01,	SFR_BITS|C320|C323|C390|C520|C530	},
{	"RCON",		0x0091,	C550	},
/* {	"",		0x80,	SFR_BITS	}, */
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
   {	"CKRDY",	0x08,	SFR_BITS|C550	},
   {	"RGMD",		0x04,	SFR_BITS|C550	},
   {	"RGSL",		0x02,	SFR_BITS|C550	},
   {	"BGS",		0x01,	SFR_BITS|C550	},
{	"P4CNT",	0x0092,	C390	},
/* {	"",		0x80,	SFR_BITS	}, */
   {	"SBCAN",	0x40,	SFR_BITS|C390	},
   {	"P4CNT.5",	0x20,	SFR_BITS|C390	},
   {	"P4CNT.4",	0x10,	SFR_BITS|C390	},
   {	"P4CNT.3",	0x08,	SFR_BITS|C390	},
   {	"P4CNT.2",	0x04,	SFR_BITS|C390	},
   {	"P4CNT.1",	0x02,	SFR_BITS|C390	},
   {	"P4CNT.0",	0x01,	SFR_BITS|C390	},
{	"DPX",		0x0093,	C390	},
/* {	"",		0x0094,	0	},	*/
{	"DPX1",		0x0095,	C390	},
{	"TRIM",		0X0096, C530	},
   {	"E4K",		0x80,	SFR_BITS|C530	},
   {	"X12_6",	0x40,	SFR_BITS|C530	},
   {	"TRM2",		0x20,	SFR_BITS|C530	},
   {	"_TRM2",	0x10,	SFR_BITS|C530	},
   {	"TRM1",		0x08,	SFR_BITS|C530	},
   {	"_TRM1",	0x04,	SFR_BITS|C530	},
   {	"TRM0",		0x02,	SFR_BITS|C530	},
   {	"_TRM0",	0x01,	SFR_BITS|C530	},
{	"CORMS0",	0x0096,	C390	},
{	"CORMS1",	0x0097,	C390	},

{	"SCON",		0x0098,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.0",	0x0098,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.1",	0x0099,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.2",	0x009A,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.3",	0x009B,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.4",	0x009C,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.5",	0x009D,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.6",	0x009E,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SCON.7",	0x009F,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"RI",		0x0098,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TI",		0x0099,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"RB8",		0x009A,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"TB8",		0x009B,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"REN",		0x009C,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SM2",		0x009D,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SM1",		0x009E,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"SM0",		0x009F,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"FE",		0x009F,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"SCON0",	0x0098, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.0",	0x0098, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.1",	0x0099, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.2",	0x009A, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.3",	0x009B, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.4",	0x009C, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.5",	0x009D, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.6",	0x009E, C320|C323|C390|C520|C530|C550	},
   {	"SCON0.7",	0x009F, C320|C323|C390|C520|C530|C550	},
   {	"RI_O",		0x0098, C320|C323|C390|C520|C530|C550	},
   {	"TI_O",		0x0099, C320|C323|C390|C520|C530|C550	},
   {	"RB8_0",	0x009A, C320|C323|C390|C520|C530|C550	},
   {	"TB8_0",	0x009B, C320|C323|C390|C520|C530|C550	},
   {	"REN_0",	0x009C, C320|C323|C390|C520|C530|C550	},
   {	"SM2_0",	0x009D, C320|C323|C390|C520|C530|C550	},
   {	"SM1_0",	0x009E, C320|C323|C390|C520|C530|C550	},
   {	"SM0_0",	0x009F, C320|C323|C390|C520|C530|C550	},
   {	"FE_0",		0x009F, C320|C323|C390|C520|C530|C550	},

{	"SBUF",		0x0099,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"SBUF0",	0x0099, C320|C323|C390|C520|C530|C550	},
/* {	"",		0x009A,	0	},	*/
{	"ESP",		0x009B,	C390	},
/* {	"",		0x80,	SFR_BITS	}, */
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
   {	"ESP.1",	0x02,	SFR_BITS|C390	},
   {	"ESP.0",	0x01,	SFR_BITS|C390	},
{	"AP",		0x009C,	C390	},
{	"ACON",		0x009D,	C390	},
/* {	"",		0x80,	SFR_BITS	}, */
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
   {	"SA",		0x04,	SFR_BITS|C390	},
   {	"AM1",		0x02,	SFR_BITS|C390	},
   {	"AM0",		0x01,	SFR_BITS|C390	},
{	"COTMA0",	0x009E,	C390	},
{	"COTMA1",	0x009F,	C390	},
{	"PMR",		0x009F,	C550	},
   {	"CD1",		0x80,	SFR_BITS|C550	},
   {	"CD0",		0x40,	SFR_BITS|C550	},
   {	"SWB",		0x20,	SFR_BITS|C550	},
   {	"CTM",		0x10,	SFR_BITS|C550	},
   {	"_4X_2X",	0x08,	SFR_BITS|C550	},
   {	"ALEOFF",	0x04,	SFR_BITS|C550	},
   {	"DME1",		0x02,	SFR_BITS|C550	},
   {	"DME0",		0x01,	SFR_BITS|C550	},

{	"PORT2",	0x00A0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"P2",		0x00A0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.0",		0x00A0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.1",		0x00A1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.2",		0x00A2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.3",		0x00A3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.4",		0x00A4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.5",		0x00A5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.6",		0x00A6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P2.7",		0x00A7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"PORT5",	0x00A1,	C390	},
{	"P5",		0x00A1,	C390	},
   {	"P5.7",		0x80,	SFR_BITS|C390	},
   {	"P5.6",		0x40,	SFR_BITS|C390	},
   {	"P5.5",		0x20,	SFR_BITS|C390	},
   {	"P5.4",		0x10,	SFR_BITS|C390	},
   {	"P5.3",		0x08,	SFR_BITS|C390	},
   {	"P5.2",		0x04,	SFR_BITS|C390	},
   {	"P5.1",		0x02,	SFR_BITS|C390	},
   {	"P5.0",		0x01,	SFR_BITS|C390	},
{	"SADDR0",	0x00A1,	C550	},
{	"P5CNT",	0x00A2,	C390	},
   {	"CAN1BA",	0x80,	SFR_BITS|C390	},
   {	"CAN0BA",	0x40,	SFR_BITS|C390	},
   {	"SP1EC",	0x20,	SFR_BITS|C390	},
   {	"C1_IO",	0x10,	SFR_BITS|C390	},
   {	"C0_IO",	0x08,	SFR_BITS|C390	},
   {	"P5CNT.2",	0x04,	SFR_BITS|C390	},
   {	"P5CNT.1",	0x02,	SFR_BITS|C390	},
   {	"P5CNT.0",	0x01,	SFR_BITS|C390	},
{	"SADDR1",	0x00A2,	C550	},
{	"C0C",		0x00A3,	C390	},
   {	"ERIE",		0x80,	SFR_BITS|C390	},
   {	"STIE",		0x40,	SFR_BITS|C390	},
   {	"PDE",		0x20,	SFR_BITS|C390	},
   {	"SIESTA",	0x10,	SFR_BITS|C390	},
   {	"CRST",		0x08,	SFR_BITS|C390	},
   {	"AUTOB",	0x04,	SFR_BITS|C390	},
   {	"ERCS",		0x02,	SFR_BITS|C390	},
   {	"SWINT",	0x01,	SFR_BITS|C390	},
{	"C0S",		0x00A4,	C390	},
   {	"BSS",		0x80,	SFR_BITS|C390	},
   {	"EC96_128",	0x40,	SFR_BITS|C390	},
   {	"WKS",		0x20,	SFR_BITS|C390	},
   {	"RXS",		0x10,	SFR_BITS|C390	},
   {	"TXS",		0x08,	SFR_BITS|C390	},
   {	"ER2",		0x04,	SFR_BITS|C390	},
   {	"ER1",		0x02,	SFR_BITS|C390	},
   {	"ER0",		0x01,	SFR_BITS|C390	},
{	"C0IR",		0x00A5,	C390	},
   {	"INTIN7",	0x80,	SFR_BITS|C390	},
   {	"INTIN6",	0x40,	SFR_BITS|C390	},
   {	"INTIN5",	0x20,	SFR_BITS|C390	},
   {	"INTIN4",	0x10,	SFR_BITS|C390	},
   {	"INTIN3",	0x08,	SFR_BITS|C390	},
   {	"INTIN2",	0x04,	SFR_BITS|C390	},
   {	"INTIN1",	0x02,	SFR_BITS|C390	},
   {	"INTIN0",	0x01,	SFR_BITS|C390	},
{	"C0TE",		0x00A6,	C390	},
{	"C0RE",		0x00A7,	C390	},

{	"IE",		0x00A8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.0",		0x00A8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.1",		0x00A9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.2",		0x00AA,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.3",		0x00AB,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.4",		0x00AC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.5",		0x00AD,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.6",		0x00AE,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IE.7",		0x00AF,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"EX",		0x00A8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ET",		0x00A9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ES",		0x00AC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"EX0",		0x00A8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ET0",		0x00A9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"EX1",		0x00AA,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ET1",		0x00AB,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ES0",		0x00AC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ET2",		0x00AD,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"ES1",		0x00AD,	C550	},
   {	"ES1",		0x00AE, C320|C323|C390|C520|C530	},
   {	"EAD",		0x00AE, C550	},
   {	"EA",		0x00AF,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"SADDR0",	0x00A9,	CXXX|C310|C320|C323|C390|C520|C530	},
{	"SADDR1",	0x00AA, C320|C323|C390|C520|C530	},
{	"C0M1C",	0x00AB,	C390	},
   {	"MSRDY",	0x80,	SFR_BITS|C390	},
   {	"ETI",		0x40,	SFR_BITS|C390	},
   {	"ERI",		0x20,	SFR_BITS|C390	},
   {	"INTRQ",	0x10,	SFR_BITS|C390	},
   {	"EXTRQ",	0x08,	SFR_BITS|C390	},
   {	"MTRQ",		0x04,	SFR_BITS|C390	},
   {	"ROW_TIH",	0x02,	SFR_BITS|C390	},
   {	"DTUP",		0x01,	SFR_BITS|C390	},
{	"C0M2C",	0x00AC,	C390	},
{	"C0M3C",	0x00AD,	C390	},
{	"C0M4C",	0x00AE,	C390	},
{	"C0M5C",	0x00AF,	C390	},

{	"CMPL0",	0x00A9,	C550	},
{	"CMPL1",	0x00AA,	C550	},
{	"CMPL2",	0x00AB,	C550	},
{	"CPTL0",	0x00AC,	C550	},
{	"CPTL1",	0x00AD,	C550	},
{	"CPTL2",	0x00AE,	C550	},
{	"CPTL3",	0x00AF,	C550	},

{	"PORT3",	0x00B0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"P3",		0x00B0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.0",		0x00B0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.1",		0x00B1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.2",		0x00B2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.3",		0x00B3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.4",		0x00B4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.5",		0x00B5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.6",		0x00B6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P3.7",		0x00B7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"RXD0",		0x00B0,	C390	},
   {	"TXD0",		0x00B1,	C390	},
   {	"INT0",		0x00B2,	C390	},
   {	"INT1",		0x00B3,	C390	},
   {	"T0",		0x00B4,	C390	},
   {	"T1",		0x00B5,	C390	},
{	"ADCON1",	0X00B2,	C550	},
   {	"STRT_BSY",	0x80,	SFR_BITS|C550	},
   {	"EOC",		0x40,	SFR_BITS|C550	},
   {	"CONT_SS",	0x20,	SFR_BITS|C550	},
   {	"ADEX",		0x10,	SFR_BITS|C550	},
   {	"WCQ",		0x08,	SFR_BITS|C550	},
   {	"WCM",		0x04,	SFR_BITS|C550	},
   {	"ADON",		0x02,	SFR_BITS|C550	},
   {	"WCIO",		0x01,	SFR_BITS|C550	},
{	"ADCON2",	0X00B3,	C550	},
   {	"OUTCF",	0x80,	SFR_BITS|C550	},
   {	"MUX2",		0x40,	SFR_BITS|C550	},
   {	"MUX1",		0x20,	SFR_BITS|C550	},
   {	"MUX0",		0x10,	SFR_BITS|C550	},
   {	"APS3",		0x08,	SFR_BITS|C550	},
   {	"APS2",		0x04,	SFR_BITS|C550	},
   {	"APS1",		0x02,	SFR_BITS|C550	},
   {	"APS0",		0x01,	SFR_BITS|C550	},
{	"ADMSB",	0X00B4,	C550	},
{	"ADLSB",	0X00B5,	C550	},
{	"WINHI",	0X00B6,	C550	},
{	"WINLO",	0X00B7,	C550	},

/* {	"",		0x00B1,	0	},	*/
/* {	"",		0x00B2,	0	},	*/
{	"C0M6C",	0x00B3,	C390	},
{	"C0M7C",	0x00B4,	C390	},
{	"C0M8C",	0x00B5,	C390	},
{	"C0M9C",	0x00B6,	C390	},
{	"C0M10C",	0x00B7,	C390	},

{	"IP",		0x00B8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.0",		0x00B8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.1",		0x00B9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.2",		0x00BA,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.3",		0x00BB,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.4",		0x00BC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.5",		0x00BD,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.6",		0x00BE,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"IP.7",		0x00BF,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PX",		0x00B8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PT",		0x00B9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PS",		0x00BC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PX0",		0x00B8,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PT0",		0x00B9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PX1",		0x00BA,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PT1",		0x00BB,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PS0",		0x00BC,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PT2",		0x00BD,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"PS1",		0x00BD,	C550	},
   {	"PS1",		0x00BE, C320|C323|C390|C520|C530	},
   {	"PAD",		0x00BE, C550	},

{	"SADEN0",	0x00B9,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
{	"SADEN1",	0x00BA, C320|C323|C390|C520|C530|C550	},
{	"C0M11C",	0x00BB,	C390	},
{	"C0M12C",	0x00BC,	C390	},
{	"C0M13C",	0x00BD,	C390	},
{	"C0M14C",	0x00BE,	C390	},
{	"T2CON",	0x00BE,	C550	},
   {	"TF2",		0x80,	SFR_BITS|C550	},
   {	"EXF2",		0x40,	SFR_BITS|C550	},
   {	"RCLK",		0x20,	SFR_BITS|C550	},
   {	"TCLK",		0x10,	SFR_BITS|C550	},
   {	"EXEN2",	0x08,	SFR_BITS|C550	},
   {	"TR2",		0x04,	SFR_BITS|C550	},
   {	"C_T2",		0x02,	SFR_BITS|C550	},
   {	"_RL2",		0x01,	SFR_BITS|C550	},
   {	"CT2",		0x02,	SFR_BITS|C550	},
   {	"CPRL2",	0x01,	SFR_BITS|C550	},
{	"C0M15C",	0x00BF,	C390	},
{	"T2MOD",	0x00BF,	C550	},
/* {	"",		0x80,	SFR_BITS	}, */
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
   {	"T2OE",		0x02,	SFR_BITS|C550	},
   {	"DCEN",		0x01,	SFR_BITS|C550	},

{	"SCON1",	0x00C0, C320|C323|C390|C520|C530	},
   {	"SCON1.0",	0x00C0, C320|C323|C390|C520|C530	},
   {	"SCON1.1",	0x00C1, C320|C323|C390|C520|C530	},
   {	"SCON1.2",	0x00C2, C320|C323|C390|C520|C530	},
   {	"SCON1.3",	0x00C3, C320|C323|C390|C520|C530	},
   {	"SCON1.4",	0x00C4, C320|C323|C390|C520|C530	},
   {	"SCON1.5",	0x00C5, C320|C323|C390|C520|C530	},
   {	"SCON1.6",	0x00C6, C320|C323|C390|C520|C530	},
   {	"SCON1.7",	0x00C7, C320|C323|C390|C520|C530	},
   {	"RI_1",		0x00C0, C320|C323|C390|C520|C530	},
   {	"TI_1",		0x00C1, C320|C323|C390|C520|C530	},
   {	"RB8_1",	0x00C2, C320|C323|C390|C520|C530	},
   {	"TB8_1",	0x00C3, C320|C323|C390|C520|C530	},
   {	"REN_1",	0x00C4, C320|C323|C390|C520|C530	},
   {	"SM2_1",	0x00C5, C320|C323|C390|C520|C530	},
   {	"SM1_1",	0x00C6, C320|C323|C390|C520|C530	},
   {	"SM0_1",	0x00C7, C320|C323|C390|C520|C530	},
   {	"FE_1",		0x00C7, C320|C323|C390|C520|C530	},

{	"PORT4",	0x00C0,	C550	},
{	"P4",		0x00C0,	C550	},
   {	"P4.0",		0x00C0,	C550	},
   {	"P4.1",		0x00C1,	C550	},
   {	"P4.2",		0x00C2,	C550	},
   {	"P4.3",		0x00C3,	C550	},
   {	"P4.4",		0x00C4,	C550	},
   {	"P4.5",		0x00C5,	C550	},
   {	"P4.6",		0x00C6,	C550	},
   {	"P4.7",		0x00C7,	C550	},
   {	"CMSR0",	0x00C0,	C550	},
   {	"CMSR1",	0x00C1,	C550	},
   {	"CMSR2",	0x00C2,	C550	},
   {	"CMSR3",	0x00C3,	C550	},
   {	"CMSR4",	0x00C4,	C550	},
   {	"CMSR5",	0x00C5,	C550	},
   {	"CMT0",		0x00C6,	C550	},
   {	"CMT1",		0x00C7,	C550	},

{	"SBUF1",	0x00C1, C320|C323|C390|C520|C530	},
   {	"SB7",		0x80,	SFR_BITS|C520	},
   {	"SB6",		0x40,	SFR_BITS|C520	},
   {	"SB5",		0x20,	SFR_BITS|C520	},
   {	"SB4",		0x10,	SFR_BITS|C520	},
   {	"SB3",		0x08,	SFR_BITS|C520	},
   {	"SB2",		0x04,	SFR_BITS|C520	},
   {	"SB1",		0x02,	SFR_BITS|C520	},
   {	"SB0",		0x01,	SFR_BITS|C520	},
{	"ROMSIZE",	0x00C2, C520|C530|C550	},
   {	"",		0x80,	SFR_BITS	},
   {	"",		0x40,	SFR_BITS	},
   {	"",		0x20,	SFR_BITS	},
   {	"",		0x10,	SFR_BITS	},
   {	"",		0x08,	SFR_BITS	},
   {	"RMS2",		0x04,	SFR_BITS|C520|C530|C550	},
   {	"RMS1",		0x02,	SFR_BITS|C520|C530|C550	},
   {	"RMS0",		0x01,	SFR_BITS|C520|C530|C550	},
/* {	"",		0x00C3,	0	},	*/
{	"PMR",		0x00C4, C390|C520|C530	},
   {	"CD1",		0x80,	SFR_BITS|C390|C520|C530	},
   {	"CD0",		0x40,	SFR_BITS|C390|C520|C530	},
   {	"SWB",		0x20,	SFR_BITS|C390|C520|C530	},
   {	"CTM",		0x10,	SFR_BITS|C390	},
   {	"_4X_2X",	0x08,	SFR_BITS|C390	},
   {	"XTOFF",	0x08,	SFR_BITS|C520|C530	},
   {	"ALEOFF",	0x04,	SFR_BITS|C390|C520|C530	},
   {	"DME1",		0x02,	SFR_BITS|C520|C530	},
   {	"DME0",		0x01,	SFR_BITS|C520|C530	},
{	"PORT5",	0x00C4, C550	},
{	"P5",		0x00C4, C550	},
   {	"ADC7",		0x80,	SFR_BITS|C550	},
   {	"ADC6",		0x40,	SFR_BITS|C550	},
   {	"ADC5",		0x20,	SFR_BITS|C550	},
   {	"ADC4",		0x10,	SFR_BITS|C550	},
   {	"ADC3",		0x08,	SFR_BITS|C550	},
   {	"ADC2",		0x04,	SFR_BITS|C550	},
   {	"ADC1",		0x02,	SFR_BITS|C550	},
   {	"ADC0",		0x01,	SFR_BITS|C550	},
{	"STATUS",	0x00C5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PIP",		0x80,	SFR_BITS|C320|C323|C390|C520|C530|C550	},
   {	"HIP",		0x40,	SFR_BITS|CXXX|C310|C390|C520|C530|C550	},
   {	"LIP",		0x20,	SFR_BITS|CXXX|C310|C390|C520|C530|C550	},
   {	"XTUP",		0x10,	SFR_BITS|C520|C530	},
   {	"SPTA1",	0x08,	SFR_BITS|C390|C520|C530|C550	},
   {	"SPRA1",	0x04,	SFR_BITS|C390|C520|C530|C550	},
   {	"SPTA0",	0x02,	SFR_BITS|C390|C520|C530|C550	},
   {	"SPRA0",	0x01,	SFR_BITS|C390|C520|C530|C550	},
{	"MCON",		0x00C6,	C390	},
   {	"IDM1",		0x80,	SFR_BITS|C390	},
   {	"IDM0",		0x40,	SFR_BITS|C390	},
   {	"CMA",		0x20,	SFR_BITS|C390	},
/* {	"",		0x10,	SFR_BITS	}, */
   {	"PDCE3",	0x08,	SFR_BITS|C390	},
   {	"PDCE2",	0x04,	SFR_BITS|C390	},
   {	"PDEC1",	0x02,	SFR_BITS|C390	},
   {	"PDEC0",	0x01,	SFR_BITS|C390	},
{	"TA",		0x00C7, C320|C323|C390|C520|C530|C550	},

{	"T2CON",	0x00C8,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.0",	0x00C8,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.1",	0x00C9,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.2",	0x00CA,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.3",	0x00CB,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.4",	0x00CC,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.5",	0x00CD,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.6",	0x00CE,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"T2CON.7",	0x00CF,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"CP_RL2",	0x00C8,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"C_T2",		0x00C9,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"TR2",		0x00CA,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"EXEN2",	0x00CB,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"TCLK",		0x00CC,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"RCLK",		0x00CD,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"EXF2",		0x00CE,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"TF2",		0x00CF,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"CPRL2",	0x00C8,	CXXX|C310|C320|C323|C390|C520|C530	},
   {	"CT2",		0x00C9,	CXXX|C310|C320|C323|C390|C520|C530	},

{	"T2IR",		0x00C8,	C550	},
   {	"T2IR.0",	0x00C8,	C550	},
   {	"T2IR.1",	0x00C9,	C550	},
   {	"T2IR.2",	0x00CA,	C550	},
   {	"T2IR.3",	0x00CB,	C550	},
   {	"T2IR.4",	0x00CC,	C550	},
   {	"T2IR.5",	0x00CD,	C550	},
   {	"T2IR.6",	0x00CE,	C550	},
   {	"T2IR.7",	0x00CF,	C550	},
   {	"CF0",		0x00C8,	C550	},
   {	"CF1",		0x00C9,	C550	},
   {	"CF2",		0x00CA,	C550	},
   {	"CF3",		0x00CB,	C550	},
   {	"CM0F",		0x00CC,	C550	},
   {	"CM1F",		0x00CD,	C550	},
   {	"CM2F",		0x00CE,	C550	},
   {	"IE2",		0x00C8,	C550	},
   {	"IE3",		0x00C9,	C550	},
   {	"IE4",		0x00CA,	C550	},
   {	"IE5",		0x00CB,	C550	},

{	"T2MOD",	0x00C9,	CXXX|C310|C320|C323|C390|C520|C530	},
/* {	"",		0x80,	SFR_BITS	}, */
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
   {	"D13T1",	0x10,	SFR_BITS|C390	},
   {	"D13T2",	0x08,	SFR_BITS|C390	},
/* {	"",		0x04,	SFR_BITS	}, */
   {	"T2OE",		0x02,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530	},
   {	"DCEN",		0x01,	SFR_BITS|CXXX|C310|C320|C323|C390|C520|C530	},
{	"RCAP2L",	0x00CA,	CXXX|C310|C320|C323|C390|C520|C530	},
{	"RCAP2H",	0x00CB,	CXXX|C310|C320|C323|C390|C520|C530	},
{	"TL2",		0x00CC,	CXXX|C310|C320|C323|C390|C520|C530	},
{	"TH2",		0x00CD,	CXXX|C310|C320|C323|C390|C520|C530	},
{	"COR",		0x00CE,	C390	},
   {	"IRDACK",	0x80,	SFR_BITS|C390	},
   {	"C1BPR7",	0x40,	SFR_BITS|C390	},
   {	"C1BPR6",	0x20,	SFR_BITS|C390	},
   {	"C0BPR7",	0x10,	SFR_BITS|C390	},
   {	"C0BPR6",	0x08,	SFR_BITS|C390	},
   {	"COD1",		0x04,	SFR_BITS|C390	},
   {	"COD0",		0x02,	SFR_BITS|C390	},
   {	"CLKOE",	0x01,	SFR_BITS|C390	},
/* {	"",		0x00CF,	0	},	*/

{	"CMPH0",	0x00C9,	C550	},
{	"CMPH1",	0x00CA,	C550	},
{	"CMPH2",	0x00CB,	C550	},
{	"CPTH0",	0x00CC,	C550	},
{	"CPTH1",	0x00CD,	C550	},
{	"CPTH2",	0x00CE,	C550	},
{	"CPTH3",	0x00CF,	C550	},

{	"PSW",		0x00D0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.0",	0x00D0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.1",	0x00D1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.2",	0x00D2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.3",	0x00D3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.4",	0x00D4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.5",	0x00D5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.6",	0x00D6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"PSW.7",	0x00D7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"P",		0x00D0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"F1",		0x00D1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"OV",		0x00D2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"RS0",		0x00D3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"RS1",		0x00D4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"F0",		0x00D5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"AC",		0x00D6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"CY",		0x00D7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"MCNT0",	0x00D1,	C390	},
   {	"_LSHIFT",	0x80,	SFR_BITS|C390	},
   {	"CSE",		0x40,	SFR_BITS|C390	},
   {	"SCB",		0x20,	SFR_BITS|C390	},
   {	"MAS4",		0x10,	SFR_BITS|C390	},
   {	"MAS3",		0x08,	SFR_BITS|C390	},
   {	"MAS2",		0x04,	SFR_BITS|C390	},
   {	"MAS1",		0x02,	SFR_BITS|C390	},
   {	"MAS0",		0x01,	SFR_BITS|C390	},
{	"MCNT1",	0x00D2,	C390	},
   {	"MST",		0x80,	SFR_BITS|C390	},
   {	"MOF",		0x40,	SFR_BITS|C390	},
/* {	"",		0x20,	SFR_BITS	}, */
   {	"CLM",		0x10,	SFR_BITS|C390	},
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
/* {	"",		0x02,	SFR_BITS	}, */
/* {	"",		0x01,	SFR_BITS	}, */
{	"MA",		0x00D3,	C390	},
{	"MB",		0x00D4,	C390	},
{	"MC",		0x00D5,	C390	},
{	"C1RMS0",	0x00D6,	C390	},
{	"C1RMS1",	0x00D7,	C390	},

{	"PW0FG",	0x00D2,	C550	},
{	"PW1FG",	0x00D3,	C550	},
{	"PW2FG",	0x00D4,	C550	},
{	"PW3FG",	0x00D5,	C550	},
{	"PWMADR",	0x00D6,	C550	},
   {	"ADRS",		0x80,	SFR_BITS|C550	},
/* {	"",		0x40,	SFR_BITS	}, */
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
   {	"PWE1",		0x02,	SFR_BITS|C550	},
   {	"PWE0",		0x01,	SFR_BITS|C550	},

{	"WDCON",	0x00D8, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.0",	0x00D8, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.1",	0x00D9, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.2",	0x00DA, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.3",	0x00DB, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.4",	0x00DC, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.5",	0x00DD, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.6",	0x00DE, C310|C320|C323|C390|C520|C530	},
   {	"WDCON.7",	0x00DF, C310|C320|C323|C390|C520|C530	},
   {	"RWT",		0x00D8, C320|C323|C390|C520|C530	},
   {	"EWT",		0x00D9, C320|C323|C390|C520|C530	},
   {	"WTRF",		0x00DA, C320|C323|C390|C520|C530	},
   {	"WDIF",		0x00DB, C320|C323|C390|C520|C530	},
   {	"PFI",		0x00DC, C320|C323|C390|C520|C530	},
   {	"EPFI",		0x00DD, C320|C323|C390|C520|C530	},
   {	"POR",		0x00DE, C310|C320|C323|C390|C520|C530	},
   {	"SMOD_1",	0x00DF, C320|C323|C390|C520|C530	},

 {	"SCON1",	0x00D8, C550	},
   {	"SCON1.0",	0x00D8, C550	},
   {	"SCON1.1",	0x00D9, C550	},
   {	"SCON1.2",	0x00DA, C550	},
   {	"SCON1.3",	0x00DB, C550	},
   {	"SCON1.4",	0x00DC, C550	},
   {	"SCON1.5",	0x00DD, C550	},
   {	"SCON1.6",	0x00DE, C550	},
   {	"SCON1.7",	0x00DF, C550	},
   {	"RI_1",		0x00D8, C550	},
   {	"TI_1",		0x00D9, C550	},
   {	"RB8_1",	0x00DA, C550	},
   {	"TB8_1",	0x00DB, C550	},
   {	"REN_1",	0x00DC, C550	},
   {	"SM2_1",	0x00DD, C550	},
   {	"SM1_1",	0x00DE, C550	},
   {	"SM0_1",	0x00DF, C550	},
   {	"FE_1",		0x00DF, C550	},

{	"SBUF1",	0x00D9, C550	},
/* {	"",		0x00DA,	0	},	*/
/* {	"",		0x00DB,	0	},	*/
{	"PWM0",		0x00DC, C550	},
{	"PWM1",		0x00DD, C550	},
{	"PWM2",		0x00DE, C550	},
{	"PWM3",		0x00DF, C550	},
{	"C1TMA0",	0x00DE,	C390	},
{	"C1TMA1",	0x00DF,	C390	},

{	"ACC",		0x00E0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.0",	0x00E0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.1",	0x00E1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.2",	0x00E2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.3",	0x00E3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.4",	0x00E4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.5",	0x00E5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.6",	0x00E6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"ACC.7",	0x00E7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"PW01CS",	0x00E1, C550	},
   {	"PW0S2",	0x80,	SFR_BITS|C550	},
   {	"PW0S1",	0x40,	SFR_BITS|C550	},
   {	"PW0S0",	0x20,	SFR_BITS|C550	},
   {	"PW0EN",	0x10,	SFR_BITS|C550	},
   {	"PW1S2",	0x08,	SFR_BITS|C550	},
   {	"PW1S1",	0x04,	SFR_BITS|C550	},
   {	"PW1S0",	0x02,	SFR_BITS|C550	},
   {	"PW1EN",	0x01,	SFR_BITS|C550	},
{	"PW23CS",	0x00E2, C550	},
   {	"PW2S2",	0x80,	SFR_BITS|C550	},
   {	"PW2S1",	0x40,	SFR_BITS|C550	},
   {	"PW2S0",	0x20,	SFR_BITS|C550	},
   {	"PW2EN",	0x10,	SFR_BITS|C550	},
   {	"PW3S2",	0x08,	SFR_BITS|C550	},
   {	"PW3S1",	0x04,	SFR_BITS|C550	},
   {	"PW3S0",	0x02,	SFR_BITS|C550	},
   {	"PW3EN",	0x01,	SFR_BITS|C550	},
{	"PW01CON",	0x00E3, C550	},
   {	"PW0F",		0x80,	SFR_BITS|C550	},
   {	"PW0DC",	0x40,	SFR_BITS|C550	},
   {	"PW0OE",	0x20,	SFR_BITS|C550	},
   {	"PW0T_C",	0x10,	SFR_BITS|C550	},
   {	"PW1F",		0x08,	SFR_BITS|C550	},
   {	"PW1DC",	0x04,	SFR_BITS|C550	},
   {	"PW1OE",	0x02,	SFR_BITS|C550	},
   {	"PW1T_C",	0x01,	SFR_BITS|C550	},
{	"PW23CON",	0x00E4, C550	},
   {	"PW2F",		0x80,	SFR_BITS|C550	},
   {	"PW2DC",	0x40,	SFR_BITS|C550	},
   {	"PW2OE",	0x20,	SFR_BITS|C550	},
   {	"PW2T_C",	0x10,	SFR_BITS|C550	},
   {	"PW3F",		0x08,	SFR_BITS|C550	},
   {	"PW3DC",	0x04,	SFR_BITS|C550	},
   {	"PW3OE",	0x02,	SFR_BITS|C550	},
   {	"PW3T_C",	0x01,	SFR_BITS|C550	},
/* {	"",		0x00E5,	0	},	*/
{	"RLOADL",	0x00E6, C550	},
{	"RLOADH",	0x00E7, C550	},

{	"C1C",		0x00E3,	C390	},
{	"C1S",		0x00E4,	C390	},
/* {	"",		0x80,	SFR_BITS	}, */
   {	"CECE",		0x40,	SFR_BITS|C390	},
/* {	"",		0x20,	SFR_BITS	}, */
/* {	"",		0x10,	SFR_BITS	}, */
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
/* {	"",		0x02,	SFR_BITS	}, */
/* {	"",		0x01,	SFR_BITS	}, */

{	"C1IR",		0x00E5,	C390	},
{	"C1TE",		0x00E6,	C390	},
{	"C1RE",		0x00E7,	C390	},

{	"EIE",		0x00E8,	C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.0",	0x00E8, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.1",	0x00E9, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.2",	0x00EA, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.3",	0x00EB, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.4",	0x00EC, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.5",	0x00ED, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.6",	0x00EE, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIE.7",	0x00EF, C310|C320|C323|C390|C520|C530|C550	},
   {	"EX2",		0x00E8, C310|C320|C323|C390|C520|C530|C550	},
   {	"EX3",		0x00E9, C310|C320|C323|C390|C520|C530|C550	},
   {	"EX4",		0x00EA, C310|C320|C323|C390|C520|C530|C550	},
   {	"EX5",		0x00EB, C310|C320|C323|C390|C520|C530|C550	},
   {	"EWDI",		0x00EC, C320|C323|C390|C520|C530	},
   {	"ERTCI",	0X00ED, C530	},
   {	"C1IE",		0x00ED,	C390	},
   {	"C0IE",		0x00EE,	C390	},
   {	"CANBIE",	0x00EF,	C390	},

   {	"EC0",		0x00E8, C550	},
   {	"EC1",		0x00E9, C550	},
   {	"EC2",		0x00EA, C550	},
   {	"EC3",		0x00EB, C550	},
   {	"ECM0",		0x00EC, C550	},
   {	"ECM1",		0X00ED, C550	},
   {	"ECM2",		0x00EE,	C550	},
   {	"ET2",		0x00EF,	C550	},

/* {	"",		0x00E9,	0	},	*/
{	"MXAX",		0x00EA,	C390	},
{	"C1M1C",	0x00EB,	C390	},
{	"C1M2C",	0x00EC,	C390	},
{	"C1M3C",	0x00ED,	C390	},
{	"C1M4C",	0x00EE,	C390	},
{	"C1M5C",	0x00EF,	C390	},

/* {	"",		0x00E9,	0	},	*/
{	"T2SEL",	0x00EA,	C550	},
   {	"TF2S",		0x80,	SFR_BITS|C550	},
   {	"TF2BS",	0x40,	SFR_BITS|C550	},
/* {	"",		0x20,	SFR_BITS	}, */
   {	"TF2B",		0x10,	SFR_BITS|C550	},
/* {	"",		0x08,	SFR_BITS	}, */
/* {	"",		0x04,	SFR_BITS	}, */
   {	"T2P1",		0x02,	SFR_BITS|C550	},
   {	"T2P0",		0x01,	SFR_BITS|C550	},
{	"CTCON",	0x00EB,	C550	},
   {	"_CT3",		0x80,	SFR_BITS|C550	},
   {	"CT3",		0x40,	SFR_BITS|C550	},
   {	"_CT2",		0x20,	SFR_BITS|C550	},
   {	"CT2",		0x10,	SFR_BITS|C550	},
   {	"_CT1",		0x08,	SFR_BITS|C550	},
   {	"CT1",		0x04,	SFR_BITS|C550	},
   {	"_CT0",		0x02,	SFR_BITS|C550	},
   {	"CT0",		0x01,	SFR_BITS|C550	},
{	"TL2",		0x00EC,	C550	},
{	"TH2",		0x00ED,	C550	},
{	"SETR",		0x00EE,	C550	},
   {	"TGFF1",	0x80,	SFR_BITS|C550	},
   {	"TGFF0",	0x40,	SFR_BITS|C550	},
   {	"CMS5",		0x20,	SFR_BITS|C550	},
   {	"CMS4",		0x10,	SFR_BITS|C550	},
   {	"CMS3",		0x08,	SFR_BITS|C550	},
   {	"CMS2",		0x04,	SFR_BITS|C550	},
   {	"CMS1",		0x02,	SFR_BITS|C550	},
   {	"CMS0",		0x01,	SFR_BITS|C550	},
{	"RSTR",		0x00EF,	C550	},
   {	"CMTE1",	0x80,	SFR_BITS|C550	},
   {	"CMTE0",	0x40,	SFR_BITS|C550	},
   {	"CMR5",		0x20,	SFR_BITS|C550	},
   {	"CMR4",		0x10,	SFR_BITS|C550	},
   {	"CMR3",		0x08,	SFR_BITS|C550	},
   {	"CMR2",		0x04,	SFR_BITS|C550	},
   {	"CMR1",		0x02,	SFR_BITS|C550	},
   {	"CMR0",		0x01,	SFR_BITS|C550	},

{	"B",		0x00F0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.0",		0x00F0,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.1",		0x00F1,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.2",		0x00F2,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.3",		0x00F3,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.4",		0x00F4,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.5",		0x00F5,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.6",		0x00F6,	CXXX|C310|C320|C323|C390|C520|C530|C550	},
   {	"B.7",		0x00F7,	CXXX|C310|C320|C323|C390|C520|C530|C550	},

{	"PORT6",	0x00F1,	C550	},
{	"P6",		0x00F1,	C550	},
   {	"STADC",	0x80,	SFR_BITS|C550	},
   {	"",		0x40,	SFR_BITS	},
   {	"PWMC1",	0x20,	SFR_BITS|C550	},
   {	"PWMC0",	0x10,	SFR_BITS|C550	},
   {	"PWMO3",	0x08,	SFR_BITS|C550	},
   {	"PWMO2",	0x04,	SFR_BITS|C550	},
   {	"PWMO1",	0x02,	SFR_BITS|C550	},
   {	"PWMO0",	0x01,	SFR_BITS|C550	},
{	"RTASS",	0x00F2, C530	},
{	"RTAS",		0x00F3, C530	},
{	"RTAM",		0x00F4, C530	},
{	"RTAH",		0x00F5, C530	},

{	"C1M6C",	0x00F3,	C390	},
{	"C1M7C",	0x00F4,	C390	},
{	"C1M8C",	0x00F5,	C390	},
{	"C1M9C",	0x00F6,	C390	},
{	"C1M10C",	0x00F7,	C390	},

{	"EIP",		0x00F8, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.0",	0x00F8, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.1",	0x00F9, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.2",	0x00FA, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.3",	0x00FB, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.4",	0x00FC, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.5",	0x00FD, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.6",	0x00FE, C310|C320|C323|C390|C520|C530|C550	},
   {	"EIP.7",	0x00FF, C310|C320|C323|C390|C520|C530|C550	},
   {	"PX2",		0x00F8, C310|C320|C323|C390|C520|C530|C550	},
   {	"PX3",		0x00F9, C310|C320|C323|C390|C520|C530|C550	},
   {	"PX4",		0x00FA, C310|C320|C323|C390|C520|C530|C550	},
   {	"PX5",		0x00FB, C310|C320|C323|C390|C520|C530|C550	},
   {	"PWDI",		0x00FC, C320|C323|C390|C520|C530	},
   {	"PRTCI",	0x00FD, C530	},
   {	"C1IP",		0x00FD,	C390	},
   {	"C0IP",		0x00FE,	C390	},
   {	"CANBIP",	0x00FF,	C390	},

   {	"PC0",		0x00F8, C550	},
   {	"PC1",		0x00F9, C550	},
   {	"PC2",		0x00FA, C550	},
   {	"PC3",		0x00FB, C550	},
   {	"PCM0",		0x00FC, C550	},
   {	"PCM1",		0X00FD, C550	},
   {	"PCM2",		0x00FE,	C550	},
   {	"PT2",		0x00FF,	C550	},

{	"RTCC",		0x00F9, C530	},
   {	"SSCE",		0x80,	SFR_BITS|C530	},
   {	"SCE",		0x40,	SFR_BITS|C530	},
   {	"MCE",		0x20,	SFR_BITS|C530	},
   {	"HCE",		0x10,	SFR_BITS|C530	},
   {	"RTCRE",	0x08,	SFR_BITS|C530	},
   {	"RTCWE",	0x04,	SFR_BITS|C530	},
   {	"RTCIF",	0x02,	SFR_BITS|C530	},
   {	"RTCE",		0x01,	SFR_BITS|C530	},
{	"RTCSS",	0x00FA, C530	},
{	"RTCS",		0x00FB, C530	},
{	"RTCM",		0x00FC, C530	},
{	"RTCH",		0x00FD, C530	},
{	"RTCD0",	0x00FE, C530	},
{	"RTCD1",	0x00FF, C530	},

{	"C1M11C",	0x00FB,	C390	},
{	"C1M12C",	0x00FC,	C390	},
{	"C1M13C",	0x00FD,	C390	},
{	"C1M14C",	0x00FE,	C390	},
{	"C1M15C",	0x00FF,	C390	},
{	"WDCON",	0x00FF,	C550	},
   {	"SMOD_1",	0x80,	SFR_BITS|C550	},
   {	"POR",		0x40,	SFR_BITS|C550	},
   {	"EPFI",		0x20,	SFR_BITS|C550	},
   {	"PFI",		0x10,	SFR_BITS|C550	},
   {	"WDIF",		0x08,	SFR_BITS|C550	},
   {	"WTRF",		0x04,	SFR_BITS|C550	},
   {	"EWT",		0x02,	SFR_BITS|C550	},
   {	"RWT",		0x01,	SFR_BITS|C550	},

{	NULL,		0x0000,	0	}
};


