PAGE ,132

;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;

;**********************************************************************
;
;		COMP
;	
;	Original code (version 2.0) written 5/3/84 by RMK
;	...version downgraded to 1.9 on 6/5/84 by RMK per RPK
;	...version 2.00 released 7/20/84 (no changes)
;	...version 2.01 released 9/26/84 
;	Fixes: READ only reads {buffersize} bytes
; 	       ALLOCATE handles odd paragraphs
;	       COMPARE correctly handles mismatch in last byte of buffer
;	       READ_FILE saves the file2 size so multiple compares with
;		the same file2 will work
;	...version 2.02 released 3/21/85
;	Fixes: Changed FNEXT entry conditions to conform to DOS 3.xx
;	       SWITCHAR is assumed to be / in version 3
;	       FIX_TWO no longer uses the 'expanded' filename which was 
;		located in the reserved area of the DTA in DOS 2 but 
;		is no longer supported in DOS 3
;	       FIND_FIRST allows read-only files
;	       FILL_FILE does not add "*.*" if pathname ends in "*" or "."
;	       SHRINK does not eat embedded spaces, ie 'A B' does not become AB
;	       
;	
;
;***********************************************************************

.XLIST
	INCLUDE	..\COMMONS\MSDOS.DEF
	INCLUDE	..\COMMONS\ASCII.DEF
.LIST 
	INCLUDE	COMP.DEF

CODE 	SEGMENT BYTE PUBLIC
	ASSUME CS:CODE, DS:CODE, ES:CODE, SS:CODE

COMP_START	=  	OFFSET $

	ORG	100H
COMP:
	JMP	COMP10

BUFFERSIZE	DW	0FFFFH		;Default buffer size is 64k
DIR_CHAR	DB	?		;Directory character ('/' or '\')
MAXDISK		DB	?		;Number of drives assigned
DEF_DRIVE	DB	?		;Default drive letter
DOS_VER		DB	?		;Dos Version #

FILE1		FILESPACE 	<>
FILE2		FILESPACE 	<>

READ_CT_LOW	DW	?		;Low word of bytes read count
READ_CT_HIGH	DW	?		;High word of read count
FILE2_SIZE_LOW  DW	?		;Low size of file2
FILE2_SIZE_HI	DW	?		;High size of file2
COUNT		DW	?		;Count of bytes transferred in a READ
ERR_COUNT	DB	?		;Count of errors in a COMPARE

WILD_FILE	DB	12 DUP (?)	;Expanded filename1 w/wildcards
START_TWO	DW	?		;Start of file 2 in PHD_DIOA
DATA_END	DB	?		;End marker - data to clear at restart

HEX_TO_ASC	DB	48,49,50,51,52,53,54,55,56,57 ;Table for hex to
		DB	65,66,67,68,69,70,32	;ASCII conversion 

.XLIST
;Error messages
HELP_MESSAGE	DW	END_HELP_MESSAGE-OFFSET HELP_MESSAGE-2
IF NBI
		DB	CC_CR,CC_LF,'                     COMP Version 2.02'
		DB	CC_CR,CC_LF,'                Copyright(C) NBI, Inc. 1984',CC_CR,CC_LF,CC_LF
ENDIF

IF ZENITH		
		DB	CC_CR,CC_LF,'                     COMP Version 2.02'
		DB	CC_CR,CC_LF,'      Copyright (C) 1985 Zenith Data Systems Corporation',CC_CR,CC_LF,CC_LF
ENDIF

IF SYNTREX
		DB	CC_CR,CC_LF,'                       COMP Version 2.02'
		DB	CC_CR,CC_LF,'                Copyright(C) SYNTREX, Inc. 1986',CC_CR,CC_LF,CC_LF
ENDIF

		DB	           'The  COMP  utility  compares  the  contents  of  two  files  or two',CC_CR,CC_LF
		DB	'specified  sets of  files.  Normally,  COMP is  used  after a  copy',CC_CR,CC_LF
		DB	'operation to verify that the files were copied correctly. The files',CC_CR,CC_LF
		DB	'that  are specified  for comparison can be on the same  drive or on',CC_CR,CC_LF
		DB	'different  drives.  They can  also  be in  the  same  or  different',CC_CR,CC_LF
		DB	'directories.   Wildcard   characters  are   allowed  in  both  file',CC_CR,CC_LF
		DB	'specifications.',CC_CR,CC_LF,CC_LF
		DB	'Syntax:  COMP ?',CC_CR,CC_LF
		DB	'         COMP [filespec1 [filespec2]]',CC_CR,CC_LF
END_HELP_MESSAGE = 	OFFSET $
CRLF		DW 	END_CRLF-OFFSET CRLF-2
		DB	CC_CR,CC_LF
END_CRLF	=	OFFSET $	
GETFIRST	DW 	END_GETFIRST-OFFSET GETFIRST-2
		DB	CC_CR,CC_LF,'Enter primary file name',CC_CR,CC_LF
END_GETFIRST	=	OFFSET $
GETSECOND	DW 	END_GETSECOND-OFFSET GETSECOND-2
		DB	'Enter 2nd file name or drive id',CC_CR,CC_LF
END_GETSECOND	=	OFFSET $
BAD_DISK	DW	END_BAD_DISK-OFFSET BAD_DISK -2
		DB	'Invalid drive specification',CC_CR,CC_LF,CC_BEL
END_BAD_DISK	=	OFFSET $
NO_FILE_FOUND	DW 	END_NO_FILE_FOUND-OFFSET NO_FILE_FOUND-2
		DB	'- File not found',CC_CR,CC_LF,CC_BEL
END_NO_FILE_FOUND	=	OFFSET $


;Note that VERSION ERROR message is displayed using DOS 1.0 call
;And therefore needs a $ at the end and no count at the beginning.
VER_ERROR	DB	CC_CR,CC_LF,'Incorrect DOS version',CC_CR,CC_LF,CC_BEL,'$'

DIFSIZES	DW 	END_DIFSIZES-OFFSET DIFSIZES-2
		DB	CC_CR,CC_LF,'Files are different sizes',CC_CR,CC_LF,CC_BEL
END_DIFSIZES	=	OFFSET $
ENDCOMP		DW 	END_ENDCOMP-OFFSET ENDCOMP-2
		DB	CC_CR,CC_LF,'10 Mismatches - ending compare',CC_CR,CC_LF,CC_BEL
END_ENDCOMP	=	OFFSET $
NO_EOF		DW 	END_NO_EOF-OFFSET NO_EOF-2
		DB	CC_CR,CC_LF,'Eof mark not found',CC_CR,CC_LF
END_NO_EOF	=	OFFSET $
NOMATCH		DW 	END_NOMATCH-OFFSET NOMATCH-2
		DB	CC_CR,CC_LF,'Compare error at offset '
	ERROR_LOC	DB	8 DUP(20H)
BYTE1IS 	DB 	CC_CR,CC_LF,'File 1 = '
	BYTE1	DB	2 DUP(?)
BYTE2IS		DB 	CC_CR,CC_LF,'File 2 = '
	BYTE2	DB	2 DUP(?),CC_CR,CC_LF
END_NOMATCH	=	OFFSET $
OK_COMP		DW 	END_OK_COMP-OFFSET OK_COMP-2
		DB	CC_CR,CC_LF,'Files compare ok',CC_CR,CC_LF
END_OK_COMP	=	OFFSET $
COMP_MORE	DW 	END_COMP_MORE-OFFSET COMP_MORE-2
		DB	CC_CR,CC_LF, 'Compare more files (Y/N)? '
END_COMP_MORE	=	OFFSET $
SYSERR		DW	END_SYSERR-OFFSET SYSERR-2
		DB	CC_CR,CC_LF, 'SYSTEM ERROR: PRESS CTRL-C', CC_CR,CC_LF,CC_BEL
END_SYSERR	=	OFFSET $
DAND		DW 	END_DAND-OFFSET DAND-2
		DB	' and '
END_DAND	=	OFFSET $

	DW	128 DUP (?)
STACK_TOP	LABEL	WORD
.LIST

COMP10:
	MOV	SP,OFFSET STACK_TOP	;Set up stack space
	CALL	GET_VERSION		;Make sure DOS version ok

;Allocate buffer space, get/set default drive spec.
COMP15:
	CALL	HELP_SCREEN		;Is this only a help request?
	CALL	ALLOCATE		;Allocate some buffer space
	CALL	GET_DEFAULTS		;See how many drives are assigned
	MOV	SI,PHD_DIOA		;Point to start of command line
	MOV	BYTE PTR [SI],FILE_SIZE ;Set to size of read request
	INC	SI			;Skip over count

;Test for file specified on command line and parse it if it exists
COMP20:
	MOV	BX,OFFSET FILE1
	CALL	PARSE			;Get first filename or EOL
	CMP	AL,TKN_EOL		;Anything specified?
	JNE	COMP40			;Yes-deal with it

;File not on command line: get file, set flag
COMP25:
	OR	FILE1.FLAGS,NOFILE	;Flag no file spec
	MOV	DX,OFFSET GETFIRST	;Want to display get first prompt
	CALL	GET_FILE		;Get a file
	JMP	COMP20			;repeat test string

;If file 1 was on command line, test for file 2
COMP40:
	TEST	FILE1.FLAGS,NOFILE	;If file1 not on com line, neither is 2
	JNZ	COMP50			;So don't test for it
	MOV	BX,OFFSET FILE2		;Point to file2 area
	MOV	SI,START_TWO		;Point to lastchar of file1 in PHD_DIOA
	INC	SI			;Point to first of file2
	CALL	PARSE			;Get second filename or eof
	CMP	AL,TKN_EOL		;File exist?
	JNE	COMP70			;Yes-deal with it

;File2 not on command line-ask for new one. If still none, flag it
COMP50:
	MOV	DX,OFFSET GETSECOND	;Else display get second prompt
	CALL	GET_FILE		;And get the file
	MOV	BX,OFFSET FILE2		;And point to second filename space
	CALL 	PARSE			;Try again
	CMP	AL,TKN_EOL		;Got a filename this time?
	JNE	COMP70			;Yes-continue
	OR	FILE2.FLAGS,NOFILE	;Set no file2 flag

;File1 and 2 names gotten-test for file1 exist and restart if not exist
COMP70:
	MOV	BX,OFFSET FILE1		;find first #1
	CALL 	FIND_THEN_MOVE		;Get file name and expand it
	TEST	FILE1.FLAGS,NOT_FOUND	;File exist?
	JZ	COMP90			;If file found, continue
	MOV	BX,OFFSET FILE1		;Pointer to file 1 values
	CALL	NO_FILE			;Display file not found
	CALL	RESTART			;Else see if want more
	JMP	COMP25			;Restart

;If file2 name doesn't exist, set it to file1 name
COMP90:
	TEST	FILE2.FLAGS,NOFILE	;File 2 specified?
	JZ	COMP100			;Yes-continue
	CALL	SETTWO			;Set file2=file1

;File2 name exists-find first on it,  expand wild cards and move the file
COMP100:
	MOV	BX,OFFSET FILE2		;Prepare to find_first on file2
	CALL	FIND_THEN_MOVE		;See if it exists at all
	TEST	FILE2.FLAGS,WILD	;Need to match chars?
	JZ	COMP106			;No
	CALL	FIX_TWO			;Fix file 2-expand stars, move it to
					;WILD_FILE, &c
;Match wild cards
COMP104:
	CALL	MATCH_TWO

;Display both filenames. If file 2 not found, display that and test for more
COMP106:
	MOV	SI,3			;Three CRLF's before filenames
	CALL	DISPLAY_TWO		;Display the file names
	TEST	FILE2.FLAGS,NOT_FOUND	;Is there a file 2?
	JZ	COMP110			;Yes, continue
	MOV	BX,OFFSET FILE2		;Display file2 not found
	CALL	NO_FILE
	JMP	COMP130			;See if we should try again

;Both files exist. Test for same size, and tet for more if different
COMP110:
	CALL	SAME_SIZE		;Are the files the same size?
	JC	COMP130			;No-see if there's more
;Files are the same size. Open and read both files
COMP120:
	CALL	READ_FILES
;Compare files, and read more if necessary
COMP127:
	CALL	COMPARE
	JC	COMP129			;Exit if too many errors
	TEST	FILE1.FLAGS,READMORE	;Are there more bytes to read?
	JZ	COMP129			;No-go test for next file
	MOV	BX,OFFSET FILE2		;Else read more from 1,2
	CALL 	READ	
	MOV	COUNT,AX		;Get new count
	MOV	BX,OFFSET FILE1
	CALL	READ
	JMP	COMP127			;And do some more

;Close both files and reset count and offset into file variables
COMP129:
	CALL	CLOSE			;Close open files

;Test for a 'next' file 1. If it doesn't exist, do compare more(y/n) stuff
COMP130:
	CALL	FIND_NEXT		;Is there a next file1?
	JNC	COMP140			;Yes-keep on matching
	CALL	RESTART			;See if they want more
	JMP	COMP25			;They want more

;Have 'next' file1. Move it, and test for and match wild cards in file2
COMP140:
	MOV	BX,OFFSET FILE1		;And to start of data area
	LEA	SI,[BX.DTA+PACKED_NAME]	;Point to new found file
	LEA	DI,[BX.EXP_NAME]	;Point to start of file1 space
	CALL	MAKE_SPACES		;Put in this new filename
	TEST	FILE2.FLAGS,WILD	;Are there wild cards in file2?
	JZ	COMP150			;No-don't match anything
	AND	FILE2.FLAGS,NOT NOT_FOUND	;Clear this flag
	MOV	BX,OFFSET WILD_FILE	;and try to find a new 2
	CALL	MATCH_TWO		;Try to match second filename

;Display new filenames. If file2 doesn't exist, display that and do 'next'
;Again, otherwise jump to test sizes and compare again.
COMP150:
	MOV	SI,2			;2 CRLF's before filename
	CALL	DISPLAY_TWO		;Display new file names
	TEST	FILE2.FLAGS,NOT_FOUND	;Is there a file2?
	JZ	COMP110			;Yes-test sizes &c
	MOV	BX,OFFSET FILE2		;Display missing filename
	CALL	NO_FILE	
	JMP	COMP130			;And try again

;***********************END MAIN PROGRAM**********************************
;*************************************************************************
;*************************************************************************
;*******************CALLED PROCEDURES START HERE**************************

;*************************************************************************
;	GET_VERSION
; 	Get DOS version and test for correctness
;	ENTRY-none
;	EXIT- GET_VERSION does a DOS exit if the version is wrong
;*************************************************************************
	PUBLIC	GET_VERSION	
GET_VERSION	PROC	NEAR
	MOV	AH,DOSF_GETVER		;Get DOS version number
	INT	DOSI_FUNC
	CMP	AL,VERSION		;Version correct?
	JGE	GET_VERS10		;Yes, continue
	MOV	DX,OFFSET VER_ERROR	;Display bad version
	MOV	AH,DOSF_OUTSTR		;Using 1.0 function call
	INT	DOSI_FUNC
	INT	DOSI_TERM		;And exit (1.0 call)
GET_VERS10:
	MOV	DOS_VER,AL		; Save this
	RET
GET_VERSION 	ENDP

;*************************************************************************
;	GET_DEFAULTS
;	Get default drive designation, store it in display area and 
;	in DEF_DRIVE
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	GET_DEFAULTS	
GET_DEFAULTS	PROC	NEAR
	MOV	AH,DOSF_GETDISK		;Get current drive
	INT	DOSI_FUNC		;In AL
	MOV	DL,AL			;Put it into DL
	ADD	AL,41H			;And change it to a letter (0=A,etc)
	MOV	DEF_DRIVE,AL   		;Save the default drive designation
	MOV	FILE1.DISK,AL		;In the filenames as well
	MOV	FILE2.DISK,AL		
	MOV	AH,DOSF_SELDISK		;And get how many drives there are
	INT	DOSI_FUNC		;In AL
	DEC	AL			;0-base it
	MOV	MAXDISK,AL		;And save it
	MOV	AX,DOSF_CHROP*256+0
	INT	21H			; DL = switch character
	MOV	AL,'\'			;Assume dir char is '\'
	CMP	DOS_VER,3		;...which must be for ver 3 and above
	JAE	GET_DEFAULTS10		
	CMP	DL,'/'			;Is switch char '/'?
	JE	GET_DEFAULTS10		;Yes,continue
	MOV	AL,'/'			;Else set dir char to '/'
GET_DEFAULTS10:
	MOV	DIR_CHAR,AL		;Save directory char
	RET
GET_DEFAULTS	ENDP

;*************************************************************************
;	ALLOCATE
;	Allocates space for read buffers, calculates and saves their size
;	and segments.
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	ALLOCATE	
ALLOCATE	PROC	NEAR
	MOV	AH,DOSF_SETBLK		;Shrink this program down
	MOV	BX,COMP_SIZE		;To its real size
	INT	DOSI_FUNC
	MOV	AH,DOSF_ALLOC		;Try to allocate
	MOV	BX,MAXMEM		;128K for file buffers
	INT	DOSI_FUNC		
	JNC	ALLOCATE20		;If no errors, continue
ALLOCATE10:
	MOV	AH,DOSF_ALLOC		;Else re-allocate
	INT	DOSI_FUNC
ALLOCATE20:
	MOV	DX,BX			;Save this number
	SHL	BX,1			;Convert from paragraphs total
	SHL	BX,1			;(bytes shr 4) to bytes/buffer
	SHL	BX,1			;(buffer shl 4 shr 1)
	DEC	BX			;In case got all 64k bytes
	MOV	BUFFERSIZE,BX		;which is buffer shl 3
	MOV	FILE1.BUFFERSEG,AX	;Save buffer segment
	SHR	DX,1			;Go from para's to segments
	ADC	AX,DX			;Account for odd paras (rmk 9/26/84)
	MOV	FILE2.BUFFERSEG,AX	;And save it
	RET
ALLOCATE	ENDP

;*************************************************************************
;	SET_DTA
;	Set disk transfer address
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	SET_DTA		
SET_DTA		PROC	NEAR
	LEA	DX,[BX.DTA]		;Set DTA space
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	RET
SET_DTA		ENDP	

;*************************************************************************
;	OUTSTRING
;	Output a string to the screen
;	ENTRY	- [DX] = count of bytes to display
;		  [DX+1] = string to display
;	EXIT	- none
;	BX must be preserved
;*************************************************************************
	PUBLIC	OUTSTRING	
OUTSTRING	PROC	NEAR
	MOV	BP,BX			;Save BX
	MOV	BX,DX			;Need an index register
	MOV	CX,[BX]			;Get number of bytes in string
	ADD	DX,2			;Point to first char of string
	MOV	BX,STDOUT		;Write to stdout (SCREEN)
	MOV	AH,DOSF_WRITEH		;Display string
	INT	DOSI_FUNC
	MOV	BX,BP			;Restore BX
	RET
OUTSTRING	ENDP

;*************************************************************************
;	INSTRING
;	Read a string from the keyboard
;	ENTRY	- [DX] = bytes to read
;		  [DX+1] = space for string (must be at least [DX] long)
;	EXIT	- none
;	BX must bemust be preserved
;*************************************************************************
	PUBLIC	INSTRING	
INSTRING	PROC	NEAR
	MOV	BP,BX			;Save BX
	MOV	SI,DX			;Need an index reg
	MOV	CL,[SI]			;Get bytes to read
	INC	DX			;Point to string space
	XOR	CH,CH			;Clear high byte
	MOV	BX,STDIN		;Get from stdin (KEYBOARD)
	MOV	AH,DOSF_READH		;Get string
	INT	DOSI_FUNC		
	MOV	BX,BP			;Restore BX
	RET
INSTRING	ENDP

;*************************************************************************
;	DISKOK
;	Test a specified drive for validity. If valid, store that letter
;	in the display space; if invalid, display that message and get
;	a new filename
;	ENTRY	- [SI] = drive letter
;		  BX = offset of file data area
;	EXIT	- Carry set if invalid disk was specified
;*************************************************************************
	PUBLIC	DISKOK	
DISKOK	PROC	NEAR
	MOV	CL,[SI]			;Get drive letter
	AND	CL,CAPS_MASK		;Get rid of caps/no caps bit
	MOV	AH,CL			;Save it
	SUB	CL,41H			;Make A be 0
	JS	DISKOK10
	CMP	CL,MAXDISK		;Is the chosen disk in range?
	JG	DISKOK10		;No-display message
	MOV	[BX].DISK,AH		;And store it
	ADD	SI,2			;Point past drive
	MOV	[BX].START,SI		;And store this as the new start
	CLC				;Show disk spec is ok
	JMP	DISKOK20		

;Bad disk specified. Select correct get-name message
DISKOK10:
	MOV	DX,OFFSET BAD_DISK	;Else display bad disk message
	CALL	OUTSTRING
	MOV	DX,OFFSET GETFIRST	;Assume this is first file
	CMP	BX,OFFSET FILE1		;Is it?
	JE	DISKOK15		;Yes-do get file
	MOV	SI,1
	CALL	DISPLAY_CRLF		;Display a line feed
	MOV	DX,OFFSET GETSECOND	;Do get file2

;Get a new filename
DISKOK15:
	CALL	GET_FILE		;Get the file
	STC
DISKOK20:
	RET			
DISKOK	ENDP
	
;*************************************************************************
;	GET_FILE
;	Display the 'enter name prompt' and get a new string
;	ENTRY	- DX points to count/message for correct file name
;	EXIT	- none
;*************************************************************************
	PUBLIC	GET_FILE	
GET_FILE	PROC	NEAR
	CALL	OUTSTRING		;Display prompt and get string
	MOV	DX,PHD_DIOA		;Get a new string in here
	CALL	INSTRING		;by this call
	MOV	SI,DX			;String pointer in SI
	RET
GET_FILE	ENDP

;*************************************************************************
;	SETTWO
;	Set filename 2 to filename 1 and transfer wild, star flags
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	SETTWO	
SETTWO	PROC	NEAR
	MOV	BX,OFFSET FILE1		;This is source data
	MOV	BP,OFFSET FILE2		;This is destination
	MOV	DI,OFFSET FILE2.REAL	;Put this new string in REAL2 space
	MOV	SI,OFFSET FILE1.REAL	;This is the 'new' string
	CALL	MOVE_STRING		;Get copy of file1 in file2 space
	MOV	AL,FILE1.FLAGS		;Get file1 flags
	AND	AL,WILD OR STARS	;Transfer these flags only
	OR	AL,NOFILE		;Flag file2 is a copy
	MOV	FILE2.FLAGS,AL		;And put it in the file 2 flags
	RET
SETTWO	ENDP	

;*************************************************************************
;	MOVE_STRING
;	Move a filename. The file data area pointed at by BP is modified
;	so that START, FILESTART, and LASTCHAR are correct for the new
;	location. Capitalize all characters.
;	ENTRY	- BX = offset of old file data area
;		  DI = offset of new file location
;		  BP = offset of new file data area
;	EXIT	- none 
;*************************************************************************
	PUBLIC	MOVE_STRING	
MOVE_STRING	PROC	NEAR
	MOV	CX,[BX].LASTCHAR	;Offset of last char in file
	MOV	SI,[BX].START		;Offset of first char in file
	SUB	CX,SI			;Char length of file
	MOV	AX,[BX].FILESTART	;And get location of last dir char
	SUB	AX,SI			;As an offset
	MOV	DX,DI			;Do some calcs
	MOV	BX,BP			;Point to destination filespace
	MOV	[BX].START,DX		;New start is new string space
	ADD	DX,AX			;Get new offset of last dir char
	MOV	[BX].FILESTART,DX	;Save it	
	MOV	DX,DI			;Get the unfixed one back
	ADD	DX,CX			;Now have offset of last char
	MOV	[BX].LASTCHAR,DX	;Save it
	INC	CX			;Fix this
	CALL	CAPS			;Move and capitalize
	RET
MOVE_STRING 	ENDP

;*************************************************************************
;	FIND_THEN_MOVE
;	Call 'find first'. If the file is found, expand the packed_name
;	of the file, else expand the original name of the file, to 12 chars
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	FIND_THEN_MOVE	
FIND_THEN_MOVE	PROC	NEAR
	CALL	FIND_FIRST		; Find first file
	MOV	SI,[BX].FILESTART	; Assume file not found
	JZ	FIND_THEN_MOVE10	; Jump if found
	OR	[BX].FLAGS,NOT_FOUND	
	JMP	FIND_THEN_MOVE20	; use name from user spec.
; file was found - if file2, use .FILESTART anyway
FIND_THEN_MOVE10:
	CMP	BX,OFFSET FILE2		; Is this file 2?
	JZ	FIND_THEN_MOVE20	; no
	LEA	SI,[BX.DTA+PACKED_NAME]	; Use found file name
FIND_THEN_MOVE20:
	LEA	DI,[BX.EXP_NAME]	;Point to start of file space
	CALL	MAKE_SPACES		;And expand it
	RET
FIND_THEN_MOVE	ENDP

;*************************************************************************
;	FIND_FIRST
;	Determine if a file exists as a file, as a directory, or not
;	at all. If it exists as a directory, fill the filename with '*.*'
;	and see if there are any files in that directory
;	ENTRY	- BX = offset of file data area
;	EXIT	- ZF reset if file not found
;	BX must be preserved
;*************************************************************************
	PUBLIC	FIND_FIRST	
FIND_FIRST	PROC	NEAR
	MOV	SI,BX			;Save filespace pointer
	CALL	SET_DTA			;Set DTA!

;Search for a file with a file attribute.If found,make sure it's really a file
FIND_FIRST5:
	MOV	AH,DOSF_FFIRST		;Find first match to file
	MOV	CX,FILE_ATTR		;Look for a file
	LEA	DX,[SI.DISK]		;In fact, look for this file
	INT	DOSI_FUNC		
	JC	FIND_FIRST10		;If error, look for a directory
	XOR	CH,CH			;Clear CH for ok
	MOV	BX,SI			;Get filespace pointer back in BX
	MOV	AL,[SI.DTA+ATTR]	;Get duplicate pointer to file def
	CMP	AL,FILE_ATTR		;Is it a real file?
	JE	FIND_FIRST20		;Yes-good
	CMP	AL,FILE_ATTR2		;This is another way that files look
	JE	FIND_FIRST20		; (the archive bit)...is ok too
	CMP	AL,FILE_ATTR3		; READ-only
	JE	FIND_FIRST30		; is ok too

;No file found. Test for directory. If directory, fill with '*.*'
FIND_FIRST10:
	MOV	AH,DOSF_FFIRST		;Else see if it's a dir
	MOV	CX,DIR_ATTR		;Say we want a dir
	LEA	DX,[SI.DISK]		;Is this a dir?
	INT	DOSI_FUNC		
	XOR	CH,CH			;Clear CH in case of problems
	MOV	AL,[SI.DTA+ATTR]	;Get duplicate pointer to file def
	CMP	AL,DIR_ATTR		;Is it a real directory?
	JNE	FIND_FIRST30		;No-then this is all an error
	MOV	BX,SI			;Get filespace in BX
	CALL	FILL_FILE		;Fill it
	JNZ	FIND_FIRST30		;NZ means file already had been filled
	MOV	SI,BX			;Get it together
	JMP	FIND_FIRST5		;And look again
FIND_FIRST20:
	SUB	CL,CL			;Show all ok
FIND_FIRST30:
	RET
FIND_FIRST	ENDP

;*************************************************************************
;	FILL_FILE	
;	Add *.* or \*.* to the end of a file and set wild and star flags
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	FILL_FILE	
FILL_FILE	PROC	NEAR
	TEST	[BX].FLAGS,FILLED	; Filled?
	JNZ	FILL_FILE30		; Yes - exit
	MOV	SI,[BX].LASTCHAR	;Point to last char
	CMP	BYTE PTR [SI],'*'	; Last char a '*'?
	JNE	FILL_FILE05
	OR	[BX].FLAGS,FILLED	; Set filled (and NZ)
	JMP	SHORT FILL_FILE30
FILL_FILE05:
	CMP	BYTE PTR [SI],'.'	; Last char a '.'?
	JNE	FILL_FILE06
	OR	[BX].FLAGS,FILLED	; Set filled (and NZ)
	JMP	SHORT FILL_FILE30
FILL_FILE06:
	MOV	AL,DIR_CHAR		;Get directory char
	CMP	[SI],AL			;Is it a dir char?
	JE	FILL_FILE10		;Yes, fine
	CMP	BYTE PTR [SI],CC_CR	;Pointing at a <CR>? (only d: spec'd)
	JE	FILL_FILE20		;Yes-start filling _right here_
	INC	SI			;Else point to next char
	MOV	[SI],AL			;And make it a dir char
FILL_FILE10:
	INC	SI			;Point to first empty space
FILL_FILE20:
	MOV	[BX].FILESTART,SI	;This is now the start of the file
	MOV	BYTE PTR [SI],STAR	;Fill with wildcards...
	INC	SI
	MOV	BYTE PTR [SI],DOT
	INC	SI
	MOV	BYTE PTR [SI],STAR
	MOV	[BX].LASTCHAR,SI	;Now this is the lastchar
	INC	SI
	MOV	BYTE PTR [SI],0		;Put in null terminator
	OR	[BX].FLAGS,WILD OR STARS OR FILLED;Set flags
	SUB	AL,AL			;Set ZR to show ok
FILL_FILE30:
	RET
FILL_FILE	ENDP

;*************************************************************************
;	MATCH_CHAR
;	Match question marks in filename2 with characters from filename 1
;	ENTRY	- BX = offset of file with wildcards 
;	EXIT	- none
;*************************************************************************
	PUBLIC	MATCH_CHAR	
MATCH_CHAR	PROC	NEAR
	MOV	SI,OFFSET FILE1.EXP_NAME ;Point to start of expanded filename
	MOV	DI,OFFSET FILE2.EXP_NAME ;And start of destination
	MOV	AH,QMARK		;Wildcard (search) char
	MOV	CL,FILENAME		;Match filename first
	CALL	MATCH			;Do it
	MOV	BYTE PTR [DI],DOT	;Put in the dot
	INC	SI			;Point to next everything
	INC	DI
	INC	BX
	MOV	CL,EXTENSION		;Do it again for the ext
	CALL	MATCH			;Do it
	RET
MATCH_CHAR	ENDP

;*************************************************************************
;	MATCH
;	Do the real testing for and replacing of wildcards
;	ENTRY	- BX = offset of file with wildcards
;		- SI = offset of expanded filename 1
;		- DI = offset of expanded filename 2
;	EXIT	- none
;*************************************************************************
	PUBLIC	MATCH	
MATCH	PROC	NEAR
MATCH10:
	MOV	AL,[BX]			;Get a char
	CMP	AL,AH			;Is it a wildcard?
	JE	MATCH20			;Yes-take care of it
	INC	SI			;Point to next everything
	INC	DI
	INC	BX
	DEC	CL			;Decrement left to go
	JZ	MATCH30			;If done, end
	JMP	MATCH10			;Else continue
MATCH20:
	MOVSB				;Move the byte
	INC	BX			;Point to next
	DEC	CL			;Count this byte
	JNZ	MATCH10			;If not done, continue
MATCH30:
	RET
MATCH	ENDP

;*************************************************************************
;	MATCH_TWO
;	Direct the matching of wildcards and the moving/shrinking of the file
;	and then 'find first' it
;	ENTRY	- BX = offset of expanded filename with wildcards
;	EXIT	- none
;*************************************************************************
	PUBLIC	MATCH_TWO	
MATCH_TWO	PROC	NEAR
	CALL	MATCH_CHAR		;Do match char
	CALL	SHRINK			;Yes-shrink file2
	MOV	BX,OFFSET FILE2		;And find first again
	CALL	FIND_FIRST		;Try to find it
	JZ	MATCH_TWO10
	OR	FILE2.FLAGS,NOT_FOUND	;Show file not found
MATCH_TWO10:
	RET
MATCH_TWO	ENDP

;*************************************************************************
;	SHRINK
;	Take an expanded, matched filename and re-pack it at the end
;	of the pathname - note that embedded spaces should not be eaten
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	SHRINK		
SHRINK		PROC	NEAR
	MOV	DI,FILE2.FILESTART	;Shrink the filename into here
	MOV	AL,[DI]			;Here?
	CMP	AL,DIR_CHAR		;Pointing at a dir char?
	JNE	SHRINK5			;No-then here's good
	INC	DI			;Point past
SHRINK5:
	LEA	SI,[FILE2.EXP_NAME]	;Point to first char
	MOV	AL,SPACE		;Get a space
	MOV	CL,LEN_EXPNAME		;12 chars max
SHRINK10:
	DEC	CL			;Next char
	JS	SHRINK30		;Jump if done
	CMP	BYTE PTR [SI],SPACE	;Is the char a space?
	JE	SHRINK20		;Yes-do something
SHRINK15:
	MOVSB				;No-transfer the char
	JMP	SHRINK10		;And go on
; found a space - if embedded (ie A B.BAS) then do not eat it
SHRINK20:
	MOV	BP,SI			; Save SI
	MOV	CH,CL			; And CL
SHRINK22:
	DEC	CH			; Done?
	JS	SHRINK25		; Yes - eat all spaces
	INC	BP			; look at next char
	CMP	BYTE PTR DS:[BP],' '	; Is this char a space?
	JNE	SHRINK15		; No - move the space and continue
	JMP	SHRINK22		; Yes-keep looking for spaces or EOF
SHRINK25:
	MOV	SI,BP			; Point to EOF
SHRINK30:
	MOV	BYTE PTR [DI],0		;Put a null in so MS-DOS sees the end
	RET
SHRINK		ENDP

;*************************************************************************
;	NO_FILE	
;	Expand stars to question marks if necessary, and display the 
;	'file not found' error message
;	ENTRY	- DX = offset of correct count/message
;		- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	NO_FILE		
NO_FILE		PROC	NEAR
	MOV	SI,2			;Want to display 2 CRLF's
	CALL	DISPLAY_CRLF		;Make some space, man
	TEST	[BX].FLAGS,STARS	;Need to expand stars?
	JZ	NO_FILE10		;No.
	LEA	DI,[BX.EXP_NAME]	;Point to expanded name
	CALL	STAR_TO_Q		;And expand it
NO_FILE10:
	CALL	DISPLAY_NAME		;And display the name
	MOV	DX,OFFSET NO_FILE_FOUND	;And display file not found
	CALL	OUTSTRING		
	RET
NO_FILE		ENDP

;*************************************************************************
;	STAR_TO_Q
;	Do the overhead for expnding stars to question marks
;	ENTRY	- BX = offset of expanded name containing stars
;	EXIT	- none
;*************************************************************************
	PUBLIC	STAR_TO_Q	
STAR_TO_Q	PROC	NEAR
	AND	[BX].FLAGS,NOT STARS ;No stars anymore, only Qmarks
	MOV	SI,DI		;Source=dest
	MOV	CX,FILENAME	;Look for stars, and turn them into 
	MOV	DH,STAR		;QMARKS
	MOV	DL,QMARK
	CALL	EX_STARS
	MOV	SI,DI		;And even it up (a good man pays his debts)
	MOV	CX,4		;Now do the extension
	CALL	EX_STARS
STAR_TO_Q10:
	RET
STAR_TO_Q	ENDP		;All done

;*************************************************************************
;	EX_STARS
;	Do the real work of expanding stars to the correct number of 
;	question marks
;	ENTRY	- BX = offset of expanded filename
;	EXIT	- none
;*************************************************************************
	PUBLIC	EX_STARS
EX_STARS	PROC	NEAR
EX_STARS10:
	LODSB			;Get a byte
	CMP	AL,DH		;Is it a star?
	JE	EX_STARS20	;Yes-deal with it
	INC	DI		;Move the destination along
	LOOP	EX_STARS10	;Else do next char
	JMP	EX_STARS40	;Jump if done
EX_STARS20:
	MOV	AL,DL		;Put the QMARK in the hot seat
EX_STARS30:
	STOSB			;Store it
	INC	SI		;Keep us up to date here,too
	LOOP	EX_STARS30	;If there's left to go, go!
EX_STARS40:
	RET
EX_STARS	ENDP

;*************************************************************************
;	CAPS
;	Turn small letters into capitals
;	ENTRY	- SI = offset of string to capitalize
;		  DI = offset of where to put it when it's done
;		  CL = Count of bytes to test/set
;	EXIT	- none
;*************************************************************************
	PUBLIC	CAPS	
CAPS	PROC	NEAR
	MOV	CH,CAPS_MASK	;Caps maker
	MOV	DL,'a'		;Low end of small alphabet
	MOV	DH,'z'		;High end of small alphabet
CAPS10:
	LODSB			;Get a byte
	CMP	AL,DL		;Is it less than an 'a'?
	JL	CAPS20 		;Yes-don't cap it
	CMP	AL,DH		;Is it bigger than a 'z'?
	JG	CAPS20	 	;Yes-leave it
	AND	AL,CH		;Cap it
CAPS20:
	STOSB
	DEC	CL
	JNZ	CAPS10		;If more, keep going
	RET			;Else quit
CAPS	ENDP

;*************************************************************************
;	DISPLAY_TWO	
;	Display both filenames
;	ENTRY	- SI = count of CRLF's to display first
;	EXIT	- none
;*************************************************************************
	PUBLIC	DISPLAY_TWO	
DISPLAY_TWO	PROC	NEAR
	CALL	DISPLAY_CRLF		
	MOV	BX,OFFSET FILE1		;Display filename 1
	CALL	DISPLAY_NAME
	MOV	DX,OFFSET DAND		;...AND...
	CALL	OUTSTRING
	MOV	BX,OFFSET FILE2		;Display filename 2
	CALL	DISPLAY_NAME
	MOV	SI,1			
	MOV	DX,OFFSET CRLF		;Display a line feed
	CALL	OUTSTRING
	RET
DISPLAY_TWO	ENDP

;*************************************************************************
;	DISPLAY_CRLF
;	Display some carriage return-line feeds
;	ENTRY	- SI = number of CRLF's to display
;	EXIT	- none
;*************************************************************************
	PUBLIC	DISPLAY_CRLF	
DISPLAY_CRLF	PROC	NEAR
DISPLAY_CRLF10:	
	MOV	DX,OFFSET CRLF		;Display a line feed
	CALL	OUTSTRING
	DEC	SI
	JNZ	DISPLAY_CRLF10		;Display more if needed
	RET
DISPLAY_CRLF	ENDP

;*************************************************************************
;	DISPLAY_NAME
;	Display the pathname (d:dir\dir\...) and the expanded filename
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	DISPLAY_NAME	
DISPLAY_NAME	PROC	NEAR
	MOV	SI,BX			;OUTSTRING kills BX
	MOV	CX,[BX].FILESTART	;Get count
	SUB	CX,[BX].START		;Like this
	ADD	CX,DISK_SIZE		;Add in to display the disk
	MOV	[BX].PATHNAME,CX	;And store it
	LEA	DX,[BX.PATHNAME]	;Point to d:pathname
	CALL	OUTSTRING		;Display it
	LEA	DX,[SI.EXP_COUNT]	;Point to expanded filename
	MOV	SI,DX			;Need an index register
	ADD	SI,FILENAME+2		;Point to the '.'
	CMP	BYTE PTR [SI+1],SPACE	;Is it a space? 
	JNE	DISPLAY_NAME10		;No-then there must be an extension
	MOV	BYTE PTR [SI],SPACE	;Yes-then don't display the '.'
DISPLAY_NAME10:
	CALL	OUTSTRING		;display it
	RET
DISPLAY_NAME	ENDP

;*************************************************************************
;	MAKE_SPACES
;	Expand a file name to 8 characters, then a dot, then the extension
;	ENTRY	- SI = pointer to packed filename
;		  DI = pointer to space for expanded filename
;	EXIT	- none
;*************************************************************************
	PUBLIC	MAKE_SPACES	
MAKE_SPACES	PROC	NEAR
	MOV	DL,DOT			;Test char
	MOV	DH,0			;In case there is no extension
	XOR	CH,CH			;Count space
	MOV	CL,FILENAME		;First time is fill file
MAKE_SPACES10:
	CMP	[SI],DL			;Got what we want?
	JE	MAKE_SPACES20		;Yes-deal with it
	CMP	[SI],DH			;This could also be it
	JE	MAKE_SPACES20		;If it is, deal with it,too
	MOVSB				;Get char
	INC	CH			;Another one transfered
	CMP	CL,CH			;Got enough?
	JNZ	MAKE_SPACES10		;No-keep getting them
MAKE_SPACES20:
	SUB	CL,CH			;Get count remaining
	MOV	AL,SPACE		;Prepare to stuff
MAKE_SPACES30:
	XOR	CH,CH			;Clear CH
	REP	STOSB			;Store a char
	MOV	[DI],DL			;Store a '.' or a null
	CMP	DL,DH			;Is this a null?
	JZ	MAKE_SPACES40		;Yes-then all done
	MOV	CX,EXTENSION		;Else fill extension
	MOV	DL,DH			;Looking for a null only
	INC	SI			;Point to next char
	INC	DI
	CMP	[SI-1],DH		;Is this a name without an extension?
	JE	MAKE_SPACES30		;Yes-just fill spaces
	JMP	MAKE_SPACES10		;And continue
MAKE_SPACES40:
	RET				;Phew!
MAKE_SPACES	ENDP

;*************************************************************************
;	FIX_TWO
;	Dealing with filename 2 only, expand stars and move that question
;	mark filled file into the 'wild-file' space
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	FIX_TWO		
FIX_TWO		PROC	NEAR
	MOV	BX,OFFSET FILE2 	;Use file2
	TEST	FILE2.FLAGS,STARS	;Need to expand stars?
	JZ	FIX_TWO10		;No
	LEA	DI,[BX.EXP_NAME]	;Point to start of expanded name
	CALL	STAR_TO_Q		;And expand stars to QMARKs
FIX_TWO10:
	LEA	SI,[BX.EXP_NAME]	;Move this file name!
	MOV	DI,OFFSET WILD_FILE	;To this location
	MOV	BX,DI			;Save this
	MOV	CX,LEN_EXPNAME SHR 1	;Move filename
	REP	MOVSW			;And move the extension
	RET
FIX_TWO		ENDP

;*************************************************************************
;	SAME_SIZE
;	Test that two files are the same size
;	ENTRY	- none
;	EXIT	- carry set if files are different sizes
;*************************************************************************
	PUBLIC	SAME_SIZE	
SAME_SIZE	PROC	NEAR
	MOV	DI,OFFSET FILE1.DTA	;Get DTA1
	MOV	SI,OFFSET FILE2.DTA	;Get DTA2
	ADD	DI,LOW_SIZE		;Point to sizes
	ADD	SI,LOW_SIZE
	MOV	BX,[DI]			;Get file1 size
	CMP	BX,[SI]			;Same as file2 size?
	JNE	SAME_SIZE10		;No-output message and return
	ADD	SI,2			;Point to high sizes
	ADD	DI,2			
	MOV	BX,[DI]			;Get file1 high size
	CMP	BX,[SI]			;Compare it with file2 high size
	JE	SAME_SIZE20		;Exit (carry cleared) if ame
SAME_SIZE10:
	MOV	DX,OFFSET DIFSIZES	;Display error message
	CALL	OUTSTRING
	STC
SAME_SIZE20:
	RET				;Carry is set if error
SAME_SIZE	ENDP

;*************************************************************************
;	READ_FILES
;	Get file handles and read data for two files. Store the bytes count.
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	READ_FILES	
READ_FILES	PROC	NEAR
	MOV	BX,OFFSET FILE2		;Get file handle for file2
	CALL	OPEN			;Open the file
	LEA	SI,[FILE2.DTA+LOW_SIZE] ; Save the file size (rmk 9/26/84)
	MOV	CX,[SI]
	MOV	FILE2_SIZE_LOW,CX
	MOV	CX,[SI+2]
	MOV	FILE2_SIZE_HI,CX
	CALL	READ			;Read from the file
	MOV	COUNT,AX		;Save update/count value of bytes read
	MOV	BX,OFFSET FILE1		;Get file handle for file1
	CALL	OPEN			;And open/read it
	CALL	READ			
	RET
READ_FILES	ENDP

;*************************************************************************
;	OPEN
;	Get a file handle
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	OPEN	
OPEN	PROC	NEAR
	MOV	DI,[BX].FILESTART	;Point to last dir char(if any)
	MOV	AL,[DI]			;Get this char
	CMP	AL,DIR_CHAR		;Is it a directory char?
	JNE	OPEN10			;No-leave it
	INC	DI			;Else point past it
OPEN10:
	LEA	SI,[BX.DTA]		;Point to packed name of file
	ADD	SI,PACKED_NAME		
	MOV	CX,LEN_EXPNAME		;Get 12 chars	
	REP	MOVSB			;On to end of pathname
	MOV	BYTE PTR [DI],0		;And end it with a zero
	LEA	DX,[BX.DISK]		;Point to start of pathname
	MOV	AL,DOSFO_RED		;Open file to read only
	MOV	AH,DOSF_OPENH		
	INT	DOSI_FUNC		;And do it
	JNC	OPEN20			;Jump if ok
	MOV	DX,OFFSET SYSERR	;Show system error
	CALL	OUTSTRING		;But keep going
OPEN20:
	MOV	[BX].HANDLE,AX		;Save the handle
	RET
OPEN	ENDP

;*************************************************************************
;	READ	
;	Read data from a file into a buffer
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	READ	
READ	PROC	NEAR	
	CALL	POINT			;Move the file pointer 
	MOV	AH,DOSF_READH		;Now we'll get some chars
	XOR	DX,DX			;Pointer to buffer (always 0)
	MOV	CX,BUFFERSIZE		;Get it (ONLY WHAT FITS-rmk 9/26/84)
	MOV	SI,[BX].BUFFERSEG	;Get read buffer segment
	MOV	BP,[BX].HANDLE		;Get handle
	XCHG	BP,BX			;In BX and save filespace pointer
	PUSH	DS			;Save DS
	MOV	DS,SI
	INT	DOSI_FUNC		;Get them bytes
	POP	DS
	AND	FILE1.FLAGS,NOT READMORE ;Turn off read more
	XCHG	BP,BX			;Get filespace pointer back in BX
	LEA	SI,[BX.DTA+LOW_SIZE]	;Point to low size
	MOV	CX,[SI]			;Get it
	MOV	DX,[SI+2]		;And high size in DX
	SUB	CX,AX			;Subtract count of bytes read
	SBB	DX,0			;From DWORD
	MOV	[SI],CX			;Store new sizes
	MOV	[SI+2],DX		;For later		
	OR	CX,DX			;All done?
	JZ	READ30			;Yes-exit
READ20:
	OR	[BX].FLAGS,READMORE	;No-flag it
READ30:
	RET
READ	ENDP

;*************************************************************************
;	POINT
;	Move a file pointer to the correct location in the file
;	ENTRY	- BX = offset of file data area
;	EXIT	- none
;*************************************************************************
	PUBLIC	POINT	
POINT	PROC	NEAR
	MOV	BP,BX			;Save BX
	MOV	AH,DOSF_LSEEK		;Move file pointer
	MOV	AL,DOSFL_BEG		;From the beginning of the file
	MOV	CX,READ_CT_HIGH		;To the current
	MOV	DX,READ_CT_LOW		;Location in the file
	MOV	BX,DS:[BP].HANDLE		;In this file
	INT	DOSI_FUNC		;NOW!
	MOV	BX,BP			;Restore BX
	RET
POINT	ENDP

;*************************************************************************
;	COMPARE
;	Compare two buffers, and display compare-related messages
;	ENTRY	- none
;	EXIT	- Carry set if error count = 10
;*************************************************************************
	PUBLIC	COMPARE		
COMPARE		PROC	NEAR
	XOR	SI,SI			;Start at offset 0
	MOV	DI,SI
	MOV	DL,ERR_COUNT		;Dl holds the count of errors
	MOV	CX,COUNT		;Get count  of bytes to test
	PUSH	ES
	PUSH	DS
	MOV	AX,FILE1.BUFFERSEG	;Point to file buffers
	MOV	ES,AX
	MOV	AX,FILE2.BUFFERSEG
	MOV	DS,AX			
;Compare files. If errors, deal with them
COMPARE10:
	REP	CMPSB			;Compare them bytes
	JNZ	COMPARE20		; Last byte patch
	JCXZ	COMPARE30		;If all same, compare last byte
;Found a difference-display the offset and the two bytes
;Note: The POP AX, PUSH RX and POP RX, PUSH DS _must_ be in that order
COMPARE20:
	POP	AX			;Get old DS value in AX
	PUSH	DX			;Save count of mismatches
	PUSH	CX			;And count of bytes to compare
	MOV	DH,[SI-1]		;Get DS:SI value
	PUSH	DS			;Save old DS value
	MOV	DS,AX			;Point to data segment
	CALL	FOUND_DIF		;Else show found a difference
	POP	AX			;Get back read segment
	POP	CX			;And count of bytes to compare
	POP	DX			;And count of mismatches
	PUSH	DS			;Save data segment
	MOV	DS,AX
	MOV	SI,DI			;Get pointers back
;Increment error count-if 10 errors, exit
	JCXZ	COMPARE30		; if this is the end, leave it!
	INC	DL
	CMP	DL,MISCOUNT		;Have 10 mismatches?
	JL	COMPARE10		;No,continue
	POP	ES
	POP	DS
	MOV	DX,OFFSET ENDCOMP	;Show compare error
	CALL	OUTSTRING	
	STC				;Show errors exceeded allowable amount
	JMP	COMPARE60		;And exit
;Test for end of file
COMPARE30:
	MOV	AL,ES:[DI-1]		;Get last byte
	MOV	BL,[SI-1]		;Other last byte
	POP	ES
	POP	DS
	MOV	ERR_COUNT,DL		;Save the error count
	TEST	FILE1.FLAGS,READMORE	;Still more bytes?
	JNZ	COMPARE50		;Don't display message
	CMP	AL,EOF			;Is it an EOF?
	JE	COMPARE40		;Yes-then it's ok
	CMP	BL,EOF			;Is it an EOF?
	JE	COMPARE40		;Yes-still ok
	MOV	DX,OFFSET NO_EOF	;Show no EOF
	CALL	OUTSTRING
;Test for applicability of ok-compare and display it if it applys
COMPARE40:
	CMP	ERR_COUNT,0		;Any errors?
	JNZ	COMPARE50		;Yes, don't display 'ok files'
	MOV	DX,OFFSET OK_COMP	;Display files ok message
	CALL	OUTSTRING
;Update count/pointer values and clear carry to show error count is ok
COMPARE50:	
	MOV	AX,COUNT		;Update pointers
	ADD	READ_CT_LOW,AX		;To files
	ADC	READ_CT_HIGH,0
	CLC				;Show no too many errors
COMPARE60:
	RET
COMPARE		ENDP

;*************************************************************************
;	FOUND_DIF
;	Deal with overhead for getting error location and byte values
;	into error message. Display error message
;	ENTRY	- DH = value of non-matching byte from file 2
;		  [DI] = value of non matching byte from file 1
;	EXIT	- none
;*************************************************************************
	PUBLIC	FOUND_DIF	
FOUND_DIF	PROC	NEAR
	MOV	AH,2			;Say, display 2 characters
	MOV	SI,OFFSET BYTE2		;DS:SI byte is alredy in DH
	CALL	MAKE_ASCII		;Make it ASCII
	MOV	DH,ES:[DI-1]		;Translate bytes
	MOV	AH,2			;Again, two characters
	MOV	SI,OFFSET BYTE1		;Into ASCII codes for display
	CALL	MAKE_ASCII
	CALL	MAKE_LOC		;Translate and set location
	MOV	DX,OFFSET NOMATCH	;Get no match message (which displays
	CALL	OUTSTRING		;entire message)
	RET
FOUND_DIF	ENDP

;*************************************************************************
;	MAKE_ASCII
;	Turn characters from numeric values to ASCII characters
;	ENTRY	- DX:CX = 8 numeric characters
;		  AH = count of characters to display, starting at DH
;	EXIT	- none
;*************************************************************************
	PUBLIC	MAKE_ASCII	
MAKE_ASCII	PROC	NEAR
	MOV	BX,OFFSET HEX_TO_ASC	;Point to start of table
MAKE_ASCII10:
	MOV	AL,DH			;Save this char
	AND	AL,CHAR_MASK		;Get rid of low digit
	SHR	AL,1			;Which must be shifted
	SHR	AL,1			;Into the low positoin
	SHR	AL,1			;Of the byte
	SHR	AL,1
	XLAT				;Make it an ASCII char
	MOV	[SI],AL			;And store it
	DEC	AH			;Decrement count of chars
	JZ	MAKE_ASCII20		;If that's all, stop
	INC	SI			;Point to next byte
	XCHG	AL,DH			;Do the same for the low digit
	AND	AL,NOT CHAR_MASK	;Get rid of high digit		
	XLAT				;Like this
	MOV	[SI],AL			;Store first char
	DEC	AH			;Count that char
	JZ	MAKE_ASCII20		;And jump if done
	INC	SI			;Else point to next byte
	MOV	DH,DL			;And move it all aroud
	MOV	DL,CH
	MOV	CH,CL			;Shift in pairs
	JMP	MAKE_ASCII10		;And do some more
MAKE_ASCII20:
	RET
MAKE_ASCII	ENDP
	
;*************************************************************************
;	MAKE_LOC
;	Get the offset of the error from the start of the file and left
;	justify it in DX:CX
;	ENTRY	- DI = offset of error from start of this read
;	EXIT	- DX:CX = offset of error from start of file, left justified
;		- AH = count of characters to display
;*************************************************************************
	PUBLIC	MAKE_LOC	
MAKE_LOC	PROC	NEAR
	MOV	SI,OFFSET ERROR_LOC	;Point to error space
	MOV	BX,DI			;DI has count+1
	DEC	BX
	MOV	DX,READ_CT_HIGH		;Put offset in DX:BX
	ADD	BX,READ_CT_LOW
	ADC	DX,0			;Like this
	JNZ	MAKE_LOC10		;If this value is not zero, don't jump
	CMP	BX,0			;DX=0. If BX=0, do special case
	JNE	MAKE_LOC10		;There are some-do them
	MOV	BYTE PTR [SI],'0'	;Else display an ASCII '0'
	JMP	MAKE_LOC40		;And exit
;DX:BX has offset of error from start of file
MAKE_LOC10:
	MOV	CH,CHAR_COUNT		;Put out 8 chars max
	MOV	CL,CHAR_MOVE		;Times to shift for next char
MAKE_LOC20:
	TEST	DH,CHAR_MASK		;Have a character?
	JNZ	MAKE_LOC30		;Yes-deal with it
	SHL	DX,CL			;Shift to next char
	MOV	AL,BH			;Get top of low char
	SHR	AL,CL			;Shift it
	OR	DL,AL			;Move it
	SHL	BX,CL			;And shift low char
	DEC	CH			;One char done
	JMP	MAKE_LOC20		;Do some more
;DX:BX has left justified offset of error from start of file
MAKE_LOC30:
	MOV	AH,CH			;Get count of chars to output in AH
	MOV	CX,BX			;Free up BX
	CALL	MAKE_ASCII		;Output them
MAKE_LOC40:
	RET
MAKE_LOC	ENDP
	
;*************************************************************************
;	FIND_NEXT
;	'Find next' occurence of file1
;	ENTRY	- none
;	EXIT	- carry set if no next file
;*************************************************************************
	PUBLIC	FIND_NEXT	
FIND_NEXT	PROC	NEAR
	MOV	BX,OFFSET FILE1		;Do set DTA
	CALL	SET_DTA
	MOV	DX,OFFSET FILE1.DTA
	MOV	AH,DOSF_FNEXT		;Call find next
	INT	DOSI_FUNC
	RET
FIND_NEXT	ENDP

;*************************************************************************
;	CLOSE	
;	Clear counts, set displayed error locatino to spaces, and
;	close both files
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	CLOSE	
CLOSE	PROC	NEAR
	MOV	READ_CT_LOW,0		;Clear read counts
	MOV	READ_CT_HIGH,0		
	MOV	COUNT,0			;And count
	MOV	ERR_COUNT,0		;And error count
	MOV	AL,SPACE		;Set error locations to spaces
	MOV	AH,AL			;Words....
	MOV	CX,CHAR_COUNT SHR 1	;Do it in words, it's faster
	MOV	DI,OFFSET ERROR_LOC
	REP	STOSW
	LEA	SI,[FILE2.DTA+LOW_SIZE]	;Restore file2 filesize
	MOV	BX,FILE2_SIZE_LOW
	MOV	[SI],BX
	MOV	BX,FILE2_SIZE_HI
	MOV	[SI+2],BX
	MOV	BX,FILE1.HANDLE		;Close file1
	MOV	AH,DOSF_CLOSEH		
	INT	DOSI_FUNC
	JC	CLOSE10			;Jump if error
	MOV	BX,FILE2.HANDLE		;Close file2
	MOV	AH,DOSF_CLOSEH		
	INT	DOSI_FUNC
	JNC	CLOSE20			;Jump if no error
CLOSE10:
	MOV	DX,OFFSET SYSERR	;Display error message
	CALL	OUTSTRING		;But keep going
CLOSE20:
	RET
CLOSE	ENDP

;*************************************************************************
;	RESTART
;	Find out if more comparing is desired. If not, deallocate
;	and exit. If so, clear file data areas and restore constants
;	ENTRY	- none
;	EXIT	- none 
;*************************************************************************
	PUBLIC	RESTART	
RESTART		PROC	NEAR
RESTART10:
	MOV	DX,OFFSET COMP_MORE	;Put out compare more prompt
	CALL	OUTSTRING
;Get y/n. Exit if n.
RESTART20:
	MOV	AH,DOSF_CONIN		;Read a char from the keyboard
	INT	DOSI_FUNC
	AND	AL,CAPS_MASK		;Mask upper/lower case bit
	CMP	AL,''			;Nothing in yet?
	JE	RESTART20		;Keep waiting
	CMP	AL,'Y'			;Is it a yes?
	JE	RESTART30		;Yes-do restart
	CMP	AL,'N'			;Is it a no?
	JNE	RESTART10		;No-tell 'em it's Y or N or try again
	CALL	DEALLOCATE		;Deallocate file space
	CALL	EXIT			;And exit
;Want more. Clear file data area and restore constants
RESTART30:
	XOR	AX,AX			;Clear AX for STOSW
	MOV	BX,FILE2.BUFFERSEG	;Need to save this
	MOV	DI,OFFSET FILE1.START	;Get start of data area to clear
	MOV	CX,OFFSET DATA_END	;Get length of entire file dependant
	SUB	CX,DI			;Data area
	SHR	CX,1			;And clear it
	JNC	RESTART35		;If this is words,jump
	STOSB				;Else store a single byte
RESTART35:
	REP	STOSW			;Clear all
	MOV	DI,PHD_DIOA		;And program header space
	INC	DI
	MOV	CX,64			
	REP	STOSW		
	MOV	FILE2.BUFFERSEG,BX	;Restore file2 buffer start address
	MOV	FILE1.EXP_COUNT,LEN_EXPNAME ;Set up length of garbage string
	MOV	FILE2.EXP_COUNT,LEN_EXPNAME ;Set up length of garbage string
	MOV	FILE2.PATHNAME,FILE_SIZE ;And size of pathname
	MOV	FILE1.PATHNAME,FILE_SIZE ;And size of pathname
	MOV	AL,DEF_DRIVE		;Restore default drive name
	MOV	FILE1.DISK,AL
	MOV	FILE2.DISK,AL
	MOV	FILE1.DISK+1,COLON	;Put the ':''s back
	MOV	FILE2.DISK+1,COLON	
	CLC
RESTART40:
	RET
RESTART	 	ENDP
	
;*************************************************************************
;	DEALLOCATE
;	Deallocate the space alloacted in ALLOCATE. Since the file2
;	buffer segment is (according to the DOS) part of the file 1
;	segment, only deallocate the file 1 buffer segment.
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
	PUBLIC	DEALLOCATE	
DEALLOCATE	PROC	NEAR
	MOV	AX,FILE1.BUFFERSEG	;They don't want more-dealloc & exit
	MOV	ES,AX			;Get file space segment
	MOV	AH,DOSF_DEALLOC		;Deallocate block
	INT	DOSI_FUNC
	RET
DEALLOCATE	ENDP

;*************************************************************************
;	EXIT
;	Stop, end, exit, finish, terminate
;	ENTRY	- none
;	EXIT	- return to DOS
;*************************************************************************
	PUBLIC	EXIT	
EXIT	PROC	NEAR
	MOV	AL,OKRETURN		;Return code of 0
	MOV	AH,DOSF_EXIT		;And exit
	INT	DOSI_FUNC		;All over!
EXIT	ENDP

;*************************************************************************
;	PARSE
;	Parse a file name. If no name exists, return. Else if filename
;	exists, test for ok disk specified, fill with *.* if needed,
;	and move filename to its new home
;	ENTRY	- SI points to first character
;	EXIT	- AL = 0 if filename exists
;		  AL = 0DH if filename doesn't exist
;*************************************************************************
	PUBLIC	PARSE
PARSE	PROC	NEAR
PARSE1:
	CALL	SOB
	CMP	BYTE PTR [SI],CC_CR	; End of physical line?
	JNZ	PARSE2
	MOV	AL,TKN_EOL		; Show end of line seen
	RET

;	Have something on the line, try to parse it out
PARSE2:
	XOR	DI,DI			;This will be a flg
	MOV	BP,SI			;Make the start the last dir char
	MOV	AL,DIR_CHAR		;Get directory char
	MOV	[BX].START,SI		;Save start address of file name
	CMP	BYTE PTR [SI+1],COLON	;Is there a drive specifier?
	JNE	PARSE5			;No-don't do anything
	CALL	DISKOK			;Test if diskok
	JC	PARSE1			;Jump if bad disk (have new file)
	MOV	BP,SI			;Make this be filestart
	CMP	BYTE PTR [SI],CC_CR	;Is it a <CR>?
	JE	PARSE4			;Yes-flag fill
	CMP	BYTE PTR [SI],SPACE	;Is char after ':' a space?
	JNE	PARSE5			;Yes-go on
	MOV	BYTE PTR [SI],CC_CR	;Fake it
;Only d: specified-flag it for later fill
PARSE4:	
	OR	[BX].FLAGS,WILD	OR STARS ;Show fill done 
	MOV	DI,STAR			;Show fill needed
	JMP	PARSE11			;And exit
;Set up characters to look for: star, question mark, <CR>, or space
PARSE5:
	MOV	DL,QMARK		;Put what we're looking for in
	MOV	DH,STAR			;Registers
	MOV	CH,CC_CR		;End of line marker
	MOV	AH,SPACE		;Or space
;Test the current character for one of the above or directory char
PARSE6:
	MOV	CL,[SI]			;Get a character
	INC	SI			;Point to next character
	CMP	CL,AL			;Is it a dir char?
	JE	PARSE7			;No,continue
	CMP	CL,DH			;Test for wild card (*)
	JE	PARSE8			;Jump if wild card
	CMP	CL,DL			;Test for wild card (?)
	JE	PARSE9			;Jump if wild card
	CMP	CL,CH			;Test for EOL
	JE	PARSE10			;Jump if found
	CMP	CL,AH			;Test for space 
	JE	PARSE10			;Spaces are also terminators
	JMP	PARSE6

;Directory char found
PARSE7:
	MOV	BP,SI			;Save this pointer to the char
	JMP	PARSE6			;After the dir char

;Wild Card or star found
PARSE8:
	OR	[BX].FLAGS,STARS	;Show found a star
PARSE9:
	OR	[BX].FLAGS,WILD		;Show wild card found
	JMP	PARSE6			;And look for more

;End of string
PARSE10:
	SUB	SI,2			;Point to char before <CR>
	CMP	[SI],AL			;Is it a dir char?
	JNE	PARSE11			;No-continue
	MOV	DI,STAR			;Flag fill
;Set up LASTCHAR and FILESTART, save pointer to what may be filename2,
;and move the file
PARSE11:
	MOV	[BX].LASTCHAR,SI	;And save it's address
	MOV	[BX].FILESTART,BP	;Save location of last dir char
	MOV	START_TWO,SI		;This is almost the start of file2
	PUSH	DI			;Save flag
	MOV	BP,BX			;Source=dest
	LEA	DI,[BX.REAL]		;We're Gonna move this string
	CALL	MOVE_STRING
	POP	DI
	OR	DI,DI			;Is it 0? (0=no fill)
	JZ	PARSE12			;Yes-don't fill
	CALL	FILL_FILE		;No-fill
PARSE12:
	MOV	AL,0			;Show we got something
	RET
PARSE	ENDP

;*************************************************************************
;	SOB
;	Skip over blanks
;	ENTRY	- SI = offset of start of possible skips
;	EXIT	- SI = offset of first non-space char
;*************************************************************************
	PUBLIC	SOB	
SOB	PROC	NEAR
	CMP	BYTE PTR [SI],SPACE	; Is it a space
	JNZ	SOB1			; nope, all done
	INC	SI
	JMP	SOB			; yep, bump over it
SOB1:
	RET
SOB	ENDP

;*************************************************************************
;	HELP_SCREEN
;	If help screen is requested, display it and exit, else return
;	ENTRY	- none
;	EXIT	- no return if help screen requested
;*************************************************************************
	PUBLIC	HELP_SCREEN	
HELP_SCREEN	PROC	NEAR
	MOV	SI,PHD_DIOA+1		;Point to start of command line
	CALL	SOB			;Skip over blanks
	CMP	BYTE PTR [SI],'?'	;First char a QMARK?
	JNE	HELP_SCREEN10		;No-exit
	CMP	BYTE PTR [SI+1],CC_CR	;Next char a <CR>?
	JNE	HELP_SCREEN10		;No-exit
	MOV	DX,OFFSET HELP_MESSAGE	;Display help message
	CALL	OUTSTRING		;Like this
	CALL	EXIT			;And quit
HELP_SCREEN10:
	RET
HELP_SCREEN	ENDP
	
COMP_END	=  	OFFSET $
COMP_SIZE	=  	((COMP_END-COMP_START)+15)SHR 4

CODE 	ENDS
	END	COMP
