	PAGE	,132
;**	This is the loader for the Z-150 5 1/4" floppy and fixed disks.
;	At location 0:7C03 is a loader table used by the BIOS.
;	Assumes the BIOS and DOS are contiguous on the disk.
;	Must leave a valid stack for the BIOS initialization code.
;
;	ENTRY:	AL has the unit booted up on. (From the ROM)
;		ES:SI points to the partition table entry booted
;		      from if winchester
;
;	EXIT:	Executes the BIOS initialization routine (at 60:0)
;

;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;


	.XLIST
	INCLUDE ..\COMMONS\ASCII.DEF
	INCLUDE ..\COMMONS\MSDOS.DEF
	INCLUDE ..\COMMONS\Z150ROM.DEF
	INCLUDE ..\COMMONS\Z150BIOS.DEF
	INCLUDE ..\COMMONS\LOADER.DEF
	INCLUDE	..\COMMONS\DRIVERS.DEF 
	INCLUDE ..\COMMONS\MACRO.ASM
	.LIST

	PAGE	,132
	TITLE	Loader for Z-150 MS-DOS 2.0 5 1/4" floppy and fixed disks

FAR_JUMP	EQU	0EAH

FALSE		=	0
TRUE		=	NOT FALSE

ZENITH		=	TRUE
NBI		=	FALSE


Z150LDR	SEGMENT PUBLIC 'PROG'
	ASSUME	CS:Z150LDR, DS:Z150LDR

	JMP	L1		; Make sure there is space for a longer jump

;	Format information table, filled in by the FORMAT routine at format time

DIR_SECTOR LABEL WORD
	IF	ZENITH
	DB	'ZDS  '
	ENDIF

	IF	NBI
	DB	'NBI  '
	ENDIF

	DB	'2.0'	

BPB_TABLE LABEL BYTE
	DB	TYPE BPB_STRUC DUP(0)

	DB	6 DUP(0)		; Date
	DB	16 DUP(0)		; Reserved storage other
					; things for use at a later time

;	Disk parameter table

DPT	LABEL	BYTE
	DB	0DFH
	DB	002H
	DB	025H
	DB	002H
	DB	008H
	DB	02AH
	DB	0FFH
	DB	050H
	DB	0F6H
	DB	00DH
	DB	004H


;	Names of the system files

FNAMES	DB	'IO      SYS'
	DB	'MSDOS   SYS'

;	Error messages

SYSMSG	DB	'No system', CC_CR, CC_LF+80H
DSKMSG	DB	'I/O error', CC_CR, CC_LF+80H
FMTMSG	DB	'Partition not formatted', CC_CR, CC_LF+80H


	IF	(LOAD_ADDR AND 0FH) NE 0
#1:	Error - Load address must be paragraph alligned
	ENDIF


RETRY_COUNT DB	?

;	DS:SI must point to the booted partition table entry

L1:
	MOV	BX,LOAD_ADDR SHR 4	; Set up local addressing (LOAD_ADDR must be para.)
	CLI
	MOV	SS,BX
	MOV	SP,OFFSET STACK_TOP
	STI
	PUSH	DS
	POP	ES
	MOV	DS,BX
	MOV	BYTE PTR BPB_TABLE+BPB_UNIT,DL	; Save boot drive

;	Test for a winchester dirve

	TEST	DL,80H
	JZ	L2

;	Check if winchester has been re-partitioned

	MOV	AX,ES:[SI+8]
	CMP	AX,WORD PTR BPB_TABLE+BPB_HIDDEN    ; If hidden is different
	JNZ	FMT_ERR
	MOV	AX,ES:[SI+12]
	CMP	AX,WORD PTR BPB_TABLE+BPB_SECS	    ; Or size is different then error
	JZ	L3

FMT_ERR:
	MOV	SI,OFFSET FMTMSG
	JMP	PMSG	

;	Install the disk parameter table

L2:
	SUB	DI,DI			; Address low memory
	MOV	ES,DI
	MOV	DI,DISK_PARMS_INTR SHL 2
	MOV	AX,OFFSET DPT
	CLD
	STOSW				; Install pointer
	MOV	AX,DS			; This segment
	STOSW
	MOV	AL,BYTE PTR BPB_TABLE+BPB_SPT	; Set correct sectors per track
	MOV	DPT+4,AL

;	Reset the disk system

L3:
	MOV	AH,0
	INT	DISK_IO_INTR

;	Calculate and read the first directory sector

	MOV	AL,BPB_TABLE+BPB_NFATS	; Number of FAT's
	CBW
	MUL	WORD PTR BPB_TABLE+BPB_FATSECS	; Times Number of sectors per FAT
	ADD	AX,WORD PTR BPB_TABLE+BPB_RES	; Plus reserved
	ADD	AX,WORD PTR BPB_TABLE+BPB_HIDDEN	; Plus Hidden sectors
	MOV	DIR_SECTOR,AX			; Save as directory sector

	MOV	CX,1			; Read 1 sector
	MOV	BX,BIOS2_SEG		; At BIOS segment
	MOV	ES,BX
	SUB	BX,BX
	CALL	READ

;	Ensure disk has the files IO.SYS and MSDOS.SYS

	MOV	SI,OFFSET FNAMES
	MOV	DI,DE_FNAME		; Address the first directory entry
	MOV	CX,11
	CLD
	REPZ	CMPSB			; Check for match
	JNZ	SYSERR			; Bad disk

	MOV	DI,DE_FNAME+DE_SIZE	; Address second filename
	MOV	CX,11
	REPZ	CMPSB
	JNZ	SYSERR

;	Load enough sectors for IO.SYS

	MOV	AX,WORD PTR BPB_TABLE+BPB_DIRENTS
	MOV	DX,DE_SIZE
	MUL	DX
	MOV	CX,SEC_SIZE
	DIV	CX
	ADD	AX,DIR_SECTOR

	MOV	CX,DISK_LOAD_COUNT
	SUB	BX,BX			; Load at offset 0
	CALL	READ			; Read the sectors

;	Transfer control to the BIOS

	DB	FAR_JUMP		; Jump to the BIOS
	DW	0
	DW	BIOS2_SEG


;*	Read sectors from a disk.
;
;	ENTRY:	AX - Logical sector to read from
;		CX - Count of sectors to read
;		ES:BX - Buffer to read data into
;
;	EXIT:	BX - updated load address
;
;	USES:	AX, BX, CX, DX,
;

;	Calculate track, sector number and head

READ:
	PUSH	CX			; Save count of sectors
	SUB	DX,DX			; Prepare for divide
	DIV	WORD PTR BPB_TABLE+BPB_SPT	; divide by sectors per track
	INC	DL			; DL = Sector #, AX = track
	MOV	CL,DL			; Move sector into CL for ROM
	SUB	DX,DX
	DIV	WORD PTR BPB_TABLE+BPB_HEADS
	MOV	DH,DL			; Put head into DH for ROM
	AND	AH,3			; Ensure only two high bits for cyl.
	ROR	AH,1			; Move high cyl. bits to left side of byte
	ROR	AH,1
	OR	CL,AH			; Set sector and cyl. high bits
	MOV	CH,AL			; Low part of cyl. for ROM
	POP	AX			; Restore count of sectors
	MOV	DL,BPB_TABLE+BPB_UNIT	; Move drive to DL for ROM

;	R/W the requested number of sectors

READ1:
	CALL	READ2			; R/W the sectors

	RET

SYSERR:
	MOV	SI,OFFSET SYSMSG	; No system files
	JMP	SHORT PMSG
DSKERR:
	MOV	SI,OFFSET DSKMSG	; Error reading disk

; Print a message to the user

PMSG:
	LODSB
	PUSH	SI			; Save registers
	PUSH	AX
	AND	AL,7FH
	MOV	AH,VIO_WTT		; Print character
	MOV	BX,0007
	INT	VIDEO_IO_INTR
	POP	AX
	POP	SI
	TEST	AL,80H
	JZ	PMSG
STALL:
	JNZ	STALL

RETRY:
	PUSH	AX			; Save return code
	MOV	AH,DIO_RESET		; Reset disk system
	INT	DISK_IO_INTR
	POP	AX			; Restore return
	DEC	RETRY_COUNT
	JZ	DSKERR
	POP	AX			; Restore count and
	JMP	SHORT READ3		;  try again

;*	Read/Write sectors
;
;	Entry:
;		AX - count of sectors to R/W
;		CH - Track number
;		CL - Sector number
;		DL - Drive
;		DH - Head number
;		ES:BX - transfer address
;
;	Exit:
;		nothing
;
;	Uses:
;		AX,
;		BX (updated load address),
;		CX (updated track and sector),
;		DH (updated head number),
;		DI.
;
READ2:
	MOV	RETRY_COUNT,NUM_RETRY
	PUSH	AX		; Save count
	MOV	AL,BYTE PTR BPB_TABLE+BPB_SPT	; Get sectors per track
	PUSH	CX
	AND	CL,3FH
	SUB	AL,CL			; How many sectors left on this track?
	POP	CX
	INC	AL
	CBW				; Clear high byte
	POP	DI			; Restore count
	CMP	DI,AX			; See if request will fit in this track	
	JAE	READ3			; Yes, fulfill request
	MOV	AX,DI			; No, get remainder of this track
READ3:
	PUSH	AX			; Save count
	MOV	AH,DIO_READ		; Pass operation type
	INT	DISK_IO_INTR		; Call ROM
	JC	RETRY			; Retry on error
	POP	AX			; Restore count

	MOV	AH,AL			; Copy sector count to AH
	SHL	AH,1			; Turn into 512 byte sectors
	ADD	BH,AH			; Update load address
	SUB	AH,AH			; Fix up sector count

	SUB	DI,AX			; Update count

;	Update head, track and sector

	PUSH	BX			; Free up a register
	MOV	BH,CL			; Get Cylander in BX
	ROL	BH,1
	ROL	BH,1
	AND	BH,3
	MOV	BL,CH

	AND	CL,3FH			; Isolate sector bits
	ADD	CL,AL			; Get new sector to start at
	CMP	CL,BYTE PTR BPB_TABLE+BPB_SPT	; Check if beyond end of track
	JBE	READ4			; No, skip
	MOV	CL,1			; Past end, now at sector 1
	INC	DH
	CMP	DH,BYTE PTR BPB_TABLE+BPB_HEADS
	JB	READ4
	SUB	DH,DH			; Back to head zero
	INC	BX			; Next track
READ4:
	ROR	BH,1			; Set up track and sector registers
	ROR	BH,1
	OR	CL,BH
	MOV	CH,BL
	POP	BX			; Restore transfer address

	CMP	DI,0			; Operation done?
	JNZ	READ5
	RET
READ5:
	MOV	AX,DI			; Update remaining sector count
	JMP	READ2			; Continue

STACK_TOP =	$+128

	ORG	(SEC_SIZE-2)
	DB	55H
	DB	0AAH

Z150LDR	ENDS
	END
                                                                                                                       
