PAGE ,132
;*************************************************************************
;	MODE -  This program allows setting of modes of operation for the
;		serial ports, the parallel ports and the display.
;		Four options are allowed as described below.
;
;	Option 1: MODE LPT#:[n][,[m][,P]]
;
;	Option 2: MODE [n],m,[,T]
;
;	Option 3: MODE COMn:baud,[parity[,databits[,stopbits[,P]]]]
;
;	Option 4: MODE LPT#:=COMn
;
;
;
;	Written by: RJM/RMK
;
;	Date: May 8, 1984
;
;	Version  1.9 released 6/5/84
;	Version	 2.00 released 7/20/84 to fix monochrome support
;	Version  2.01 released 8/15/84 to allow Ethernet interaction
;	Version  2.02 released 9/05/84 to fix terminate/stay resident bug
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;*************************************************************************
	.XLIST
	INCLUDE	..\COMMONS\ASCII.DEF
	INCLUDE ..\COMMONS\MSDOS.DEF
	INCLUDE ..\COMMONS\MACRO.ASM
	INCLUDE	..\COMMONS\Z150ROM.DEF
	INCLUDE	..\COMMONS\IOCONFIG.DEF
	INCLUDE MODE.DEF
	.LIST

NUM_LPT	=	3
NUM_COM	=	2


CODE	SEGMENT	BYTE PUBLIC
	ASSUME	CS:CODE, DS:CODE, ES:NOTHING, SS:CODE


ZERO	EQU	OFFSET $

	ORG	100H
MODE:
	JMP	MODE1

PUBLIC PRINTER_OFF,PRINTER_SEG,SERIAL_OFF,SERIAL_SEG,RETRY_TBL
PRINTER_OFF	DW	?		;Vectors to BIOS printer
PRINTER_SEG	DW	?		;and serial interrupt handlers
SERIAL_OFF	DW	?		;Note that OFF (offset) must
SERIAL_SEG	DW	?		;come BEFORE SEG (segment)

; This table has a byte for each of the 2 COM devices and the 3 LPT devices-
;   The COM information is FIRST.
RETRY_TBL	DB	5 DUP (FALSE)	;Default is no infinite retry

PUBLIC MY_PRINTER_INTR,MY_SERIAL_INTR
PRINTER_HERE	DB 	'Mode'		;Mode signature
MY_PRINTER_INTR		PROC
	STI
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	DI,OFFSET PRINTER_OFF
	OR	AH,AH
	JNZ	MPI10		;If not print char, just do int
	MOV	BX,DX		;Index reg
	ADD	BX,SER_TBL_SIZE
	CMP	BYTE PTR RETRY_TBL[BX],FALSE	;retry enabled?
	JE	MPI10		;No-then don't retry, for pete's sake!
	MOV	CL,PRINTER_TIMEOUT
	CALL	RETRY
	JMP	SHORT MPI20
MPI10:
	PUSHF
	CALL	DWORD PTR CS:[DI]
MPI20:
	POP	DS
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	IRET
MY_PRINTER_INTR		ENDP

SERIAL_HERE	DB	'Mode'		;Yup, this is mode
MY_SERIAL_INTR		PROC
	STI
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	DI,OFFSET SERIAL_OFF
	CMP	AH,SER_OUT_REQ	;Output char request?
	JNE	MSI10		;If not print char, just do int
	MOV	BX,DX		;Index reg
	CMP	BYTE PTR RETRY_TBL[BX],FALSE	;retry enabled?
	JE	MSI10		;No-then don't retry, for pete's sake!
	MOV	CL,SERIAL_TIMEOUT
	CALL	RETRY
	JMP	SHORT MSI20
MSI10:
	PUSHF
	CALL	DWORD PTR CS:[DI]
MSI20:
	POP	DS
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	IRET
MY_SERIAL_INTR		ENDP


PUBLIC RETRY
RETRY	PROC	NEAR
	MOV	BX,ROM_DATA
	MOV	DS,BX
	MOV	BX,BIOS_BREAK
	AND	BYTE PTR [BX],NOT BREAK_FLAG ;Clear break
RETRY10:
	PUSH	AX		;Save set up
	PUSHF
	CALL	DWORD PTR CS:[DI]
	TEST	AH,CL		;Need to retry?
	POP	BP		;Don't mess up the error codes in AX
	JZ	OUT		;No
	TEST	BYTE PTR [BX],BREAK_FLAG ;Had a ctrl-break?
	JNZ	OUT		;No
	MOV	AX,BP		
	JMP	SHORT RETRY10
OUT:
	RET
RETRY	ENDP

PUBLIC VID_SPACE
VIDEO_HERE	DB	'Mode'		;Mode's signal-yo
VID_SPACE	VID_STRUC 	<>
END_VID_SPACE	=	OFFSET $

;End of terminate but stay resident code.....

VID_LEN		DW TYPE VID_STRUC

OPTIONS		DW	OFFSET OPTION1
		DW	OFFSET OPTION2
		DW	OFFSET OPTION3
		DW	OFFSET OPTION4
		DW	OFFSET HELP_SCREEN

OPT1	DB	CC_CR, CC_LF, 'Option1', CC_CR, CC_LF, '$'
OPT2	DB	CC_CR, CC_LF, 'Option2', CC_CR, CC_LF, '$'
OPT3	DB	CC_CR, CC_LF, 'Option3', CC_CR, CC_LF, '$'
OPT4	DB	CC_CR, CC_LF, 'Option4', CC_CR, CC_LF, '$'

BAUD	DW	'11'			;  110 BAUD
	DW	'15'			;  150 BAUD
	DW	'30'			;  300 BAUD
	DW	'60'			;  600 BAUD
	DW	'12'			; 1200 BAUD
	DW	'24'			; 2400 BAUD
	DW	'48'			; 4800 BAUD
	DW	'96'			; 9600 BAUD
NUM_BAUD = (OFFSET $ - OFFSET BAUD) / 2

PRINT_BAUD	DB	'110 ,','$'		;  110 BAUD
		DB	'150 ,','$'		;  150 BAUD
		DB	'300 ,','$'		;  300 BAUD
		DB	'600 ,','$'		;  600 BAUD
		DB	'1200,','$'		; 1200 BAUD
		DB	'2400,','$'		; 2400 BAUD
		DB	'4800,','$'		; 4800 BAUD
		DB	'9600,','$'		; 9600 BAUD

LPT	DB	'LPT'
LEN_LPT	=	OFFSET $ - OFFSET LPT

COM	DB	'COM'
LEN_COM	=	OFFSET $ - OFFSET COM

PARM_LIST	PARM_POINTER 	<>

TEXT		DB	?	;Text mode

CURRENT_VMODE	DB	?
BURST		DB	1		;Default is ON
COLUMNS		DB	80		;Current screen width
DISPLAY_COUNT	DB	?		;Times to display '0123456789'
DISPLAY_PAGE	DB	0		;Current displayed page
CUR_ATR		DB	?		;Attribute to use for clear screen
VALID_SCROLL	DB	?		;Valid scroll modes

PRINTER		DW	?		;Printer ID
PBAUD		DW	?		;Baud value (output form)

DATA_SEG	DW	?		;Segment where TSR stuff is

HELP_MENUS	DW	OFFSET HELP_ONE
		DW	OFFSET HELP_TWO
		DW	OFFSET HELP_THREE
		DW	OFFSET HELP_FOUR
.XLIST
HELP_MAIN	LABEL 	BYTE
IF NBI
		DB	'                        MODE Version 2.02'                        
     		DB	CC_CR,CC_LF,'                   Copyright(C) NBI, Inc. 1984',CC_CR,CC_LF
ELSE		
		DB	'                        MODE Version 2.02',CC_CR,CC_LF
		DB      '        Copyright (C) 1984 Zenith Data Systems Corporation',CC_CR,CC_LF
ENDIF
		DB	'MODE  enables  you to  configure your system for specific  peripheral',CC_CR,CC_LF
		DB	'devices  by  entering a  single  command  line. The  configuration or',CC_CR,CC_LF
		DB	'protocol that you define with  MODE  remains in memory for use by the',CC_CR,CC_LF
		DB	'system until you redefine it with  another MODE  command or until you',CC_CR,CC_LF
		DB	'reset or reboot your system.',CC_CR,CC_LF,CC_LF
		DB	'Syntax:    MODE ?',CC_CR,CC_LF										                                                 				
		DB	'           MODE LPT#:[n][,[m][,P]]',CC_CR,CC_LF
		DB	'           MODE [n][,[m][,[T]][,s]]',CC_CR,CC_LF
		DB	'           MODE COMn:baud[,[parity][,[databits][,[stopbits][,P]]]]',CC_CR,CC_LF
		DB	'           MODE LPT#:=COMn',CC_CR,CC_LF,CC_LF
		DB	'The command lines shown  above are used to',CC_CR,CC_LF,CC_LF
		DB	'1 -- Display this help screen',CC_CR,CC_LF
		DB	'2 -- Configure a parallel device',CC_CR,CC_LF
		DB	'3 -- Configure a color/graphics or monochrome display device',CC_CR,CC_LF
		DB	'4 -- Configure a serial device',CC_CR,CC_LF
		DB	'5 -- Remap parallel output to a serial port',CC_CR,CC_LF,CC_LF
		DB	'For more  information, enter the  number of your  selection. To exit,',CC_CR,CC_LF
		DB	'press RETURN.'
GET_SCR_NUM	DB	CC_CR,CC_LF,'                 Enter selection or press RETURN:','$'                 


;;Help Screen for Option 1: Configure a Parallel device
HELP_ONE	DB	CC_CR,CC_LF,'                 Configuring a Parallel Device',CC_CR,CC_LF,CC_LF,CC_LF
		DB	'To  configure a  parallel device, enter a  command  line in the  form',CC_CR,CC_LF,CC_LF
		DB	'      		     MODE LPT#:[n][,[m][,P]]',CC_CR,CC_LF,CC_LF
		DB	'where # is 1,2, or 3 and  designates the  specific LPT device (LPT1:,',CC_CR,CC_LF
		DB	'      LPT2:, or LPT3:) to be configured;',CC_CR,CC_LF
		DB	'      n is 80 or 132, and specifies the number of characters per line;',CC_CR,CC_LF
		DB	'      m is 6 or 8, and specifies the number of lines per inch; and',CC_CR,CC_LF
		DB	'      P invokes continuous retry on timeout errors.',CC_CR,CC_LF,CC_LF
		DB	'Defaults are 80 characters per line and 6 lines per inch.',CC_CR,CC_LF,CC_LF
		DB	'   Press any key to return to the main menu or RETURN to exit:','$'

;;Help Screen for Option 2: Configuring a display device
HELP_TWO	DB	CC_CR,CC_LF,'	           Configuring a Display Device',CC_CR,CC_LF,CC_LF
		DB	'To configure a color/graphics or  monochrome display  device, enter a',CC_CR,CC_LF
		DB	'command line in the form',CC_CR,CC_LF,CC_LF
		DB	'		   MODE [n][,[m][,[T]][,s]]',CC_CR,CC_LF,CC_LF
		DB	'where n defines the display mode and may be one of the following:',CC_CR,CC_LF
		DB	'      40    Sets the display width to 40 characters per line.',CC_CR,CC_LF
		DB	'      80    Sets the display width to 80 characters per line.',CC_CR,CC_LF
		DB	'      BW40  Sets the display mode to black and  white (disables color',CC_CR,CC_LF
		DB	'            burst) with 40 characters per line.',CC_CR,CC_LF
		DB	'      BW80  Sets the display mode to black and  white (disables color',CC_CR,CC_LF
		DB	'            burst) with 80 characters per line.',CC_CR,CC_LF
		DB	'      CO40  Sets the display mode to color (enables color burst) with',CC_CR,CC_LF 
		DB	'	     40 characters per line.',CC_CR,CC_LF
		DB	'      CO80  Sets the display mode to color (enables color burst) with',CC_CR,CC_LF 
		DB	'	     80 characters per line.',CC_CR,CC_LF
		DB	'      GR40  Sets the display to medium-resolution  graphics mode with',CC_CR,CC_LF
		DB	'	     40 characters per line.',CC_CR,CC_LF
		DB	'      GR80  Sets the display  to  high-resolution  graphics mode with',CC_CR,CC_LF
		DB	'	     80 characters per line.',CC_CR,CC_LF
		DB	'      MONO  Sets the  display mode  to monochrome. In  this mode, the',CC_CR,CC_LF
		DB	'            screen display width is always 80 characters per line.',CC_CR,CC_LF
		DB	'                press any key to continue:','$'
HELP_TWO_A	DB	'                 MODE [n][,[m][,[T]][,s]]',CC_CR,CC_LF,CC_LF
		DB	'      m shifts the display, and may  be either R (right) or L (left).',CC_CR,CC_LF
		DB	'      For an 80-character display, the m parameter shifts the display',CC_CR,CC_LF
		DB	'      two  character  positions.  For a  40-character  display, the m',CC_CR,CC_LF
		DB	'      parameter shifts the display one character position.',CC_CR,CC_LF,CC_LF
		DB	'      T causes mode to display a  test pattern for display alignment.',CC_CR,CC_LF
		DB	'      The T parameter cannot be used without the m parameter.',CC_CR,CC_LF,CC_LF
		DB	'      s defines the scroll mode and may be one of the following:',CC_CR,CC_LF
		DB	'	   0	    Software scroll mode',CC_CR,CC_LF
		DB	'	   1	    Jump scroll mode',CC_CR,CC_LF
		DB	'	   2	    Smooth (hardware) scroll mode',CC_CR,CC_LF,CC_LF
		DB	'      The default scroll mode is 0 (software scroll mode)',CC_CR,CC_LF,CC_LF
		DB	'   Press any key to return to the main menu or RETURN to exit:','$'


;;Help screen for Option 3: Configuring a serial device
HELP_THREE	DB	'                     Configuring a Serial Device',CC_CR,CC_LF,CC_LF
		DB	'To configure a serial device, enter a command line in the form',CC_CR,CC_LF,CC_LF
		DB	'	MODE COMn:baud[,[parity][,[databits][,[stopbits][,P]]]]',CC_CR,CC_LF,CC_LF
		DB	'where n is 1 or 2  and designates  the specific  COM device (COM1: or',CC_CR,CC_LF
		DB	'      COM2:) to be configured;',CC_CR,CC_LF
		DB	'      baud is the baud rate (110, 150, 300, 600, 1200, 2400, 4800, or',CC_CR,CC_LF
		DB	'      9600);',CC_CR,CC_LF
		DB	'      parity specifies whether odd (O), even (E), or no (N) parity is',CC_CR,CC_LF
		DB	'      to be used;',CC_CR,CC_LF
		DB	'      databits  is the  word length in bits (7 or 8) exclusive of any',CC_CR,CC_LF
		DB	'      parity or stop bits;',CC_CR,CC_LF
		DB	'      stopbits is the number of stop bits (1 or 2) required; and',CC_CR,CC_LF
		DB	'      P invokes continuous retry on time-out errors.',CC_CR,CC_LF,CC_LF
		DB	'Defaults are even parity, 7 data bits, 2 stop  bits if the  specified',CC_CR,CC_LF
		DB	'baud rate is 110, 1 stop bit if the specified  baud rate  is not 110,',CC_CR,CC_LF
		DB	'and no continuous retry on  time-out errors. There is  no default for',CC_CR,CC_LF
		DB	'device nor for the baud rate.',CC_CR,CC_LF,CC_LF
		DB	'   Press any key to return to the main menu or RETURN to exit:','$'


;;Help screen for Option 4: Remapping Parallel Output to a Serial Port
HELP_FOUR	DB	'                  Remapping Parallel Output',CC_CR,CC_LF,CC_LF
		DB	'To remap parallel  output to a serial  port, enter a  command line in',CC_CR,CC_LF
		DB	'the form',CC_CR,CC_LF,CC_LF
		DB	'	              MODE LPT#:=COMn',CC_CR,CC_LF,CC_LF        
		DB	'where # is 1,2, or 3 and  designates the  specific LPT device (LPT1:,',CC_CR,CC_LF
		DB	'      LPT2:, or LPT3:) to be remapped',CC_CR,CC_LF
		DB	'      n is 1 or 2  and  designates the  specific COM device (COM1: or',CC_CR,CC_LF
		DB	'      COM2:) to which parallel output is to be mapped.',CC_CR,CC_LF,CC_LF
		DB	'IMPORTANT: Before  you can  map  parallel output (LPT#:) to  a serial',CC_CR,CC_LF
		DB	'port (COMn:), the COM device must be defined with a MODE command line',CC_CR,CC_LF
		DB	'in the form MODE COMn:baud[,[parity][,[databits][,[stopbits][,P]]]]',CC_CR,CC_LF,CC_LF
		DB	'   Press any key to return to the main menu or RETURN to exit:','$'
.LIST
CRLF		DB CC_CR, CC_LF, '$'
ILLEGAL_DEVICE	DB CC_CR,CC_LF,'Illegal device name',CC_BEL,CC_CR,CC_LF,'$'
INVALID_PARMS	DB CC_CR,CC_LF,'Invalid parameters',CC_BEL,CC_CR,CC_LF,'$'
BAUD_MSG	DB CC_CR,CC_LF,'Invalid baud rate specified', CC_BEL, CC_CR, CC_LF,'$'
MODE_RESIDENT	DB CC_CR,CC_LF,'Resident portion of MODE loaded',CC_CR,CC_LF,'$'
NUMBERS		DB '0123456789','$'
RIGHT_MSG	DB CC_CR,CC_LF,CC_LF,'Do you see the leftmost 0? (Y/N)',CC_CR,CC_LF,'$'
LEFT_MSG	DB CC_CR,CC_LF,CC_LF,'Do you see the rightmost 9? (Y/N)',CC_CR,CC_LF,'$'
MOVE_WARNING	DB CC_CR,CC_LF,'    WARNING: Proceeding with this command may cause your system to lock up.','$'
MODE_WARNING 	DB CC_CR,CC_LF,'    WARNING: Changing modes without shifting the screen to the right may '
		DB CC_CR,CC_LF,'    lock up your system'
PROCEED		DB CC_CR,CC_LF,'    Do you wish to proceed? (Y/N)',CC_CR,CC_LF,'$'
LPT_MSG		DB CC_CR,CC_LF,'LPT'
LPT_NUM		DB ?,': ','$'
SET_FOR		DB 'set for ','$'
MSG_80		DB '80',CC_NUL,CC_CR,CC_LF,'$'
MSG_132		DB '132',CC_NUL,CC_CR,CC_LF,'$'
PRINTER_ERROR	DB CC_CR,CC_LF,'Printer error',CC_BEL,CC_CR,CC_LF,'$'
LINES_PER_INCH	DB CC_CR,CC_LF,'Printer lines per inch set',CC_CR,CC_LF,'$'
NO_RETRY	DB CC_CR,CC_LF,'No retry on parallel printer timeout',CC_CR,CC_LF,'$'
NOT_REDIRECTED  DB 'not redirected',CC_CR,CC_LF,'$'
INF_RETRY	DB CC_CR,CC_LF,'Infinite retry on parallel printer timeout',CC_CR,CC_LF,'$'
REDIRECT	DB 'redirected to '
COM_MSG		DB 'COM'
COM_NUM		DB ?,': ','$'		
COM_PARMS	DB 'e,'			;This is the default list for
DATA_BITS	DB '7,'			;COM parms
STOP_BITS	DB '1,'
COM_RETRY	DB '-',CC_CR,CC_LF,'$'
COM_INIT	DB	0		; Initialization parameters for COM

; This flag has vaious bits for different residentnesses
RESIDENT_FLAG	DB	FALSE		;Assume all non-resident
FLAG_STAY	EQU	00000001B	; Terminate and stay resident
FLAG_PRINTER	EQU	00000010B	; Set if printer int taken
FLAG_SERIAL	EQU	00000100B	; Set if serial int taken
FLAG_VIDEO	EQU	00001000B	; Set if vid parms int taken

	DW	128 DUP(?)
STACK_TOP	LABEL	WORD

MODE1:
	MOV	SP,OFFSET STACK_TOP
	PUSH	DS 
	POP	DATA_SEG	; Get data seg
	XOR	AX,AX
	MOV	ES,AX		;ES will be for 0:[]
	CALL	DECODE		; Determine which option of mode and return index
	DEC	AX
	MOV	BX,AX
	SHL	BX,1
	CALL	OPTIONS[BX]
	TEST 	RESIDENT_FLAG,FLAG_STAY ; Terminate and stay resident?
	JZ	MODE2			;    NO!!
	MOV	DX,OFFSET END_VID_SPACE
	INT	DOSI_TERMR
MODE2:
	INT	DOSI_TERM	;Exit clean

;*************************************************************************
;	DECODE - This routine will scan the command line and determine
;		which option (as defined above) the user has selected.
;		The option number is returned in AX
;
;	ENTRY:	None
;
;	EXIT:	AX - Option number
;		SI - Pointer to first non-white character on command line
;		COUNT - Count of characters left on command line
;
;*************************************************************************
PUBLIC DECODE
DECODE	PROC	NEAR

;	Get the count of characters on the command line

	MOV	SI,PHD_DIOA
	INC	SI		;Point past count
;	Skip over white space

	CALL	SKIP_WHITE
	PUSH	SI		;Save pointer to command line
	MOV	CL,AL		
;	Check if number of chars is enough for options 1, 3 and 4

	CMP	AL,LEN_LPT
	JB	D3

;	Check if command line contains "LPT"

	MOV	DX,SI
	MOV	DI,OFFSET LPT
	CMP	BYTE PTR [SI],'L'	; Check if command is LPT
	JNZ	D1			; Does not contain LPT, check next option

;	Check if "=" sign in command

	ADD	SI,LEN_LPT		; Correct pointer
	SUB	CL,LEN_LPT		; Correct count for part already scanned
	MOV	AX,4			; Assume option 4
	CMP	CL,3			; Ensure more chars are there
	JB	D2
	CMP	BYTE PTR [SI+2],'='
	JZ	DECODE_EXIT		; Yes, option 4, no
D2:
	MOV	AX,1			; option 1
	JMP	SHORT DECODE_EXIT

;	Check if command line contains "COM"

D1:
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	SI,DX
	MOV	DI,OFFSET COM
	PUSH	CX
	MOV	CX,LEN_COM
	CLD
	REP	CMPSB			; Check for "COM"
	POP	CX
	POP	ES
	JNZ	D3			; No, option 2 else
	MOV	AX,3			; it is option 3
	SUB	CL,LEN_COM		; Correct count
	JMP	SHORT DECODE_EXIT

;	Command is option 2

D3:
	CMP	BYTE PTR [SI],'?'	; Help screen?
	JNE	D4			
	MOV	AX,5			; Help screen.
	JMP	SHORT DECODE_EXIT
D4:
	MOV	AX,2			; Option 2

DECODE_EXIT:
	POP	SI			; Restore pointer to beginning of command line
	RET

DECODE	ENDP

;*************************************************************************
;	Option 1 - this option is used to set lines per inch, lines per
;	page, and enable continuous retry on timeout errors
;*************************************************************************
PUBLIC OPTION1
OPTION1	PROC	NEAR
	CALL	DEVICE_OK		;Test for ok devic
	INC	SI			;Now, point to first char
	CALL	PARSE_PARMS
	CALL	TEST_RESIDENT		; Set TSR flags and get seg for table
	MOV	DX,PRINTER
	MOV	BP,DX			;printer as offset
	ADD	BP,SER_TBL_SIZE
	MOV	AL,FALSE
	CALL	SET_RETRY		; Turn off retry
	CALL	UNMAP
	MOV	DX,OFFSET LPT_MSG
	CALL	OUTSTRING
	MOV	DX,OFFSET NOT_REDIRECTED
	CALL	OUTSTRING
	MOV	SI,PARM_LIST.ONE
	CMP	BYTE PTR [SI],0		;Parm 1?
	JE	OPTION1_10		;No-parm 2?
	CALL	SET_LINE_LENGTH
OPTION1_10:
	MOV	SI,PARM_LIST.TWO
	OR	SI,SI
	JZ	OPTION1_20		;Do this so get not infinite mess
	CMP	BYTE PTR [SI],0
	JE	OPTION1_20
	CALL	SET_VERTICAL_SPACE
OPTION1_20:
	MOV	SI,PARM_LIST.THREE
	OR	SI,SI
	JZ	OPTION1_25
	CMP	BYTE PTR [SI],'P'
	JE	OPTION1_30
OPTION1_25:
	MOV	DX,OFFSET NO_RETRY
	CALL	OUTSTRING
	JMP	SHORT OPTION1_90
OPTION1_30:
	CALL	SET_INFINITE
OPTION1_90:
	RET
OPTION1_100:
	MOV	DX,OFFSET ILLEGAL_DEVICE
	CALL	ERROR_EXIT
OPTION1	ENDP	

DEVICE_OK	PROC	NEAR
	ADD	SI,LEN_LPT		; Skip past length of "LPT"
	LODSB				; Get the device number
	SUB	AL,'1'
	CMP	AL,0
	JB	DEVICE_OK10
	CMP	AL,NUM_LPT
	JAE	DEVICE_OK10
	CMP	BYTE PTR [SI], ':'	;Should be followed by a ':'
	JNE	DEVICE_OK10		
	XOR	AH,AH
	MOV	PRINTER,AX		;Save this printer address
	ADD	AL,'1'
	MOV	LPT_NUM,AL
	RET
DEVICE_OK10:
	MOV	DX,OFFSET ILLEGAL_DEVICE
	CALL	ERROR_EXIT
DEVICE_OK	ENDP

SET_RETRY	PROC	NEAR
	PUSH	ES
	MOV	CX,DATA_SEG			;Set the retry flag-
	MOV	ES,CX				;ES points to table which
	MOV	BYTE PTR ES:RETRY_TBL[BP],AL	;Is/will stay resident
	POP	ES
	RET
SET_RETRY	ENDP	

PRINT_RESIDENT	PROC	NEAR
	MOV	DX,OFFSET MODE_RESIDENT
	CALL	OUTSTRING
PRINT_RESIDENT10:
	RET
PRINT_RESIDENT	ENDP

SET_LINE_LENGTH	PROC	NEAR
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	BP,SI
	MOV	AL,CC_DC2		;Assume n=80
	MOV	CX,LEN_80		;Test for n=80
	MOV	DI,OFFSET MSG_80	;Compare it with '80'+nul
	MOV	DX,DI
	REP	CMPSB
	JZ	SLL10	
	MOV	SI,BP
	MOV	CX,LEN_132
	MOV	DI,OFFSET MSG_132
	MOV 	DX,DI
	REP	CMPSB
	JNZ	OPTION1_90		;If not 80 or 132, exit-no message
	MOV	AL,CC_SI		;And get DC1 char
SLL10:
	PUSH	DX
	CALL	LPRINT			;And send these codes
	MOV	DX,OFFSET LPT_MSG
	CALL	OUTSTRING
	MOV	DX,OFFSET SET_FOR
	CALL	OUTSTRING
	POP	DX
	CALL	OUTSTRING
	POP	ES
	RET
SET_LINE_LENGTH	ENDP

SET_VERTICAL_SPACE	PROC	NEAR
	MOV	BL,'2'			;Assume 1/6 inch
	CMP	BYTE PTR [SI],SIX_PER	;Right?
	JE	SVS10			
	CMP	BYTE PTR [SI],EIGHT_PER
	JNE	SVS20			;If not 8 or 6, exit
	MOV	BL,'0'	
SVS10:
	MOV	AL,CC_ESC		;Send 'ESC'
	CALL	LPRINT			
	MOV	AL,BL			;And vert value
	CALL	LPRINT
	MOV	DX,OFFSET LINES_PER_INCH
	CALL	OUTSTRING
SVS20:
	RET
SET_VERTICAL_SPACE	ENDP
	
SET_INFINITE	PROC	NEAR
	CALL	MAKE_OPTION1_RES	;Make us resident
	MOV	BP,PRINTER
	ADD	BP,SER_TBL_SIZE
	MOV	AL,TRUE
	CALL	SET_RETRY
	MOV	DX,OFFSET INF_RETRY
	CALL	OUTSTRING
	RET
SET_INFINITE	ENDP

;*************************************************************************
;	MAKE_OPTION1_RES
;	Take printer IO interrupt
;	ENTRY	- none
;	EXIT	- none
;	CALLS	- OUTSTRING
;*************************************************************************
PUBLIC MAKE_OPTION1_RES
MAKE_OPTION1_RES 	PROC	NEAR
	TEST	RESIDENT_FLAG,FLAG_PRINTER OR FLAG_SERIAL OR FLAG_VIDEO
	JNZ	MO1R10			;  Yes-don't TSR
	OR	RESIDENT_FLAG,FLAG_STAY
	CALL	PRINT_RESIDENT		; Tell the user...
MO1R10:
	TEST	RESIDENT_FLAG,FLAG_PRINTER  ; Printer res?
	JNZ	MO1R20			; Yup-exit
	MOV	DX,OFFSET MY_PRINTER_INTR ;Point to own printer routine
; Get old vector and save it in resident area
	PUSH	DS
	MOV	DS,DATA_SEG		; Point to correct DS 
	MOV	BX,(PRINTER_IO_INTR SHL 2)+2 ;Printer IO intr
	MOV	AX,ES:[BX]
	MOV	PRINTER_SEG,AX
	MOV	AX,ES:[BX-2]

; Take printer interrupt (DX set already)
	MOV	PRINTER_OFF,AX
	MOV	AL,PRINTER_IO_INTR
	MOV	AH,DOSF_SIVEC		
	INT	DOSI_FUNC
	POP	DS
MO1R20:
	RET
MAKE_OPTION1_RES	ENDP

LPRINT	PROC	NEAR
	MOV	DX,PRINTER
	XOR	AH,AH
	INT	PRINTER_IO_INTR
	TEST	AH,PRINTER_TIMEOUT
	JNZ	LPRINT10
	RET
LPRINT10:
	MOV	DX,OFFSET PRINTER_ERROR
	CALL	ERROR_EXIT
LPRINT	ENDP

;*************************************************************************
;	Option 2- this option is used to change video and/or scroll
;	modes, and to shift the display to the right or left.
;	ENTRY	- none
;	EXIT    - none
;	CALLS	- GET_VIDEO_MODE, SET_VIDEO_MODE, SHIFT_DISPLAY, 
;		  SET_SCROLL_MODE
;*************************************************************************
PUBLIC OPTION2
OPTION2	PROC	NEAR
	CALL	PARSE_PARMS		;Parse the parms
	CALL	GET_VIDEO_MODE		;Get the current video mode
	MOV	SI,PARM_LIST.ONE
	CMP	BYTE PTR [SI],0		;Anything there?
	JE	OPTION2_10		;No-leave it
	CALL	SET_VIDEO_MODE		;Set the correct video mode
OPTION2_10:
	MOV	SI,PARM_LIST.TWO
	OR	SI,SI
	JZ	OPTION2_40		;Out of parms
	CMP	BYTE PTR [SI],0		;R or L specified?
	JNE	OPTION2_20		;Yes-do move
	MOV	SI,PARM_LIST.THREE	;R/L not spec- had T anyway?
	OR	SI,SI
	JZ	OPTION2_40		;Out of parms
	CMP	BYTE PTR [SI],0
	JE	OPTION2_30		;No-keep on testing
	CALL	VMODE_ERROR		;Display error and die
OPTION2_20:
	CALL	SHIFT_DISPLAY		;Shift the display
OPTION2_30:
	MOV	SI,PARM_LIST.FOUR	;Scroll mode specified?
	OR	SI,SI
	JZ	OPTION2_40		;Out of parms
	CALL	SET_SCROLL_MODE
OPTION2_40:
	RET
OPTION2	ENDP	

;Mode 2 called procedures

;*************************************************************************
;	GET_VIDEO_MODE
;	Get the current video mode and set up mode dependant variables
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC GET_VIDEO_MODE
GET_VIDEO_MODE	PROC	NEAR
	MOV	AH,VIO_CVS		;Choose get current video state
	INT	VIDEO_IO_INTR		;Option of video interrupt
	CMP	AL,MONOCHROME		
	JE	GET_VIDEO_MODE10	
	AND	AL,CLEAR_BURST		;Get rid of the burst
GET_VIDEO_MODE10:
	MOV	CURRENT_VMODE,AL	;Save the VMODE
	CALL	SET_VARS		;Set up the rest
	RET
GET_VIDEO_MODE	ENDP

;*************************************************************************
;	SET_VIDEO_MODE
;	Parse the video mode string and call the approprate routine
;	to test/choose the mode. Test for left edge problems and let the 
;	user quit if the screen would die. Change the equipment flag to
;	mono or color-graphics adapter card. Set the mode.
;	ENTRY	- SI = pointer to PARM_LIST.ONE
;	EXIT	- none
;	CALLS	- PARSE_VMODE, VMODE_ERROR, MONO_MODE, CORB_MODE,
;		  GXXX_MODE, CHANGE_WIDTH, OUTSTRING, INCHAR, SET_VARS,
;		  SET_EQUIP_FLAG
;*************************************************************************
PUBLIC SET_VIDEO_MODE, VMODTBL
VMODTBL	DW	OFFSET	VMODE_ERROR	;Bad mode
	DW	OFFSET 	MONO_MODE	;Monochrome mode request
	DW	OFFSET 	CORB_MODE	;Color or B+W mode request
	DW	OFFSET	GXXX_MODE	;Graphics mode
	DW	OFFSET  CHANGE_WIDTH	;Width change only


SET_VIDEO_MODE	PROC	NEAR
	CALL	PARSE_VMODE		;Get internal mode number
	MOV	BL,AL
	XOR	BH,BH
	SHL	BX,1			;Turn mode into table offset
	CALL	VMODTBL[BX]		;And jump
	CMP	AL,MONOCHROME
	JE	SET_VIDEO_MODE20	;Don't futz with monochrome
;Test for left edge too far condition
	PUSH	ES
	MOV	BX,VIDEO_PARMS_INTR SHL 2
	MOV	SI,ES:[BX]		
	MOV	CX,ES:[BX+2]		
	MOV	ES,CX		
	CMP	CURRENT_VMODE,TEXT80
	JE	SET_VIDEO_MODE10
	CMP	BYTE PTR ES:[SI].TEXT_40+2,UNSTABLE_PARMS_GRFX_T40
	JBE	SET_VIDEO_MODE20
	JMP	SET_VIDEO_MODE15
SET_VIDEO_MODE10:
	CMP	BYTE PTR ES:[SI].TEXT_80+2,UNSTABLE_PARMS_T80
	JBE	SET_VIDEO_MODE20
SET_VIDEO_MODE15:
	MOV	DX,OFFSET MODE_WARNING	
	CALL	OUTSTRING
	CALL	INCHAR
	CMP	AL,'Y'
	JNE	SET_VIDEO_MODE30
SET_VIDEO_MODE20:
	CALL	SET_VARS		;Set up video vars
	CALL	SET_EQUIP_FLAG		;Change equip flag
	MOV	AH,VIO_MODE		;Do a set video mode
	INT	VIDEO_IO_INTR		;Set it
SET_VIDEO_MODE30:
	POP	ES
	RET				;Return
SET_VIDEO_MODE	ENDP

;*************************************************************************
;	PARSE_VMODE
;	Parse the parm. If C or B specified, set TEXT flag and save correct
;	burst flag
;	ENTRY	- SI = Pointer to mode name
;	EXIT	- AL = 0 if an invalid mode was specified
;		  AL = 1 if M (monochrome) was specified
;		  AL = 2 if C (color) was specified
;		  AL = 3 if B (black and white) was specified
;		  AL = 4 if G (graphics) was specified
;		  AL = 5 if 40 or 80 (change width) was specified		
;*************************************************************************
PUBLIC PARSE_VMODE
PARSE_VMODE	PROC	NEAR
	MOV	AL,0			;AL will be the # of the mode selected
	MOV	AH,[SI]		
	CMP	AH,CC_CR		;Nothing but CR?
	JE	PARSE_VMODE40		;Yes-exit
	INC	AL			;Assume monochrome
	CMP	AH,MONO			;Want monochrome adapter?
	JE	PARSE_VMODE40		;Yes-exit
	INC	AL
	CMP	AH,COLOR		;Cxxx?
	JNE	PARSE_VMODE10		;No-continue testing
	MOV	BURST,ON		;Turn on burst
	MOV	TEXT,TRUE		;Set change to text
	MOV	AH,[SI+2]		;Get next half
	JMP	SHORT PARSE_VMODE30	;And exit
PARSE_VMODE10:
	CMP	AH,BLACK_WHITE		;Bxxx?
	JNE	PARSE_VMODE20		;No
	MOV	BURST,OFF		;Turn off burst
	MOV	TEXT,TRUE		;Set change to text
	MOV	AH,[SI+2]
	JMP	SHORT PARSE_VMODE30	;And exit
PARSE_VMODE20:
	INC	AL			
	CMP	AH,GRAPHICS		;Gxxx?
	JE	PARSE_VMODE40		;Yes
	INC	AL
	MOV	TEXT,FALSE		;Show b/c not spec
PARSE_VMODE30:
	CMP	AH,W40			;40-width specified?
	JE	PARSE_VMODE40		;Yes-ok
	CMP	AH,W80			;80-width?
	JE	PARSE_VMODE40
	CMP	TEXT,TRUE		;Cxxx or Bxxx?
	JE	PARSE_VMODE40
	XOR	AL,AL			;Show illegal mode
PARSE_VMODE40:
	RET
PARSE_VMODE	ENDP

;*************************************************************************
;	VMODE_ERROR
;	Display invalid parms message and exit
;	ENTRY	- none
;	EXIT	- returns to DOS
;	CALLS	- ERROR_EXIT
;*************************************************************************
PUBLIC VMODE_ERROR
VMODE_ERROR	PROC	NEAR
	MOV	DX,OFFSET INVALID_PARMS
	CALL	ERROR_EXIT
VMODE_ERROR	ENDP

;*************************************************************************
;	MONO_MODE
;	Test for monochrome card. If there, fine, else error
;	ENTRY	- none
;	EXIT	- AL = monochrome mode or return to DOS if no monochrome card
;	CALLS	- VMODE_ERROR
;*************************************************************************
PUBLIC MONO_MODE
MONO_MODE	PROC	NEAR
	PUSH	ES
	MOV	DX,BIOS_PAGE_VAR	
	MOV	ES,DX			;Set up ES to point to ROM data area
	MOV	DI,TOP_MONO		;PAGE_BASE[8]
	MOV	AX,ES:[DI]		;Start address of monochrome card			
	SUB	DI,2
	AND	AX,PAGE_SIZE		;Mod 4k
	MOV	DI,AX			;Get it in an index register
	MOV	AX,MONOCHROME_SEG
	MOV	ES,AX
	MOV	AH,'R'			;Get test values
	MOV	AL,'K'	
	MOV	ES:[DI],AH		;Write them to the monochrome card
	MOV	ES:[DI-2],AL
	NOP				;Let the bus settle
	CMP	ES:[DI-2],AL		;If this is a K, ok
	JNE	MONO_MODE10		;Not a k- not ok
	CMP	ES:[DI],AH		;If this is an R, all right
	JNE	MONO_MODE10		;Not an R-not ok
	MOV	CURRENT_VMODE,MONOCHROME
	MOV	AL,MONOCHROME		;To the monochrome card
	POP	ES
	RET
;Invalid mode-display message and quit
MONO_MODE10:
	POP	DS
	POP	ES
	CALL	VMODE_ERROR
MONO_MODE	ENDP

;*************************************************************************
;	CORB_MODE
;	Set up mode for C or B
;	ENTRY	- AH = third character in mode name
;	EXIT	- AL = correct mode (0-3)
;*************************************************************************
PUBLIC CORB_MODE
CORB_MODE	PROC	NEAR
	MOV	AL,BURST		;Get burst on/off parm
	MOV	DL,TEXT80		;Assume 80 width
	CMP	AH,W40			;Wrong?
	JNE	CORB_MODE10		;No
	MOV	DL,TEXT40		
CORB_MODE10:
	MOV	CURRENT_VMODE,DL
	OR	AL,DL			;Set width (text, burst already set)
	RET
CORB_MODE	ENDP

;*************************************************************************
;	GXXX_MODE
;	Set up medium or high res graphics
;	ENTRY	- AH = third character in mode name
;	EXIT	- AL = correct mode (4 or 6)
;*************************************************************************
PUBLIC GXXX_MODE
GXXX_MODE	PROC	NEAR
	MOV	BURST,ON		;Pretend burst is on
	MOV	AL,GRFX80      		;Assume high res graphics
	CMP	BYTE PTR [SI+2],W40	
	JNE	GXXX_MODE10		
	MOV	AL,GRFX40		;Wrong-do med res
GXXX_MODE10:
	MOV	CURRENT_VMODE,AL
	RET
GXXX_MODE	ENDP

;*************************************************************************
;	CHANGE_WIDTH
;	Change to/from 80 (640) from/to 40 (320)
;	ENTRY	- AH = 4 or 8
;	EXIT	- AL = correct mode (0-7)
;*************************************************************************
PUBLIC CHANGE_WIDTH
CHANGE_WIDTH	PROC	NEAR
	XOR	AL,AL
	MOV	DL,MONOCHROME		;Assume monochrome
	CMP	CURRENT_VMODE,MONOCHROME;In monochrome?
	JE	CHANGE_WIDTH20		;Yes-do nothing
	CMP	CURRENT_VMODE,GRFX40	;In graphics mode?
	JB	CHANGE_WIDTH10		;No
	MOV	DL,GRFX80		;Assume high res
	CMP	AH,W40
	JNE	CHANGE_WIDTH20		
	MOV	DL,GRFX40
	JMP  	SHORT CHANGE_WIDTH20
CHANGE_WIDTH10:
	MOV	AL,BURST		;Get burst on/off parm
	MOV	DL,TEXT80  		;Assume 80 width
	CMP	AH,W40			;Wrong?
	JNE	CHANGE_WIDTH20		;No
	MOV	DL,TEXT40  		
CHANGE_WIDTH20:
	OR	AL,DL			;Set width (text, burst already set)
	MOV	CURRENT_VMODE,DL
	RET
CHANGE_WIDTH	ENDP

;*************************************************************************
;	SET_VARS
;	Set up mode dependant parms
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC SET_VARS
SET_VARS	PROC
	MOV 	AH,CURRENT_VMODE	;Get current vmode
	MOV	DISPLAY_PAGE,0
	MOV	DISPLAY_COUNT,COUNT_NUMBERS ;Assume 80 width
	MOV	COLUMNS,COLS_80
	MOV	VALID_SCROLL,SOFT	;And soft scroll
	CMP	AH,MONOCHROME		;Mono?
	JNE	SET_VARS10		;No
	MOV	CUR_ATR,WHITE	
	JMP	SHORT SET_VARS40
;Test for text and set
SET_VARS10:
	CMP	AH,GRFX40		;Graphics
	JAE	SET_VARS30
	MOV	CUR_ATR,WHITE
	CMP	AH,TEXT80
	JE	SET_VARS40
	SHR	DISPLAY_COUNT,1
	SHR	COLUMNS,1
	MOV	VALID_SCROLL,JUMP
	JMP	SHORT SET_VARS40
;Set for graphics
SET_VARS30:
	MOV	CUR_ATR,BLACK
	MOV	VALID_SCROLL,SMOOTH
	CMP	AH,GRFX80
	JE	SET_VARS40
	SHR	DISPLAY_COUNT,1
	SHR	COLUMNS,1
SET_VARS40:
	RET
SET_VARS	ENDP

;*************************************************************************
;	SET_EQUIP_FLAG
;	Turn on/off monochrome enable bits in equipment flag
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC SET_EQUIP_FLAG
SET_EQUIP_FLAG	PROC	NEAR
	PUSH	ES
	MOV	DX,ROM_DATA
	MOV	ES,DX
	MOV	BX,EQUIP_FLAG
	MOV	DX,ES:[BX]
	CMP	AL,MONOCHROME		;If monochrome, leave equip_flag
	JE	SET_EQUIP_FLAG10
	AND	DX,NOT SET_MONO		;Turn off mono bits
;Set this bit so that equip_flag shows 80X25 bw - fix added 7/18/84 rmk
	OR	DL,CARD_80		; But leave card on
	JMP	SHORT SET_EQUIP_FLAG20
SET_EQUIP_FLAG10:
	OR	DX,SET_MONO		;Set both bits for mono
SET_EQUIP_FLAG20:
	MOV	ES:[BX],DX		;And put it back
	POP	ES
	RET
SET_EQUIP_FLAG	ENDP

;*************************************************************************
;	SHIFT_DISPLAY
;	Shift display right or left, interactively or just once
;	ENTRY	- SI = pointer to PARM_LIST.TWO
;	EXIT	- none
;	CALLS	- MAKE_RESIDENT, OUTSTRING, INCHAR, TEST_AND_WARN, 
;		  MOVE_IT, RESTORE_PARMS
;*************************************************************************
PUBLIC SHIFT_DISPLAY
SHIFT_DISPLAY	PROC	NEAR
	MOV	AL,-1			;Assume move right
	MOV	DI,OFFSET RIGHT_MSG
	CMP	BYTE PTR [SI],'R'	;Now we are set up to move right
	JE	SHIFT_DISPLAY10
	CMP	BYTE PTR [SI],'L'	;Must have an R or an L
	JNE	SHIFT_DISPLAY50		;No-don't do anything
	MOV	AL,1
	MOV	DI,OFFSET LEFT_MSG
SHIFT_DISPLAY10:
	CALL	MAKE_OPTION2_RES	;Make CRT mode res. 
	MOV	SI,PARM_LIST.THREE
	MOV	BH,BL
	ADD	BH,BH			;BH=2 BL for move TEXT80
	CMP	BYTE PTR [SI],'T'	;Test?
	JNE	SHIFT_DISPLAY30		;No
SHIFT_DISPLAY15:
	MOV	CL,DISPLAY_COUNT
	XOR	CH,CH			;Now have number of times to display
SHIFT_DISPLAY20:
	MOV	DX,OFFSET NUMBERS
	CALL	OUTSTRING
	LOOP	SHIFT_DISPLAY20		;Display numbers across screen
	MOV	DX,DI
	CALL	OUTSTRING		;And 'do you see' message
	CALL	INCHAR			;Get single char from keyboard
	CMP	AL,'Y'
	JZ	SHIFT_DISPLAY40		;And if it's a yes,exit
SHIFT_DISPLAY30:
	CMP	DI,OFFSET LEFT_MSG
	JNE	SHIFT_DISPLAY35
	CALL	TEST_AND_WARN		;Test for edge of screen
	JZ	SHIFT_DISPLAY40		;And exit if user got scared
SHIFT_DISPLAY35:
	CALL	MOVE_IT			;Do move it loop
	CMP	BYTE PTR [SI],'T'
	JNE	SHIFT_DISPLAY40		;If not testing, stop
	CALL	CLEAR_SCREEN
	JMP	SHIFT_DISPLAY15		;And continue
SHIFT_DISPLAY40:
	CALL	RESTORE_PARMS
SHIFT_DISPLAY50:
	RET	
SHIFT_DISPLAY	ENDP

;*************************************************************************
;	MAKE_OPTION2_RES
;	Make CRT parms resident 
;	ENTRY	- none
;	EXIT	- none
;	AX,DI preserved
;	CALLS	- GET_PARMS, OUTSTRING
;*************************************************************************
PUBLIC MAKE_OPTION2_RES
MAKE_OPTION2_RES 	PROC	NEAR
	PUSH	AX
	PUSH	DI
	CALL	CLEAR_SCREEN
	CALL	GET_PARMS
	CALL	TEST_RESIDENT		
	TEST	RESIDENT_FLAG,FLAG_PRINTER OR FLAG_SERIAL OR FLAG_VIDEO
	JNZ	MO2R10
	OR	RESIDENT_FLAG,FLAG_STAY
	CALL	PRINT_RESIDENT
MO2R10:
	TEST	RESIDENT_FLAG,FLAG_VIDEO
	JNZ	MO2R20
	MOV	AL,VIDEO_PARMS_INTR
	MOV	DX,OFFSET VID_SPACE	;Point to our own CRT table
	PUSH	DS
	MOV	DS,DATA_SEG
	MOV	AH,DOSF_SIVEC		
	INT	DOSI_FUNC
	POP	DS
MO2R20:
	POP	DI
	POP	BX			;CRT add/sub in BX
	RET
MAKE_OPTION2_RES	ENDP

;*************************************************************************
;	TEST_RESIDENT
;	Do the actual test for residence (printer, serial, or mode)
;	ENTRY	- none
;	EXIT	- ZR means not resident
;*************************************************************************
PUBLIC TEST_RESIDENT, IS_SERIAL, IS_PRINTER, IS_VID_PARMS, REALLY
TEST_RESIDENT	PROC	NEAR
	CALL	IS_PRINTER
	CALL	IS_SERIAL
	CALL	IS_VID_PARMS
	RET				;NZ means already installed
TEST_RESIDENT	ENDP
	
IS_SERIAL	PROC	NEAR
	MOV	BX,(SERIAL_IO_INTR SHL 2)+2 ;Test serial IO intr
	CMP	WORD PTR ES:[BX],BIOS_PAGE_VAR ;Is it at F000?
	JZ	NOT_SERIAL
	MOV	AL,FLAG_SERIAL
	CALL	REALLY			;Not at F000 - is it really Mode?
NOT_SERIAL:
	RET
IS_SERIAL	ENDP

IS_PRINTER	PROC	NEAR
	MOV	BX,(PRINTER_IO_INTR SHL 2)+2 ;Printer IO intr
	CMP	WORD PTR ES:[BX],BIOS_PAGE_VAR ;Is it at F000?
	JZ	NOT_PRINTER
	MOV	AL,FLAG_PRINTER
	CALL	REALLY
NOT_PRINTER:
	RET
IS_PRINTER	ENDP

IS_VID_PARMS	PROC	NEAR
	MOV	BX,(VIDEO_PARMS_INTR SHL 2)+2 ;Video parms pointer
	CMP	WORD PTR ES:[BX],BIOS_PAGE_VAR ;Is it at F000?
	JZ	NOT_VID_PARMS
	MOV	AL,FLAG_VIDEO
	CALL	REALLY
NOT_VID_PARMS:
	RET
IS_VID_PARMS	ENDP

;REALLY was added 8/15/84, to allow MODE to work with other programs
;(such as Ethernet) which steal the printer, serial, or video-parms inter-
;rupts. It's no longer good enough to not be at segment F000-you must also
;say 'Mode' for MODE to be considered resident.		rmk

PUBLIC  REALLY
REALLY	PROC	NEAR
	PUSH	ES
	PUSH	DI
	MOV	DI,ES:[BX-2]	;Get offset of whatever is not at F000
	MOV	ES,ES:[BX]	; and segment
	CMP	BYTE PTR ES:[DI-4],'M' ;Is it really 'Mode'?
	JNZ	NOT_REALLY
	CMP	BYTE PTR ES:[DI-3],'o'
	JNZ	NOT_REALLY
	CMP	BYTE PTR ES:[DI-2],'d'
	JNZ	NOT_REALLY
	CMP	BYTE PTR ES:[DI-1],'e'
	JNZ	NOT_REALLY
	OR	RESIDENT_FLAG,AL ;Set bit for this interrupt and NZ flag
	MOV	DATA_SEG,ES	;And save this value
	JMP	SHORT REALLY_EXIT
NOT_REALLY:
	XOR	DI,DI		; Set ZR - that means MODE is not there
REALLY_EXIT:
	POP	DI
	POP	ES
	RET
REALLY	ENDP

;*************************************************************************
;	GET_PARMS
;	Move the CRT controller parms into VID_SPACE
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC GET_PARMS
GET_PARMS	PROC	NEAR
	PUSH	ES
	MOV	DI,OFFSET VID_SPACE	;Move video parameters
	MOV	CX,VID_LEN		;to the space where we can
	PUSH	ES
	PUSH	DS
	POP	ES
	POP	DS			;DS=0000, ES=Current data seg
	MOV	BX,VIDEO_PARMS_INTR SHL 2
	MOV	SI,[BX]		
	MOV	DX,[BX+2]		
	MOV	DS,DX		
	REP	MOVSB
	PUSH	ES
	POP	DS
	POP	ES			;DS=current DS, ES=0000
	RET
GET_PARMS	ENDP

;*************************************************************************
;	TEST_AND_WARN
;	If shift left would cause a garbage screen, warn user and let 
;	user back off
;	ENTRY	- none
;	EXIT	- ZR means oh, no, don't mess up my screen
;	CALLS	- OUTSTRING, INCHAR
;*************************************************************************
PUBLIC TEST_AND_WARN
TEST_AND_WARN	PROC	NEAR
	CMP	CURRENT_VMODE,GRFX80
	JG	TEST_AND_WARN40		;Get  out on MONO w/NZ set
	CMP	CURRENT_VMODE,TEXT80	;Text 80 mode?
	JE	TEST_AND_WARN10
	CMP	BYTE PTR VID_SPACE.TEXT_40+2,UNSTABLE_PARMS_GRFX_T40
	JB	TEST_AND_WARN40
	JMP	SHORT TEST_AND_WARN20
TEST_AND_WARN10:
	CMP	BYTE PTR VID_SPACE.TEXT_80+2,UNSTABLE_PARMS_T80
	JB	TEST_AND_WARN40		;If range is ok, exit
TEST_AND_WARN20:
	MOV	DX,OFFSET MOVE_WARNING
	CALL	OUTSTRING
	MOV	DX,OFFSET PROCEED
	CALL	OUTSTRING
	CALL	INCHAR
	CMP	AL,'N'
TEST_AND_WARN40:
	RET
TEST_AND_WARN	ENDP

;*************************************************************************
;	MOVE_IT
;	Update CRT controller parms and (if not in mono mode) reprogram it
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC MOVE_IT
MOVE_IT	PROC	NEAR
	ADD	VID_SPACE.TEXT_80+2,BH  ;Get current horizontal
	ADD	VID_SPACE.TEXT_40+2,BL  ;Get current horizontal
	ADD	VID_SPACE.GRFX_M+2,BL	;Get current horizontal
	CMP	CURRENT_VMODE,MONOCHROME	;That's all you do in mono mode
	JE	MOVE_IT10
	MOV	BP,BX			;Save BX
	MOV	BL,CURRENT_VMODE
	XOR	BH,BH
	CMP	BL,GRFX80		;High res graphics?
	JNE	MOVE_IT5
	MOV	BL,GRFX40		;In this case, it's same as GRFX40
MOVE_IT5:
	SHL	BX,1			;Point to offset in VID_STRUC
	SHL	BX,1			
	SHL	BX,1			
	ADD	BX,H_SYNC
	MOV	AH,BYTE PTR VID_SPACE[BX]	;Get the new value
	MOV	DX,CRT_CONTROLLER	;And reprogram the CRT
	MOV	AL,H_SYNC		;Controller 
	OUT	DX,AL
	INC	DX
	MOV	AL,AH
	OUT	DX,AL
	MOV	BX,BP			;Restore BX
MOVE_IT10:
	RET
MOVE_IT	ENDP

;*************************************************************************
;	RESTORE_PARMS
;	Move the CRT parms from VID_SPACE to whatever is pointed to by
;	the 'interrupt' pointer 
;	ENTRY	- none
;	EXIT	- none
;*************************************************************************
PUBLIC RESTORE_PARMS
RESTORE_PARMS	PROC	NEAR
	MOV	SI,OFFSET VID_SPACE	;Move video parameters
	MOV	CX,VID_LEN		;to the space where we can
	PUSH	ES			;Control them 
	MOV	BX,VIDEO_PARMS_INTR SHL 2
	MOV	DI,ES:[BX]		
	MOV	AX,ES:[BX+2]		
	MOV	ES,AX		
	REP	MOVSB
	POP	ES
	RET
RESTORE_PARMS	ENDP

;*************************************************************************
;	SET_SCROLL_MODE
;	Test for valid scroll mode and set. On a non-Z150, only scroll
;	mode 0 is valid. On a Z150, scroll mode 0 is valid for all video 
;	modes; scroll mode 1 on all but 80 text; scroll mode 2 is valid
;	only in graphics mode
;	ENTRY	- SI = pointer to scroll parm
;	EXIT	- none
;	CALLS	- IS_Z150, VMODE_ERROR
;*************************************************************************
PUBLIC SET_SCROLL_MODE
SET_SCROLL_MODE	PROC	NEAR
	CALL	IS_Z150
	JNZ	SET_SCROLL_MODE20	;Not a z150
	MOV	AL,[SI]			;Get scroll mode parm
	SUB	AL,'0'			;Change from ASCII to numbers
	CMP	AL,VALID_SCROLL		;Is it valid?
	JG	SET_SCROLL_MODE20
	MOV	AH,VIO_SSM		;Set scroll mode
	INT	VIDEO_IO_INTR	
	RET
SET_SCROLL_MODE20:
	CALL	VMODE_ERROR
SET_SCROLL_MODE	ENDP
	
;*************************************************************************
;	IS_Z150
;	Test for Zenith Z-150
;	ENTRY	- none
;	EXIT	- NZ means not a Z150
;*************************************************************************
PUBLIC IS_Z150
IS_Z150	PROC	NEAR
	PUSH	ES
	MOV	AX,BIOS_PAGE_VAR
	MOV	ES,AX
	MOV	BX,ZDS_FLAG
	CMP	BYTE PTR ES:[BX],'Z'
	JNE	IS_Z15010		;Not a z150
	CMP	BYTE PTR ES:[BX+1],'D'
	JNE	IS_Z15010		;Not a z150
	CMP	BYTE PTR ES:[BX+2],'S'
	POP	ES
IS_Z15010:
	RET
IS_Z150	ENDP

;*************************************************************************
;	INCHAR
;	Get and capitaliize a character from the keyboard
;	ENTRY	- none
;	EXIT	- AL = character
;	SI,BX preserved
;*************************************************************************
PUBLIC INCHAR
INCHAR	PROC	NEAR
	PUSH	BX
	PUSH	SI
	CALL	INVAL
	AND	AL,CAPS_MASK		;Capitalize
	POP	SI
	POP	BX
	RET
INCHAR	ENDP

;*************************************************************************
;	CLEAR_SCREEN
;	Clear the screen and return the cursor to the upper left corner
;	ENTRY	- none
;	EXIT	- none
;	BX, CX preserved
;*************************************************************************
PUBLIC CLEAR_SCREEN
CLEAR_SCREEN	PROC	NEAR
	PUSH	BX
	PUSH	CX
	MOV	AH,VIO_SPU
	XOR	AL,AL			;Blank entire screen
	XOR	CX,CX			;Start at upper left corner
	MOV	DH,ROWS			;Go to lower left
	MOV	DL,COLUMNS
	DEC	DL			;0-base it
	MOV	BH,CUR_ATR		;Get attribute to set
	INT	VIDEO_IO_INTR
	MOV	AH,VIO_SCP		;Set cursor
	XOR	DX,DX			;To upper left
	MOV	BH,DISPLAY_PAGE		;On this page
	INT	VIDEO_IO_INTR
	POP	CX
	POP	BX
	RET
CLEAR_SCREEN	ENDP			

;*************************************************************************
;	OPTION3 - This routine will allow the configuring of a serial
;	port parameters such as baud rate, parity, word length, and stop bits
;**************************************************************************
PUBLIC OPTION3
OPTION3	PROC	NEAR

	ADD	SI,LEN_COM		; Skip past length of "COM"
	LODSB				; Get the device number

;	Prepare device number

	CMP	AL,'1'
	JE	OPTION3_10
	CMP	AL,'2'
	JNE	OPTION3_100

OPTION3_10:
	MOV	COM_NUM,AL
	SUB	AL,'1'
	MOV	DL,AL
	SUB	DH,DH
	MOV	BP,DX			;Save this com device number

;	Parse the command line

	CMP	BYTE PTR [SI], ':'	; Colon must be included
	JNE	OPTION3_100
	INC	SI			
	CALL	PARSE_PARMS


;	Get the baud rate parameter

	CALL	DO_BAUD

;	Baud/Com # specs are OK-turn off infinite retry and set TSR flag


;	Do the parity

	CALL	DO_PARITY

;	Do the databits

	CALL	DO_DATABITS

;	Do the stopbits

	CALL	DO_STOPBITS


;	Turn off retry BEFORE initialization
	CALL	TEST_RESIDENT		; Set flags and segment variable
	MOV	AL,FALSE
	CALL	SET_RETRY

;	Initialize the device
	MOV	DX,BP
	MOV	AH,SIO_INIT
	MOV	AL,COM_INIT
	INT	SERIAL_IO_INTR

;Set up retry

	CALL	SET_INF_SER

;Output the COM spec string
	MOV	DX,OFFSET CRLF
	CALL	OUTSTRING
	MOV	DX,OFFSET COM_MSG
	CALL	OUTSTRING
	MOV	DX,PBAUD
	CALL	OUTSTRING
	MOV	DX,OFFSET COM_PARMS
	CALL	OUTSTRING

OPTION3_EXIT:
	RET

OPTION3_100:
	MOV	DX,OFFSET ILLEGAL_DEVICE
	CALL	ERROR_EXIT		;Display illegal device message, exit

OPTION3	ENDP	

DO_BAUD	PROC	NEAR

	MOV	SI,PARM_LIST.ONE	; Get the parameter pointer
	CMP	BYTE PTR [SI],0		; Is there enough characters?
	JE	BAD_PARMS		; No, invalid parms
	CMP	BYTE PTR [SI+1],0
	JE	INVALID_BAUD		; No, invalid baud

;	Match the baud rate

	MOV	DI,OFFSET BAUD		; Locate the correct baud rate
	MOV	CL,0			; Counter for baud
	MOV	AX,[SI]			; Get requested baud
	XCHG	AL,AH			; Get it in the correct order
DB1:
	CMP	AX,[DI]			; Is this the one?
	JZ	DB2			; Yes, prepare it
	INC	DI			; No, get ready for next one
	INC	DI
	INC	CL
	CMP	CL,NUM_BAUD		; At end yet?
	JBE	DB1			; No, try again

;	Invalid baud reate specified

INVALID_BAUD:
	MOV	DX,OFFSET BAUD_MSG
	CALL	ERROR_EXIT

;No parms on command line after "COMn:"
BAD_PARMS:
	MOV	DX,OFFSET INVALID_PARMS
	CALL	ERROR_EXIT
;	Got the baud rate prepare it

DB2:
	CALL	BAUD_OUT
	ROR	CL,1
	ROR	CL,1
	ROR	CL,1
	OR	COM_INIT,CL
	RET
DO_BAUD	ENDP

BAUD_OUT	PROC	NEAR
	MOV	DL,CL			;Table maneuvers
	SHL	DL,1			;Mul by 5
	SHL	DL,1
	ADD	DL,CL
	ADD	DL,CL			
	XOR	DH,DH
	ADD	DX,OFFSET PRINT_BAUD
	MOV	PBAUD,DX		;Save this...
	RET
BAUD_OUT	ENDP

DO_PARITY	PROC	NEAR

;	Get the parity parameter

	MOV	SI,PARM_LIST.TWO
	OR	SI,SI			; Out of parms?
	JZ	DP1			; Yup, do default
	SUB	CL,CL			; Assume no parity
	CMP	BYTE PTR [SI],'N'	; No parity specified?
	JZ	DP2			; Yes, do it
	OR	CL,1			; Assume odd parity
	CMP	BYTE PTR [SI],'O'	; Odd parity specified?
	JZ	DP2			; Yes, do it
DP1:
	OR	CL,3			; Must be even or default
	JMP	DP3
DP2:
	MOV	AL,[SI]
	OR	AL,NOT CAPS_MASK	; Make it lower case
	MOV	COM_PARMS,AL
DP3:
	SHL	CL,1
	SHL	CL,1
	SHL	CL,1
	OR	COM_INIT,CL
	RET

DO_PARITY	ENDP


DO_DATABITS	PROC	NEAR

	MOV	CL,3			; Assume 8 data bits
	MOV	SI,PARM_LIST.THREE
	OR	SI,SI
	JZ	DD1
	CMP	BYTE PTR [SI],'8'	; Is it 8?
	JZ	DD2			; Yes do it
DD1:
	MOV	CL,2			; No, 7
	JMP	DD3
DD2:
	MOV	DATA_BITS,'8'		;Change display
DD3:
	OR	COM_INIT,CL
	RET

DO_DATABITS	ENDP


DO_STOPBITS	PROC	NEAR

	MOV	SI,PARM_LIST.FOUR
	MOV	CL,1			;Assume 2 in case no parm
	OR	SI,SI
	JZ	DS1
	DEC	CL			; Assume 1 stop bit
	CMP	BYTE PTR [SI],'1'	; Is it 1?
	JZ	DS2			; Yes do it
	INC	CL			; No, assume 2
	CMP	BYTE PTR [SI],'2'	; Is it 2?
	JZ	DS2			; Yes, do it

;	Get default stopbits, if 110 baud 1 stop bit else 2
DS1:	
	TEST	COM_INIT,BAUD_MASK	;Is it 110 baud?
	JZ	DS2			; Yes-leave 2 stopbits
	SUB	CL,CL

;	Set the number of stop bits

DS2:
	MOV	BL,CL			;Get this in a form we can use
	ADD 	BL,'1'
	MOV	STOP_BITS,BL
	SHL	CL,1
	SHL	CL,1
	OR	COM_INIT,CL
	RET

DO_STOPBITS	ENDP

SET_INF_SER	PROC	NEAR
	MOV	SI,PARM_LIST.FIVE
	CMP	BYTE PTR [SI], 'P'
	JNE	SET_INF_SER10
	CALL	MAKE_OPTION3_RES	;Make us resident
	MOV	BYTE PTR COM_RETRY,'p'
	MOV	AL,TRUE
	CALL	SET_RETRY
SET_INF_SER10:
	RET
SET_INF_SER	ENDP

;*************************************************************************
;	MAKE_OPTION3_RES
;	Take serial IO interrupt
;	ENTRY	- none
;	EXIT	- none
;	CALLS	- OUTSTRING
;*************************************************************************
PUBLIC MAKE_OPTION3_RES
MAKE_OPTION3_RES 	PROC	NEAR
	TEST	RESIDENT_FLAG,FLAG_PRINTER OR FLAG_SERIAL OR FLAG_VIDEO
	JNZ	MO3R10			;  Yes-don't TSR
	OR	RESIDENT_FLAG,FLAG_STAY
	CALL	PRINT_RESIDENT		; Tell the user...
MO3R10:
	TEST	RESIDENT_FLAG,FLAG_SERIAL  ; Serial res?
	JNZ	MO3R20			; Yup-exit
	MOV	DX,OFFSET MY_SERIAL_INTR ;Point to own printer routine

; Save old vector in resident area
	PUSH	DS
	MOV	DS,DATA_SEG		; Points to correct DS
	MOV	BX,(SERIAL_IO_INTR SHL 2)+2 ;Serial IO intr
	MOV	AX,ES:[BX]
	MOV	SERIAL_SEG,AX
	MOV	AX,ES:[BX-2]
	MOV	SERIAL_OFF,AX

; Take interrupt vector - DX already set up
	MOV	AL,SERIAL_IO_INTR
	MOV	AH,DOSF_SIVEC		
	INT	DOSI_FUNC
	POP	DS
MO3R20:
	RET
MAKE_OPTION3_RES	ENDP

;*************************************************************************
;	OPTION 4 - This routine will allow remapping of a parallel
;	port to a serial port.
;
;	ENTRY:	SI - Pointer to input string
;	EXIT:	None
;	USES:	All 
;*************************************************************************
PUBLIC OPTION4, MAP, UNMAP,GET_TABLE_PTR, GET_TABLE_INDEX
OPTION4	PROC	NEAR
;	Get the number of the LPT device and verify it

	CALL	DEVICE_OK

;	Get the number of the COM device and verify it

	ADD	SI,5
	LODSB
	
	CMP	AL,'1'			
	JE	OPTION4_10
	CMP	AL,'2'
	JNE	OPTION4_20
	
OPTION4_10:
	PUSH	ES
	MOV	COM_NUM,AL
	SUB	AL,'0'			; Numeric value for MAP
	CALL	MAP

 	MOV	DX,OFFSET LPT_MSG
	CALL	OUTSTRING
	MOV	DX,OFFSET REDIRECT
	CALL	OUTSTRING
	MOV	DX,OFFSET CRLF
	CALL	OUTSTRING



	POP	ES
	RET

OPTION4_20:
	MOV	DX,OFFSET ILLEGAL_DEVICE
	CALL	ERROR_EXIT		;Display illegal device message, exit
OPTION4	ENDP	

MAP	PROC	NEAR

	CALL	GET_TABLE_PTR
	CALL	GET_TABLE_INDEX
	AND	BYTE PTR ES:[BX],0F0H
	OR	BYTE PTR ES:[BX],AL
	RET

MAP	ENDP


UNMAP	PROC	NEAR

	PUSH	ES
	PUSH	BX
	PUSH	AX

	CALL	GET_TABLE_PTR

	AND	BYTE PTR ES:[BX],0F0H	; Clear current mapping

	POP	AX
	POP	BX
	POP	ES
	RET

UNMAP	ENDP	


GET_TABLE_PTR	PROC	NEAR

	LES	BX,ES:[IO_PARMS_INTR SHL 2]
	RET

GET_TABLE_PTR	ENDP

GET_TABLE_INDEX	PROC	NEAR

	PUSH	AX
	MOV	AX,PRINTER
	MOV	AH,PCT_SIZE
	MUL	AH
	ADD	BX,AX
	POP	AX
	RET

GET_TABLE_INDEX	ENDP
PUBLIC HELP_SCREEN, RANGE_CHECK, INVAL
HELP_SCREEN	PROC	NEAR
	CALL	GET_VIDEO_MODE
	CALL	CLEAR_SCREEN
HS_10:
	MOV	DX,OFFSET HELP_MAIN	;Display main help screen
HS_20:
	CALL	OUTSTRING
	CALL	INVAL			;Get user choice
	CMP	AL,CC_CR		;CR?
	JE	HS_OUT
	MOV	AH,'5'			
	CALL	RANGE_CHECK
	JC	HS_ERR
	PUSH	AX
	CALL	CLEAR_SCREEN
	POP	AX
	CMP	AL,'1'
	JE	HS_10
	SUB	AL,'2'			;Get table offset
	XOR	BH,BH
	MOV	BL,AL
	SHL	BX,1			
	MOV	DX,HELP_MENUS[BX]	;Get help menus
	PUSH	DX
	CALL	OUTSTRING	
	CALL	INVAL
	POP	DX
	CMP	DX,OFFSET HELP_TWO	;Need to display more?
	JNE	HS_40
	CALL	CLEAR_SCREEN
	MOV	DX,OFFSET HELP_TWO_A
	CALL	OUTSTRING
	CALL	INVAL
HS_40:
	PUSH	AX
	CALL	CLEAR_SCREEN
	POP	AX
	CMP	AL,CC_CR		
	JNE	HS_10			;CR means exit to DOS
HS_OUT:	
	RET
HS_ERR:
	MOV	DX,OFFSET GET_SCR_NUM
	JMP	HS_20
HELP_SCREEN	ENDP

RANGE_CHECK	PROC	NEAR
	CMP	AL,'1'			;Range test
	JL	RC_ERR	
	CMP	AL,AH
	JG	RC_ERR
	CLC
	JMP	SHORT RC_EXIT
RC_ERR:
	STC
RC_EXIT:
	RET
RANGE_CHECK	ENDP

INVAL	PROC	NEAR
	MOV	AH,DOSF_CONIN		
	INT	DOSI_FUNC
	RET
INVAL	ENDP

;*************************************************************************
;	SKIP_WHITE
;	Take the string pointed to by SI and compress it so that there 
;	are no blanks in it.
;	ENTRY	- SI = pointer to string with possible spaces
;	EXIT	- AL = count of non-blank chars
;	USES	- DI, SI, AX
;*************************************************************************
PUBLIC SKIP_WHITE
SKIP_WHITE	PROC	NEAR
	MOV	DI,SI		;Source = dest
	XOR	AL,AL		;Use AL for the count
SKIP_WHITE10:
	CMP	BYTE PTR [SI],CC_CR	;Line terminator
	JE	SKIP_WHITE30
	MOV	AH,[SI]
	CMP	AH,' '
	JZ	SKIP_WHITE20
	CMP	AH,CC_HT
	JZ	SKIP_WHITE20
	CMP	AH,'a'		;Is it less than an 'a'?
	JL	SW1    		;Yes-don't cap it
	CMP	AH,'z'		;Is it bigger than a 'z'?
	JG	SW1	 	;Yes-leave it
	AND	AH,CAPS_MASK	;Cap it
SW1:
	MOV	[DI],AH
	INC	DI		;Non-blank char found-point past
	INC	SI		;It, and increment count
	INC	AL	
	JMP	SKIP_WHITE10
SKIP_WHITE20:
	INC	SI		;Point past blank char
	JMP	SKIP_WHITE10
SKIP_WHITE30:
	MOV	BYTE PTR [DI],CC_CR 	;Store string terminator
	XOR	AH,AH		
	SUB	DI,AX			;Point to start of string
	MOV	SI,DI		
	RET				;Exit
SKIP_WHITE	ENDP

;*************************************************************************
;	ERROR_EXIT
;	Display error message and exit
;	ENTRY	- DX = offset of start of message
;	EXIT	- Returns to DOS
;*************************************************************************
PUBLIC ERROR_EXIT
ERROR_EXIT	PROC	NEAR
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC		;Display string
	INT	DOSI_TERM		;And exit program
ERROR_EXIT	ENDP


PUBLIC PARSE_PARMS
PARSE_PARMS	PROC	NEAR
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	BX,OFFSET PARM_LIST	;BX points to list of parm pointers
	MOV	DI,BX			
	MOV	CX,PARM_LEN SHR 1
	XOR	AX,AX
	REP	STOSW
;Save address of parms
PARSE_PARMS10:
	MOV	[BX],SI			;Store address of parameter 
	ADD	BX,2
;Compare loop
PARSE_PARMS20:
	CMP	BYTE PTR [SI],','	;Test for parm separator
	JE	PARSE_PARMS30
	CMP	BYTE PTR [SI],CC_CR	;Test for <CR> (end of string)
	JE	PARSE_PARMS40		;Jump if got it
	INC	SI
	JMP	PARSE_PARMS20
;Comma found
PARSE_PARMS30:
	MOV	BYTE PTR [SI],CC_NUL	;Null terminator
	INC	SI
	JMP	PARSE_PARMS10		;And store it
;<CR>-string terminator-found
PARSE_PARMS40:
	MOV	BYTE PTR [SI],CC_NUL	;Another null terminator
	POP	ES
	RET
PARSE_PARMS	ENDP

PUBLIC OUTSTRING
OUTSTRING	PROC	NEAR
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET
OUTSTRING	ENDP

MODE_END	EQU	OFFSET $
MODE_SIZE	EQU	((MODE_END-ZERO)+15) SHR 4

CODE	ENDS
	END	MODE
