	PAGE	,132
	TITLE	Winchester boot code

;	This code will boot from a winchester partition.

;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

	.XLIST
	INCLUDE	..\COMMONS\Z150ROM.DEF
	INCLUDE ..\COMMONS\DRIVERS.DEF
	INCLUDE	..\COMMONS\LOADER.DEF
	.LIST

FAR_JUMP	EQU	0EAH
RELOC		EQU	0600H	; New offset for boot code
SEC_SIZE	EQU	512
NUM_RETRY	EQU	5
ENTRY_SIZE	EQU	16	; Size of a partition entry

SBC	SEGMENT	BYTE PUBLIC

	ASSUME	CS:SBC

ZERO	=	$

	ORG	0
	
	SUB	AX,AX	     ; Address page 0, stack below loader
	CLI
	MOV	SS,AX
	MOV	SP,7C00H
	STI
	
	MOV	SI,SP		; Prepare to relocate this code

	PUSH	DX		; Save the drive number from the ROM

	MOV	ES,AX
	PUSH	CS
	POP	DS

	MOV	DI,RELOC		; Re-locate this code to correct offset
	MOV	CX,SEC_SIZE/2
	CLD
	REP	MOVSW
	DB	FAR_JUMP		;jump to self at new location
	DW	OFFSET P1 + RELOC
	DW	0

P1:
	MOV	DS,AX
	MOV	SI,OFFSET PART_TABLE + RELOC
	MOV	CX,NUM_PART

;	Find active partition

P2:
	TEST	BYTE PTR [SI],80H	; Test for bootable partition
	JZ	P3
	CMP	BYTE PTR [SI+4],0	; Make sure partition is allocated
	JNZ	P4

;	Check next partition

P3:
	ADD	SI,ENTRY_SIZE
	LOOP	P2

;	No bootable partitions, report to user

	MOV	SI,OFFSET NO_BOOT + RELOC
	JMP	SHORT PMSG

;	Partition found, read in boot sector

P4:
	POP	DX		; Restore drive number
	MOV	DH,[SI+1]	; Get head for boot
	MOV	CX,[SI+02]	; Get track and cylinder
	MOV	BP,SI		; Save address of part table

;	Read in boot sector

	MOV	DI,NUM_RETRY	; Retry count
P5:
	MOV	BX,LOAD_ADDR	; Boot location
	MOV	AX,DIO_READ SHL 8 + 1	; Read 1 sector
	PUSH	DI
	INT	DISK_IO_INTR
	POP	DI
	JNB	P6		; No error jump to boot
	SUB	AX,AX		; reset
	INT	DISK_IO_INTR
	DEC	DI
	JNZ	P5		; Retry
	MOV	SI,OFFSET BAD_LOAD + RELOC	; Bad load, can't read disk
	JMP	SHORT PMSG

;	Check for valid system

P6:
	MOV	SI,OFFSET BAD_SYS + RELOC
	CMP	WORD PTR DS:[7DFEH],0AA55H
	JNZ	PMSG
	MOV	SI,BP			; Restore address of part table
	DB	FAR_JUMP		; boot loader
	DW	LOAD_ADDR
	DW	0

;	Print a message to the console
PMSG	PROC	NEAR

	LODSB
	OR	AL,AL
	JZ	STALL
	MOV	AH,VIO_WTT
	INT	VIDEO_IO_INTR
	JMP	PMSG
STALL:
	JMP	STALL

PMSG	ENDP

NO_BOOT	DB	'No bootable partitions', 0

BAD_LOAD DB	'Unable to read boot code from partition', 0

BAD_SYS	DB	'Not a bootable partition', 0


;	Locate the partition table at the end of the loader

	ORG	SEC_SIZE-(4*ENTRY_SIZE+2)

PART_TABLE LABEL WORD
	DB	ENTRY_SIZE DUP(0)	; Table 1

	DB	ENTRY_SIZE DUP(0)	; Table 2

	DB	ENTRY_SIZE DUP(0)	; Table 3

	DB	ENTRY_SIZE DUP(0)	; Table 4
NUM_PART	=	(OFFSET $ - OFFSET PART_TABLE)/16

	DW	0AA55H		; Table signature

SBC	ENDS
	END
                                                                                                                              
