Page	60,132
Title	-Task Handler
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 1_Nov_85
;
;
%Out	Task.asm
page
;----------------------------------------------------------------------
; Equates and Structure Definitions (8_Jul_85)
;---------------------------------------------
;
; Include Files
;--------------
;	Rom.lit
;	Video.lit
;	IO.lit
;	Icon.lit
;
	.xlist
	Include	Rom.lit
	Include	..\Video\Video.lit
	Include	..\Io\io.lit
	Include ..\Icon\Icon.lit
	.list

		;Video Screen Defintions
Lo_Screen_Base	equ	0B800h		;Segment Address of Video Ram
Hi_Screen_Base	equ	0BA00h		;Start of Odd Scan Lines in Video Ram


page
Rom_Data Segment At (40H)
;========================
;
	extrn	Shift_Status:Byte
Rom_Data EndS

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment

	extrn	Low_Battery_2_Function:Near
	extrn	Cursor_Updated_Function:Near
	extrn	LoBatt1_State0:Near
	extrn	LoBatt1_State1:Near
	extrn	LoBatt1_State2:Near
	extrn	Alt_Calc_Function:Near
	extrn	Clock_Icon:Near
	extrn	Phone_Icon:Near
 	extrn	Disk_Icon:Near
	extrn	Calc_Icon_L:Near
	extrn	Calc_Icon_R:Near
	extrn	Ac_Changed:Near
	extrn	Alarm_Service:Near
	extrn	Alt_Clock_Icon:Near
	extrn	Cursor_Off_Function:Near
	extrn	Power_Off_Function:Near

	extrn	Start_Up_Warm:Near	;Entry to the Boot Code
	extrn	Out_Morrow_6845:Near	;Output a Byte to the 6845
	extrn	R_W_RTC_Ram:Near	;Read/Write or get status of NovRam
	extrn	Nmi_Return:Near		;Return Code for Nmi's in SRam

	extrn	Set_Video_Mode:Near
	extrn	Set_Cursor_Style:Near
	extrn	Set_Cursor_Position:Near
	extrn	Get_Cursor_Position:Near
	extrn	Set_Display_Page:Near
	extrn	Get_Video_Status:Near
;***
	extrn	DS_To_Rom_Data:Near

	extrn	Get_Key_Buff:Near	;Read Key from Keyboard
	extrn	Get_Key_Status:Near	;Return Keyboard Status

	extrn	Video_Active:Byte	;Boolean Flag indicating Int10 Active
	extrn	Irq_Mask_Save:Byte
	extrn	Nmi_AX_Save:Word
	extrn	Nmi_BX_Save:Word
	extrn	Nmi_CX_Save:Word
	extrn	Nmi_DX_Save:Word
	extrn	Nmi_SS_Save:Word
	extrn	Nmi_SP_Save:Word
	extrn	Nmi_Flags_Save:Word

	extrn	Nmi_IP_Save:Word
	extrn	Nmi_CS_Save:Word

	extrn	Nmi_Stack:Word
	extrn	Nmi_PStack:Word
	extrn	Nmi_PStack_Size:Abs

	extrn	Last_Task_Id:Byte
	extrn	Current_Task_Id:Byte
	extrn	SC_Task:Byte		;State Change -- Task
	extrn	SC_State:Byte		;State Change -- State
	extrn	Scr_Save_Base:Word	;Base of Screen Save Area
	extrn	Current_State:Byte	;Table of Task's Current State
	extrn	No_Task_Change:Byte	;Flag to DisAble Long Tasks
	extrn	LoBatt_Disp:Byte	;LoBatt1 Message Display Flag

	extrn	Stk_LoBatt:Word		;Task Stack Definitions
	extrn	Stk_Phone:Word
	extrn	Stk_Clock:Word
	extrn	Stk_Calc:Word
	extrn	Stk_Alarm:Word
	extrn	Stk_Alt_Clk:Word

	extrn	Reg_Phone:Byte		;Task Register Save Area Definitions
	extrn	Reg_Disk:Byte
	extrn	Reg_Calc:Byte

	extrn	Vid_LoBatt1:Byte	;Task Video Save Area Definitions
	extrn	Vid_Phone:Byte
	extrn	Vid_Disk:Byte
	extrn	Vid_Calc:Byte
	extrn	Vid_Alarm:Byte
	extrn	Diag_Load_Addr:Word	;Base of Diagnostics Ram Area
	extrn	Set_Intr_Ptr:Near
	extrn	Get_Intr_Ptr:Near
	extrn	Z150_Intr_Tbl:Word	; table of interrupt offsets
	extrn	Old_Shift_Status:Byte	; copy of old shift status
page
;----------------------------------------------------------------------
; Code Segment Fixed Data Area
;-----------------------------
;
State_Vector_Table Label Word; (5_Aug_85)
;----------------------------------------
;
	dw	S0_LoBatt2		;Power Fail
	dw	0			;Cursor Update (Handled Specially)
	dw	S0_LoBatt1		;Low Battery
	dw	S0_Alt_Calc		;Pass Calc. Memory Value to MsDos
	dw	S0_Clock_Icon		;World Map and Setup
	dw	S0_Phone_Icon		;Modem/Phone Dialing Services
	dw	S0_Disk_Icon		;MsDos
	dw	S0_Calc_Icon		;Calculator
	dw	S0_Ac_Changed		;Ac Power On
	dw	S0_Alarm		;Appointment Alarm
	dw	S0_Alt_Clock		;Startup Diagnostics
	dw	S0_Alt_Phone		;expansion
	dw	S0_Alt_Disk		;ReBoot
	dw	S0_Cursor_Off		;Turn Off the Cursor
	dw	S0_Power_Off		;Ac Power turned off

Vector_Max	equ	($ - State_Vector_Table) - 2

;----------------------------------------------------------------------
; State Descriptors (7_Aug_85)
;-----------------------------
;	1) F_Control Flag Definitions
;		Cont............Continue an interrupted process
;		Need_Stack	Process Needs a Stack
;		ReStart_Ok......Task can be Re:Entered
;		Level_2.........Lowest Priority Task
;		Level_1.........Medium Priority Task
;		Level_0.........Highest Priority Task
;
;	2) F_Enter/F_Exit Flag Definitions
;		S_Reg...........Save the registers
;		S_Scr		Save a screen area
;		F_Key...........Flush the Keyboard Input Buffer
;		R_Vid		Restore the Video Attributes
;		R_Scr...........Restore a screen area
;		R_Reg		Restore the registers
;
S0_LoBatt2	Label Byte
	db	Level_2			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	Low_Battery_2_Function	;S_Execution (Job's Entry Point)
	page

S0_LoBatt1	Label Byte
	db	Level_1			;F_Control (Entry Control Flags)
	db	S_Scr			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_LoBatt1		;S_Screen (Screen Parameter Struc)
	dw	Vid_LoBatt1		;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	LoBatt1_State0		;S_Execution (Job's Entry Point)

S1_LoBatt1	Label Byte
	db	Level_1			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	R_Scr			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_LoBatt1		;S_Screen (Screen Parameter Struc)
	dw	Vid_LoBatt1		;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	LoBatt1_State1		;S_Execution (Job's Entry Point)

S2_LoBatt1	Label Byte
	db	Level_0			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	LoBatt1_State2		;S_Execution (Job's Entry Point)

S0_Alt_Calc	Label Byte
	db	Level_0			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	Alt_Calc_Function	;S_Execution (Job's Entry Point)

S0_Clock_Icon	Label Byte
	db	Level_2 + Need_Stack	;F_Control (Entry Control Flags)
	db	F_Key			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	Stk_Clock		;S_Stack (Job's Initial Stack)
	dw	Clock_Icon		;S_Execution (Job's Entry Point)
	page

S0_Phone_Icon	Label Byte
	db	Level_2 + Need_Stack	;F_Control (Entry Control Flags)
	db	F_Key			;F_Enter (Entry State Flags)
	db	S_Reg + S_Scr		;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_Phone_Icon		;S_Screen (Screen Parameter Struc)
	dw	Vid_Phone		;S_Video (Video Parameter Struc)
	dw	Reg_Phone		;S_Register (Register Parameter Struc)
	dw	Stk_Phone		;S_Stack (Job's Initial Stack)
	dw	Phone_Icon		;S_Execution (Job's Entry Point)

S1_Phone_Icon	Label Byte
	db	Level_2+ReStart_Ok+Cont ;F_Control (Entry Control)
	db	F_Key+R_Vid+R_Scr+R_Reg	;F_Enter (Entry State Flags)
	db	S_Reg + S_Scr		;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_Phone_Icon		;S_Screen (Screen Parameter Struc)
	dw	Vid_Phone		;S_Video (Video Parameter Struc)
	dw	Reg_Phone		;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	0			;S_Execution (Job's Entry Point)

S0_Disk_Icon	Label Byte
	db	Level_2 + Cont		;F_Control (Entry Control Flags)
	db	F_Key+R_Vid+R_Scr+R_Reg	;F_Enter (Entry State Flags)
	db	S_Reg + S_Scr		;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_Disk_Icon		;S_Screen (Screen Parameter Struc)
	dw	Vid_Disk		;S_Video (Video Parameter Struc)
	dw	Reg_Disk		;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	0			;S_Execution (Job's Entry Point)

S0_Calc_Icon	Label Byte
	db	Level_2 + Need_Stack + ReStart_Ok ;F_Control (Entry Control Flags)
	db	S_Scr + S_Reg + F_Key	;F_Enter (Entry State Flags)
	db	R_Reg + R_Scr		;F_Exit (Exit State Flags)
	db	1			;S_State (Next State)
	dw	Scr_0_Calc_Icon		;S_Screen (Screen Parameter Struc)
	dw	Vid_Calc		;S_Video (Video Parameter Struc)
	dw	Reg_Calc		;S_Register (Register Parameter Struc)
	dw	Stk_Calc		;S_Stack (Job's Initial Stack)
	dw	Calc_Icon_L		;S_Execution (Job's Entry Point)

S1_Calc_Icon	Label Byte
	db	Level_2 + Need_Stack + ReStart_Ok ;F_Control (Entry Control Flags)
	db	S_Scr + S_Reg + F_Key	;F_Enter (Entry State Flags)
	db	R_Reg + R_Scr		;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_1_Calc_Icon		;S_Screen (Screen Parameter Struc)
	dw	Vid_Calc		;S_Video (Video Parameter Struc)
	dw	Reg_Calc		;S_Register (Register Parameter Struc)
	dw	Stk_Calc		;S_Stack (Job's Initial Stack)
	dw	Calc_Icon_R		;S_Execution (Job's Entry Point)
	page

S0_Ac_Changed	Label Byte
	db	Level_0			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	Ac_Changed		;S_Execution (Job's Entry Point)

S0_Alarm	Label Byte
	db	Level_2 + Need_Stack	;F_Control (Entry Control Flags)
	db	S_Scr			;F_Enter (Entry State Flags)
	db	R_Scr			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	Scr_0_Alarm		;S_Screen (Screen Parameter Struc)
	dw	Vid_Alarm		;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	Stk_Alarm		;S_Stack (Job's Initial Stack)
	dw	Alarm_Service		;S_Execution (Job's Entry Point)

S0_Alt_Clock	Label Byte
	db	Level_2 + Need_Stack	;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	Stk_Alt_Clk		;S_Stack (Job's Initial Stack)
	dw	Alt_Clock_Icon		;S_Execution (Job's Entry Point)

S0_Alt_Phone	Label Byte
	db	Level_2			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	EtRet			;S_Execution (Job's Entry Point)

S0_Alt_Disk	Label Byte
	db	Level_2			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	EtRet			;S_Execution (Job's Entry Point)
	page

S0_Cursor_Off	Label Byte
	db	Level_0			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	Cursor_Off_Function	;S_Execution (Job's Entry Point)

S0_Power_Off	Label Byte
	db	Level_0			;F_Control (Entry Control Flags)
	db	0			;F_Enter (Entry State Flags)
	db	0			;F_Exit (Exit State Flags)
	db	0			;S_State (Next State)
	dw	0			;S_Screen (Screen Parameter Struc)
	dw	0			;S_Video (Video Parameter Struc)
	dw	0			;S_Register (Register Parameter Struc)
	dw	0			;S_Stack (Job's Initial Stack)
	dw	Power_Off_Function	;S_Execution (Job's Entry Point)
	page

;----------------------------------------------------------------------
; Screen Position Parameters (24_May_85)
;---------------------------------------
;	1) Starting Column and Row start with Column/Row 1
;
Scr_Disk_Icon	Label Word
	db	0			;Screen Starting Column
	db	0			;Screen Starting Row
	db	80			;Screen Columns to Save
	db	25			;Screen Rows to Save
	dw	0			;Offset to Screen Save Area

Scr_0_Calc_Icon	Label Word
	db	0			;Screen Starting Column
	db	0			;Screen Starting Row
	db	24			;Screen Columns to Save
	db	15			;Screen Rows to Save
	dw   (80*25*8)			;Offset to Screen Save Area

Scr_1_Calc_Icon	Label Word
	db	56			;Screen Starting Column
	db	0			;Screen Starting Row
	db	24			;Screen Columns to Save
	db	15			;Screen Rows to Save
	dw   (80*25*8)			;Offset to Screen Save Area

Scr_LoBatt1	Label Word
	db	15			;Screen Starting Column
	db	1			;Screen Starting Row
	db	31			;Screen Columns to Save
	db	1			;Screen Rows to Save
	dw   (24*15*8) + (80*25*8)	;Offset to Screen Save Area

Scr_Phone_Icon	Label Word
	db	0			;Screen Starting Column
	db	0			;Screen Starting Row
	db	80			;Screen Columns to Save
	db	25			;Screen Rows to Save
	dw   (31*8)+(24*15*8)+(80*25*8)	;Offset to Screen Save Area

Scr_0_Alarm	Label Word
	db	0			;Screen Starting Column
	db	0			;Screen Starting Row
	db	40			;Screen Columns to Save
	db	1			;Screen Rows to Save
	dw   (80*25*2)+(31*8)+(24*15*8)+(80*25*8) ;Offset to Screen Save Area

page
;----------------------------------------------------------------------
RS_Vector Label Word; (15_May_85)
;--------------------------------
;	1) This is a table of vectors to the Nmi Control routines. These
;	   routines save/restore various system resources (eg screen/registers)
;	2) Note: The order of this table is dependent on the ordering of the
;	   bits in the F_Entry/F_Exit Bytes in the State Table.
;		S_Reg...........Save the registers
;		S_Scr		Save a screen area
;		F_Key...........Flush the Keyboard Input Buffer
;		R_Vid		Restore the Video Attributes
;		R_Scr...........Restore a screen area
;		R_Reg		Restore the registers
;
	dw	Reg_Save		;Save Register
	dw	Screen_Save		;Save Screen
	dw	Flush_Keyboard		;Flush the Keyboard Buffer
	dw	Restore_Video		;Restore the Video Parameters
	dw	Screen_Restore		;Restore Screen
	dw	Reg_Restore		;Restore Register

RS_Vector_Len	equ	($ - RS_Vector) /2


;----------------------------------------------------------------------
Save_Vectors Label Word; (9_May_85)
;----------------------------------
;
	dw	Mode_0_Save		;Mode 0 40x25 black and white
	dw	Mode_0_Save		;Mode 1 40x25 color
	dw	Mode_0_Save		;Mode 2 80x25 black and white
	dw	Mode_0_Save		;Mode 3 80x25 color
	dw	Mode_4_Save		;Mode 4 320x200 color
	dw	Mode_4_Save		;Mode 5 320x200 black and white
	dw	Mode_6_Save		;Mode 6 640x200 black and white
	dw	Mode_0_Save		;Mode 7 80x25 MonoChrome


;----------------------------------------------------------------------
Restore_Vectors Label Word; (7_May_85)
;-------------------------------------
;
	dw	Mode_0_Restore		;Mode 0 40x25 black and white
	dw	Mode_0_Restore		;Mode 1 40x25 color
	dw	Mode_0_Restore		;Mode 2 80x25 black and white
	dw	Mode_0_Restore		;Mode 3 80x25 color
	dw	Mode_4_Restore		;Mode 4 320x200 color
	dw	Mode_4_Restore		;Mode 5 320x200 black and white
	dw	Mode_6_Restore		;Mode 6 640x200 black and white
	dw	Mode_0_Restore		;Mode 7 80x25 MonoChrome

page
;----------------------------------------------------------------------
Rom_Sector_Table Label Word; (26_Jun_85)
;---------------------------------------
;	1) This table is used to load the sectors from the Rom Disk (the
;	   part of the 80c39's memory that's accessable to the 8088).
;	2) Each entry consists of 2 words a) the number of bytes to transfer
;	   and b) the offset from the base of the diagnostics load area.
;
	dw	254,254 * 0		;Sector 0
	dw	254,254 * 1		;Sector 1
	dw	254,254 * 2		;Sector 2
	dw	254,254 * 3		;Sector 3
	dw	254,254 * 4		;Sector 4
	dw	254,254 * 5		;Sector 5
	dw	254,254 * 6		;Sector 6
	dw	254,254 * 7		;Sector 7

;----------------------------------------------------------------------
Int_Save_Tbl Label Byte; (25_July_85)
;---------------------------------------
;	1) This table contains the Interrupt numbers for the vectors
;	   in low memory that must be saved / restored along with registers.
;
	db	05h			; Print Screen Interrupt
	db	08h			; Time of Day hardware interrupt
	db	09h			; Keyboard Hardware interrupt
	db	10h			; Video interrupt
	db	14h			; Com port interrupts
	db	16h			; Keyboard input interrupt
	db	1Ah			; Get/Set Time interrupt

Int_Save_Cnt	equ ($ - Int_Save_Tbl)	; # of vectors to save/restore

;----------------------------------------------------------------------
Exec_Init Proc Near; (8_Jul_85)
;------------------------------
;	1) This process initializes the Current Task's Id, Enables Long Tasks
;	   by setting the No_Task_Change Flag to False and then sets all task
;	   states to 0.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing, ss:Nothing
Public	Exec_Init

	push	ds
	push	cs
	pop	ds			;DS:= Monitor_Segment

	mov	al,0Ch			;(0Ch = Nmi Disk Icon - 2)
	mov	Current_Task_Id,al	;Current Task:= Disk_Icon
	mov	Last_Task_Id,al		;Last Task:= Disk_Icon
	mov	No_Task_Change,0	;Allow Long Tasks to Execute
	mov	LoBatt_Disp,False	;LoBatt Message on Display:= False

	mov	ah,0			;AH:= Default (Screen NOT Saved)
	mov	bx,0			;BX:= Array Pointer
	mov	cx,Vector_Max / 2	;CX:= Number of Task Entries

EiLp1:	mov	Current_State[bx],0	;Repeat Current_State:= State 0
	inc	bx			;	Increment Array Pointer (byte)
	loop	EiLp1			;Until (All elements of array 0'ed)

	pop	ds
	ret

Exec_Init	EndP

page
;----------------------------------------------------------------------
Change_State Proc Near; (13_May_85)
;----------------------------------
;	1) This routine changes the current Task's State
;	2) Entry Register Values:
;		AL -> New State Number
;		AH -> New Task Number (0 based e.g. Cursor:= 2)
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing
Public	Change_State

	push	ax			;(Save the new state Number)
	mov	SC_State,al		;Set the Desired State
	mov	SC_Task,ah		;Set the Desired Task

	mov	ah,State_Flag		;AH:= State Change Request
	mov	al,Nmi_ReGenerate	;AL:= Nmi ReGenerate Reg
	call	Out_Morrow_6845		;Reinitiate the Nmi

	pop	ax
	ret				;Return

Change_State	EndP

page
;----------------------------------------------------------------------
Nmi_Interrupt Proc Far; (28_May_85)
;----------------------------------
;	1) This routine saves a subset of the machine's registers and then
;	   transfers control to either 1) Dispatch_Nmi (for normal Nmi
;	   processing) or to 2) Change_State (to exit the current state).
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing
Public Nmi_Interrupt

	push	ax			;save some working registers
	push	dx

	mov	dx,Color_Card
	in	al,dx			;AL:= Nmi Function Number

	mov	Nmi_SS_Save,ss		;save the current stack
	mov	Nmi_SP_Save,sp
	mov	dx,cs			;install the new stack
	mov	ss,dx
	mov	sp,Offset Nmi_Stack

	push	ax			;(save the Task Id)
	mov	Nmi_BX_Save,bx
	mov	Nmi_CX_Save,cx

	mov	bx,Nmi_SS_Save		;Determine the NMI stack pointer
	mov	cl,4			;Get physical address of stack
	shl	bx,cl
	add	bx,Nmi_SP_Save		;Add stack pointer to segment
	and	bx,1Fh 			;Get the stack index

	;move entry register values to restore locations
	call	Pop_Nmi_Stack
	mov	Nmi_DX_Save,ax

	call	Pop_Nmi_Stack
	mov	Nmi_AX_Save,ax

	call	Pop_Nmi_Stack
	mov	Nmi_IP_Save,ax

	call	Pop_Nmi_Stack
	mov	Nmi_CS_Save,ax

	call	Pop_Nmi_Stack
	mov	Nmi_Flags_Save,ax
	page

	pop	bx			;(Nmi Function value read from 80c39)
	cmp	bl,Cursor_Updated
	jz	Short NmiSk1		;If (This is NOT a Cursor Update)

	in	al,Interrupt_Mask
	mov	Irq_Mask_Save,al	;	Save the Current Irq Mask

	mov	al,bl			;	Restore Nmi Function Number
	call	Execute_Task		;	Execute a Normal Task

NmiRet:	mov	al,Irq_Mask_Save	;	Restore the Irq Mask
	out	Interrupt_Mask,al
	jmp	Short NmiSk2

NmiSk1:	call	Cursor_Updated_Function	;Else	Update the Cursor Position

NmiSk2:	mov	ax,Nmi_Flags_Save	;AX:= Flag Register
	mov	bx,Far_Jump shl 8+Cli_Code ;(BL:=Cli, BH:=Far Jump)
	test	ax,Interrupt_Flag	;If (Interrupt Enabled eq True)
	jz	NmiSk3

	mov	bx,Far_Jump shl 8+Sti_Code ;	(BL:=Sti, BH:=Far Jump)
	and	ax,Not Interrupt_Flag	;	Clear the Interrupt Enable Bit
NmiSk3:	mov	Word Ptr Nmi_Return,bx	;put the instruction in memory
	push	ax			;put flags on stack

	mov	bx,Nmi_BX_Save		;restore registers
	mov	cx,Nmi_CX_Save

	mov	dx,Color_Card
	in	al,dx			;Restore Nmi Servicing

	mov	ax,Nmi_AX_Save		;restore registers
	mov	dx,Nmi_DX_Save
	popf

	mov	ss,Nmi_SS_Save
	mov	sp,Nmi_SP_Save
	jmp	Nmi_Return
	
Nmi_Interrupt	EndP

page
;----------------------------------------------------------------------
Pop_Nmi_Stack Proc Near
;----------------------
;	this routine will 'pop' values off of the nmi stack.
; BX contains the index into the stack which is located at the last 32 bytes
; of the first 4k of monitor ram. i.e. starting at F000:0FE0
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	mov	ax,Nmi_PStack[bx]	;'POP' the NMI stack
	add	bx,2			;Bump the NMI 'stack pointer'
	cmp	bx,Nmi_PStack_Size	;Did we wrap around?
	jb	pns1			;No, done
	mov	bx,0			;Yes, do the wrap around
	je	pns1			;If high POPed byte is good, exit
	mov	ah,Byte Ptr Nmi_PStack	;word wrapped, so correct high byte
	inc	bx			;Correct the NMI pointer
pns1:	add	Nmi_SP_Save,2		;Bump the user stack pointer
	ret

Pop_Nmi_Stack	EndP

page
;----------------------------------------------------------------------
Execute_Task Proc Near; (21_Jun_85)
;----------------------------------
;	1) This routine filters the Function Number returned from reading
;	   the 6845. There are four execution path destinations:
;		1) A Direct Return is caused by Illegal Values or Conditions.
;		2) A Task may be run immediatly without using any more of the
;		   task Handler's resources.
;		3) The current task may be placed into a new state after
;		   terminating its current state.
;		4) A New Task May Be Initiated after suspending the current
;		   task.
;	2) Entry Register Values
;		AL -> Task Number = Nmi Function Number
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	test	al,State_Flag		;If (This is a State Change Request)
	jnz	EtSk3			;	Change the State

	test	al,Sector_Flag		;If (We're reading a Rom Sector)
	jz	EtSk0

	call	Read_Rom		;	Read the Rom Sector
	ret				;	Return

EtSk0:	sub	al,2			;(Set Function Number to 0 base)
	cmp	al,Vector_Max		;If ( (Function Number too High) Or
	ja	EtRet
	cmp	al,0			;     (Function Number too Low)  Or
	jb	EtRet
	test	al,1			;     (Function Number is Odd) )
	jnz	EtRet			;	Return

	call	Get_State_Pntr		;BX:= Base of New Task's State Struct.
	test	cs:[bx.F_Control],Level_0
	jz	EtSk1			;If (New Task is High Priority)

	call	cs:[bx.S_Execution]	;	Execute the New Task Immediatly
	ret				;	Return

EtSk1:	cmp	al,Current_Task_ID	;If (New Task Id ne Current Task Id)
	jz	EtSk2

	call	New_Task		;	Execute the New Task
	ret				;	Return

EtSk2:	test	cs:[bx.F_Control],ReStart_Ok
	jz	EtRet			;If (Task can be ReStarted)

	mov	al,cs:[bx.S_State]
	mov	SC_State,al		;	Set the Desired State
	mov	al,Current_Task_Id
	mov	SC_Task,al		;	Set the Desired Task

EtSk3:	call	New_State		;	Change the State
EtRet:	ret				;Return

Execute_Task	EndP

page
;----------------------------------------------------------------------
Read_Rom Proc Near; (1_Jul_85)
;-----------------------------
;	1) This routine reads the selected sector into SRam using the
;	   Rom_Sector_Table to figure the starting address and the number
;	   bytes to transfer.
;	2) Entry Register Values:
;		AL -> Sector Number or'ed with Sector_Flag
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing
Public	Read_Rom

	and	al,Not Sector_Flag	;AL:= Sector Number
	cbw
	shl	ax,1
	shl	ax,1			;AX:= Sector Number * 4
	mov	bx,ax

	mov	cx,Rom_Sector_Table[bx]	;CX:= Number of Bytes to transfer
	inc	bx
	inc	bx

	mov	bx,Rom_Sector_Table[bx]	;BX:= Load Offset
	add	bx,Offset Diag_Load_Addr

	mov	dx,Color_Card+Crt_Mode_Select
RrLp1:	in	al,dx			;Repeat	Read a Byte from the 80c39
	mov	cs:[bx],al		;	Store the byte
	inc	bx			;	Increment storage pointer
	loop	RrLp1			;Until (whole block has been read)
	ret				;Return

Read_Rom	EndP

page
;----------------------------------------------------------------------
New_Task Proc Near; (14_May_85)
;------------------------------
;	1) This routine potentially starts up a new task.
;	2) Entry Register Values:
;		AL -> New Task's Id
;		BX -> Pointer to the New Task's State Structure
;	3) Exit Register Values:
;		AL -> New Task's Id
;		BX -> Pointer to the New Task's State Structure
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	call	Ok_to_Continue		;If (NOT Ok to Continue)
	jc	NtSk1			;	ReGenerate the Nmi

	test	cs:[bx.F_Control],Level_1
	jnz	NtSk3			;If (New task Level ne 1)

	cmp	No_Task_Change,0	;	If (Task Change Inhibited)
	jz	NtSk2

NtSk1:	add	al,2
	xchg	ah,al			;		AH:= New Task's Id
	mov	al,Nmi_ReGenerate	;		AL:= Nmi ReGenerate Reg
	call	Out_Morrow_6845		;		ReGenerate the Nmi
	ret				;		Return

NtSk2:	push	ax
	push	bx
	xchg	al,Current_Task_Id	;	Update the Current Task's Id
	mov	Last_Task_Id,al		;	Update the Last Task's Id

	call	Get_State_Pntr		;	BX:= Pointer to Old Task's State
	mov	ah,cs:[bx.F_Exit]	;	AH:= Exit State Control
	call	Exec_RS_Vector		;	Terminate Current Task
	pop	bx
	pop	ax

NtSk3:	call	Start_Task		;Start the New Task
	ret				;Return

New_Task	EndP

page
;----------------------------------------------------------------------
New_State Proc Near; (12_May_85)
;-------------------------------
;	1) This routine changes the current task's state.
;	2) Entry Register Values:
;		none
;	3) Exit Register Values:
;		AL -> New Task's Id
;		BX -> Pointer to the New State's Structure
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	call	Ok_to_Continue		;If ((Irq Active) or (NovRam Enabled))
	jnc	NsSk1

	mov	ah,State_Flag		;	AH:= Change State Flag
	mov	al,Nmi_ReGenerate	;	AL:= Nmi ReGenerate Reg
	call	Out_Morrow_6845		;	Reinitiate the Nmi
	ret				;	Return

NsSk1:	mov	al,SC_Task		;AL:= Task Number
	call	Get_State_Pntr		;BX:= Pointer to Current Task's State
	mov	ah,cs:[bx.F_Exit]	;AH:= Exit State Control
	call	Exec_RS_Vector		;Terminate Current Task

	mov	bl,al
	mov	bh,0			;BX:= Offset - Task's State Table Entry
	shr	bx,1			;(adjust offset for byte pointer)
	mov	ah,SC_State

	mov	Current_State[bx],ah	;Update the Task's State
	call	Get_State_Pntr		;BX:= Pointer to New Task's State
	call	Start_Task		;Stop Last Task, Start Current Task
	ret				;Return

New_State	EndP

page
;----------------------------------------------------------------------
Start_Task Proc Near; (28_May_85)
;--------------------------------
;	1) This routine suspends the current task's state, initiates the
;	   new task's state and then transfers control to the new state.
;	2) Entry Register Values:
;		AL -> New Task's Id
;		BX -> Pointer to New Task's State
;	3) The Registers are NOT defined on Exit.
;	4) Notice the test for Level 0 tasks which suppresses ReEnabling the
;	   Nmi's. This is needed because state changes can cause Level_0 tasks
;	   to execute this code.
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	mov	ah,cs:[bx.F_Enter]	;AH:= Entry State Control
	call	Exec_RS_Vector		;Start New Task

	mov	al,Not ( (Not Timer_Intr_Mask) or (Not Keyboard_Intr_Mask) )
	out	Interrupt_Mask,al	;Unmask Timer and Keyboard Interrupts
	sti				;Allow Limited Interrupt Service

	test	cs:[bx.F_Control],Level_2
	jz	EnSk2			;If (Level eq 2)

	test	cs:[bx.F_Control],Cont	;	If (Continue eq true)
	jnz	EnSk3			;		Finish Restarting Task

	test	cs:[bx.F_Control],Need_Stack
	jz	EnSk1			;	If (Need_Stack eq true)

	mov	sp,cs:[bx.S_Stack]	;		Allocate a Stack
	mov	ax,Offset NmiRet
	push	ax			;		Push Return Address

EnSk1:	mov	dx,Color_Card		;	DX:= 6845 Address Reg
	in	al,dx			;	ReEnable Nmi Servicing

EnSk2:	call	cs:[bx.S_Execution]	;Execute the Nmi
EnSk3:	ret				;Return

Start_Task	EndP

page
;----------------------------------------------------------------------
Ok_to_Continue Proc Near; (13_May_85)
;------------------------------------
;	1) This routine checks if 1) an Interrupt is in progress or 2) if
;	   NovRam is enabled or 3) if an Int 10 is in progress. If any of
;	   these conditions exist then the Nmi is re:generated and the
;	   carry is returned set; Otherwise the carry is returned cleared.
;	2) Entry Register Values:
;		AL -> Nmi Function Number
;	3) Exit Register Values:
;		AX -> Entry Value
;		DX -> Destroyed
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	push	ax
	mov	al,2			;AL:= Function Get R/W Status
	call	R_W_Rtc_Ram
	cmp	al,0			;If ( (Nov_Ram is NOT Enabled) And
	jnz	OcSk1

	mov	al,In_Service_Intrs	;     (an Irq is in NOT in process) And
	out	Interrupt_Ctrl,al
	in	al,Interrupt_Ctrl
	or	al,al
	jnz	OcSk1

	cmp	Video_Active,True	;     (an Int 10 is NOT inprocess) )
	jz	OcSk1

	pop	ax
	clc				;	Clear Carry (Ok to Continue)
	ret				;	Return

OcSk1:	pop	ax
	stc				;Set Carry (NOT Ok to Continue)
	ret				;Return

Ok_to_Continue	EndP

page
;----------------------------------------------------------------------
Get_State_Pntr Proc Near; (30_Apr_85)
;------------------------------------
;	1) Entry Register Values
;		AL -> Task Id Number (Task Ids are Even Numbers Only)
;	2) Exit Register Values
;		AX -> Unchanged
;		BX -> Offset to Start of Task's State Descriptor
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	push	ax
	mov	bl,al
	mov	bh,0			;BX:= Offset to the Task
	push	State_Vector_Table[bx]	;Stack:= Pointer to Task's State 0

	shr	bx,1			;(adjust offset for byte pointer)
	mov	al,Current_State[bx]	;AL:= Task's Current State
	mov	ah,Size State_Descriptor;AH:= Size of a State Sturcture
	mul	ah			;AX:= Offset to the current state

	pop	bx
	add	bx,ax			;BX:= Pointer to Base State Descriptor

	pop	ax
	ret				;Return

Get_State_Pntr	EndP

page
;----------------------------------------------------------------------
Exec_RS_Vector Proc Near; (15_Apr_85)
;------------------------------------
;	1) This routine processes a task control byte. The task control byte
;	   consists of a series of flags (eg Save_Registers).
;	2) Entry Register Values
;		AL -> Task Id Number (Task Ids are Even Numbers Only)
;		AH -> Task Control Byte
;		BX -> Pointer to Task's State Descriptor
;	3) Exit Register Values
;		AL -> Unchanged
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	push	cx
	push	dx
	mov	dx,0			;Vector_Index:= Base of Vector Table
	mov	cx,RS_Vector_Len	;Loop_Counter:= Max Count

PcLp1:	shr	ah,1			;Repeat	Shift Next Task into Carry
	jnc	PcSk1

	push	ax			;	If (Function is Active)
	push	bx
	push	cx
	push	dx

	shr	al,1			;		AL:= task number
	xchg	dx,bx
	mov	bx,RS_Vector[bx]
	xchg	dx,bx
	call	dx			;		Execute the Function

	pop	dx
	pop	cx
	pop	bx
	pop	ax

PcSk1:	inc	dx			;	Vector_Index:= Next Vector
	inc	dx
	loop	PcLp1

	pop	dx
	pop	cx
	ret				;Return

Exec_RS_Vector	EndP

page
;----------------------------------------------------------------------
Flush_Keyboard Proc Near; (9_Jul_85)
;-----------------------------------
;	1) This routine pulls keys from the Keyboard input buffer until
;	   its empty.
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing
Public	Flush_Keyboard

FkLp1:	call	Get_Key_Status		;While (Keyboard Buffer eq Active)
	jz	FkSk1

	call	Get_Key_Buff		;	Read the Key from the Buffer
	jmp	Short FkLp1

FkSk1:	ret				;Return

Flush_Keyboard	EndP

page
;----------------------------------------------------------------------
; Register Save and Restore Routines:
;------------------------------------
;
;	1) Save Registers:
;		-Enter with the task number in the AL.
;		-Saves the registers in the task's register save area.
;		-Sets the task's register status to 'active'
;
;
;	2) Restore Registers:
;		-Enter with the task number in the AL.
;		-If the task's Id is in range and the registers have been
;		 saved then they are restored and the task's register status
;		 is set to inactive.
;
page
;----------------------------------------------------------------------
Reg_Save Proc Near; (21_May_85)
;------------------------------
;	1) This process saves all Registers, Segment_Registers and Indexes.
;	2) Register Entry Values:
;		AL -> Task Id Number
;		BX -> Pointer to Base of State_Descriptor.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	push	ax
	push	bx
	push	ds
	mov	bx,cs:[bx.S_Register]	;BX:= Base of the Register Block
	mov	cs:[bx.R_DS_Save],ds	;Save the Data Segment
	push	cs
	pop	ds			;DS:= Monitor Segment
	mov	[bx.R_ES_Save],es	;Save Segments & Indexes
	mov	[bx.R_BP_Save],bp
	mov	[bx.R_SI_Save],si
	mov	[bx.R_DI_Save],di

	mov	ax,Nmi_AX_Save		;Save General Registers
	mov	[bx.R_AX_Save],ax
	mov	ax,Nmi_BX_Save
	mov	[bx.R_BX_Save],ax
	mov	ax,Nmi_CX_Save
	mov	[bx.R_CX_Save],ax
	mov	ax,Nmi_DX_Save
	mov	[bx.R_DX_Save],ax

	mov	ax,Nmi_Flags_Save	;Save Registers from Transient Area
	mov	[bx.R_Flags_Save],ax
	mov	ax,Nmi_SS_Save
	mov	[bx.R_SS_Save],ax
	mov	ax,Nmi_SP_Save
	mov	[bx.R_SP_Save],ax
	mov	ax,Nmi_IP_Save
	mov	[bx.R_IP_Save],ax
	mov	ax,Nmi_CS_Save
	mov	[bx.R_CS_Save],ax
;*****
	pushf
	cli				; disable int's during vector set-up
	call	Save_Int_Vectors	; save selected interrupt vectors
	call	Jam_Vectors		; Jam selected interrupt vectors
	popf
;****
	push	ds
	call	DS_To_Rom_Data		; get keyboard shift status

	Assume	DS:Rom_Data

	mov	al,Shift_Status
	pop	ds

	Assume	DS:Monitor_Segment

	mov	[bx.R_KbState_Save],al	; and save it
;****
	in	al,Interrupt_Mask	;Save the Interrupt Mask
	mov	[bx.R_IrqMsk_Save],al
;==>	mov	[bx.R_Status],True	;If (Registers Have been Saved)
	pop	ds
	pop	bx
	pop	ax
	ret				;Return (AH=Task Saved)

Reg_Save	EndP

page
;----------------------------------------------------------------------
Reg_Restore Proc Near; (21_May_85)
;---------------------------------
;	1) This process restores all Registers, Segment_Registers and Indexes.
;	2) Register Entry Values:
;		AL -> Task Id Number
;		BX -> Pointer to Base of State_Descriptor Relative to the CS:
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	push	ax
	push	bx
	push	cs
	pop	ds			;DS:= Base of Monitor Segment
	mov	bx,[bx.S_Register]	;BX:= Base of the Register Block
;==>	cmp	[bx.R_Status],True	;If (Registers Have been Saved)
;==>	jne	RrSk1
;***
	pushf
	cli				; disable int's during vector set-up
	call	Restore_Int_Vectors	; restore selected interrupt vectors
	popf

	mov	al,[bx.R_KbState_Save]	; get Shift_Status
	push	ds
	call	DS_To_Rom_Data

	Assume	DS:Rom_Data

	mov	Shift_Status,al		; and restore it
	pop	ds

	Assume	DS:Monitor_Segment

	xor	al,0ffh			; force keyboard reset
	mov	Old_Shift_Status,al

;****
	mov	ax,[bx.R_AX_Save]	;	Restore General Registers
	mov	Nmi_AX_Save,ax
	mov	ax,[bx.R_BX_Save]
	mov	Nmi_BX_Save,ax
	mov	ax,[bx.R_CX_Save]
	mov	Nmi_CX_Save,ax
	mov	ax,[bx.R_DX_Save]
	mov	Nmi_DX_Save,ax

	mov	ax,[bx.R_Flags_Save]	;	Restore Transient Area
	mov	Nmi_Flags_Save,ax
	mov	ax,[bx.R_SS_Save]
	mov	Nmi_SS_Save,ax
	mov	ax,[bx.R_SP_Save]
	mov	Nmi_SP_Save,ax
	mov	ax,[bx.R_IP_Save]
	mov	Nmi_IP_Save,ax
	mov	ax,[bx.R_CS_Save]
	mov	Nmi_CS_Save,ax

	mov	bp,[bx.R_BP_Save]	;	Restore Segments & Indexes
	mov	si,[bx.R_SI_Save]
	mov	di,[bx.R_DI_Save]
	mov	es,[bx.R_ES_Save]
	mov	al,[bx.R_IrqMsk_Save]
	mov	Irq_Mask_Save,al

	out	Interrupt_Mask,al	;	Restore the Interrupt Mask
	mov	[bx.R_Status],False	;	Clear the Task's Status
	mov	ds,[bx.R_DS_Save]	;	Restore the Data Segment
RrSk1:	pop	bx
	pop	ax
	ret				;Return

Reg_Restore	EndP

page
;----------------------------------------------------------------------
Save_Int_Vectors Proc Near; (25_July_85)
;---------------------------------
;	1) This process saves selected interrupt vectors.
;	2) Vectors to be saved are defined in the Int_Save_Tbl,
;	   and the vectors are saved in the task's State_Descriptor.
;	2) Register Entry Values:
;		AL -> Task Id Number
;		BX -> Pointer to Base of State_Descriptor Relative to the CS:
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	pushreg	<ax, dx, si, ds>
	mov	dx,0			; point to base of save table

	call	Get_Vect		; get 1st Vector
	mov	cs:[bx.R_Int5_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int5_O_Save],si	; save the offset

	call	Get_Vect		; get 2nd Vector
	mov	cs:[bx.R_Int8_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int8_O_Save],si	; save the offset

	call	Get_Vect		; get 3rd Vector
	mov	cs:[bx.R_Int9_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int9_O_Save],si	; save the offset

	call	Get_Vect		; get 4th Vector
	mov	cs:[bx.R_Int10_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int10_O_Save],si	; save the offset

	call	Get_Vect		; get 5th Vector
	mov	cs:[bx.R_Int14_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int14_O_Save],si	; save the offset

	call	Get_Vect		; get 6th Vector
	mov	cs:[bx.R_Int16_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int16_O_Save],si	; save the offset

	call	Get_Vect		; get 7th Vector
	mov	cs:[bx.R_Int1A_S_Save],ds	; save the segment
	mov	cs:[bx.R_Int1A_O_Save],si	; save the offset
	
	popreg	<ds, si, dx, ax>
	ret

Get_Vect:
	xchg	dx,bx
	mov	al,cs:Int_Save_Tbl[bx]	;  Get interrupt number to save
	xchg	bx,dx
	call	Get_Intr_Ptr		;  get the vector to DS:SI
	inc	dx			;  bump vector table index

	ret

Save_Int_Vectors	EndP

page
;----------------------------------------------------------------------
Restore_Int_Vectors Proc Near; (25_July_85)
;---------------------------------
;	1) This process restoresselected interrupt vectors.
;	2) Vectors to be restoredare defined in the Int_Save_Tbl,
;	   and the vectors are restored from the task's State_Descriptor.
;	2) Register Entry Values:
;		AL -> Task Id Number
;		BX -> Pointer to Base of State_Descriptor Relative to the CS:
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	pushreg	<ax, bx, dx, si, ds>
	mov	dx,0			; point to base of save table

	mov	ds,cs:[bx.R_Int5_S_Save]	; get the segment
	mov	si,cs:[bx.R_Int5_O_Save]	; get the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int8_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int8_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int9_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int9_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int10_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int10_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int14_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int14_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int16_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int16_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector

	mov	ds,cs:[bx.R_Int1A_S_Save]	; save the segment
	mov	si,cs:[bx.R_Int1A_O_Save]	; save the offset
	call	Set_Vect		; get vector # from table, and set vector
	
	popreg	<ds, si, dx, bx, ax>
	ret

Set_Vect:
	xchg	dx,bx
	mov	al,cs:Int_Save_Tbl[bx]	;	Get interrupt number to save
	xchg	dx,bx
	call	Set_Intr_Ptr		;	get the vector to DS:SI
	inc	dx			; get next vector
	ret

Restore_Int_Vectors	EndP

page
;----------------------------------------------------------------------
Jam_Vectors Proc Near; (25_July_85)
;---------------------------------
;	1) This process resets selected interrupt vectors.
;	2) Vectors to be reset are defined in the Int_Save_Tbl,
;	   and the vectors are set from the Z150_Intr_Tbl.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	pushreg	<ax, bx, cx, ds, si>
	push	cs
	pop	ds			; set Segment to use for interrupts
	mov	cx,Int_Save_Cnt		; # of vectors to save
	mov	bx,0			; start with 1st entry in table
					; repeat
Jam_Next:
	push	bx
	mov	bl,Int_Save_Tbl[bx]	;	get interrrupt # being jammed
	mov	al,bl
	shl	bl,1			;	adjust for Word table index
	mov	si,cs:Z150_Intr_Tbl[bx]	;	get segment offset to si

;	DS:SI := Segment,Offset of Rom Int handler, al = Int #

	call	Set_Intr_Ptr		;	
	pop	bx
	inc	bx			;	next int to be restored index
	loop	Jam_Next		; until (all vectors reset)
	popreg	<si, ds, cx, bx, ax>
	ret
Jam_Vectors	EndP

page
;----------------------------------------------------------------------
; Section Contents:
;------------------
;	This file contains routines for saving and restoring areas of the
; video memory. There are four Public Entry Points:
;
;
;	1) Screen_Init: (Done as part of Exec_Init)
;		-No entry parameters
;		-Initializes the screen status array
;
;	2) Screen_Save:
;		-Enter with AL equal to the screen to be accessed.
;		-Saves a screen in a predetermined area according to the 
;		 the screen number passed in the AL on entry and Sets the
;		 screen status to 'active'. The video parameters are also
;		 saved.
;
;	3) Screen_Restore:
;		-Enter with AL equal to the screen to be accessed.
;		-If the screen number is in range and the screen status is
;		 active then the screen is saved in a predetermined area
;		 (according to the screen number). The screen status is reset
;		 to inactive if the restore is successful.
;
;	4) Restore Video Parameters
;		-Enter with AL equal to the screen to be accessed.
;
page
;----------------------------------------------------------------------
Screen_Save Proc Near; (16_Apr_85)
;---------------------------------
;	1) Enter Register Values
;		BX -> Pointer to Base of State_Descriptor
;	2) Register Exit Values
;		General Purpose Registers Destroyed (AX, CX and DX)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	bx
	push	bp
	push	si
	push	di
	push	ds
	push	es

	push	cs
	pop	ds			;DS:= Base of the Monitor Segment
	call	Save_V_Param		;Save Video Parameters
	call	Get_Page_Offset		;Get Page Offsets (sets DL,DH,BP)
	call	Get_Position		;Get Screen Position (sets AX,CX,DI,SI)
	mov	bx,[bx.S_Video]
	push	bx			;(save pointer to base of Video Struc)

	mov	bl,[bx.S_Crnt_Mode]
	shl	bl,1
	mov	bh,0			;BX:= Offset to Proper Mode Save Rtn
	cld				;CLear the Direction Flag (L to R)
SsLp1:	push	ax			;Repeat
	push	bx
	push	cx
	push	dx
	call	Save_Vectors[bx]	;	Save 1 Row
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	inc	ah			;	Starting_Row:= Starting_Row+1
	dec	ch			;	Number_Rows:= Number_Rows - 1
	jnz	SsLp1			;Until (Number of Rows eq 0)

	pop	bx
	mov	[bx.S_Status],True	;Update the Screen's Status
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	bx
	ret

Screen_Save	EndP

page
;----------------------------------------------------------------------
Save_V_Param Proc Near; (9_Jul_85)
;---------------------------------
;	1) Entry Register Values
;		BX -> Pointer to Base of the Video Parameter Block
;	2) Exit Register Values
;		BP -> Page Offset in Bytes
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ax
	push	dx

	push	bx
	mov	bx,[bx.S_Video]		;BX:= Pointer to Video Param Struc.

	;Read and Save Current Video Mode
	push	bx
	call	Get_Video_Status	;Read Current Video Mode
	mov	dh,bh			;(move page from bh to dh)
	pop	bx

	mov	[bx.S_Crnt_Mode],al	;Current Screen Mode
	mov	[bx.S_Char_Cols],ah	;Number of character columns
	mov	[bx.S_Crnt_Page],dh	;Current Display Page

	;Read and Save the Current Cursor Location
	push	bx
	mov	bh,[bx.S_Crnt_Page]	;BH:= Current Page
	call	Get_Cursor_Position	;Read Current Cursor Location
	pop	bx

	mov	[bx.S_Cursor_Loc],dx	;Save the Current Cursor Location
	mov	[bx.S_Cursor_Mode],cx	;Save the Current Cursor Mode

	pop	bx
	pop	dx
	pop	ax
	ret				;Return

Save_V_Param	EndP

page
;----------------------------------------------------------------------
Mode_0_Save Proc Near; (25_Apr_85)
;---------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula:
;		Row_Offset:= (Starting_Char_Row * 2) * Bytes_per_Row
;		Starting_Address:= Row_Offset + (Starting_Char_Column * 2)
;		Row_Count:= Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Character Column
;		AH -> Starting Character Row
;		CL -> Number of Character Columns to Transfer
;		CH -> Number of Character Rows to Transfer
;		DL -> Number of Character Columns per Row
;		DI -> Save Buffer Address
;		BP -> Page Offset in Bytes
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	mov	bx,Scr_Save_Base
	mov	es,bx			;ES:= Base of Screen Save Area
	mov	bx,Lo_Screen_Base
	mov	ds,bx			;DS:= Base of Screen Ram

	shl	al,1			;Starting_Column:= Starting_Column * 2
	mov	bl,al
	mov	bh,0			;Adjusted Starting Column

	shl	dl,1			;(turn Char_Columns into Byte_Columns)
	mov	al,dl			;AL:= Bytes per Row
	mul	ah			;Row_Offset:= Starting_Row * Bytes/Row
	add	ax,bx			;AX:= Row_Offset + Start Col (in bytes)
	add	ax,bp			;(add in the page offset)
	mov	si,ax			;SI:= Screen Address (DI already set)

	shl	cl,1
	mov	ch,0			;CX:= Number of Columns to Save

	rep	movsb			;Move the String
	pop	ds
	ret				;Return

Mode_0_Save	EndP

page
;----------------------------------------------------------------------
Mode_4_Save Proc Near; (25_Apr_85)
;---------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula twice, once with the base address
;	   set to the start of the video buffer and then a second time
;	   with the base address at the start of the video buffer + 2000h:
;		Row_Offset:= 4 * (Starting_Row * Bytes_per_Column)
;		Starting_Address:= Row_Offset + (Starting_Column * 2)
;		Row_Count:= 4 * Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Column
;		AH -> Starting Row
;		CL -> Number of Columns
;		CH -> Number of Rows
;		DI -> Save Buffer Address
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	mov	bx,Scr_Save_Base
	mov	es,bx			;ES:= Destination Segment
	mov	bx,Lo_Screen_Base
	mov	ds,bx			;DS:= Source Segment
	shl	cl,1
	mov	ch,0			;CX:= Number of Columns to Save
	shl	al,1			;AL:= Starting_Column * 2
	shl	ah,1			;AH:= Starting_Row * 4
	shl	ah,1

	mov	bl,al
	mov	bh,0			;BX:= Starting Column

	mov	dh,2			;DH:= Bottom-Half - Top-Half Counter
Sm4Lp1:	mov	dl,4			;Repeat DL:= # of odd/even scan lines
	push	ax			;	(Save starting row/column)

Sm4Lp2:	push	ax			;	Repeat	(save Starting Col)
	push	cx			;		(save Number of Cols)

	mov	al,80			;		AL:= Bytes/Row
	mul	ah			;		AH:= Bytes/Row * Rows
	add	ax,bx			;		Add in column offset
	mov	si,ax			;		SI:= Screen Address
	rep	movsb			;		Move the String

	pop	cx
	pop	ax

	inc	ah			;		Row:= Row + 1
	dec	dl			;		Row_Cntr:= Row_Cntr - 1
	jnz	Sm4Lp2			;	Until (Row_Cntr eq 0)

	mov	ax,Hi_Screen_Base
	mov	ds,ax			;	Offset Segment to High Screen
	pop	ax			;	Restore Starting Index Offset

	dec	dh			;	Decrement Outer Loop Counter
	jnz	Sm4Lp1			;Until (Both Top & Bottom lines moved)

	pop	ds
	ret				;Return

Mode_4_Save	EndP

page
;----------------------------------------------------------------------
Mode_6_Save Proc Near; (25_Apr_85)
;---------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula twice, once with the base address
;	   set to the start of the video buffer and then a second time
;	   with the base address at the start of the video buffer + 2000h:
;		Row_Offset:= 4 * (Starting_Row * Bytes_per_Column)
;		Starting_Address:= Row_Offset + (Starting_Column)
;		Row_Count:= 4 * Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Column
;		AH -> Starting Row
;		CL -> Number of Columns
;		CH -> Number of Rows
;		DI -> Save Buffer Address
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	mov	bx,Scr_Save_Base
	mov	es,bx			;ES:= Destination Segment
	mov	bx,Lo_Screen_Base
	mov	ds,bx			;DS:= Source Segment

	mov	ch,0			;CX:= Number of Columns to Save
	shl	ah,1			;AH:= Starting_Row * 4
	shl	ah,1

	mov	bl,al
	mov	bh,0			;BX:= Starting Column

	mov	dh,2			;DH:= Bottom-Half - Top-Half Counter
Sm6Lp1:	mov	dl,4			;Repeat DL:= # of odd/even scan lines
	push	ax			;	(Save starting row/column)

Sm6Lp2:	push	ax			;	Repeat	(save Starting Col)
	push	cx			;		(save Number of Cols)

	mov	al,80			;		AL:= Bytes/Row
	mul	ah			;		AH:= Bytes/Row * Rows
	add	ax,bx			;		Add in column offset
	mov	si,ax			;		SI:= Screen Address
	rep	movsb			;		Move the String

	pop	cx
	pop	ax

	inc	ah			;		Row:= Row + 1
	dec	dl			;		Row_Cntr:= Row_Cntr - 1
	jnz	Sm6Lp2			;	Until (Row_Cntr eq 0)

	mov	ax,Hi_Screen_Base
	mov	ds,ax			;	Offset Segment to High Screen
	pop	ax			;	Restore Starting Index Offset

	dec	dh			;	Decrement Outer Loop Counter
	jnz	Sm6Lp1			;Until (Both Top & Bottom lines moved)

	pop	ds
	ret				;Return

Mode_6_Save	EndP

page
;----------------------------------------------------------------------
Screen_Restore Proc Near; (16_Apr_85)
;------------------------------------
;	1) This routine can restore a screen and its video paramters.
;	2) If the screen has never been saved then nothing is done.
;	3) Enter Register Values
;		BX -> Pointer to Base of State_Descriptor Structure
;	4) Register Exit Values
;		General Purpose Registers Destroyed (AX, CX and DX)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	bx
	push	bp
	push	si
	push	di
	push	ds
	push	es

	push	cs
	pop	ds			;DS:= Base of the Monitor Segment
	call	Get_Page_Offset		;Get Page Offsets (sets DL,DH,BP)
	call	Get_Position		;Get Screen Position (sets AX,CX,DI,SI)

	mov	bx,[bx.S_Video]
	mov	bl,[bx.S_Crnt_Mode]
	shl	bl,1
	mov	bh,0			;BX:= Offset to Proper Mode Save Rtn
	cld				;CLear the Direction Flag (L to R)
SrLp1:	push	ax			;Repeat
	push	bx
	push	cx
	push	dx
	call	Restore_Vectors[bx]	;	Restore 1 Row
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	inc	ah			;	Starting_Row:= Starting_Row+1
	dec	ch			;	Number_Rows:= Number_Rows - 1
	jnz	SrLp1			;Until (Number of Rows eq 0)

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	bx
	ret				;Return

Screen_Restore	EndP

page
;----------------------------------------------------------------------
Mode_0_Restore Proc Near; (25_Apr_85)
;------------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula:
;		Row_Offset:= Starting_Row * Bytes_per_Row
;		Starting_Address:= Row_Offset + (Starting_Char_Column * 2)
;		Row_Count:= Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Character Column
;		AH -> Starting Character Row
;		CL -> Number of Character Columns to Transfer
;		CH -> Number of Character Rows to Transfer
;		DL -> Character Columns across a page
;		DH -> Current Page Number
;		SI -> Save Buffer Address
;		BP -> Page Offset (in Bytes)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	push	cs
	pop	ds			;DS:= Monitor_Segment Base
	mov	bx,Scr_Save_Base
	mov	ds,bx			;DS:= Start of the Screen Save Area
	mov	bx,Lo_Screen_Base
	mov	es,bx			;ES:= Start of Screen Buffer

	shl	al,1			;Starting_Column:= Starting_Column * 2
	mov	bl,al
	mov	bh,0			;Adjusted Starting Column (byte offset)

	shl	dl,1			;(turn Char_Columns into Byte_Columns)
	mov	al,dl			;AL:= Number of Bytes per Row
	mul	ah			;Row_Offset:= Starting_Row * Bytes/Row
	add	ax,bx			;AX:= Row_Offset + Adjusted Start Col
	add	ax,bp			;(add in the page offset)
	mov	di,ax			;DI:= Screen Address

	shl	cl,1
	mov	ch,0			;CX:= Number of Bytes to Save

	rep	movsb			;Move the String
	pop	ds
	ret				;Return

Mode_0_Restore	EndP

page
;----------------------------------------------------------------------
Mode_4_Restore Proc Near; (25_Apr_85)
;------------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula twice, once with the base address
;	   set to the start of the video buffer and then a second time
;	   with the base address at the start of the video buffer + 2000h:
;		Row_Offset:= 4 * (Starting_Row * Bytes_per_Column)
;		Starting_Address:= Row_Offset + (Starting_Column * 2)
;		Row_Count:= 4 * Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Column
;		AH -> Starting Row
;		CL -> Number of Columns
;		CH -> Number of Rows
;		SI -> Save Buffer Address
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	push	cs
	pop	ds			;DS:= Monitor_Segment Base
	mov	bx,Scr_Save_Base
	mov	ds,bx			;DS:= Source Segment
	mov	bx,Lo_Screen_Base
	mov	es,bx			;ES:= Destination Segment
	shl	cl,1
	mov	ch,0			;CX:= Number of Columns to Save
	shl	al,1			;AL:= Starting_Column * 2
	shl	ah,1			;AH:= Starting_Row * 4
	shl	ah,1

	mov	bl,al
	mov	bh,0			;BX:= Starting Column

	mov	dh,2			;DH:= Bottom-Half - Top-Half Counter
Rm4Lp1:	mov	dl,4			;Repeat DL:= # of odd/even scan lines
	push	ax			;	(Save starting row/column)

Rm4Lp2:	push	ax			;	Repeat	(save Starting Col)
	push	cx			;		(save Number of Cols)

	mov	al,80			;		AL:= Bytes/Row
	mul	ah			;		AH:= Bytes/Row * Rows
	add	ax,bx			;		Add in column offset
	mov	di,ax			;		DI:= Screen Address
	rep	movsb			;		Move the String

	pop	cx
	pop	ax

	inc	ah			;		Row:= Row + 1
	dec	dl			;		Row_Cntr:= Row_Cntr - 1
	jnz	Rm4Lp2			;	Until (Row_Cntr eq 0)

	mov	ax,Hi_Screen_Base
	mov	es,ax			;	Offset Segment to High Screen
	pop	ax			;	Restore Starting Index Offset

	dec	dh			;	Decrement Outer Loop Counter
	jnz	Rm4Lp1			;Until (Both Top & Bottom lines moved)

	pop	ds
	ret				;Return

Mode_4_Restore	EndP

page
;----------------------------------------------------------------------
Mode_6_Restore Proc Near; (25_Apr_85)
;------------------------------------
;	1) This routine calculates the starting address on the screen by
;	   using the following formula twice, once with the base address
;	   set to the start of the video buffer and then a second time
;	   with the base address at the start of the video buffer + 2000h:
;		Row_Offset:= 4 * (Starting_Row * Bytes_per_Column)
;		Starting_Address:= Row_Offset + (Starting_Column)
;		Row_Count:= 4 * Row_Count
;	2) Notice that the starting row/column and number of row/columns
;	   are given in characters as opposed to bytes.
;	3) Entry Register Values:
;		AL -> Starting Column
;		AH -> Starting Row
;		CL -> Number of Columns
;		CH -> Number of Rows
;		SI -> Save Buffer Address
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds
	push	cs
	pop	ds			;DS:= Monitor_Segment Base
	mov	bx,Scr_Save_Base
	mov	ds,bx			;DS:= Source Segment
	mov	bx,Lo_Screen_Base
	mov	es,bx			;ES:= Destination Segment

	mov	ch,0			;CX:= Number of Columns to Save
	shl	ah,1			;AH:= Starting_Row * 4
	shl	ah,1

	mov	bl,al
	mov	bh,0			;BX:= Starting Column

	mov	dh,2			;DH:= Bottom-Half - Top-Half Counter
Rm6Lp1:	mov	dl,4			;Repeat DL:= # of odd/even scan lines
	push	ax			;	(Save starting row/column)

Rm6Lp2:	push	ax			;	Repeat	(save Starting Col)
	push	cx			;		(save Number of Cols)

	mov	al,80			;		AL:= Bytes/Row
	mul	ah			;		AH:= Bytes/Row * Rows
	add	ax,bx			;		Add in column offset
	mov	di,ax			;		DI:= Screen Address
	rep	movsb			;		Move the String

	pop	cx
	pop	ax

	inc	ah			;		Row:= Row + 1
	dec	dl			;		Row_Cntr:= Row_Cntr - 1
	jnz	Rm6Lp2			;	Until (Row_Cntr eq 0)

	mov	ax,Hi_Screen_Base
	mov	es,ax			;	Offset Segment to High Screen
	pop	ax			;	Restore Starting Index Offset

	dec	dh			;	Decrement Outer Loop Counter
	jnz	Rm6Lp1			;Until (Both Top & Bottom lines moved)

	pop	ds
	ret				;Return

Mode_6_Restore	EndP

page
;----------------------------------------------------------------------
Restore_Video Proc Near; (9_Jul_85)
;----------------------------------
;	1) Entry Register Values
;		BX -> Pointer to Base of State_Descriptor
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	bx
	push	ds

	push	cs
	pop	ds			;DS:= Monitor Segment Base
	mov	bx,[bx.S_Video]		;BX:= Base of Video Param Structure

	mov	al,[bx.S_Crnt_Page]	;AL:= Current Page
	call	Set_Display_Page	;Restore the Current Page

	mov	al,[bx.S_Crnt_Mode]	;AL:= Current Video Mode
	call	Set_Video_Mode		;Restore the Video Mode

	mov	cx,[bx.S_Cursor_Mode]	;CX:= Cursor Mode
	call	Set_Cursor_Style	;Restore the Cursor Mode (style)

	mov	dx,[bx.S_Cursor_Loc]	;DX:= Current Cursor Location
	mov	al,[bx.S_Crnt_Page]
	mov	bh,al			;BH:= Page
	call	Set_Cursor_Position	;Restore the cursor position

	pop	ds
	pop	bx
	ret				;Return

Restore_Video	EndP

page
;----------------------------------------------------------------------
Get_Page_Offset Proc Near; (16_Apr_85)
;-------------------------------------
;	1) This routine returns the BP pointer equal to an offset (in bytes)
;	   from the base of video ram to the start of the current page.
;	2) Entry Register Values:
;		BX -> Pointer to Base of State_Descriptor
;	3) Exit Register Values
;		DL -> Number of Character Columns (ie characters per row)
;		DH -> Current Page
;		BP -> Page Offset in Bytes
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ax
	push	bx
	mov	bx,[bx.S_Video]		;BX:= Pointer to Video Param Struc.

	mov	dl,[bx.S_Char_Cols]	;DL:= Number of Characters in a Row
	mov	dh,[bx.S_Crnt_Page]	;DH:= Current Page
	push	dx			;(Save Char/Col and Current_Page)

	mov	ax,0			;AX:= Default Page Zero
	test	dh,0FFh			;If (Current Page ne 0)
	jz	GpSk2

	mov	ax,800h			;	AX:= Size of a 40x25 page
	cmp	dl,80			;	If (we're in 80x25 mode)
	jne	GpSk1

	shl	ax,1			;		AX:= Size of 80x25 page
GpSk1:	mov	dl,dh
	mov	dh,0			;	DX:= Number of Pages
	mul	dx			;	(AX:= Number Pages * Page Size)

GpSk2:	mov	bp,ax			;BP:= Offset to Current Page
	pop	dx

	pop	bx
	pop	ax
	ret				;Return

Get_Page_Offset	EndP

page
;----------------------------------------------------------------------
Get_Position Proc Near; (25_Apr_85)
;----------------------------------
;	1) This routine returns the selected screen's starting row/column
;	   the number of rows/columns to transfer and save buffer offset
;	   address. Notice that all values are given as alpha/numeric.
;	2) Entry Register Values:
;		BX -> Start of Screen Parameter Struct.
;		DL -> Maximum Number of Character Columns
;		DH -> Current Page
;	3) Exit Register Values:
;		AL -> Starting Column
;		AH -> Starting Row
;		CL -> Number of Columns to Transfer
;		CH -> Number of Rows to Transfer
;		DX -> Entry Value (DL-Characters in a Row, DH-Current Page)
;		DI -> Save Buffer Address
;		SI -> Save Buffer Address
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	bx
	mov	bx,[bx.S_Screen]	;BX:= Pointer to Screen Param Struc.

	mov	al,[bx.Starting_Col]	;AL:= Starting Col
	mov	ah,[bx.Starting_Row]	;AH:= Starting Row
	mov	cl,[bx.Numb_of_Cols]	;CL:= Number of Columns to Transfer
	cmp	cl,dl			;If (Number_Col_to_Save gt Max_Columns)
	jle	GpoSk1

	mov	cl,dl			;	CL:= Forced to Max Columns
GpoSk1:	mov	ch,[bx.Numb_of_Rows]	;CH:= Number of Rows to Transfer
	mov	di,[bx.Ram_Buf_Addr]	;DI:= Save Buffer Offset
	mov	si,di			;SI:= Save Buffer Offset

	pop	bx
	ret				;Return

Get_Position	EndP

Monitor_Segment	EndS
		End
