;Page	60,132
;Title	Clock / World Map Routines for Pivot II
;
;	Copyright 1984, 1985
;	Morrow Design, Inc.
;	San Leandro, Ca.
;	Last Update 31_Oct_85
;
;	Version 1.00  19 Feb 85			
;	Author:	David Block and Rich Peters     
;
;----------------------------------------------------------------------
; Subroutine Index (10_Mar_85)
;-----------------------------
;
;	Clock_Icon
;	poll_loop
;	SetUp_Clk_Screen
;	Draw_Cal
;	Get_Date
;	Dy_Offset
;	Drw_Time_DX
;	Drw_Time
;	Get_Time
;
;	Do_Calen_Function
;	Do_Schedule
;	Day_Left
;	Day_Right
;	Month_Left
;	Month_Right
;	Here_Now
;	Here_NowM
;	Zone_Right
;	Zone_Left			
;	Do_Setup
;	No_Op
;	Erase_Zone_Line
;	Draw_Zone_Line
;
;	Put_Date_Rev
;	Put_Date_Norm
;	Clk_DFlag
;	Set_DFlag

page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Icon.lit
;
;	.xlist
;	Include ..\Rom\Rom.lit		;Basic System Definitions
;	Include ..\Rom\Intr.lit		;Interrupt Routine Definitions
;	Include	..\Icon\Icon.lit	;Include the Common Equates
;	.list
;
;======================================================================
;Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

;	extrn	Put_String_Imm:Near	;In IconIO
;	extrn	Put_String_N:Near	;In IconIO
;	extrn	Put_String:Near		;In IconIO
;	extrn	Put_Chr:Near		;In IconIO
;	extrn	Put_Ascii_Word:Near	;In IconIO
;	extrn	Put_Ascii:Near		;In IconIO
	extrn	Draw_Horizontal:Near	;In Draw
	extrn	Draw_Vertical:Near	;In Draw
	extrn	Draw_Map:Near		;In Draw

	If	Enable_Setup		;if setup enabled then make it external
	extrn	Sys_Setup:Near
	EndIf

	If	Enable_Appt		;if appts enabled, they are external
	extrn	Appt:Near
	EndIf

;	extrn	Cal_String:Byte		;Text for Calander Box
;	extrn	Zone_Pos:Word		;Table of columns for zone lines
	extrn	Mondays:Byte
	extrn	Upd_Mode:Byte  		;function being updated
	extrn	MOffset:Byte		;month offset  0 = sunday
	extrn	NmDays:Byte		;number of days in month
	extrn	Upd_Cmp:Byte		;compare value for reverse vid
	extrn	DFlags:Byte
	extrn	Xor_Flag:Byte
	extrn	System_Setup:Word
	extrn	Disp_Day:Byte
	extrn	Disp_Month:Byte
	extrn	Disp_Year:Word
	extrn	Disp_Zone:Byte
	extrn	Clock_Second:Byte
	extrn	Clock_Minute:Byte
	extrn	Clock_Day:Byte
	extrn	Clock_Hour:Byte
	extrn	Clock_Month:Byte
	extrn	Clock_Year:Word
	extrn	Big_Time_OK:Byte

page
;----------------------------------------------------------------------
FxTbl Label Word
;---------------
;
	If	Enable_Appt
	dw	offset DO_SCHEDULE
	Else
	dw	offset NO_OP
	EndIf

	dw	offset DAY_LEFT
	dw	offset DAY_RIGHT
	dw	offset MONTH_LEFT
	dw	offset MONTH_RIGHT
	dw	offset HERE_NOW
	dw	offset ZONE_LEFT
	dw	offset ZONE_RIGHT
	dw	offset NO_OP

	If	Enable_Setup
	dw	offset DO_SETUP
	Else
	dw	offset NO_OP
	EndIf


page
;----------------------------------------------------------------------
Clock_Icon Proc Near; (21_Apr_85)
;--------------------------------
;	1) This is the main line of the the Clock Icon. It is continually
;	   executed until an ICON key is hit, or until APPT or SETUP is
;	   used. When APPT or SETUP is called.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Clock_Icon

	mov	ax,Monitor_Segment
	mov	ds,ax			;DS:= Monitor_Segment
	call	Setup_Clk_Scr		;draw clock screen

Poll_Loop:				;Loop
	mov	Big_Time_Ok,True	; enable big time display
	call	Do_Calen_Function	;	Update Display If key hit
	mov	ah,ToD_Get_Time		;	Get Time (Hours,Mins,Secs)
	int	Time_of_Day_Intr
; Now, Get date from system Ram
	mov	cx,Clock_Year		;CX:= Clock Year
	mov	dh,Clock_Month		;DH:= Clock Month
	mov	dl,Clock_Day		;DL:= Clock Day

	push	cx
	push	dx
	call	Drw_Time		;	Update the Time of Day Display
	pop	dx
	pop	cx

	test	Byte Ptr System_Setup,10h
	jz	Poll_Loop		;	If (in here now mode)

	mov	al,Byte Ptr System_Setup+1
	and	al,1Fh
	mov	Disp_Zone,al		;		set disp zone = setup

	cmp	Disp_Year,cx		;		If ( (year changed) Or
	jnz	do_hn
	cmp	Disp_Month,dh		;		     (Month changed) Or
	jnz	do_hn
	cmp	Disp_Day,dl		;		     (Day changed) )
	jz	Poll_Loop

do_hn:	call	Here_NowM		;			Change Display
	jmp	Poll_Loop

Clock_Icon	EndP

page
;----------------------------------------------------------------------
Setup_Clk_Scr Proc Near; (21_Apr_85)
;-----------------------------------
;	1) This routine paints the initial clock screen. This includes
;	   the world map, the calander and the function key prompts.
;	2) This routine also sets up the video parameters. Page 0 is
;	   selected. Then Hi-Res graphics is selected. Finally the cursor
;	   is turned off.
;	3) The System Setup byte is set to the following default:
;		bit 4: here/now mode true
;		bit 5: no zones on screen
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

;**	mov	ah,5			;AH:= Select Display Page
;**	mov	al,0			;AL:= Select Page 0
;**	int	Video_IO_Intr		;Select Display Page 0

	mov	ax,06h			;AH:= Set Video Mode Function
					;AL:= select 640-200 graphics mode
	int	Video_IO_Intr		;Set Hi_Res Graphics

    	mov	ah,1			;AH:= Set Cursor Style Function
	mov	ch,0			;CH:= Start Scan Line to 0
	mov	cl,0			;CL:= End Scan Line to 0
    	int	Video_IO_Intr		;Turn off the Cursor

	mov 	DFlags,0
	mov	Disp_Zone,16		;Initialize Displayed Zone (needed??)**

	call	Draw_Map		;Draw the map
;**	mov	ah,ToD_Get_Date		;Get Date (Year,Month,Day)
;**	int	Time_of_Day_Intr
	mov	ah,ToD_Get_Time		;Get Time (Hours,Mins,Secs)
	int	Time_of_Day_Intr
	call	Get_Date		;Update Disp-Year-Month-Day
	call	Draw_Cal		;Draw the Calendar

	or	Byte Ptr System_Setup,30h
	ret				;Return

Setup_Clk_Scr	EndP

page
;----------------------------------------------------------------------
Draw_Cal Proc Near; (31_Oct_85)
;------------------------------
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	call	DY_Offset		;Calc # days in month & 1st day of month
	mov	DFlags,Zer_Sup		;Supress Zeros, Small Chars
	mov	al,0			;drawing lines without XOR'ing pixels
	mov	Xor_Flag,al

	;Clear a Box
	mov	ah,6			;AH:= Scroll Screen Up Function
	mov	al,0			;AL:= Clear Entire Window
;**	mov	bh,7h			;BH:= Window Attribute (Normal)
	mov	cx,0			;CX:= Starting Location
	mov	dx,0E1Dh		;DX:= Ending Location (28x15 clear)
	int	Video_IO_Intr		;Clear the Calendar Box

	;Top Upper Horizontal Line of Box
	mov	ax,27			;Row:= 27
	mov	bx,4			;Column:= 4
	mov	cx,216			;Length:= 216
	call	Draw_Horizontal		;Horizontal Line at the top of the box

	;Top Lower Horizontal Line of Box
	mov	ax,29			;Row:= 29
	mov	bx,4			;Column:= 4
	mov	cx,216			;Length:= 216
	call	Draw_Horizontal		;Horizontal Line at the top of the box

	;Bottom Upper Horizontal Line of Box
	mov	ax,115			;Row:= 115
	mov	bx,4			;Column:= 4
	mov	cx,216			;Length:= 216
	call	Draw_Horizontal

	;Bottom Lower Horizontal Line of Box
	mov	ax,117			;Row:= 117
	mov	bx,4			;Column:= 4
	mov	cx,216			;Length:= 216
	call	Draw_Horizontal

	;Left Vertical Line of Box
	mov	ax,27			;Row:= 27
	mov	bx,3			;Column:= 3
	mov	cx,90			;Length:= 90
	call	Draw_Vertical

	;Right Vertical Line of Box
	mov	ax,27			;Row:= 27
	mov	bx,220			;Column:= 220
	mov	cx,90			;Length:= 90
	call	Draw_Vertical

	; now, fill in the box with days, month, etc, and label function keys.
	mov	dx,0603h		;put up days of week
	mov	si,Offset Cal_String
	call	Put_String		;following data labels days and F-keys

	;Display Month
	mov	al,Disp_Month		;load month
	mov	dx,0405h		;row 4, column 5
	call	Put_String_N		;put nth string in table up

	;Display Year
	and	DFlags,Not Zer_Sup 	;turn on zero suppress
	mov	ax,Disp_Year		;Display Year
	mov	dx,0414h		;row 4, column 20
	call	Put_Ascii_Word		;put ax out in ascii 

	;Display Days
	mov	cl,NmDays		; get number of days in month
	mov	ch,0
	mov	al,1			; start with first day of month

dyl1:	push	ax
	push	cx
	call	Put_Date_Norm		; put a number in calendar
	pop	cx
	pop	ax

	inc	ax			; loop until all days are up
	loop	dyl1

	mov	al,Disp_Day		; get date we are starting at
	call	Put_Date_Rev		; put it up in reverse
	ret

Draw_Cal	EndP

page
;----------------------------------------------------------------------
Get_Date Proc Near; (21_Apr_85)
;------------------------------
;	1) returns cx:Year dh:Month, dl:Day
;	2) Updates Displayed: Year, Month and Day
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Get_Date

	mov	ah,ToD_Get_Date		;Get Date (CX=Year,DH=Month,DL=Day)
	int	Time_of_Day_Intr	;time interrupt number

	mov	Disp_Year,cx		;Save the Year
	mov	Disp_Month,dh		;Save the Month
	mov	Disp_Day,dl		;Save the Day
	ret				;Return

Get_Date	EndP

;----------------------------------------------------------------------
Dy_Offset Proc Near
;------------------
;	1) Determines the day of the week for a given date
;	2) sets nmdays to the number of days in the month to be displayed.
;	
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	mov	ax,Disp_Year		; calculate day of week for jan1, then
					; adjust for the correct month
	mov	cx,ax			; cx = ax = year 
	add	ax,3		
	shr	ax,1
	shr	ax,1			; (YEAR+3)/4
	add	ax,5			; offset 5 more
	add	ax,cx			; ((YEAR+3)/4)+5+year

	mov	bx,Offset Mondays	; number of days
	test	cl,3			; see if month is divisible by 4
	jz	dyof3			; if so, then could be a leap year
	add	bx,12			; otherwise, it's not so point to 
					; non leap year table
dyof3:	mov	cl,Disp_Month		; get month
	jmp	short dyof5		; for each month past January...

dyof4:	add	al,byte ptr cs:[bx]	;  add number of days in month
	adc	ah,0			; add carry in from table
	inc	bx			;  point to next month index
dyof5:	dec	cl			; see if it should be added in
	jg	dyof4			; if more months to add, then loop

	mov	cx,7			; find out how many weeks past Jan 1..
	sub	dx,dx			; ...date to be displayed is
	div	cx			;(divide by 7)
	mov	MOffset,dl		; dl = remainder or offset from monday
	mov	al,byte ptr cs:[bx]	; get number of days to be displayed
	mov	NmDays,al		; and save it in nmdays
	ret

DY_Offset	EndP

page
;----------------------------------------------------------------------
Drw_Time_DX Proc Near; (8_Mar_85)
;--------------------------------
;	1) draws the time in large characters under the calendar
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Drw_Time_DX

	mov	ah,1
	jmp	Drwt1

Drw_Time_DX	EndP

;----------------------------------------------------------------------
Drw_Time Proc Near; (21_Apr_85)
;------------------------------
;	1) draws the time in large characters under the calendar
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Drw_Time

	cmp	Big_Time_Ok,False	; if big time is disabled
	jnz	Drwt0
	jmp	DrwT6			; then just return
					; else...
Drwt0:	mov	ah,0
	mov	al,Big_Chr + Zer_Sup
	mov	dx,1003h		;screen location row/column
	test	Byte Ptr System_Setup, 40h	; if (24 hour format)
	jz	DrwT1
	inc	dl				; then move right two spaces
	inc	dl

Drwt1:	mov	DFlags,al		;--> Entry for Drw_Time & Drw_Time_DX
	call	Clk_DFlag
	call	Get_Time

	push	ax
	test	Byte Ptr System_Setup, 40h	; test if 24 or 12 hour format
	jnz	DrwT3				; if 12 hour format
						;   then adjust time
	add	al,24
DrwT2:	sub	al,12
	cmp	al,13			; TOO BIG ??
	jnc	Drwt2			; IF 1..12, C=1

DrwT3:	call	Put_Ascii
	and	DFlags,Not (Zer_Sup+Rev_Chr)	; No More Zero Suppress
	mov	al,':'

	push	ax
	call	Put_Chr
	pop	ax

	call	Clk_DFlag
	mov	al,Clock_Minute		;minute digit
	call	Put_Ascii

	and	DFlags,Not Rev_Chr
	mov	al,':'

	push	ax
	call	Put_Chr			; seconds digit
	pop	ax

	call	Clk_DFlag
	mov	al,Clock_Second
	call	Put_Ascii

	and	DFlags,Not Rev_Chr
	inc	dx
	pop	ax			;get hour back

	test	Byte Ptr System_Setup, 40h
	jnz	DrwT5			;If (we're in 12hour format)

	cmp	al,12			;	If (Hour ge 0) and (Hour le 11)
	mov	al,'a'			;		AL:= a (for am)
	jc	Drwt4

	mov	al,'p'			;	Else	AL:= p (for pm)
DrwT4:	call	Put_Chr			;	Print 'a' or 'p'
	mov	al,'m'
	call	Put_Chr			;	Print 'm'
	jmp	Short DrwT6

DrwT5:	mov	al,' '			;Else	(we're in 24 hour format)
	call	Put_Chr			;	Print 2 spaces to clear am/pm
	mov	al,' '
	call	Put_Chr

DrwT6:	ret				;Return

Drw_Time	EndP

page
;----------------------------------------------------------------------
Get_Time Proc Near
;-----------------
;	1) Returns with al containing the current time, corrected for 
;	   time zone offset in range of 0-23.
;	2) Used by Zone Left/Right, and DRW_TIME
;	3) Entry Conditions: NONE
;	4) Exit Conditions: AL = time in 0-23 range all other regs preserved.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	push	bx
	mov	al,Clock_Hour		;get hour in al
	add	al,48			;temporary offset for doing math
	add	al,Disp_Zone		;add current time zone
	mov	bh,Byte Ptr System_Setup+1
	and	bh,1Fh
	sub	al,bh 			;subtract time zone in setup

gt1:	sub	al,24			;convert to 0-23 range by subtracting..
	jnc	gt1			;24 until it goes negative

	add	al,24			;then add 24 for 0-23 range
	pop	bx
	ret				;return with hour of time zone in al

Get_Time	EndP

page	
;----------------------------------------------------------------------
; Process a KeyStroke (10_Mar_85)
;--------------------------------
;	1) When a key has been hit, this routine will get the key, make
;	   sure it's a legal function, and either chain to SETUP or APPT
;	   if either has been selected, or adjust the time zone or date
;	   depending on the function key pressed.
;	2) Entry Conditions: NONE 
;	3) Exit Conditions:  NONE
;	   --> NOTE: SETUP and APPT will not return. They will fixup the
;	       stack, and jump to cal_ret to redraw the entire clock screen.
;
Do_Calen_Function:
	mov	ah,1			;keystroke status
	int	Keyboard_IO_Intr
	jz	dc_exit			;if key was pressed

	mov	ah,0			;get keystroke
	int	Keyboard_IO_Intr

dc1cc:	xchg	al,ah			; move scan code to al
	sub	al,FxBase		; make f1-10 indexes based on 0
	jc	Dc_Exit			; if key code is out of range 

	cmp	ax,10			; then return
	jnc	Dc_Exit

	shl	ax,1			; make key a word offset
	mov	si,ax			; use si as index pointer
	mov	al,Disp_Day		;make current date available
	mov	ah,Disp_Zone		;get zone in ah
	call	FxTbl[SI]		; DO FUNCTION

	cmp	al,Disp_Day		; if date didn't change
	jz	dc_Exit			;   then nothing to do!!

	cmp	al,NmDays		; if al> number of days in displayed month
	jg	Next_Month		;   then go to next month

	test	al,al			; if al < 1
	jle	Prev_Month		;   then go back one month

	;Now updating in the current month, set previous date to normal video
	xchg	al,Disp_Day		;make current date normal video
	call	Put_Date_Norm		;put date up in normal video
	mov	al,Disp_Day		;get date that was selected
	call	Put_Date_Rev		;and put it up in reverse video
dc_exit:ret

Prev_month:
	push	ax			; save day selected by function key
	dec	Disp_Month		;decrement month
	jg	pm1			;if previous year

	mov	Disp_Month,12		;   then set for last month (December)
	dec	Disp_Year		;        decrement the year
pm1:	call	dy_offset		; make a current index
	pop	ax			; get back selected days
	neg	al			; if al=-1, then make day 1 of previous month
	jnz	pm2			; otherwise, just make last day

	mov	al,NmDays		;get day in month
pm2:	mov	Disp_Day,al		;  move it to display date

Update_month:
	jmp	Draw_Cal		;  and draw new calendar

Next_month:				;Input ax : current day +last month
	sub	al,NmDays
	mov	Disp_Day,al		;save new displayed date
	inc	Disp_Month		;set for next month
	cmp	Disp_Month,13		;Passed into the next year?	
	jc	Update_Month		;no

	mov	Disp_Month,1		;yes
	inc	Disp_Year		;next year
	jmp	Draw_Cal		

page
;----------------------------------------------------------------------
; Process Cursor keys to Operate the calendar here
;-------------------------------------------------
;
; Do the Schedule Function
;-------------------------
;
	If	Enable_appt
Do_Schedule:
	add	sp,4			;KILL 2 RETs since we have to redraw map
	mov	Big_Time_Ok,False	; disable big time display while in scheduler
	call	appt
	call	Setup_Clk_Scr		; draw clock screen
	jmp	poll_loop
	EndIf


; Move back one month
;--------------------
;
Day_Left:
	dec	al			;Back a Day
	jmp	dchup			;set NOT here/now and return


; Move ahead one day
;-------------------
;
Day_Right:
	inc	AL			;Forward a day
	jmp	dchup			;set NOT here/now and return


; Move back one month
;--------------------
;
Month_Left:
	mov	al,0ffh			;AL:= FF (to indicate back a month)

dchup:	and	byte ptr System_Setup,Not 10h ;take out of here/now mode
	ret				;and return to main line loop


; Move ahead one month
;---------------------
;
Month_Right:
	mov	al,NmDays		;AL:= days in the displayed month
	inc	al			;add one to wrap over to next month
	jmp	dchup			;set NOT here/now and return


; Do the Here-Now Function
;-------------------------
;
here_now:
	test	byte ptr system_Setup,20h ;if (any lines displayed) 
	jnz	HN_Sk1
	call	Erase_Zone_Line		  ;	get rid of previous zone line
HN_Sk1:	or	byte ptr system_setup,30h ;put in here/now mode turn off


; Display the time zone
;----------------------
;
Here_NowM:				;time zone display
	call	Get_Date		;get date
	jmp	Draw_Cal		;display current date


; Move one zone to the right
;---------------------------
;
Zone_Right:
	push	ax			;save zone & date
	call	get_time		;get time 0-23
	cmp	al,23			;see if time is after 11pm
	pop	ax			;restore zone & date
	jnz	zr_ok			;if not after 11 pm then ok

	inc	al			;else next zone = next day set next day
zr_ok:	inc	ah			; next zone
	cmp	ah,13			;see if crossed dateline
	jnz	dr_ok			;  if crossed dateline

	dec	al			;    then go back a day
dr_ok:	cmp	ah,24			;see if zone wrapped around
	jc	znup			; if no wrap occured then update zone
	mov	ah,1			; else set zone to one...
					;  and fall through to move back a zone

; Move one zone to the Left
;--------------------------
;
Zone_Left:			
	push	ax			; save zone & date
	call	get_time		; get time 0-23
	cmp	al,0			; see if just after midnight
	pop	ax			; restore zone & date
	jnz	zl_ok			; jmp if not just after midnight

	dec	al			; else, next zone is previous day
zl_ok:	dec	ah			; next zone to left
	cmp	ah,12			; see if crossing dateline
	jnz	dl_ok			; if crossing dateline

	inc	al			;   then set for next day
dl_ok:	cmp	ah,0ffh			; see if wrapping around
	jnz	znup			;  if no wrap, then update zone display

	mov	ah,23			;  else, set for zone 23
znup:	push	ax			;  save zone and date
	test	byte ptr system_Setup,20h ; if (any lines displayed) 
	jnz	No_Erase		;      then

	call	erase_zone_line		; get rid of previous zone line
No_Erase:
	pop	ax			; get back date and zone
	mov	disp_zone,ah		; save displayed zone
	and	byte ptr system_setup,not 20h	; zones out, draw them
	push	ax
	call	draw_zone_line		; put up new zone line
	pop	ax
	jmp	dchup			; set NOT here/now and return


; Do the Setup Function
;----------------------
;
	If	Enable_setup
Do_Setup:
	add	sp,4			;kill returns since screen needs re-drawing
	mov	Big_Time_Ok,False	; disable big time display while in setup
;*********
	mov	al,Byte Ptr System_Setup+1
	and	al,1Fh
	mov	Disp_Zone,al		;		set disp zone = setup
;*********
	call	Sys_Setup		;go to setup mode
	call	Setup_Clk_Scr		; draw clock screen
	jmp	poll_loop
	EndIf


; No Operation
;-------------
;
No_Op:	pop	ax			; DO NO OPERATION
	ret

page
;----------------------------------------------------------------------
; Erase/Draw a Zone Line (26_Mar_85)
;----------------------------------
;
Erase_Zone_Line:
	mov	dx,1328h		;row / column address for cities 19/40
	mov	DFlags,0		;normal video
	mov	al,' '			;put out 27 blanks to clear cities
	mov	cx,27
Ez_1:	call	Put_Chr
	loop	Ez_1
	jmp	short dr_z10

Draw_Zone_Line:
	mov	al,Disp_Zone		;get zone to be displayed
	add	al,48			;add offset of city names in string table
	mov	dx,1328h		;set row/column position
	mov	DFlags,0		;normal video
	call	Put_String_N		;put up city names

dr_z10:	mov	bl,Disp_Zone		;get zone to be displayed
	sub	bl,13			;offset to correct zone line in table
	jnc	dr_z11
	add	bl,24

dr_z11:	mov	bh,0
	shl	bx,1			;Column:= Column * 2
	mov	ax,cs:zone_pos[bx+2]	;get column for zone line
	push	ax
	mov	ax,cs:zone_pos[bx]	;get column for next line also

	mov	bx,ax
	call	D_Zone_L		;draw/erase first zone line
	pop	bx
	call	D_Zone_L		;and draw it
dr_z99:	ret


D_Zone_L:
	mov	al,0FFh			;set to XOR data with map
	mov	XOR_Flag,al

	mov	ax,24			;Row:= 24  (Scan Line)
	mov	cx,115			;CX:= Length of line
	call	Draw_Vertical
	ret

page
;----------------------------------------------------------------------
; Print the Date
;---------------
;	1) put value in al at date pos
;
put_date_rev:	;Enter Here to put up date in reverse video w/zero suppression
	mov	bl,rev_chr+zer_sup
	jmp	short pdn1

put_date_norm:	;Entry Here to put up date in normal video w/zero suppression
	mov	bl,zer_sup

pdn1:	mov	DFlags,bl		; move attribute flags
	cmp	al,32			; if date is in range
	jc	pdn2			; then continue

	mov	al,31			; else force it in range
pdn2:	mov	dx,ax			; save al value
	add	al,MOffset		; calculate where date goes on screen
	dec	ax			;-1
	mov	cl,3	
	mul	cl
	mov	cl,21
	div	cl
	xchg	ah,al
	add	ax,0804h		; first pos is col 4, row 8
	xchg	ax,dx			; restore regs
	jmp	Put_Ascii

page
;----------------------------------------------------------------------
; SET DFLAGS FOR REVERSE VIDEO AS PER Upd_Mode
;---------------------------------------------
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Set_DFlag

Clk_DFlag:
	test	ah,ah
	jz	sdfr

Set_DFlag:
	and	DFlags,NOT Rev_Chr
	inc	Upd_Cmp
	mov	al,Upd_Cmp
	cmp	al,Upd_Mode
	jnz	Sdfr

	or	DFlags,Rev_Chr
sdfr:	ret

; Monitor_Segment	EndS
;		End
