page
;----------------------------------------------------------------------
Set_Display_Page Proc Near; (18_Jul_85)
;--------------------------------------
; 	1) Set_Display_Page is called to determine what page will be
;	   shown on the monitor.
;	2) Input Register Values:
;		AL -> Page number to be displayed.
;	3) Output Values:
;		Correct cursor position for this page
;		Current_Page
;		Displayed_Page
;		Crt_Start_Address
;
Public	Set_Display_Page

	PushReg	<ax,bx,dx,si,ds>
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	bh,al			;Get page number in BH
	call	Set_Io_Page		;Set up I/O variables for page

	mov	Displayed_Page,al	;Keep track of page being displayed
	mov	Old_Displayed_Page,al	;Keep copy of old displayed page
	cbw				;Convert page number to a word
	mov	bx,ax			;Get page number in BX
	shl	bx,1			;Make BX into a word offset
	mov	si,Page_Base[bx]	;Get the current page bage
	cmp	Video_Mode,7		;Are we in monochrome mode?
	jne	SDP1			;No, have the correct address

	mov	si,Page_Base[8 * 2]	;Yes - treat monochrome as page 8
SDP1:	shr	si,1			;Make it into a hardware address
	mov	Crt_Start_Address,si	;Save display address
	mov	dx,Cursor_Position[bx]	;Get the current cursor position

	push	bx			;Save the page pointer
	mov	bh,Displayed_Page	;Get the new display page number
	call	Set_Cursor_Position	;Update the hardware cursor
	pop	bx			;Restore the page pointer

	mov	al,Video_On		;Turn on the video
	call	Out_Video_Mode		;Set up the CRT for the right mode
	mov	bx,si			;Get the CRT start address
	mov	al,Crt_Start_Port	;Get the CRT start addr port number
	call	Send_Video_Word		;Display the right page!

	PopReg	<ds,si,dx,bx,ax>
	ret

Set_Display_Page EndP

page
;----------------------------------------------------------------------
Set_IO_Page Proc Near; (17_Jul_85)
;---------------------------------
;	1) Set_IO_Page is called prior to reading, writing or scrolling
;	   information on a page, so that calling routines will properly
;	   wrap-around when information is displayed.
;	2) Entry Register Values:
;		BH -> Page to be displayed.
;	3) Exit Values:
;		Current_Page --- Number of the Current Page
;		Start_of_Page -- Pointer to First Byte of Current Page
;		End_of_Page ---- Pointer to Last Byte of Current Page
;
	push	bx
	cmp	Video_Mode,3		;If (alphanumeric mode ne True)
	jbe	SioP1

	mov	bh,0			;	New_Page_Number:= Forced to 0
SioP1:	mov	Current_Page,bh		;Current_Page:= New_Page_Number

	mov	bx,0			;BX:= 0 (PAGE_START)
	cmp	Video_Mode,7		;If (MonoChrome mode ne True)
	je	SioP2

	mov	bl,Current_Page
	mov	bh,0			;	BX:= New Page Number
	shl	bx,1			;	(Make page number word offset)
	mov	bx,Page_Start[bx]	;	BX:= Pointer to start of page

SioP2:	mov	Start_of_Page,bx	;Start_of_Page:= Pointer to Start Addr

	add	bx,Page_Size		;(BX:= Pointer to 1st byte next page)
	dec	bx			;(BX:= Pointer to last byte this page)
	mov	End_of_Page,bx		;End_of_Page:= Pointer to Last Addr
	pop	bx
	ret				;Return

Set_IO_Page	EndP

 correct address

	mov	si,Page_B