	PAGE	,132
	TITLE	Z-150 Miscellaneous Interrupt Service Routines

;**********************************************************************
;
;                 ----------------------------------
;----------------- Misc. Interrupt Service Routines ------------------
;                 ----------------------------------
;
;	      Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************
MONITOR_SEGMENT SEGMENT WORD PUBLIC

ROM_DATA SEGMENT WORD AT (40H)
ROM_DATA ENDS

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, SS:ROM_DATA, ES:NOTHING

	INCLUDE	ROM.LIT
	INCLUDE IO.LIT
	INCLUDE INTR.LIT

	EXTRN	DATA_SEGMENT:WORD, DISP_STRING:NEAR, SOFTWARE_BREAKPOINT:FAR
	EXTRN	DIV_ERR_MSG:BYTE, OVERFLOW_MSG:BYTE, WILD_INTR_MSG:BYTE
	EXTRN	WILD_HW_MSG:BYTE, NMI_MSG:BYTE

	IF	NOT MORROW
	EXTRN	PARITY_ERR_MSG:BYTE
	ENDIF


;**********************************************************************
; ZERO_DIVIDE_INTERRUPT:
;
;	Zero_Divide_Interrupt is called when the CPU has executed
; a divide-by-zero, and no user trap has been installed.  This routine
; prints out a message to inform the user of the problem, and it then
; returns.
;**********************************************************************
ZERO_DIVIDE_INTERRUPT PROC FAR
	PUBLIC	ZERO_DIVIDE_INTERRUPT
	PUSHREG	<SI,DS>			;Save registers
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	MOV	SI,OFFSET DIV_ERR_MSG	;Print the divide-by-zero message
	CALL	DISP_STRING
	POPREG	<DS,SI>			;Restore registers
	IRET
ZERO_DIVIDE_INTERRUPT ENDP



;**********************************************************************
; OVERFLOW_INTERRUPT
;
;	Overflow_Interrupt is called when the CPU has overflowed during
; an arithmetic operation without a user interrupt service routine
; being installed.  An overflow message is printed, and control is
; returned to the routine which caused the interrupt.
;**********************************************************************
OVERFLOW_INTERRUPT PROC FAR
	PUBLIC	OVERFLOW_INTERRUPT
	PUSHREG	<SI,DS>			;Save registers
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	MOV	SI,OFFSET OVERFLOW_MSG	;Print the overflow message
	CALL	DISP_STRING
	POPREG	<DS,SI>			;Restore registers
	IRET
OVERFLOW_INTERRUPT ENDP



;**********************************************************************
; DO_NOTHING:
;
;	'Do_Nothing' is executed when an installable interrupt has not 
; been installed, but the interrupt has been executed (ie, the user 
; break interrupt, etc).
;**********************************************************************
DO_NOTHING PROC FAR
	PUBLIC	DO_NOTHING
	IRET				;Do precisely nothing!
DO_NOTHING ENDP



;**********************************************************************
; RESERVED_INTERRUPT:
;
;	Reserved_Interrupt is called when a user interrupt is executed
; which is not defined, or is reserved for future use.  It prints out
; an error message, and forces control to return to the monitor, in
; order that the debug facilities of the monitor may help find the
; problem.
;**********************************************************************
RESERVED_INTERRUPT PROC NEAR
	PUBLIC	RESERVED_INTERRUPT
	PUSHREG	<SI,DS>			;Save contents of registers
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	MOV	SI,OFFSET WILD_INTR_MSG	;Point to the wild interrupt message
	CALL	DISP_STRING		;Display message
	POPREG	<DS,SI>			;Restore registers
;	JMP	SOFTWARE_BREAKPOINT	;Perform a software breakpoint
	DB	FAR_JUMP		;Far jump
	DW	OFFSET SOFTWARE_BREAKPOINT ;Offset of breakpoint routine
	DW	SEG MONITOR_SEGMENT	;Segment of monitor entry
RESERVED_INTERRUPT ENDP



;**********************************************************************
; RESERVED_HARDWARE_INTERRUPT:
;
;	Reserved_Hardware_Interrupt is called when a hardware interrupt
; is received for which no interrupt driver is present.   It returns
; to the monitor ROM once it sends an END_OF_INTERRUPT to the intr
; controller.
;**********************************************************************
RESERVED_HARDWARE_INTERRUPT PROC FAR
	PUBLIC	RESERVED_HARDWARE_INTERRUPT
	PUSHREG	<AX>			;Save contents of register AX
	MOV	AL,END_OF_INTR		;Send end-of-interrupt to...
	OUT	INTERRUPT_CTRL,AL	;...interrupt controller chip
	POPREG	<AX>			;Restore register contents
	IRET
RESERVED_HARDWARE_INTERRUPT ENDP


	IF	MORROW

NMI_INTERRUPT	PROC	FAR
	PUBLIC	NMI_INTERRUPT
	IRET
NMI_INTERRUPT	ENDP

	ELSE

;**********************************************************************
; NMI_INTERRUPT:
;
;	NMI_Interrupt is called when a non-maskable-interrupt has been
; received.  This routine attempts to determine if the cause of the
; error was a memory error.  If so, the contents of user registers are
; displayed, the parity error latch is cleared, and control is sent
; to the monitor ROM.  Otherwise, an NMI-received message is printed.
;**********************************************************************
NMI_INTERRUPT PROC FAR
	PUBLIC	NMI_INTERRUPT
	PUSH	AX			;Save status of register AX
	PUSH	DS			;Save old data segment
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	IN	AL,MEMORY_STATUS	;Read the memory error register
	AND	AL,PARITY_ERR OR MEMORY_ERR ;Did a parity error occur?
	JZ	NMI1			;No, continue
	MOV	AL,[0]			;Yes - clear error from memory board
	IN	AL,SYS_CTRL_PORT	;Read the system control port
	OR	AL,DISABLE_PARITY_CHK OR DISABLE_MEMORY_CHK
	OUT	SYS_CTRL_PORT,AL	;Clear the parity error latch
	AND	AL,NOT (DISABLE_PARITY_CHK OR DISABLE_MEMORY_CHK)
	OUT	SYS_CTRL_PORT,AL	;Enable further parity checking
	PUSH	SI			;Save contents of SI
	MOV	SI,OFFSET PARITY_ERR_MSG;Display parity error message
	CALL	DISP_STRING
	POP	SI			;Restore SI
	POP	DS			;Restore data segment
	POP	AX			;Restore register AX
;	JMP	SOFTWARE_BREAKPOINT	;Perform a software breakpoint
	DB	FAR_JUMP		;Far jump
	DW	OFFSET SOFTWARE_BREAKPOINT ;Offset of breakpoint routine
	DW	SEG MONITOR_SEGMENT	;Segment of monitor entry
NMI1:	PUSH	SI			;Save contents of SI
	MOV	SI,OFFSET NMI_MSG	;Print NMI interrupt occurred msg
	CALL	DISP_STRING
	POP	SI			;Restore contents of register SI
	POP	DS			;Restore data segment
	POP	AX			;Restore register AX
	IRET				;Return to caller
NMI_INTERRUPT ENDP

	ENDIF



MONITOR_SEGMENT ENDS

	END

