	PAGE	,132
	TITLE	Z-150 Error Message Display Routines

;**********************************************************************
;
;                  --------------------------------
;------------------ Error Message Display Routines --------------------
;                  --------------------------------
;
;	      Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:NOTHING

	INCLUDE	ROM.LIT
	INCLUDE IO.LIT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../VIDEO/VIDEO.EXT
	INCLUDE ../DISK/DISK.LIT
	INCLUDE ../DISK/DISK.EXT

	EXTRN	DIAG_DISP_STRING:NEAR, DIAG_DISP_HEX_WORD:NEAR
	EXTRN	DIAG_CONSOLE_OUTPUT:NEAR, CLEAR_VIDEO_RAM:NEAR
	EXTRN	WAIT_BREAK:NEAR, MFM_150:NEAR, CRT_MODE:BYTE, BEEP:NEAR
	EXTRN	DISP_STRING:NEAR, CRLF:NEAR, DIAG_DISP_DEC_WORD:NEAR
	EXTRN	DISK_MSG_TABLE:BYTE, MEM_CHIP:WORD
	EXTRN	VIDEO_CHIP:WORD, BAD_RAM_MSG1:BYTE, BAD_RAM_MSG2:BYTE
	EXTRN	BAD_RAM_MSG3:BYTE, BAD_RAM_MSG4:BYTE
	EXTRN	ERROR_MSG:BYTE, DISK_ERROR_MSG:BYTE, READ_DIP_SWITCHES:NEAR

	IF	NOT MORROW
	EXTRN	PARITY_CHIP:WORD, BAD_PARITY_MSG:BYTE
	ENDIF


;**********************************************************************
; BAD_RAM: (RAM_PTR, GOOD_DATA, BAD_DATA, VIDEO_FLAG, VIDEO_SEGMENT)
;
;	Bad_Ram is called when one of the system memory tests
; detects a failure during diagnostics.  It displays the
; address, failed bit, and bad chip number on the console.
; Like the other error routines, it will wait for a CTRL-BREAK
; to be entered at the console, and then it will exit directly
; to the MFM_150 monitor.
;
; Input:
;    ES:DI: Pointer to failed memory location
;	DX: Good data (value memory should have)
;	AX: Bad data (data actually contained in RAM)
;	SI: Contains video segment if the carry flag is set
;	CY: Video segment already determined flag
;**********************************************************************
BAD_RAM PROC NEAR
	PUBLIC	BAD_RAM
	MOV	BX,ES			;Save the failed RAM segment in BX
	MOV	ES,SI			;Get the pointer to the video segment
	JC	BR0			;Jump if we already have the segment
	CALL	SET_VIDEO_SEGMENT	;Don't have it - point to the video board
BR0:	XOR	AX,DX			;Find which bits have failed
	TEST	AL,AL			;Is the failure in the low byte?
	JNE	BR1			;Yes - have correct address now
	INC	DI			;No, point to the high byte
	MOV	AL,AH			;Place the failed bits in AL
BR1:	PUSH	AX			;Save the failed bit string
	MOV	SI,OFFSET BAD_RAM_MSG1	;Point to the RAM failure message
	CALL	DISP_RAM_FAILURE	;Display 'RAM failure!' and address
	MOV	SI,OFFSET BAD_RAM_MSG2	;Display ', Bit: ' following address
	CALL	DIAG_DISP_STRING
	POP	CX			;Restore failed bit string into CX
	MOV	AL,0			;Start with bit # for bit 0
	MOV	CH,7			;Set chip offset in BL
BR2:	SHR	CL,1			;Test a bit to see if it is in error
	JNC	BR3			;No error in this bit, try the next
	ADD	AL,'0'			;Make bit # into the bit name
	CALL	DIAG_CONSOLE_OUTPUT	;Display failed bit number
	JMP	SHORT BR4		;Next, calculate chip number
BR3:	INC	AL			;Advance to the next bit name
	DEC	CH			;Decrement the bit offset
	TEST	CL,CL			;Checked all bits yet?
	JNZ	BR2			;No, loop until error found
;
; Calculate and print the RAM chip which failed...
;
BR4:	CMP	BX,MONO_SEGMENT		;Is this a monochrome card?
	JE	BR9			;Yes - don't know about chip numbers!
	MOV	SI,OFFSET BAD_RAM_MSG3	;Display ', Chip: U'
	CALL	DIAG_DISP_STRING
	MOV	AX,DI			;Get the offset in AX
	MOV	CL,4			;Divide offset by 16...
	SHR	AX,CL			;...to get segment number
	ADD	AX,BX			;Add in base segment to get para. #
	CMP	AX,0A000H		;Is this a system memory failure?
	JB	BR7			;Yes - display bad memory RAM chip
	MOV	SI,0			;Initially, point to first RAM chip
	CMP	CH,4			;Was the error in the lower nibble?
	JB	BR5			;Yes, all set
	ADD	SI,1 * 2		;No - point to the high nibble chip
BR5:	TEST	DI,1			;Was this an even byte failure?
	JE	BR6			;Yes - have correct chip number
	ADD	SI,2 * 2		;No, point to the odd chip number
BR6:	MOV	AX,CS:VIDEO_CHIP[SI]	;Get the failed chip number
	JMP	SHORT BR8		;... and display it on the console
BR7:	MOV	CL,12			;Get shift to find 64K index
	SHR	AX,CL			;Shift paragraph to get offset
	MOV	CL,5			;Want offset of block on memory board
	DIV	CL			;Generate offset MOD 5
	MOV	AL,AH			;Place the offset in AX as a word
	CBW
	MOV	SI,AX			;Place offset in SI
	SHL	SI,1			;Set up for word access
	MOV	AX,CS:MEM_CHIP[SI]	;Get the base chip number
	ADD	AL,CH			;Add in offset to failed chip
	ADC	AH,0			;...add any carry into M.S. byte
BR8:	CALL	DIAG_DISP_DEC_WORD	;Display bad chip number on console
BR9:	MOV	SI,OFFSET BAD_RAM_MSG4	;Display end of RAM message
	CALL	DIAG_DISP_STRING	;... ' +++'
	JMP	ERROR_RETURN		;Wait for acknowledgement and exit
BAD_RAM ENDP



	IF	NOT MORROW


;**********************************************************************
; BAD_PARITY: (RAM_PTR, VIDEO_FLAG, VIDEO_SEGMENT)
;
;	Bad_Parity is similar to BAD_RAM, except that it is used
; in the event of parity errors.  This routine is actually used for
; two different cases:  parity RAM failure, and parity generation
; hardware failure.  Since there is no practical way to distinguish
; between the two types of failures, a common message is used for
; both. 
;
; Input:
;    ES:DI: Pointer to failed RAM location
;	CY: Set if the video segment is in SI
;	SI: Video segment if the carry flag is set
;**********************************************************************
BAD_PARITY PROC NEAR
	PUBLIC	BAD_PARITY
	MOV	BX,ES			;Save the failed RAM segment
	MOV	ES,SI			;Set the video segment parameter
	JC	BP0			;Jump if the video segment is set
	CALL	SET_VIDEO_SEGMENT	;Set up the segment if necessary
BP0:	MOV	SI,OFFSET BAD_PARITY_MSG;Point to the 'Parity Hardware Failure'
	CALL	DISP_RAM_FAILURE	;...message, and print the address
	MOV	SI,OFFSET BAD_RAM_MSG3	;Print the ', Chip: U' message
	CALL	DIAG_DISP_STRING
;
; Calculate and print the parity chip which failed...
;
	MOV	CL,4			;Divide offset by 16...
	SHR	DI,CL			;...to get segment number
	ADD	DI,BX			;Add in base segment to get para. #
	MOV	AX,DI			;Get the paragraph number in AX
	MOV	CL,12			;Get shift to get M.S. nibble of address
	SHR	AX,CL			;Put the M.S. address nibble in AX
	MOV	CL,5			;Number of banks/memory board
	DIV	CL			;Divide to get parity chip offset
	MOV	AL,AH			;Place chip offset in AL
	CBW				;Extend it to a word
	MOV	SI,AX			;Place offset in DI
	SHL	SI,1			;Set up for word access
	MOV	AX,CS:PARITY_CHIP[SI]	;Get the parity chip number
	CALL	DIAG_DISP_DEC_WORD	;Display it on the console
	MOV	SI,OFFSET BAD_RAM_MSG4	;Print out ' +++'
	CALL	DIAG_DISP_STRING	;...with a newline
	JMP	ERROR_RETURN		;Wait for BREAK, and exit to monitor
BAD_PARITY ENDP


	ENDIF




;**********************************************************************
; DISP_RAM_FAILURE: (BAD_LOCATION, MSG)
;
;	Disp_RAM_Failure is called by the BAD_RAM and BAD_PARITY
; routines to display the failure message and the failed address.
;
; Input:
;    BX:DI: Pointer containing bad RAM address
;	SI: Pointer with error message to be displayed
;
; Output:
;	DX: Cursor position following displayed messages.
;	ES: Pointing to the current video segment
;**********************************************************************
DISP_RAM_FAILURE PROC NEAR
	PUBLIC	DISP_RAM_FAILURE
	PUSHREG	<AX,SI>
	MOV	DX,(0 SHL 8) OR 0	;Home the software cursor position
	PUSH	SI			;Save ptr to error cause message
	MOV	SI,OFFSET ERROR_MSG	;Display the '+++ ERROR:  ' message
	CALL	DIAG_DISP_STRING
	POP	SI			;Restore text for error cause
	CALL	DIAG_DISP_STRING	;Display the actual cause message
	MOV	AX,BX			;Get the failed RAM segment
	CALL	DIAG_DISP_HEX_WORD	;Display the failed memory segment
	MOV	AL,':'			;Display an address separator
	CALL	DIAG_CONSOLE_OUTPUT	;...between the segment and offset
	MOV	AX,DI			;Get the failed RAM offset
	CALL	DIAG_DISP_HEX_WORD	;Display the failed address offset
	POPREG	<SI,AX>
	RET
DISP_RAM_FAILURE ENDP



;**********************************************************************
; DISPLAY_DISK_ERROR: (ERROR_CODE)
;
;	Display_Disk_Error is called when an error has been encountered
; during a disk boot, or during the disk diagnostics.  It will
; display a text message, wait for break to be entered, and then
; it will transfer control to the MFM_150 monitor.  Note that, unlike
; the other error routines, this routine uses that standard video output
; routines, since diagnostics must have passed to permit a disk boot 
; to occur.
;
; Input:
;	AH: Disk error code (see definition for DISK_STATUS)
;**********************************************************************
DISPLAY_DISK_ERROR PROC NEAR
	PUBLIC	DISPLAY_DISK_ERROR
	MOV	SI,OFFSET DISK_ERROR_MSG;Point to the generic disk err msg
	CALL	DISP_STRING		;Display '+++ DISK ERROR:  '
	MOV	SI,OFFSET DISK_MSG_TABLE;Point to the disk error table
DDE1:	CMP	BYTE PTR CS: [SI],nil	;Reached the end of the table yet?
	JE	DDE2			;Yes - assume bad disk controller
	TEST	AH,BYTE PTR CS: [SI]	;Is this the correct error?
	JNZ	DDE2			;Yes, display the associated message
	ADD	SI,3			;No, go on to the next error record
	JMP	SHORT DDE1
DDE2:	INC	SI			;Point to the text ptr for this msg
	MOV	SI,WORD PTR CS:[SI]	;Get the pointer to the error message
	CALL	DISP_STRING		;Display rest of message
	CALL	CRLF			;Print Carriage-Return, Line-Feed
	CALL	WAIT_BREAK		;Wait for a response to error message
	JMP	MFM_150			;Return control to MFM_150 monitor
DISPLAY_DISK_ERROR ENDP



;**********************************************************************
; DISPLAY_ERROR_MSG: (MSG_PTR)
; ERROR_RETURN:
;
;	Display_Error_Msg is called when a hardware fault has been
; detected and an error message must be displayed.  It sets up
; the diagnostics mode CRT display, displays the user's error
; message, and then waits for a break code from the keyboard.
; Once the break code has been received, control does NOT return
; to the caller, but rather the MFM_150 monitor is executed.
;	The alternate entry point ERROR_RETURN is available for
; routines which display their own error message.
;
; Input:
;	SI: Pointer to null-terminated message to be displayed.
;
; Output:
;	ES: Pointing to the current video segment
;**********************************************************************
DISPLAY_ERROR_MSG PROC NEAR
	PUBLIC	DISPLAY_ERROR_MSG, ERROR_RETURN
	MOV	BX,ES			;Get the current segment definition
	CMP	BX,SCREEN_SEGMENT	;Is it the color card?
	JE	DEM0			;Yes - all set
	CMP	BX,MONO_SEGMENT		;Is this the monochrome card?
	JE	DEM0			;Yes - have a valid segment
	CALL	SET_VIDEO_SEGMENT	;Point to the current video card
DEM0:	MOV	DX,(0 SHL 8) OR 0	;Set DX to the home position
	PUSH	SI			;Save pointer to the error message
	MOV	SI,OFFSET ERROR_MSG	;Point to the generic error message
	CALL	DIAG_DISP_STRING	;Display '+++ ERROR:  '
	POP	SI			;Restore pointer to specific message
	CALL	DIAG_DISP_STRING	;Display the specific error message

ERROR_RETURN:
	MOV	CX,40			;Set character count
	MOV	AL,' '			;Display spaces to erase extra text
DEM1:	CALL	DIAG_CONSOLE_OUTPUT	;Display a space character
	LOOP	DEM1			;Loop until enough erased
	CALL	BEEP			;BEEP! to signal error condition
	CALL	WAIT_BREAK		;Wait for a break to be entered
	JMP	MFM_150			;Transfer to the MFM monitor
DISPLAY_ERROR_MSG ENDP



;**********************************************************************
; SET_VIDEO_SEGMENT:
;
;	Set_Video_Segment is called to set the current segment address
; for display of diagnostics information.
;
; Output:
;	ES: Pointing to the default display segment
;**********************************************************************
SET_VIDEO_SEGMENT PROC NEAR
	PUBLIC	SET_VIDEO_SEGMENT
	PUSHREG	<AX,BX>
	MOV	BX,SCREEN_SEGMENT	;Point to the video RAM segment
	CALL	READ_DIP_SWITCHES	;Read the system configuration switches
	AND	AH,VIDEO_MODE_MASK	;Mask out the video board select bits
	CMP	AH,VIDEO_MODE_MONO	;Is the monochrome board selected?
	JNE	SVS1			;No, have correct video segment
	MOV	BX,MONO_SEGMENT		;Point to the monochrome video segment
SVS1:	MOV	ES,BX			;Point ES to the correct segment
	POPREG	<BX,AX>
	RET
SET_VIDEO_SEGMENT ENDP



MONITOR_SEGMENT ENDS

	END
