	PAGE	,132
	TITLE	Z-150 Diagnostics Output Routines

;**********************************************************************
;
;                    -----------------------------
;-------------------- Diagnostics Output Routines ---------------------
;                    -----------------------------
;
;	       Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	INCLUDE ROM.LIT
	INCLUDE IO.LIT
	INCLUDE ../SYS/SYS.EXT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../VIDEO/VIDEO.EXT
	INCLUDE ../KEYBOARD/KEYBOARD.LIT

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, SS:ROM_DATA, ES:NOTHING

	EXTRN	SET_VIDEO_MODE:NEAR, GET_KEY:NEAR, TEXT_LINE_OFFSET:WORD
	EXTRN	BEEP:NEAR, START_UP:FAR, MFM_150:NEAR, READ_DIP_SWITCHES:NEAR


;**********************************************************************
; WAIT_BREAK:
;
;	Wait_Break is called to wait for a 'break' from the console.
; The routine will first flush any existing contents of the keyboard 
; buffer hardware, and then it waits until an ASCII ESCAPE character 
; has been entered at the console.
;**********************************************************************
WAIT_BREAK PROC NEAR
	PUBLIC	WAIT_BREAK
	PUSHF				;Save current interrupt-enable status
	CLI				;Prevent interrupts for TEST_KEY
WB1:	CALL	TEST_KEY		;Are keys waiting to be read?
	JNC	WB2			;No, finished flushing keyboard buff
	MOV	AL,FALSE		;Yes - get code to read a key now...
	CALL	GET_KEY			;Flush a key from the keyboard
	JMP	SHORT WB1		;Go and pick up more keys...
WB2:	CALL	TEST_BREAK		;Has a break been entered?
	JNC	WB2			;No, wait until one entered
	POPF				;Restore old interrupt status
	RET
WAIT_BREAK ENDP



;**********************************************************************
; TEST_BREAK:
;
;	Test_Break is called to determine if the user wishes to abort
; a diagnostics routine.  Either the 'SCROLL_LOCK' (Break) key, or
; the ESCAPE key may be entered to abort the test.  In addition,
; the Ctrl-Alt-Del sequence will force a reset, and Ctrl-Alt-Ins
; will jump directly into the MFM-150 monitor.
;
; Output:
;	CY: Set to true if an abort was received.  Reset if no key
;	    was typed, or if the key typed was not a break key.
;**********************************************************************
TEST_BREAK PROC NEAR
	PUBLIC	TEST_BREAK
	PUSHREG	<AX,BX>
TB1:	CALL	TEST_KEY		;Has a key been entered?
	JNC	TB3			;No, return with carry reset
	MOV	AL,FALSE		;Set the don't-wait-for-key flag
	CALL	GET_KEY			;Retrieve the key from buffer
	CMP	AL,SCROLL_KEY		;Could this be an abort?
	STC				;[Set abort flag if so!]
	JE	TB3			;Yes - return with break flag set!
	CMP	AL,ESC_KEY		;Was an ESCAPE entered?
	STC				;[Set break flag if so...]
	JE	TB3			;Yes - return!
	CMP	AL,DEL_KEY		;Is this a DEL (as in CTRL-ALT-DEL)?
	JNE	TB2			;No, check for another key
;	JMP	START_UP		;Yes - reinitialize the system
	DB	FAR_JUMP		;Far jump to start-up code
	DW	OFFSET START_UP		;Offset  of monitor reset
	DW	SEG MONITOR_SEGMENT	;Segment of monitor reset
TB2:	CMP	AL,INS_KEY		;Is this an exit-to-monitor?
	CLC				;[Clear the break-entered flag]
	JNE	TB1			;No, check for more keys
	JMP	MFM_150			;Yes - exit to the monitor
TB3:	POPREG	<BX,AX>
	RET
TEST_BREAK ENDP



;**********************************************************************
; TEST_KEY:
;
;	Test_Key is called in diagnostics mode to determine if a key
; has been pressed.  It relies on interrupts being disabled to scan
; the keyboard.
;
; Output:
;	CY: Set if a key has been typed, or reset if none was typed.
;**********************************************************************
TEST_KEY PROC NEAR
	PUBLIC	TEST_KEY
	PUSHREG	<AX>
	MOV	AL,POLL_PENDING_INTRS	;Get command to poll intr requests
	OUT	INTERRUPT_CTRL,AL	;Request pending from intr ctrl port
	IN	AL,INTERRUPT_CTRL	;Read the pending interrupts
	AND	AL,NOT KEYBOARD_INTR_MASK ;Is a keyboard char waiting?
	ADD	AL,0FFH			;Set carry if so, reset it if not
	POPREG	<AX>
	RET
TEST_KEY ENDP



;**********************************************************************
; DIAG_CLEAR_SCREEN: (VIDEO_SEGMENT)
;
;	Diag_Clear_Screen clears the contents of the diagnostics mode
; screen by displaying spaces on the entire screen.  The home cursor
; position of (0,0) is returned to the caller.
;
; Input:
;	ES: Contains current video segment
;
; Output:
;	DX: Set to home position (0,0)
;**********************************************************************
DIAG_CLEAR_SCREEN PROC NEAR
	PUBLIC	DIAG_CLEAR_SCREEN
	PUSHREG	<AX,CX,DI>		;Save registers
	MOV	DI,0			;Point to beginning of memory
	MOV	CX,SCREEN_WORDS		;Get the length of the screen
	MOV	AX,(DEFAULT_ATTRIBUTE SHL 8) OR ' ' ;Set fill to spaces
	REP	STOSW			;Fill screen RAM with spaces
	MOV	DX,0			;Point software cursor to home posn
	POPREG	<DI,CX,AX>		;Restore registers
	RET
DIAG_CLEAR_SCREEN ENDP



;**********************************************************************
; DIAG_DISP_DEC_WORD: (WORD, VIDEO_SEGMENT, CHAR_POSN)
;
;	Diag_Disp_Dec_Word displays a word as a decimal number, in
; ASCII digits on the console.  Leading zeros are suppressed.
;
; Input:
;	AX: Word value to be displayed
;	DX: Character position to display the number
;	ES: Segment for default display adapter
;
; Output:
;	DX: Contains cursor position of first character following 
; 	    displayed number.
;
; Note: This routine uses a recursive algorithm to convert a number,
;	so it will use as much as DIGITS*3 levels of stack space.
;**********************************************************************
DIAG_DISP_DEC_WORD PROC NEAR
	PUBLIC	DIAG_DISP_DEC_WORD
DDW1:	PUSHREG	<AX,CX>			;Save registers
	PUSH	DX			;Save the current character position
	MOV	DX,0			;Extend number to a dword
	MOV	CX,10			;Divide current number by 10
	DIV	CX
	MOV	CX,DX			;Place remainder in register CX
	POP	DX			;Restore character position
	TEST	AX,AX			;Have we reached leading zeros yet?
	JZ	DDW2			;Yes - display M.S. digit
	CALL	DDW1			;No, display leading digits
DDW2:	MOV	AX,CX			;Get character in AX
	ADD	AL,'0'			;Convert character to decimal
	CALL	DIAG_CONSOLE_OUTPUT	;Display a char of the number
	POPREG	<CX,AX>			;Restore registers
	RET
DIAG_DISP_DEC_WORD ENDP



;**********************************************************************
; DIAG_DISP_HEX_WORD: (WORD, VIDEO_SEGMENT, CHAR_POSN)
; DIAG_DISP_HEX_BYTE: (BYTE, VIDEO_SEGMENT, CHAR_POSN)
; DIAG_DISP_HEX_NIBBLE: (NIBBLE, VIDEO_SEGMENT, CHAR_POSN)
;
;	Diag_Disp_Hex_Word displays the contents of AX as a 4 character
; ASCII string on the console in diagnostics mode.  Diag_Disp_Hex_Byte
; displays AL as two ASCII-Hex chars, and Diag_Disp_Hex_Nibble displays
; the nibble in AL as a single character.
;
; Input:
;	AX: Word, or ...
;	AL: Byte, or ...
;	AL: Nibble to be displayed.
;	DX: Current character position
;	ES: Segment for default video card
;
; Output:
;	DX: Advanced to cursor position following displayed characters.
;
; Note: Register AX is destroyed by this call
;**********************************************************************
DIAG_DISP_HEX_WORD PROC NEAR
	PUBLIC	DIAG_DISP_HEX_WORD, DIAG_DISP_HEX_BYTE, DIAG_DISP_HEX_NIBBLE
	PUSH	AX			;Save the word being output
	MOV	AL,AH			;Get the low byte first
	CALL	DIAG_DISP_HEX_BYTE	;Print the low byte
	POP	AX			;Restore word, display low byte
DIAG_DISP_HEX_BYTE:
	PUSH	AX			;Save low nibble on stack
	PUSH	CX			;Save CX
	MOV	CL,4			;Get the high nibble first
	SHR	AL,CL			;... into AL
	POP	CX			;Restore register CX
	CALL	DIAG_DISP_HEX_NIBBLE	;Display the high nibble
	POP	AX			;Retrieve and display low nibble
DIAG_DISP_HEX_NIBBLE:
	AND	AL,0FH			;Make sure we only have a nibble
	ADD	AL,'0'			;Convert char to hex
	CMP	AL,'9'			;Is the character a digit?
	JBE	DHW1			;Yes - display character
	ADD	AL,'A'-'9'-1		;No, convert char to 'A'-'F'
DHW1:	CALL	DIAG_CONSOLE_OUTPUT	;Display the converted character
	RET
DIAG_DISP_HEX_WORD ENDP



;**********************************************************************
; DIAG_DISP_STRING: (STRING, VIDEO_SEGMENT, CHARACTER_POSITION)
;
;	Diag_Disp_String displays a null (00H) terminated string on
; the console in diagnostics mode.
;
; Input:
;	SI: Pointer to string (assumed to be in the monitor segment).
;	DX: Character position to begin displaying string.
;	ES: Segment of current display board
;
; Output:
;	DX: New character position (following string).
;**********************************************************************
DIAG_DISP_STRING PROC NEAR
	PUBLIC	DIAG_DISP_STRING
	PUSHREG	<AX,SI>
DDS1:	MOV	AL,BYTE PTR CS: [SI]	;Get a character to be displayed
	INC	SI			;Point to the next character
	TEST	AL,AL			;Reached the end of the string?
	JZ	DDS2			;Yes - return
	CALL	DIAG_CONSOLE_OUTPUT	;No, display this character
	JMP	SHORT DDS1		;Loop until whole string displayed
DDS2:	POPREG	<SI,AX>
	RET
DIAG_DISP_STRING ENDP



;**********************************************************************
; DIAG_CONSOLE_OUTPUT: (CHAR, VIDEO_SEGMENT, CHAR_POSN)
; DIAG_DISPLAY_CHAR: (CHAR, VIDEO_SEGMENT, CHAR_POSN)
;
;	Diag_Console_Output is called in diagnostics mode to output char-
; acters on the screen.  This routine is designed to display chars
; with no memory references - hence, it is limited to display of
; only ASCII character values, Tab, Carriage Return, and Line Feed.  The
; routine assumes that the current video mode is 80x25 text, with
; page 0 being displayed.  Note that either the color card or the mono-
; chrome card may be the destination of the character being displayed,
; as determined by the setting of the system DIP switches.
;	Diag_Display_Char is an alternate entry point for display of all
; characters (ie, CR, LF, and TAB are also displayed).
;
; Input:
;	AL: Character to be displayed
;	DX: Current cursor position (DH: Row, and DL: Column)
;	ES: Segment for current video display
;
; Output:
;	DX: Contains position of next character to be displayed.
;
; Note: This routine is designed for use during diagnostics ONLY.  The
; 	routine does not support a cursor or scrolling.  Also, in the
;	event of a TAB, the routine is recursive.
;**********************************************************************
DIAG_CONSOLE_OUTPUT PROC NEAR
	PUBLIC	DIAG_CONSOLE_OUTPUT, DIAG_DISPLAY_CHAR
	CMP	AL,CR			;Is this character a Carriage Return?
	JNE	DDC1			;No, try again
	MOV	DL,0			;Yes - set cursor position to 0
	JMP	SHORT DDC5		;Done processing carriage return
DDC1:	CMP	AL,LF			;Is this char a Line Feed?
	JE	DDC4			;Yes - advance to next line
	CMP	AL,TAB			;Is this a horizontal tab?
	JNE	DIAG_DISPLAY_CHAR	;No, display the character
	PUSH	AX			;Yes - save register AX
	MOV	AH,DL			;Get the current column number
	AND	AH,TAB_MASK		;Find start of current tab
	ADD	AH,TAB_SIZE		;Find next tab stop
	SUB	AH,DL			;Find number of spaces to display
DDC2:	MOV	AL,' '			;Display a space character
	CALL	DIAG_DISPLAY_CHAR
	DEC	AH			;Reached the tab stop yet?
	JNZ	DDC2			;No, loop until tab stop reached
	POP	AX			;Restore register AX
	JMP	SHORT DDC5		;Yes - return to caller

DIAG_DISPLAY_CHAR:
	PUSH	AX			;Save the current character
	PUSH	BX			;Save register BX
	MOV	BL,DH			;Get the line number in BX as a word
	MOV	BH,0
	SHL	BX,1			;Make it a word offset
DDC3:	MOV	BX,CS:TEXT_LINE_OFFSET[BX] ;Retrieve the start-of-line offset
	ADD	BL,DL			;Add in column twice (chars + attrs)
	ADC	BH,0
	ADD	BL,DL			;Add in the column number again
	ADC	BH,0			;Now pointing to display char
	MOV	AH,DEFAULT_ATTRIBUTE	;Get the default display attribute
	MOV	WORD PTR ES: [BX],AX	;Write character on screen
	POP	BX			;Restore register BX
	POP	AX			;Restore the character
	INC	DL			;Increment the column number
	CMP	DL,MAX_COLUMNS		;At the end of the line?
	JB	DDC5			;No, return
	MOV	DL,0			;Yes - set column number to 0
DDC4:	INC	DH			;Advance to the next row
	CMP	DH,NUMBER_OF_ROWS	;Wrapped around end of screen?
	JB	DDC5			;No, return
	MOV	DH,0			;Yes - wrap to first line of screen
DDC5:	RET				;Return to caller
DIAG_CONSOLE_OUTPUT ENDP



;**********************************************************************
; SET_DIAG_VIDEO_MODE:
;
;	Set_Diag_Video_Mode is called to set up the video screen
; when diagnostics are being run.  This special video mode is used
; so that information may still be displayed even though system RAM
; is not working correctly (except for the stack RAM, which always
; points to a block other than that found in error).
;	The video mode actually used in diagnostics is 80 by 25
; alphanumeric text mode.
;**********************************************************************
SET_DIAG_VIDEO_MODE PROC NEAR
	PUBLIC	SET_DIAG_VIDEO_MODE
	PUSHREG	<AX>
	MOV	AX,(0 SHL 8) OR 3	;Set video mode, mode = 80x25 Color
	CALL	SET_VIDEO_MODE		;Set the correct video mode
	POPREG	<AX>
	RET
SET_DIAG_VIDEO_MODE ENDP



MONITOR_SEGMENT ENDS

	END

