	PAGE	,132
	TITLE	Z-150 Compatibility File

;**********************************************************************
;
;                          --------------------
;-------------------------- Compatibility File ------------------------
;                          --------------------
;
;	Copyright (C) 1983, by Zenith Data Systems Corporation
;
;**********************************************************************

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT

	INCLUDE	../ROM/ROM.LIT
	INCLUDE	../DISK/DISK.LIT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../DEBUG/DASM.LIT
	INCLUDE ../KEYBOARD/KEYBOARD.LIT
	INCLUDE ../KEYBOARD/KEYBOARD.EXT


	EXTRN	START_UP:FAR, BOOT_INTERRUPT:NEAR, SERIAL_IO_INTERRUPT:NEAR
	EXTRN	KEYBOARD_IO_INTERRUPT:NEAR, KEYBOARD_INTERRUPT:NEAR
	EXTRN	DISK_IO_INTERRUPT:NEAR, DISK_INTERRUPT:NEAR, MFM_150:NEAR
	EXTRN	PRINTER_IO_INTERRUPT:NEAR, VIDEO_IO_INTERRUPT:NEAR
	EXTRN	GET_MEMORY_SIZE_INTERRUPT:NEAR, GET_IO_CONFIG_INTERRUPT:NEAR
	EXTRN	TIME_OF_DAY_INTERRUPT:NEAR, TIMER_INTERRUPT:NEAR
	EXTRN	PRINT_SCREEN_INTERRUPT:NEAR, BREAKPOINT:FAR



;**********************************************************************
; Label for use in padding ROM
;**********************************************************************
		PUBLIC	COMPATBL
COMPATBL	EQU	THIS BYTE		;Should reside at 0E000H

		ORG	0E008H - 0E000H		;Place at copyright location
		DB	'MF',19H		;Copyright message sumcheck



;**********************************************************************
; Jump to Initialization Routine
;**********************************************************************
		ORG	0E05BH - 0E000H
;		JMP	START_UP		;Power-up/reset entry
		DB	FAR_JUMP		;Far jump
		DW	OFFSET START_UP		;Offset of start-up routine
		DW	SEG MONITOR_SEGMENT	;Segment of start-up routine




;**********************************************************************
; Debugger Help Message
;**********************************************************************
		PUBLIC	HELP_MSG
HELP_MSG	DB     '		- MFM-150 Command Summary -',CR,LF,CR,LF
		DB     'CMD:	Explanation		Syntax',CR,LF
		DB     '----	-----------		------',CR,LF
     		DB     '?:	Help			?',CR,LF
		DB     'B:	Boot from disk		B [{F|W}][{0|1|2|3}][:<partition>]',CR,LF
		DB     'C:	Color Bar		C',CR,LF
		DB     'D:	Display memory		D [<range>]',CR,LF
		DB     'E:	Examine memory		E <addr>',CR,LF
		DB     'F:	Fill memory		F <range>,{<byte>|"<string>"}...',CR,LF
		DB     'G:	Execute (Go)		G [=<addr>][,<breakpoint>]...',CR,LF
		DB     'H:	Hex math		H <number1>,<number2>',CR,LF
		DB     'I:	Input from port		I <port>',CR,LF
		DB     'M:	Move memory block	M <range>,<dest>',CR,LF
		DB     'O:	Output to port		O <port>,<value>',CR,LF
		DB     'R:	Examine Registers	R [<register>]',CR,LF
		DB     'S:	Search memory		S <range>,{<byte>|"<string>"}...',CR,LF
		DB     'T:	Trace program		T [<count>]',CR,LF
		DB     'U:	Unassemble program	U [<range>]',CR,LF
		DB     'V:	Set Video/Scroll	V [M<mode>][S<scroll>]',CR,LF
		DB     'TEST:	Extended diagnostics	TEST',CR,LF
		DB     'Where	<range> is:		<addr>{,<addr>|L<length>}',CR,LF,CR,LF
		DB     '	 Copyright (C) 1984, by Zenith Data Systems',CR,LF,0



;**********************************************************************
; Bootstrap Loader
;**********************************************************************
		ORG	0E6F2H - 0E000H
		JMP	BOOT_INTERRUPT		;Boot operating system



;**********************************************************************
; Serial I/O Interrupt
;**********************************************************************
		ORG	0E739H - 0E000H
		JMP	SERIAL_IO_INTERRUPT	;RS-232 I/O call interrupt



;**********************************************************************
; Menu-Driven Diagnostics Main Menu
;**********************************************************************
		PUBLIC	MAIN_MENU
MAIN_MENU 	EQU 	THIS BYTE		;Menu-driven diagnostics menu
		DB	CR,LF,LF,LF,LF,LF,LF
		DB	TAB,TAB,TAB
		DB	'CHOOSE ONE OF THE FOLLOWING:',CR,LF,LF
		DB	TAB,TAB,TAB
		DB	'1. DISK READ TEST',CR,LF
		DB	TAB,TAB,TAB
		DB	'2. KEYBOARD TEST',CR,LF
		DB	TAB,TAB,TAB
		DB	'3. MEMORY TEST',CR,LF
		DB	TAB,TAB,TAB
		DB	'4. POWER-UP TEST',CR,LF
		DB	TAB,TAB,TAB
		DB	'5. EXIT',CR,LF,LF,LF
		DB	TAB,TAB,TAB
		DB	'ENTER YOUR CHOICE: ',0



;**********************************************************************
; Keyboard I/O Interrupt
;**********************************************************************
		ORG	0E82EH - 0E000H
		JMP	KEYBOARD_IO_INTERRUPT	;Keyboard char/status routine




;**********************************************************************
; Keyboard Interrupt Service Routine
;**********************************************************************
		ORG	0E987H - 0E000H
		JMP	KEYBOARD_INTERRUPT	;Actual keyboard interrupt



;**********************************************************************
; Special 'Kludge' Entry point into keyboard interrupt routine.
; Expects character in (AL), handled in interrupt routine.
;**********************************************************************
		ORG	0E996H - 0E000H
		ADD	SP,8 * 2		;Throw away garbage registers
		JMP	KEYBOARD_INTERRUPT	;Re-enter the keyboard interrupt



;**********************************************************************
; Debugger/Monitor Sign-On Message
;**********************************************************************
		PUBLIC	MFM_150_MSG1, MFM_150_MSG2
MFM_150_MSG1	DB	'MFM-150 Monitor, Version '
		DB	VERSION / 10 + '0','.',VERSION MOD 10 + '0'
		IF	SPECIAL
		DB	SPECIAL_VER_CHAR
		ENDIF
		DB	CR,LF,'Memory Size: ',0
MFM_150_MSG2	DB	'K bytes',CR,LF
		DB	'Enter "?" for help.',CR,LF,0



;**********************************************************************
; Debugger Register and Flag Names
;**********************************************************************
		PUBLIC	REG_NAMES, FLAG_NAMES
REG_NAMES	DB	'AX','BX','CX','DX','SI','DI','BP'
		DB	'SP','CS','DS','SS','ES','IP','FL'
		DB	'IP'
;
; Flag Names are organized as:  Cleared-state name, Set-state name.
;
FLAG_NAMES	DW	'NC','CY'			;Carry flag
		DW	   0,   0			;Unused bit 1
		DW	'PO','PE'			;Parity flag
		DW	   0,	0			;Unused bit 3
		DW	'NA','AC'			;Aux. carry
		DW	   0,	0			;Unused bit 5
		DW	'NZ','ZR'			;Zero flag
		DW	'PL','NG'			;Sign flag
		DW	   0,	0			;Trace flag
		DW	'DI','EI'			;Interrupt flag
		DW	'UP','DN'			;Direction flag
		DW	'NV','OV'			;Overflow flag
		DW	   0,   0			;Unused flag 12
		DW	   0,   0			;Unused flag 13
		DW	   0,   0			;Unused flag 14
		DW	   0,   0			;Unused flag 15



;**********************************************************************
; Keyboard Key Encoding Tables
;**********************************************************************
		INCLUDE	../KEYBOARD/KEYTBL.ASM



;**********************************************************************
; Disk I/O Interrupt
;**********************************************************************
		ORG	0EC59H - 0E000H
		JMP	DISK_IO_INTERRUPT	;Disk I/O call handler



;**********************************************************************
; Debugger Pause/Continue Message
;**********************************************************************
		PUBLIC	CONTINUE_MSG
CONTINUE_MSG	DB	'			    - Press any key to continue -',CR,LF,0



;**********************************************************************
; Video Start-of-Line Offsets
;**********************************************************************
		DW	4000H,4000H,4000H,4000H	;Negative offsets for progs...
		DW	4000H,4000H,4000H,4000H ;which wrap around...
GRAPHICS_LINE_OFFSET EQU THIS WORD
		PUBLIC	GRAPHICS_LINE_OFFSET
		DW	0000H,0140H,0280H,03C0H ;Offsets of text...
		DW	0500H,0640H,0780H,08C0H ;...lines while in...
		DW	0A00H,0B40H,0C80H,0DC0H ;...graphics mode
		DW	0F00H,1040H,1180H,12C0H
		DW	1400H,1540H,1680H,17C0H
		DW	1900H,1A40H,1B80H,1CC0H
		DW	1E00H

		DW	4000H,4000H,4000H,4000H	;Negative line numbers will
		DW	4000H,4000H,4000H,4000H	;...yield off-screen display
TEXT_LINE_OFFSET EQU THIS WORD
		PUBLIC	TEXT_LINE_OFFSET
		DW	0000H,00A0H,0140H,01E0H	;Offsets of text...
		DW	0280H,0320H,03C0H,0460H	;...lines while in...
		DW	0500H,05A0H,0640H,06E0H	;...80x25 text mode
		DW	0780H,0820H,08C0H,0960H
		DW	0A00H,0AA0H,0B40H,0BE0H
		DW	0C80H,0D20H,0DC0H,0E60H
		DW	0F00H,0FA0H,1040H,10E0H ;Note that displays
		DW	1180H,1220H,12C0H,1360H ;of up to 50 lines
		DW	1400H,14A0H,1540H,15E0H ;are supported in
		DW	1680H,1720H,17C0H,1860H ;text modes, via the
		DW	1900H,19A0H,1A40H,1AE0H ;use of interlaced
		DW	1B80H,1C20H,1CC0H,1D60H ;sync and video mode
		DW	1E00H,1EA0H,1F40H,1FE0H ;within the CRTC chip.



;**********************************************************************
; Disk Interrupt Service Routine
;**********************************************************************
		ORG	0EF57H - 0E000H
		JMP	DISK_INTERRUPT		;Actual disk interrupt



;**********************************************************************
; Default Disk Parameter Table
;**********************************************************************
		ORG	0EFC7H - 0E000H
		PUBLIC	DISK_PARMS		;Disk parameter table
DISK_PARMS	DISK_P	<0DFH,02H,25H,02H,08H,2AH,0FFH,50H,0F6H,19H,04H>




;**********************************************************************
; Printer I/O Interrupt
;**********************************************************************
		ORG	0EFD2H - 0E000H
		JMP	PRINTER_IO_INTERRUPT	;Printer I/O call handler



;**********************************************************************
; Video I/O Interrupt
;**********************************************************************
		ORG	0F065H - 0E000H
		JMP	VIDEO_IO_INTERRUPT	;Video I/O call handler



;**********************************************************************
; CRT Controller Parameters (60 Hz and 50 Hz Refresh Rates)
;**********************************************************************
		ORG	0F0A4H - 0E000H
	  	PUBLIC  ROM_PARMS_60		;CRT controller parms (60 Hz)
ROM_PARMS_60 	VID_PARMS <38H,28H,2DH,0AH,1FH,06H,19H,1CH,2,7,6,7,0,0,0,0>;40
	 	VID_PARMS <71H,50H,5AH,0AH,1FH,06H,19H,1CH,2,7,6,7,0,0,0,0>;80
	  	VID_PARMS <38H,28H,2DH,0AH,7FH,06H,64H,70H,2,1,6,7,0,0,0,0>;GRFX
	  	VID_PARMS <61H,50H,52H,0FH,19H,06H,19H,19H,2,13,11,12,0,0,0,0>;Mono

		PUBLIC	ROM_PARMS_50		;CRT controller parms (50 Hz)
ROM_PARMS_50 	VID_PARMS <38H,28H,2DH,0AH,26H,02H,19H,20H,2,7,6,7,0,0,0,0>;40
	 	VID_PARMS <71H,50H,5AH,0AH,26H,02H,19H,20H,2,7,6,7,0,0,0,0>;80
	  	VID_PARMS <38H,28H,2DH,0AH,7FH,06H,64H,70H,2,1,6,7,0,0,0,0>;GRFX
	  	VID_PARMS <61H,50H,52H,0FH,19H,06H,19H,19H,2,13,11,12,0,0,0,0>;Mono



;**********************************************************************
; Disassembler Data Tables
;**********************************************************************
		INCLUDE ../DEBUG/DASMTBL.ASM



;**********************************************************************
; Get Memory Size Interrupt
;**********************************************************************
		ORG	0F841H - 0E000H
		JMP	GET_MEMORY_SIZE_INTERRUPT ;Return memory size



;**********************************************************************
; Get I/O Configuration Interrupt
;**********************************************************************
		ORG	0F84DH - 0E000H
		JMP	GET_IO_CONFIG_INTERRUPT	;Return I/O configuration



;**********************************************************************
; Dummy Cassette I/O Interrupt
;**********************************************************************
		ORG	0F859H - 0E000H
		IRET				;Dummy cassette I/O call


;**********************************************************************
; Disk Error Message Tables
;**********************************************************************
		PUBLIC	DISK_MSG_TABLE, DISK_ERROR_MSG
DISK_MSG_TABLE	DB	TIMEOUT_ERROR	;Time out error occurred
		DW	DISK_TO_MSG
		DB	SEEK_ERROR	;Seek (to track) failed
		DW	DISK_SEEK_MSG
		DB	BAD_CTRL_ERROR	;Bad disk controller
		DW	DISK_CTRL_MSG
		DB	CRC_ERROR	;CRC (Cyclic Redundancy Check) error
		DW	DISK_CRC_MSG
		DB	OVERRUN_ERROR	;DMA overrun failure
		DW	DISK_ORUN_MSG
		DB	RECORD_ERROR	;Record not found
		DW	DISK_RECORD_MSG
		DB	ADDRESS_ERROR	;Address mark invalid
		DW	DISK_ADDR_MSG
		DB	nil		;End of table
		DW	DISK_CTRL_MSG	;Must be bad controller here...

DISK_ERROR_MSG	DB	'+++ DISK ERROR:  ',0
DISK_TO_MSG	DB	'Drive not ready! +++',0
DISK_SEEK_MSG	DB	'Seek failure! +++',0
DISK_CTRL_MSG	DB	'Bad disk controller! +++',0
DISK_CRC_MSG	DB	'CRC error! +++',0
DISK_ORUN_MSG	DB	'DMA overrun error! +++',0
DISK_RECORD_MSG	DB	'Sector not found! +++',0
DISK_ADDR_MSG	DB	'Invalid address mark detected! +++',0



;**********************************************************************
; System Error Messages
;**********************************************************************
		PUBLIC	ERROR_MSG, BAD_RAM_MSG1, BAD_RAM_MSG2, BAD_RAM_MSG3
		PUBLIC	BAD_RAM_MSG4

		IF	NOT MORROW
		PUBLIC	BAD_PARITY_MSG
		ENDIF

ERROR_MSG	DB	'+++ ERROR:  ',0
BAD_RAM_MSG1	DB	'RAM failure!  Address: ',0
BAD_RAM_MSG2	DB	', Bit: ',0
BAD_RAM_MSG3	DB	', Chip: U',0
BAD_RAM_MSG4	DB	' +++',0

	IF	NOT MORROW
BAD_PARITY_MSG	DB	'Parity hardware failure!  Address: ',0
	ENDIF



;**********************************************************************
; RAM Chip Number Tables
;**********************************************************************
		PUBLIC	MEM_CHIP, VIDEO_CHIP, VIDEO_CHIP
		IF	NOT MORROW
		PUBLIC	PARITY_CHIP
		ENDIF

MEM_CHIP	DW	402, 412, 422, 432, 442	;Starting chip number for RAMs
	IF	NOT MORROW
PARITY_CHIP	DW	401, 411, 421, 431, 441	;Parity chip numbers
	ENDIF
VIDEO_CHIP	DW	312, 308, 309, 314	;Video RAM chips



;**********************************************************************
;	  I N T E R R U P T   R O U T I N E   M E S S A G E S
;**********************************************************************
		PUBLIC	DIV_ERR_MSG, OVERFLOW_MSG, WILD_INTR_MSG
		PUBLIC	WILD_HW_MSG, NMI_MSG
		IF	NOT MORROW
		PUBLIC	PARITY_ERR_MSG
		ENDIF

DIV_ERR_MSG	DB	CR,LF,'+++ Divide by Zero! +++',CR,LF,0
OVERFLOW_MSG	DB	CR,LF,'+++ Overflow! +++',CR,LF,0
WILD_INTR_MSG	DB	CR,LF,'+++ Wild Interrupt! +++',CR,LF,0
WILD_HW_MSG	DB	CR,LF,'+++ Wild Hardware Interrupt! +++',CR,LF,0
	IF	NOT MORROW
PARITY_ERR_MSG	DB	CR,LF,'+++ ERROR:  Memory parity failure! +++',CR,LF,0
	ENDIF
NMI_MSG		DB	CR,LF,'+++ Non-Maskable Interrupt Received! +++',CR,LF,0



;**********************************************************************
; Graphics Character Font
;**********************************************************************
		ORG	0FA6EH - 0E000H		;Character font table
		INCLUDE	../VIDEO/FONT.ASM	;(Font is 8x8)



;**********************************************************************
; Get/Set Time-of-day
;**********************************************************************
		ORG	0FE6EH - 0E000H
		JMP	TIME_OF_DAY_INTERRUPT	;Get/set time of day



;**********************************************************************
; Timer Interrupt
;**********************************************************************
		ORG	0FEA5H - 0E000H
		JMP	TIMER_INTERRUPT		;Timer tick service routine



;**********************************************************************
; System Error Messages
;**********************************************************************
		PUBLIC	BAD_CPU_MSG, BAD_ROM_MSG, BAD_KB_MSG, BAD_TINTR_MSG
BAD_CPU_MSG	DB	'CPU failure! +++',0
BAD_ROM_MSG	DB	'ROM checksum failure! +++',0
BAD_KB_MSG	DB	'Invalid/No keyboard code received! +++',0
BAD_TINTR_MSG	DB	'Timer Interrupt failure! +++',0



;***********************************************************************
; FEED_KEYBOARD: (SCAN_CODE)
;
;	Feed_Keyboard is a special entry point which allows a program
; to pass a key to the ROM as though it were typed at the keyboard.
; This entry point expects a scan code in AL.  When using this entry
; point, don't forget to send both Make and Break key codes for each
; key!  Also, it is quite easy to get the keyboard LEDs out of sync
; when using this technique - be careful!
;
; Input:
;	AL: Scan code for character
;
; NOTE: THIS PROGRAM REQUIRES THAT THE CALLER SAVE FLAGS ON THE STACK
;	BEFORE BEING CALLED - ie, EXECUTE A PUSHF INSTRUCTION FIRST!!
;***********************************************************************
		ORG	0FF40H - 0E000H		;Feed key entry point
		MOV	FEED_KEY,TRUE		;Flag that this is a 'feed-key' operation
		MOV	AH,AL			;Copy the key code into AH
		JMP	KEYBOARD_INTERRUPT	;Execute the keyboard interrupt code



;***********************************************************************
; Another Dummy Return Instruction...
;***********************************************************************
		IRET



;**********************************************************************
; Dummy Return Instruction
;**********************************************************************
		ORG	0FF53H - 0E000H
		IRET				;Compatible dummy routine



;**********************************************************************
; Print Screen Interrupt
;**********************************************************************
		ORG	0FF54H - 0E000H
		JMP	PRINT_SCREEN_INTERRUPT	;Print screen contents (text)



;**********************************************************************
; Jump to Monitor Routine
;**********************************************************************
		ORG	0FFEDH - 0E000H
		PUBLIC	MONITOR
MONITOR		EQU	THIS FAR
		JMP	MFM_150			;Jump to MFM-150 Monitor/Debugger



;**********************************************************************
; Power-Up / Reset Vector
;**********************************************************************
		ORG	0FFF0H - 0E000H
		PUBLIC	RESET
RESET:		JMP	START_UP		;Initialization / Startup code

MONITOR_SEGMENT	ENDS



;**********************************************************************
; ROM Checksum location and Machine I.D.
;**********************************************************************
CHECKSUM_SEGMENT SEGMENT BYTE PUBLIC

		DB	7 DUP (00H)		;Pad out to checksum
		PUBLIC	ROM_CHECKSUM
ROM_CHECKSUM	DW	0000H			;Set initial checksum to 0
		DB	0FEH			;Machine-ID (XT compatible)
		DB	000H			;Last byte of ROM
CHECKSUM_SEGMENT ENDS


		END

