/*
	PT2ASCII - convert archive paper tape to display ASCII.

			   The program takes two arguments - input archive filename
												 output ASCII filename
*/

#include <stdio.h>
#include <string.h>
#include "cvtables.h"

void main(int argc, char *argv[])
{
	int i;
	int j;
	char code;
	char eof;
	FILE *iF;
	FILE *oF;
	char iN[80];
	char oN[80];
	int cp;

	cp = 0;
	eof = EOF;

	printf("Convert archive paper tape to display ASCII.\n");

	if (argc > 1) {
		strcpy(iN, argv[1]);
	} else {
		strcpy(iN, "input.pt");
	}
	printf("  Input file: %s\n", iN);
	iF = fopen(iN, "rb");
	if (iF == 0) {
		printf("No such input file - %s\n", iN);
		exit();
	}

	if (argc > 2) {
		strcpy(oN, argv[2]);
	} else {
		strcpy(oN, "output.asc");
	}
	printf("  Output file: %s\n", oN);
	oF = fopen(oN, "w");
	if (oF == 0) {
		printf("Cannot open output file - %s\n", oN);
		fclose(iF);
		exit();
	}

	while ((code=fgetc(iF))!=eof) {
		cp++;
		fputc(T4[code], oF);
		if ((cp%80)==0) fputc('\n', oF);
	}

	if ((cp%80)!=0) fputc('\n', oF);

	fclose(iF);
	fclose(oF);

	printf("  Characters processed: %d\n", cp);
	printf("Conversion complete.\n\n");
}
