
/* typestr.c -  */
/* Copyright 1994 Syndesis Corporation */
/* July 12, 1990 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"


/* Strings that correspond to FK_xxx values */

static char *type_str[]
= { 
    /* UCSD's codes */
    /* 0      1       2       3       4       5       6       7       8 */
    "None", "XDsk", "Code", "Text", "Info", "Data", "Graf", "Foto", "Secu",
    /* Ours, not UCSD */
    /* 9 */
    "unkn"
};


/* Month strings */

static char *months[16]
= {
  /* 0 */
    "Bad",
  /* 1      2      3      4      5      6 */
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
  /* 7      8      9      10     11     12 */
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", 
  /* 13     14     15 */
    "BaE", "BaD", "BaF"
};


/* UCSD file type strings */

static char tbuf[ 32 ];

char *ucsdTypeStr( short kind )
{
char *str;


    /* High bit here means what? */
    if (kind & 0x8000) {
        kind &= 0x07FF;
    }

    if (kind > 0 && kind < 9) {
        str = type_str[ kind ];
    }
    else {
        sprintf( tbuf, "Ux%02hx", kind );
        str = tbuf;
    }

    return str;
}


/* UCSD months */

static char mbuf[ 32 ];

char *ucsdMonthStr( short kind )
{
char *str;


    /* Should always be 0..15 */
    if (kind < 16) {
        str = months[ kind ];
    }
    /* Safety */
    else {
        sprintf( mbuf, "?%hd", kind );
        str = mbuf;
    }

    return str;
}

