
/* Declarations for RT-11 volumes */

/* Types for rtFileEntry 'status' */

#define RT_TENTATIVE    256     /* Temporary file */
#define RT_EMPTY        512     /* Marks empty space */
#define RT_PERM         1024    /* A "real" file */
#define RT_ENDMARK      2048    /* Marks the end of file entries */


/* Number of file descriptors in the directory block */

#define RT_NUM_FILES    72


/* Size of each RT-11 disk block, 512 or 0x200 bytes */

#define RT11_BLK_SIZE          512


/* RT-11 file directory entry, stored in rtDirEntry below */

typedef struct {
    USHORT status;      /* state of file RT_xxx */
    USHORT name[3];     /* Six bytes to store the filename in RAD-50 format */
    /* No element structure padding implied as being in the file here */
    USHORT length;      /* in blocks */
    USHORT filler;      /* */
    USHORT date;        /* date stamp */
} rtFileEntry;


/* RT-11 volume directory entry, stored in 1024 bytes */

typedef struct {
    USHORT segsAvailable;   /* */
    USHORT nextSegment;     /* */
    USHORT highSegment;     /* */
    USHORT filler;          /* */
    USHORT beginSegment;    /* */
    rtFileEntry files[72];  /* */
} rtDirRoot;


/* readrtv.c */
USHORT readRT11VolInfo( FILE *infp, rtDirRoot *root );

/* rad50asc.c */
void rad50ToAscii( USHORT rad50, char *str );

/* rtdate.c */
void rtDateStr( USHORT date, char *str );

/* setdate.c */
void rtSetTimeStamp( char *filename, rtFileEntry *eachEntry );

