
/* readinfo.c - Read a UCSD disk image directory entries */
/* Copyright 1994 Syndesis Corporation */
/* July 12, 1990 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"

/* #define DEBUG */

#ifdef DEBUG
#define DBG(x)  x
#else
#define DBG(x)
#endif


/* Read the file descriptors */

USHORT ucsdReadFileInfo( FILE *infp, ucsdDirEntry *dir )
{
USHORT lerr;
ucsdDirEntry *eachEntry;
short each;


    /* Advance to block 2's file info */
    fseek( infp, (long) (UCSD_BLK_SIZE * 2) + 0x1A, SEEK_SET );

    /* Read each element */
    eachEntry = dir;
    for (each=0; each<UCSD_MAX_DIR_ENTRIES; each++) {

        if ((lerr=getShort( infp, &eachEntry->firstBlk )) != TE_NOERROR) {
            goto out;
        }

        if ((lerr=getShort( infp, &eachEntry->lastBlk )) != TE_NOERROR) {
            goto out;
        }

        if ((lerr=getShort( infp, &eachEntry->fileKind )) != TE_NOERROR) {
            goto out;
        }

        if (fread( &eachEntry->fileName, (size_t) 16, (size_t) 1, infp ) != 1) {
            lerr = TE_BADREAD;
            goto out;
        }
        /* Note: these ->fileNames are stored in Pascal form, convert to C before use */

        if ((lerr=getShort( infp, &eachEntry->lastByte )) != TE_NOERROR) {
            goto out;
        }

        if ((lerr=getShort( infp, &eachEntry->lastAccess )) != TE_NOERROR) {
            goto out;
        }

        eachEntry ++;
    }

    lerr = TE_NOERROR;
out:
    return lerr;
} 

