Unit B1401IEX;

Interface

Uses SysUtils,Windows,Classes,Forms,
     IBMTrace,
     IBM1403,
     B1401COR,
     B1401IOD,
     B1401CNV;

Type TRunState=(
       RSInit,     // Initialized
       RSLoad,     // Card deck loaded
       RSRuni,     // Running
       RSStep,     // Single step mode
       RSHalt,     // Halted
       RSEror,     // Error condition
       RSAdSt,     // Stop at address
       RSMWSt,     // Stop on memory Write
       RSMASt,     // Stop on memory Access
       RSStop);    // Stopped by operator

// Machine operating/control status
Var RunState:   TRunState;
    //nEnabled: Boolean;
    FetchPhase: Boolean;
    TraceMode:  Boolean;
    TraceDets:  Boolean;
    TraceRegs:  Boolean;
    AddrStop:   Word;

// Global Machine status registers and switches
Var IAReg:    Word;
    AAReg:    Word;
    BAReg:    Word;
    UCInd:    Boolean;
    ECInd:    Boolean;
    LCInd:    Boolean;
    HCInd:    Boolean;
    Switches: String;

// Current instruction values
Var OpReg:    Char;
    DChar:    Char;
    InstLen:  Byte;

// Values formed from current instruction fetch, saved for execute
Var IATmp:    Word;
    AATmp:    Word;
    BATmp:    Word;
    DCTmp:    Char;
    CZTmp:    Byte;
    WMTmp:    Boolean;

// Current instruction working values
Var AReg:     Byte;
    BReg:     Byte;
    EFAdr:    Word;

Procedure Fetch;
Procedure Execute;

Implementation

Uses B1401CON;

Procedure TestForBranch(IL: Byte);
Begin
  IATmp:=0;
  If InstLen=IL then begin
    IATmp:=GetIAddr;
    TraceAdd(' and Branch to '+W2S(IATmp));
  End;
End;

Procedure StepWait;
Begin End;

Procedure FSetWM;
Begin
  AATmp:=GetIAddr; BATmp:=0;
  TraceAdd('Set WM at '+W2S(AATmp));
  If GetMark(IAReg) then InstLen:=4 else InstLen:=7;
  If InstLen=7 then begin
    BATmp:=GetIAddr;
    TraceAdd(' and '+W2S(BATmp));
  End;
End;
Procedure ESetWM;
Begin
  AAReg:=AATmp;
  SetWM(AAReg);
  Dec(AAReg);
  If InstLen=7 then begin
    BAReg:=BATmp;
    SetWM(BAReg);
    Dec(BAReg);
  End;
End;

Procedure FClrWM;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Clear WM at '+W2S(AATmp));
  If InstLen<>4 then begin
    TraceAdd(' and '+W2S(BATmp));
  End;
End;
Procedure EClrWM;
Begin
  AAReg:=AATmp; ClrWM(AAReg); Dec(AAReg);
  If InstLen<>4 then begin
    BAReg:=BATmp; ClrWM(BAReg); Dec(BAReg);
  End else Begin
    BAReg:=AAReg;
  End;
End;

Procedure FNOP;
Begin
  TraceAdd('No Operation');
End;
Procedure ENOP;
Var CC: Word;
Begin
  CC:=0;
  While (Not GetMark(IAReg)) And (Not Check) do begin
    Inc(IAReg); Inc(CC);
  End;
  If TraceDets then
    If CC>0 then TraceAdd('        '+IntToStr(CC)+' chars skipped');
End;

Procedure FClearStg;
Begin
  AATmp:=AAReg; IATmp:=0;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then begin
      IATmp:=AATmp;
      AATmp:=GetIAddr;
    End;
  End;
  EFAdr:=(AATmp Div 100)*100;
  TraceAdd('Clear Storage from '+W2S(AATmp)+' downto '+W2S(EFAdr));
  If InstLen=7 then TraceAdd(', Branch to '+W2S(IATmp));
End;
Procedure EClearStg;
Begin
  AAReg:=AATmp;
  While (AAReg>=EFAdr) And (Not Check) do begin
    SetCore(AAReg,$20); ClrWM(AAReg); Dec(AAReg);
    If AAReg=0 then Break; //????
  End;
  If InstLen=7 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FMoveChars;
Begin
  If InstLen=5 then begin
    TraceAdd('Bad Instruction length (5)');
//  RunEnabled:=False; Exit;
    Runstate:=RSEror; Exit;
  End;
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Move chars from '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EMoveChars;
Var EF: Boolean;
    CA: Byte;
    CC: Word;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  CC:=0;
  Repeat
    CA:=GetCore(AAReg);
    If TraceDets then begin
      TraceAdd('        => '+W2S(AAReg)+' "'+Chr(CA)+'" to '+W2S(BAReg));
      TracePut;
    End;
    SetCore(BAReg,CA);
    EF:=GetMark(AAReg) Or GetMark(BAReg);
    Dec(AAReg); Dec(BAReg);
    If Not Check then Inc(CC);
  Until EF Or Check;
  TraceAdd('        Chars moved='+IntToStr(CC));
End;

Procedure FLoadChars;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Load chars from '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure ELoadChars;
Var CC: Word;
    CA: Byte;
    WM: Boolean;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  CC:=0;
  Repeat
    CA:=GetCore(AAReg); WM:=GetMark(AAReg);
    If TraceDets then begin
      TraceAdd('        => '+W2S(AAReg)+' "'+Chr(CA)+'" to '+W2S(BAReg));
      If WM then TraceAdd(' plus WM');
      TracePut;
    End;
    SetCore(BAReg,CA);  SetMark(BAReg,WM);
    Dec(AAReg); Dec(BAReg);
    If Not Check then Inc(CC);
  Until WM Or Check;
  TraceAdd('        Chars moved='+IntToStr(CC));
End;

Procedure FMoveZone;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen=7 then begin
    AATmp:=GetIAddr; BATmp:=GetIAddr;
  End;
  TraceAdd('Move zone bits from '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EMoveZone;
Var OA,OB: Byte;
    CA,CB: Char;
    NA,ZA: Byte;
    NB,ZB: Byte;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  OA:=GetCore(AAReg); CA:=Chr(OA);
  OB:=GetCore(BAReg); CB:=Chr(OB);
  Asc2NZ(CA,NA,ZA);
  Asc2NZ(CB,NB,ZB);
  CB:=NZ2Asc(NB,ZA);
  OB:=Ord(CB);
  SetCore(BAReg,OB);
  Dec(AAReg); Dec(BAReg);
//TracePut;
End;

Procedure FMoveNumerics;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen=7 then begin
    AATmp:=GetIAddr; BATmp:=GetIAddr;
  End;
  TraceAdd('Move numerics from '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EMoveNumerics;
Var OA,OB: Byte;
    CA,CB: Char;
    NA,ZA: Byte;
    NB,ZB: Byte;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  OA:=GetCore(AAReg); CA:=Chr(OA);
  OB:=GetCore(BAReg); CB:=Chr(OB);
  Asc2NZ(CA,NA,ZA);
  Asc2NZ(CB,NB,ZB);
  CB:=NZ2Asc(NA,ZB);
  OB:=Ord(CB);
  SetCore(BAReg,OB);
  Dec(AAReg); Dec(BAReg);
End;

Procedure FMoveCharsSZ;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Move chars and suppress zeroes from '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EMoveCharsSZ;
Var EF: Boolean;
    OA: Byte;
    CA: Char;
    CC: Word;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  CC:=0;
  Repeat
    EF:=GetMark(AAReg);
    OA:=GetCore(AAReg); CA:=Chr(OA);
    Case CA of
      '0',',': CA:=' ';
    End;
    SetCore(BAReg,Ord(CA));
    ClrWM(BAReg);
    Dec(AAReg); Dec(BAReg);
    If Not Check then Inc(CC);
  Until EF Or Check;
  TraceAdd('        Chars moved='+IntToStr(CC));
End;

Procedure FReadCard;
Begin
  TraceAdd('Read Card');
  TestForBranch(4);
End;
Procedure EReadCard;
Begin
  ReadCard;
  If InstLen=4 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FSelStacker;
Begin
  DChar:=GetDChar;
  TraceAdd('Select Stacker: '+DChar);
  TestForBranch(5);
End;
Procedure ESelStacker;
Begin
  If InstLen=5 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FPrint;
Begin
  TraceAdd('Write Print line');
  TestForBranch(4);
End;
Procedure EPrint;
Var ES: String;
    AD: Word;
Begin
  ES:='';
  For AD:=201 to 332 do begin
    BAReg:=AD;
    BReg:=GetCore(BAReg);
    If BReg=0 then BReg:=$20;
    ES:=ES+Chr(BReg);
  End;
  PrinterForm.PrintLine(ES);
  If InstLen=4 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FPrintCtrl;
Begin
  DChar:=GetDChar;
  TraceAdd('Carriage Control - Skip to channel '+DChar);
  TestForBranch(5);
End;
Procedure EPrintCtrl;
Var ES: String;
    CC: Word;
Begin
  ES:='';
  For CC:=1 to 8 do
    PrinterForm.PrintLine(ES);
  If InstLen=5 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FWriteAndRead;
Begin
  TraceAdd('Write Print line and Read Card');
  TestForBranch(4);
End;
Procedure EWriteAndRead;
Var ES: String;
    AD: Word;
Begin
  ES:='';
  For AD:=201 to 333 do begin
    BAReg:=AD;
    BReg:=GetCore(BAReg);
    If BReg=0 then BReg:=$20;
    ES:=ES+Chr(BReg);
  End;
  PrinterForm.PrintLine(ES);
  ReadCard;
  If InstLen=4 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FHalt;
Begin
  TraceAdd('Halt');
  If InstLen=4 then begin
    IATmp:=GetIAddr;
    TraceAdd(' Resume at '+W2S(IATmp));
  End;
End;
Procedure EHalt;
Begin
//RunEnabled:=False;
  Runstate:=RSHalt;
  If InstLen=4 then begin
    BAReg:=IAReg;   // Indexing feature
    IAReg:=IATmp;
  End;
End;

Procedure FModifyAddr;
Var EF: Boolean;
    OA,OB: Word;
Begin
  AATmp:=GetIAddr; BATmp:=GetIAddr;
  TraceAdd('Modify Address at '+W2S(BATmp)+' with '+W2S(AATmp));
  OA:=GetAddr(AATmp);
  OB:=GetAddr(BATmp);
  EFAdr:=OA+OB; EF:=EFAdr>16000;
  If EF then EFAdr:=EFAdr-16000;
  TraceAdd('        '+W2S(OB)+'+'+W2S(OA)+'=>'+W2S(EFAdr));
  If EF then TraceAdd('(wrap)');
End;
Procedure EModifyAddr;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  PutAddr(BAReg,EFAdr);
End;

Procedure FStoreAAReg;
Begin
  EFAdr:=GetIAddr;
  TraceAdd('Store A-Address Register ('+W2S(AAReg)+') to '+W2S(EFAdr));
  If InstLen=7 then begin
    IATmp:=GetIAddr; Dec(IAReg,3);
    TracePut;
    TraceAdd('FOLLOWED BY: '+W2S(IATmp));
  End;
End;
Procedure EStoreAAReg;
Begin
  PutAddr(EFAdr,AAReg);
  BAReg:=AAReg;        // BA contains previous value
  Dec(AAReg,3);
End;

Procedure FStoreBAReg;
Begin
  EFAdr:=GetIAddr;
  If InstLen>1 then begin
    TraceAdd('Store B-Address Register ('+W2S(BAReg)+') to '+W2S(EFAdr));
    If InstLen=7 then begin
      IATmp:=GetIAddr;
      TraceAdd(' and '+W2S(IATmp));
    End;
  End;
End;
Procedure EStoreBAReg;
Begin
  PutAddr(EFAdr,BAReg);
  If InstLen=7 then begin
    PutAddr(IATmp,BAReg);
//  Dec(BAReg,3);
  End;
  Dec(AAReg,3);
End;

Procedure FCompare;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Compare '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure ECompare;
Var EF: Boolean;
    OA,OB: Byte;
    CA,CB: Byte;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  UCInd:=False; ECInd:=False; LCInd:=False; HCInd:=False;
  Repeat
    OA:=GetCore(AAReg); OB:=GetCore(BAReg);
    EF:=GetMark(AAReg) Or GetMark(BAReg);
    If GetMark(AAReg) And (Not GetMark(BAReg)) then
//    UCInd:=True;
      HCInd:=True;
//  If Not EF then begin
      If TraceDets then
        TraceAdd('        '+W2S(AAReg)+' '+W2S(BAReg)+' "'+Chr(OA)+' '+Chr(OB)+'"');
      CA:=CollSeq(OA);    CB:=CollSeq(OB);
      If CB<>CA then UCInd:=True;
      If CB=CA  then ECInd:=True;
      If CB<CA  then LCInd:=True;
      If CB>CA  then HCInd:=True;
      If TraceDets then begin
        If UCInd then TraceAdd(' Unequal');
        If ECInd then TraceAdd(' Equal');
        If LCInd then TraceAdd(' Low');
        If HCInd then TraceAdd(' High');
        TracePut;
      End;
//  End;
    Dec(AAReg); Dec(BAReg);
//  TracePut;
  Until EF Or Check;
  TracePut;
//TraceForm.Reset;
End;

Procedure FBranch;
Begin
  IATmp:=GetIAddr; DChar:=#0; BATmp:=0;
  TraceAdd('Branch to '+W2S(IATmp));
  If InstLen=5 then begin
    DChar:=GetDChar;
    TraceAdd(' If Indicator Set "'+DChar+'" (');
    Case DChar of
      '/': TraceAdd('Unequal)');
      'S': TraceAdd('Equal)');
      'T': TraceAdd('Low)');
      'U': TraceAdd('High)');
      '@': TraceAdd('UNKNOWN FLAG)');
      'A': TraceAdd('Switch A)');
      'B': TraceAdd('Switch B)');
      'C': TraceAdd('Switch C)');
      'D': TraceAdd('Switch D)');
      'E': TraceAdd('Switch E)');
      'F': TraceAdd('Switch F)');
      'G': TraceAdd('Switch G)');
      Else Begin
             TraceAdd('INVALID d-char)');
//           RunEnabled:=False;
             Runstate:=RSEror;
           End;
    End;
  End;
  If InstLen=7 then
    TraceAdd(' *** extra 3 chars ignored***');
  If InstLen=8 then begin
    BATmp:=GetIAddr;
    DChar:=GetDChar;
    DCTmp:=Chr(GetCore(BATmp));
    TraceAdd(' If Char at '+W2S(BATmp)+' ("'+DCTmp+'") equals "'+DChar+'"');
  End;
End;
Procedure EBranch;
Begin
  BAReg:=IAReg;   // Indexing feature
  AAReg:=IATmp;
  If (InstLen=4) Or (InstLen=7) then begin
    IAReg:=IATmp;
  End;
  If InstLen=5 then begin
    Case DChar of
      '/': If UCInd then IAReg:=IATmp;
      'S': If ECInd then IAReg:=IATmp;
      'T': If LCInd then IAReg:=IATmp;
      'U': If HCInd then IAReg:=IATmp;
//    '@': IAReg:=IATmp;
      'A'..
      'G': If Pos(DChar,Switches)>0 then IAReg:=IATmp;
    End;
  End;
  If InstLen=8 then begin
    If DCTmp=DChar then IAReg:=IATmp;
  End;
End;

Procedure FBranchWMZ;
Var CC: Char;
    CN: Byte;
Begin
  IATmp:=GetIAddr;
  BATmp:=GetIAddr; DChar:=GetDChar;
  CC:=Chr(GetCore(BATmp)); Asc2NZ(CC,CN,CZTmp); WMTmp:=GetMark(BATmp);
  TraceAdd('Branch to '+W2S(IATmp)+' If WMZ at '+W2S(BATmp)+' ("'+CC+'") matches "'+DChar+'": ');
  Case DChar of
    '1': TraceAdd('Word Mark');
    '2': TraceAdd('No Zone');
    'B': TraceAdd('AB-Zone');
    'K': TraceAdd('B-Zone');
    'S': TraceAdd('A-Zone');
    '3': TraceAdd('No Zone or WM');
    'C': TraceAdd('AB-Zone or WM');
    'L': TraceAdd('B-Zone or WM');
    'T': TraceAdd('A-Zone or WM');
    Else Begin
           TraceAdd('INVALID d-char)');
//         RunEnabled:=False;
           Runstate:=RSEror;
         End;
  End;
End;
Procedure EBranchWMZ;
Begin
  BAReg:=IAReg;   // Indexing feature
  AAReg:=IATmp;
  Case DChar of
    '1': If WMTmp   then IAReg:=IATmp;
    '2': If CZTmp=0 then IAReg:=IATmp;
    'B': If CZTmp=3 then IAReg:=IATmp;
    'K': If CZTmp=2 then IAReg:=IATmp;
    '3': If (CZTmp=0) Or WMTmp then IAReg:=IATmp;
    'C': If (CZTmp=3) Or WMTmp then IAReg:=IATmp;
    'L': If (CZTmp=2) Or WMTmp then IAReg:=IATmp;
    'T': If (CZTmp=1) Or WMTmp then IAReg:=IATmp;
  End;
End;

Procedure FAdd;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then
      BATmp:=GetIAddr
    else
      BATmp:=AATmp;     // Add A to itself
  End;
//TraceAdd('Add '+W2S(AATmp)+' (+W2S(ATmp)+') to '+W2S(BATmp)+' (+W2S(BTmp)+')');
  TraceAdd('Add '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EAdd;
Var EF:    Boolean;
    OA,OB: Byte;
    VA,VB,DM: Longint;
    LB,RC: Byte;
    RS:    String;
    CC:    Word;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  VA:=0; VB:=0; DM:=1; LB:=0;
  Repeat
    OA:=GetCore(AAReg); OB:=GetCore(BAReg);
    OA:=OA-$30; OB:=OB-$30;
    VA:=VA+OA*DM; VB:=VB+OB*DM;
    DM:=DM*10;
    EF:=GetMark(AAReg) Or GetMark(BAReg);
    Dec(AAReg); Dec(BAReg); Inc(LB);
  Until EF Or Check;
  RS:=W2S(VB+VA); RC:=5;
  For CC:=1 to LB do begin
    SetCore(BATmp,Ord(RS[RC]));
    Dec(BATmp); Dec(RC);
  End;
  If TraceDets then
    TraceAdd('        => '+W2S(VB)+'+'+W2S(VA)+'='+RS);
End;

Procedure FSub;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then BATmp:=GetIAddr;
  End;
  TraceAdd('Subtract '+W2S(AATmp)+' from '+W2S(BATmp));
End;
Procedure ESub;
Var EF:    Boolean;
    OA,OB: Byte;
    VA,VB,DM: Longint;
    LB,RC: Byte;
    RS:    String;
    CC:    Word;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  VA:=0; VB:=0; DM:=1; LB:=0;
  Repeat
    OA:=GetCore(AAReg); OB:=GetCore(BAReg);
    OA:=OA-$30; OB:=OB-$30;
    VA:=VA+OA*DM; VB:=VB+OB*DM;
    EF:=GetMark(AAReg) Or GetMark(BAReg);
    Dec(AAReg); Dec(BAReg); Inc(LB);
  Until EF Or Check;
  RS:=W2S(VB-VA); RC:=5;
  For CC:=1 to LB do begin
    SetCore(BATmp,Ord(RS[RC]));
    Dec(BATmp); Dec(RC);
  End;
  If TraceDets then
    TraceAdd('        => '+W2S(VB)+'-'+W2S(VA)+'='+RS);
End;

Procedure FZeroAdd;
Begin
  AATmp:=AAReg; BATmp:=BAReg;
  If InstLen>1 then begin
    AATmp:=GetIAddr;
    If InstLen=7 then begin
      BATmp:=GetIAddr;
    End;
  End;
  TraceAdd('Add '+W2S(AATmp)+' to '+W2S(BATmp));
End;
Procedure EZeroAdd;
Var EF:    Boolean;
    OA,OB: Byte;
    VA,VB,DM: Longint;
    LB,RC: Byte;
    RS:    String;
    CC:    Word;
Begin
  AAReg:=AATmp; BAReg:=BATmp;
  VA:=0; VB:=0; DM:=1; LB:=0;
  Repeat
    OA:=GetCore(AAReg); OB:=GetCore(BAReg);
    OA:=OA-$30; OB:=OB-$30;
    VA:=VA+OA*DM; VB:=VB+OB*DM;
    DM:=DM*10;
    EF:=GetMark(AAReg) Or GetMark(BAReg);
    Dec(AAReg); Dec(BAReg); Inc(LB);
  Until EF Or Check;
  RS:=W2S(VB+VA); RC:=5;
  For CC:=1 to LB do begin
    SetCore(BATmp,Ord(RS[RC]));
    Dec(BATmp); Dec(RC);
  End;
  If TraceDets then
    TraceAdd('        => '+W2S(VB)+'+'+W2S(VA)+'='+RS);
End;

//******************************************************************************
//  Processing - Instruction Fetch
//------------------------------------------------------------------------------
procedure Fetch;
begin
  Try
    TraceAdd(W2S(IAReg)+' ');
    OpReg:=GetOpCod;
    If Check then Exit;
    TraceAdd(OpReg+' ');
    Case OpReg Of
      ',': FSetWM;
      'o': FClrWM;
      'N': FNOP;
      '/': FClearStg;
      'M': FMoveChars;
      'L': FLoadChars;
      'Y': FMoveZone;
      'D': FMoveNumerics;
      'Z': FMoveCharsSZ;
      '1': FReadCard;
      '2': FPrint;
      '3': FWriteAndRead;
      'F': FPrintCtrl;
      'K': FSelStacker;
      '.': FHalt;
      '#': FModifyAddr;
      'Q': FStoreAAReg;
      'H': FStoreBAReg;
      'C': FCompare;
      'B': FBranch;
      'V': FBranchWMZ;
      'A': FAdd;
      'S': FSub;
      'q': FZeroAdd;
      Else Begin
             TraceAdd('Invalid Opcode: $'+IntToHex(Ord(OpReg),2));
             TraceAdd(' Instruction Length='+IntToStr(InstLen));
//           RunEnabled:=False;
             Runstate:=RSEror;
           End;
    End;
  Except
  End;
  TracePut;
end;

//******************************************************************************
//  Processing - Instruction Execution
//------------------------------------------------------------------------------
procedure Execute;
begin
  Try
    Case OpReg Of
      ',': ESetWM;
      'o': EClrWM;
      'N': ENOP;
      '/': EClearStg;
      'M': EMoveChars;
      'L': ELoadChars;
      'Y': EMoveZone;
      'D': EMoveNumerics;
      'Z': EMoveCharsSZ;
      '1': EReadCard;
      '2': EPrint;
      '3': EWriteAndRead;
      'F': EPrintCtrl;
      'K': ESelStacker;
      '.': EHalt;
      '#': EModifyAddr;
      'Q': EStoreAAReg;
      'H': EStoreBAReg;
      'C': ECompare;
      'B': EBranch;
      'V': EBranchWMZ;
      'A': EAdd;
      'S': ESub;
      'q': EZeroAdd;
    End;
  Except
  End;
  If TraceRegs then begin
    TracePut;
    TraceAdd('        AAReg='+W2S(AAReg)+'  BAReg='+W2S(BAReg)+'  IAReg='+W2S(IAReg));
  End;
  TracePut;
end;

End.
