/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.209] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "w.h"
#include "r.h"
#include "p.h"

/*****************************************************************************
				1401 Simulator

	       Write Line, Read Card and Punch Card Instruction


	      Write Line, Read Card and Punch Card (One Address)
	      --------------------------------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
WRP		7	III		

Function: This is the same as the write-line-read-card-and-punch-card
instruction, except the next instruction is taken from the I-address instead
of from the next sequential instruction address.  The program branch occurs
after the input card has been read, the output card has been punched and the
output line written.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		181 or 081

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

	       Write Line, Read Card and Punch Card (No Address)
	       -------------------------------------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
WRP		7	

Function: This operation combines the operations of Write Line, Read Card, and
Punch Card.

The contents of locations 101-180 are transferred to the punch.

The contents of locations 201-332 are transferred to the printer.

A card is fed on the reader, and 80 columns of information are transferred to
memory locations 1..80.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		181 or 081

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_WRP
* Result: boolean
*       true if operation succeeded (excluding card reader errors)
*	false if operation failed
* Effect: 
*	Punches the contents of locations 101-180;
*       Reads a card into locations 1-80;
*	Writes the data from locations 201-332
****************************************************************************/

boolean inst_WRP()
    {
     tell_op(op_A);

     /* Do write first, in case read or punch should fail */

     if(!inst_W()) 
	return false;
     if(!inst_P()) 
	return false;
     if(!inst_R()) 
	return false;

     return true;
    }
