/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.105] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "w.h"
#include "r.h"

/*****************************************************************************
				1401 Simulator

			Write and Read Card Instruction


		       Write and Read Card (One Address)
		       ---------------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
WR		3	III		

Function: This is the same as the write-and-read-card instruction, except the
next instruction is taken from the I-address instead of from the next
sequential instruction address.  The program branch occurs after the card has
been read into storage and the line printed.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		081

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

		       Write and Read Card (No Address)
		       --------------------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
WR		3	

Function: This operation combines the operations of Write Line and Read Card.
The printer takes priority, and the printer cycle is completed before the
actual card reading takes place.

The contents of locations 201-332 are transferred to the printer.

A card is fed, and 80 columns of information are transferred to memory
locations 1..80.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		081

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_WR
* Result: boolean
*       true if operation succeeded (excluding card reader errors)
*	false if operation failed
* Effect: 
*	Writes the contents of locations 201-332;
*       Reads a card into locations 1-80;
****************************************************************************/

boolean inst_WR()
    {
     tell_op(op_A);

     if(!inst_W()) 
	return false;
     if(!inst_R()) 
	return false;

     return true;
    }
