/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.105] Created
* 30-Dec-85 | [1.283] Now handle I/O check stop switch
* 25-Feb-86 | [1.379] include <> => include ""
* 10-Nov-91 | [1.428] <jmn> converted for Microsoft C 6.0
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "cdr.h"
#include "alert.h"
#include "poll.h"
#include "ifetch.h"

/*****************************************************************************
				1401 Simulator

			   Read Card Instruction


			 Read Card (One Address)
			 -----------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
R		1	III		

Function: This is the same as the read-card instruction, except the next 
instruction is taken from the I-address instead of from the next sequential
instruction address.  The program branch occurs after the card has been
read into storage.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		081

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			 Read Card (No Address)
			 ----------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
R		1	

Function: A card is fed, and 80 columns of information are transferred to
memory locations 1..80.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		081

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_R
* Result: boolean
*       true if operation succeeded (excluding card reader errors)
*	false if operation failed
* Effect: 
*       Reads a card into locations 1-80;
****************************************************************************/

boolean inst_R()
    {
     tell_op(op_A);

     switch(I_cycle)
        { /* length dispatch */
	 case 1: /* Normal read */
	 	if(!read_card())
		   { /* failed */
		    alert(alert_reader);
		    return !IOcheck;
		   } /* failed */
		B_addr = 81;
		break;

	case 4: /* Read-and-branch */

		B_addr = I_addr;
		NI_addr = A_addr;

	 	if(!read_card())
		   { /* failed */
		    alert(alert_reader);
		    return !IOcheck;
		   } /* failed */

		poll();
		break;

	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */

     single_cycle_state = single_cycle_complete;
     tell_new_state("R");

     return true;
    }
