/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 12-Dec-85 | [1.178] Created change log
* 12-Dec-85 | [1.178] Changed console button position
* 22-Dec-91 | [1.507] <jmn> added prn_clear button
* 24-Dec-94 | [1.600J] JRJ added tape button
*****************************************************************************/
/*****************************************************************************
			      PERIPHERALS screen
*****************************************************************************/

/* The CONSOLE button */

#define console_X 67
#define console_Y 10

#define console_width 10
#define console_height 3

/* The TAPE button */

#define tape_X 70
#define tape_Y 14
#define tape_width 8
#define tape_height 3

/* The READER controls */

#define reader_X 0
#define reader_Y 4

#define cdr_clear_X (reader_X + 1)
#define cdr_clear_Y (reader_Y + 2)

#define cdr_name_X  (reader_X + button_width + 1)
#define cdr_name_Y  (reader_Y + 2)


/* The PRINTER controls */

#define printer_X 18
#define printer_Y 4

#define prn_form_X (printer_X + 1)
#define prn_form_Y (printer_Y + 2)

#define prn_line_X  (printer_X + button_width + 1)
#define prn_line_Y  (printer_Y + 2)

#define prn_clear_X (printer_X + 2*(button_width) + 1)
#define prn_clear_Y  (printer_Y + 2)

/* The PUNCH controls */

#define punch_X 0
#define punch_Y 11

#define cdp_clear_X (punch_X + 1)
#define cdp_clear_Y (punch_Y + 2)

#define cdp_name_X  (punch_X + button_width + 1)
#define cdp_name_Y  (punch_Y + 2)


/* The stack of input cards */

#define cardheight 4
#define cardwidth 24

#define cardbase_X 25
#define cardbase_Y (24 - cardheight)

#define cardoffset_X 3
#define cardoffset_Y 2

/* The card punch */

#define punchbase_X 0
#define punchbase_Y (24-cardheight)

void draw_peripherals_screen(void);
void check_peripherals(coord X,coord Y);
void draw_peripherals(void);
void do_peripherals(void);
