/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.205] Created
* 30-Dec-85 | [1.283] Handle I/O check stop switch
* 25-Feb-86 | [1.379] include<> => include ""
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0 libraries
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "cdp.h"
#include "alert.h"
#include "poll.h"
#include "ifetch.h"

/*****************************************************************************
				1401 Simulator

			    Punch Card Instruction


			   Punch Card (One Address)
			   ------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
P		4	III		

Function: This is the same as the punch-card instruction, except the next 
instruction is taken from the I-address instead of from the next sequential
instruction address.  The program branch occurs after the card has been
punched.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		181

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			    Punch Card (No Address)
			    -----------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
p		4	

Function: A card is fed, and 80 columns of information are transferred from
memory locations 101..180.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		181

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_P
* Result: boolean
*       true if operation succeeded (excluding card punch errors)
*	false if operation failed
* Effect: 
*       Punched a card into locations 101-180;
****************************************************************************/

boolean inst_P()
    {
     tell_op(op_A);

     switch(I_cycle)
        { /* length dispatch */
	 case 1: /* Normal punch */
	 	if(!punch_card())
		   { /* failed */
		    alert(alert_punch);
		    return !IOcheck;
		   } /* failed */
		B_addr = 181;
		break;

	case 4: /* Punch-and-branch */

		B_addr = I_addr;
		NI_addr = A_addr;

	 	if(!punch_card())
		   { /* failed */
		    alert(alert_punch);
		    return !IOcheck;
		   } /* failed */

		poll();
		break;

	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */

     single_cycle_state = single_cycle_complete;
     tell_new_state("P");

     return true;
    }
