/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.105] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "ifetch.h"
#include "poll.h"

/*****************************************************************************
				1401 Simulator

			       Halt Instruction


			     Halt (No Addresses)
			     -------------------

Instruction format

Mnemonic	Op Code	
--------        ------- 
H		.	

Function: This instruction causes the machine to stop and the stop-key
light to turn on.  Pressing the start key causes the program to start at
the next instruction in sequence.

Word Marks:  Word marks are not affected

Address Registers After Operation:

I-Add		A-Add		B-Add
NSI		Ap		Bp

Chaining: 

			      Halt (One Address)
			      ------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
H		.	III		

Function: This is the same as the halt instruction, except that the
next instruction is at the I-address.

Word Marks:  Word marks are not affected

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI

Chaining: 

			      Halt (Two Address)
			      ------------------
[NOTE: This is a valid instruction only on the 1440]

Instruction format

Mnemonic	Op Code	A-address B-address
--------        ------- --------- ---------
H		.	AAA	  BBB

Function: This is the same as the halt instruction

Word Marks:  Word marks are not affected

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		AAA		BBB


*****************************************************************************/

/****************************************************************************
*                                   inst_H
* Result: boolean
*       false, always (halt instructions always halt!)
* Effect: 
*       Halts the machine by returning a false value.  The NI register is
*	set up properly (so start-reset+start will go to NSI, but start
*	will branch if opcode was halt-and-branch)
****************************************************************************/

inst_H()
    {
     tell_op(op_A);

     switch(I_cycle)
        { /* decode */
	 case 1: /* halt */
	 	break;
	 case 4: /* halt and branch */
	 	B_addr = I_addr;
		NI_addr = A_addr;
		break;
	 default: /* Illegal length */
	  	illegal_length();
	  	return false;
	 
	} /* decode */

     single_cycle_state = single_cycle_complete;
     tell_new_state("H");
     return false;
    }
