/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Nov-85 | [1.20] Created
* 24-Nov-91 | [1.177] <jmn> memory.h => automem.h
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
* 24-Nov-91 | [1.177] <jmn> mach.h => machmem.h
*  3-Dec-91 | [1.220] <jmn> set C_bits on memory which has data
*****************************************************************************/

#include <boolean.h>
#include <stdio.h>
#include <asmops.h>
#include <automem.h>
#include <machmem.h>
#include <ste.h>
#include <pass1.h>
#include <pass2.h>
#include <list.h>
#include <bcd.h>
#include <chars.h>

extern int dot;
extern int sdot;
extern int star;
extern char line[81];

/****************************************************************************
*                                    machop
* Inputs:
*       int opindex: (not used)
*	int pass: 1 or 2
* Effect: 
*       Processes most machine operations
****************************************************************************/

void machop(int opindex,int pass)
    {
     switch(pass)
        { /* pass decode */	 
         case 1: label_1();
	 	 break;
	 case 2: label_2();
	 	 break;
	} /* pass decode */	 

     memory[check_memory(dot)] = C_bits | optable[opindex].opcode | word_mark;
     dot++;

     /* Now go parse operands */

     switch(pass)
        { /* pass decode */	 
         case 1: operands_1(opindex);
	 	 break;
	 case 2: operands_2(opindex);
		  /* Now we generate a listing file.  Everything from sdot to dot-1
		     is part of the instruction */

		 {
		  int i;

		  list_addr(sdot);

		  for(i=sdot;i<sdot+8;i++)
		      if(i<dot)
			 put_data(i-sdot,bcd_to_ascii(memory[i]));
		      else
			 put_data(i-sdot,' ');
		  list_line();
		  emit_listing();
		 }
	 	 break;
	} /* pass decode */	 

     star = dot;
     return;
    }
