/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 30-Nov-85 | [1.85] Created
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
*  5-Dec-91 | [1.248] <jmn> allow label and operand on LTORG
*****************************************************************************/
#include <boolean.h>
#include <pos.h>
#include <ste.h>
#include <sym.h>
#include <list.h>
#include <pass1.h>
#include <operand.h>
#include <operands.h>
#include <expr.h>
#include <error.h>
#include <err.h>

extern int line_number;
static void litop_1(void);
static void litop_2(void);

/****************************************************************************
*                                    litop
* Inputs:
*       int opindex: Op table index (irrelevant)
*	int pass: Pass (1 or 2)
* Effect: 
*       Handles 'lit' pseudo-op
****************************************************************************/

void litop(int opindex,int pass)
    {
     switch(pass)
        {
         case 1: litop_1();
	 	 break;
         case 2: litop_2();
	 	 break;
	}
    }

/****************************************************************************
*                                   litop_1
* Effect: 
*	Fiddles litpool and litoffset
****************************************************************************/

void litop_1()
    {
     unsigned start;
     int noperands;

     label_1();		/* process optional label */

     noperands = scan_operands();
     switch(noperands)
        { /* how many operands */
	 case 0:
		 litpool = dot;
		 break;
	 case 1:
		 if(!expr(operands[0],&litpool,true,expr_lit_illegal,1,true))
		    return;
		 break;
	 default:
		 error(err_operand,"LTORG has too many operands");
		 return;
	} /* how many operands */
     resolve_lits(line_number,"LIT pass 1");
     litoffset = 0;
     return;
    }

/****************************************************************************
*                                   litop_2
* Effect: 
*	Actually dumps the literals
****************************************************************************/

static void litop_2()
    {
     list_addr(sdot);
     list_line();
     emit_listing();
     dump_lits(line_number,"LIT pass 2");
    }
