/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.206] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 10-Nov-91 | [1.428] <jmn> converted for Microsoft C 6.0
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "p.h"
#include "r.h"

/*****************************************************************************
				1401 Simulator

		     Read Card and Punch Card Instruction


		    Read Card and Punch Card (One Address)
		       ---------------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
RP		5	III		

Function: This is the same as the read-card-and-punch-card instruction, except
the next instruction is taken from the I-address instead of from the next
sequential instruction address.  The program branch occurs after the card has
been read into storage and the output card punched.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		181

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

		     Read Card and Punch Card (No Address)
		     -------------------------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
RP		5	

Function: This operation combines the operations of Read Card and Punch Card.
The two functions overlap, and, in effect, take place simultaneously.

The contents of locations 101-180 are transferred to the punch.

A card is fed, and 80 columns of information are transferred to memory
locations 1..80.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		181

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_RP
* Result: boolean
*       true if operation succeeded (excluding card reader errors)
*	false if operation failed
* Effect: 
*	Punches the contents of locations 101-180;
*       Reads a card into locations 1-80;
****************************************************************************/

boolean inst_RP()
    {
     tell_op(op_A);

     /* Do punch first, in case read should fail */

     if(!inst_P()) 
	return false;
     if(!inst_R()) 
	return false;

     return true;
    }
