/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.199] Created change log
* 15-Dec-85 | [1.199] Added logic state L
* 15-Dec-85 | [1.201] Added compare_state
* 17-Dec-85 | [1.212] Added overflow
* 30-Dec-85 | [1.283] Added IOcheck
* 29-Jul-86 | [1.385] Added lamp_test
*  6-Aug-86 | [1.410] Made all byte extractions cast to unsigned char;
*           | properly parenthesized args
*  6-Aug-86 | [1.410] A_bits, B_bits, BA_bits now normal octal thingies
*           | again; (unsigned char) nnn is not ctce
* 10-Nov-91 | [1.428] <jmn> added ANSI headers
* 24-Nov-91 | [1.177] <jmn> removed macros to machmem.h so it can be shared
*           | with autocoder
*****************************************************************************/
#include "machmem.h"
extern unsigned char OP;
extern unsigned char B;
extern unsigned char A;
extern unsigned char L;

extern int A_addr;
extern int B_addr;
extern int I_addr;
extern int NI_addr;
extern unsigned char d_char;
extern int cycle;
extern int single_cycle_state; 
extern int compare_state;
extern boolean overflow;
extern boolean IOcheck;
extern boolean lamp_test;

extern int I_cycle;

#define cycle_none 0
#define cycle_I 1
#define cycle_A 2
#define cycle_B 3

/*  Single cycle state desciptions are found in appropriate .h files; 

    All state descriptions are opcode*100+substate.

    The base ones are found here:
*/

#define single_cycle_run  0
#define single_cycle_start 1
#define single_cycle_complete 2

#define single_cycle(op,microstate)  (op * 100 + microstate)

#define microstate(x) (x % 100)
#define macrostate(x) (x / 100)


/* Generic microstates: */

#define A_complete 1
#define B_complete 2
#define A_f_complete 3
#define A_s_complete 4
#define B_f_complete 5
#define B_s_complete 6

/* This is the base of instruction-specific microstate */

#define local_microstate 7

extern void diag_op(short mask);
extern void partial_display(void);
extern void display_state(void);
extern void stop(void);
extern void start(void);
extern void load_machine(void);
extern void require_reset(void);
extern void do_reset(void);
extern void set_wm(short addr);
extern void clear_wm(short addr);
extern boolean execute(void);
extern boolean inst_illegal(void);
extern char * single_cycle_decode(void);
extern void diag_state(void);
extern boolean bad_address(short addr);
extern boolean bad_address_r(short addr);
extern char * mode_decode(void);
extern void bad_d(char * msg, unsigned char d);

/****************************************************************************
*				 ValidNonZero
* Inputs:
*       int addr: Contents of an address register
* Result: boolean
*       true if address is valid
*	false if address is zero
****************************************************************************/

#define ValidNonZero(addr) ((addr) != 0)
