/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Nov-85 | [1.20] Created
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
*****************************************************************************/
#include <stdio.h>
#include <boolean.h>

#include <err.h>
#include <operands.h>
#include <expr.h>
#include <operand.h>
#include <error.h>
#include <ste.h>
#include <pass1.h>
#include <list.h>

extern int dot;
extern int star;
extern int sdot;
extern char line[81];
extern unsigned maxdot;
void orgop_1(void);
void orgop_2(void);

/****************************************************************************
*                                    orgop
* Inputs:
*       int opindex: Op table index (irrelevant)
*	int pass: Pass (1 or 2)
* Effect: 
*       Sets 'dot'
****************************************************************************/

void orgop(int opindex,int pass)
    {

     switch(pass)
        {
         case 1: orgop_1();
	 	 break;
         case 2: orgop_2();
	 	 break;
	}
    }

/****************************************************************************
*                               get_org_operand
* Inputs:
*	int pass: Pass #
* Effect: 
*       Scans the operand to the org
*	If valid, sets dot, star, etc. to that value
****************************************************************************/

void get_org_operand(int pass)
    {
     int orgcnt;
     unsigned orgval;

     orgcnt = scan_operands();

     if(orgcnt == 0)
        { /* missing */
	 error(err_operand,"ORG symbol requires operand");
	 return;
	} /* missing */
     if(orgcnt > 1)
        { /* too many */
	 error(err_operand,"ORG requires only one operand");
	} /* too many */
     
     if(!expr(operands[0],&orgval,true,expr_lit_illegal,pass,true)) 
	return;

     if(ixreg(orgval) != 0)
        { /* not ctce */
	 error(err_operand,"ORG expression must not be indexed");
	 return;
	} /* not ctce */

     sdot = dot = star = orgval;
    }

/****************************************************************************
*                                   orgop_1
* Effect: 
*       Installs the EQUed symbl
****************************************************************************/

static void orgop_1()
    {
     getlabelval * v;

     v = getlabel();

     if(v != NULL)
        { /* Don't want label on ORG */
	 error(err_label,"ORG must not have label");
	 return;
	} /* lose */

     /* Get org operand */

     get_org_operand(1);

    }

/****************************************************************************
*                                   orgop_2
* Effect: 
*       Checks the EQUed symbol
****************************************************************************/

static void orgop_2()
    {
     getlabelval * v;

     v = getlabel();

     if(v != NULL)
        { /* lose */
	 list_err(err_label);
	 return;	/* already reported in pass1 */
	} /* lose */

     get_org_operand(2);

     list_addr(sdot);
     list_line();
     emit_listing();

    }
