/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Nov-85 | [1.20] Created
*  1-Dec-85 | [1.90] Actually process END statement
* 24-Nov-91 | [1.177] <jmn> converted to C6.0
*****************************************************************************/

#include <stdio.h>
#include <boolean.h>

#include <err.h>

#include <operands.h>
#include <expr.h>
#include <error.h>
#include <list.h>
#include <expr.h>
#include <operand.h> 

extern boolean saw_end;
extern unsigned start;

/****************************************************************************
*                                  setstart
* Inputs:
*	int pass: pass #
* Effect: 
*       Sets the start address, if the operand is valid
****************************************************************************/

void setstart(int pass)
    {
     int noperands;

     noperands = scan_operands();

     if(noperands == 0)
        { /* missing label */
	 error(err_operand,"No start address given on END statement");
	 return;
	} /* missing label */

     if(noperands > 1)
        { /* too many */
	 error(err_operand,"Too many operands on END statement");
	} /* too many */

     expr(operands[0],&start,true,expr_lit_illegal,pass,false);
    }

/****************************************************************************
*                                    endop
* Inputs:
*       int opindex: (not used)
*	int pass: 1 or 2
* Effect: 
*       Handles 'end' directive
****************************************************************************/
/*ARGSUSED */

void endop(int opindex,int pass)
    {
     saw_end = true;
     switch(pass)
        { /* pass decode */
	 case 1: break;

	 case 2: setstart(pass);
	 	list_addr(start);
		list_line();
		emit_listing();
	 	break;
	} /* pass decode */
	 
     return;
    }
