.;
.;
.; MCEBLD.CMD -- Commandfile to build the MCE Commandline editor
.;
        .Sets VERS 	"V4.28"
.;
.;      Copyright (c) 1987-1998
.;
.;      J.H. Hamakers,
.;      pAkUiT International
.;      Elsbes 40
.;      3069 LN  Rotterdam
.;      The Netherlands
.;      Phone    : +31 - 10 - 407 86 31
.;      E-Mail   : hamakers@pobox.com
.;	Internet : http://members.tripod.com/~hans_hamakers
.;
.;      All rights reserved
.;
.;      This software may be copied and distributed ONLY
.;      on a non profit basis and with the inclusion of
.;      the above copyright statement.
.;
.;
.;      >>>>> PLEASE CONTACT ME FOR PROBLEMS OR SUGGESTIONS <<<<<
.;
.;       +---------------------------------------------------+
.;       | See MCEREL.TXT for information about this release |
.;       +---------------------------------------------------+
.;
        .Enable Global
        .Enable Substitution
        .Disable Display
.;
        .Sets IDNPRE	"10"		   ! Identcode for MCEPRE (OCTAL)
        .Sets SAVFIL    "MCESAVED.DAT"	   ! Saved Anwerfile
;
;       +---------------+
;       |   +-------+   |
;       |  /         \  |
;       | / D E C U S \ |   D E C U S  makes it work
;       | \   P D P   / |
;       |  \  S I G  /  |
;       |   +-------+   |
;       +---------------+
;
;MCEBLD.CMD -- Commandfile to build the MCE Commandline editor 'VERS'
        .If	<Cli> = "DCL" .Setf MCR
        .If	<Cli> = "MCR" .Sett MCR
        .IfDf	MCR	.Goto 10$
        .Disable	Quiet
;
;MCEBLD -- CLI  "'<Cli>'" not supported
;
        .Exit	<Severe>
.10$:
;
        .If P1 = "MAC"	.Goto	50$
        .If P1 = "LINK"	.Goto	50$
        .Disable	Quiet
;
; This Commandfile builds YOUR version of MCE. It prompts for several
; options to be build in MCE. It creates a conditional assembly 
; definition file called MCEPRE.MAC, two Commandfiles MCEASM.CMD and
; MCETKB.CMD and optionally a helpfile MCE.HLP. If you already have those
; files you can restart MCEBLD with "@MCEBLD MAC" to assemble and
; taskbuild or "@MCEBLD LINK" to taskbuild.
;
;*****
;
; MCEBLD can use saved answers from a previous session.
;
; MCEBLD can use the saved answers as default and still ask questions
; or it can directly use these answers and skip the questions which
; answers are defined.
; 
;
.20$:
	.Setf	SAV
	.Ask Q MCEBLD -- Do you have a saved answer file [D:N] : 
	.Iff Q	.Goto	40$
	.AskS [::SAVFIL] SAVFIL MCEBLD -- Name of the saved answer file [D:'SAVFIL'] : 
	.TestFile 'SAVFIL'
	.If <FilErr> Eq 1	.Goto	30$
	;
	;MCEBLD -- Error ! file 'SAVFIL' not found !
	;
	.Goto	20$
.30$:
        .Ask SAV MCEBLD -- Do you want to skip the questions [D:N] : 
	@'SAVFIL'
.40$:
;
;*****
;
; MCEBLD can save answers for a future session
;
	.Ask SAVOUT MCEBLD -- Do you want to save answers [D:N] : 
	.Iff	SAVOUT	.Goto	50$
	.AskS [::SAVFIL] SAVFIL MCEBLD -- Name of the saved answer file [D:'SAVFIL'] : 
.50$:
        .IfNdf	$A$SV	.Setf	$A$SV	! Conditional for CRW/ASV 
        .If P1 = "ASV"	.Sett	$A$SV	!   Erasmus university R'dam
	.Ift	$A$SV	.Sets	$INIDR "[2,2]"	!  Change MCE.MAC to change 
.;						!   directory
	.IfNdf $INIDR	.Sets	$INIDR "[1,2]"	! Init-file directory
.;						!  Change MCE.MAC to change 
.;						!    directory
	.IfNdf PLUS	.Setf	PLUS
	.IfNdf $PRO	.Setf	$PRO
.;
	.If <System> =  6 .Sett	PLUS
	.IfNdf $PRO	.If <System> = 11	.Sett	$PRO
	.Sets	HLPCHR	" ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	.Setn	HLPNR	1.
	.Sets	MAXHLP	HLPCHR[HLPNR:HLPNR]
        .If P1 = "MAC"	.Goto	MAC
        .If P1 = "LINK"	.Goto	LINK
	.Ift $PRO	.Goto	60$
;
;*****
	.IfNdf $CLS	.Goto	55$
	.Ift SAV ;                 -- Multiple CLI support included    : '$CLS'
	.Ift SAV	.Goto	60$
.55$:
;
; The standard CLI (Commandline Interpreter) of RSX is MCR.
; When your system supports the use of other CLIs such as DCL than
; include multiple CLI support in MCE.
;
	.IfNdf $CLS	.SetF	$CLS
	.Iff $CLS	.Sets	X "N"
	.Ift $CLS	.Sets	X "Y"
	.Ask [$CLS] $CLS MCEBLD -- Want the multiple CLI support [D:'X'] ? 
;
.60$:
;*****
	.IfNdf $INI	.Goto	70$
	.Ift SAV ;                 -- MCE Init-file support            : '$INI'
	.Ift SAV	.Goto	140$
.70$:
;
; When Init-file support is included MCE reads initialization files
	.Iff $CLS ; which can contain Commanddefinitions Internal- and MCR-Commands.
	.Ift $CLS ; which can contain Commanddefinitions Internal- and CLI-Commands.
;
; Files are searched in this order:
;
        .Iff $CLS	.Goto	100$
        .Iff PLUS	.Goto	80$
;     LB:'$INIDR'MCEINI.xxx
;     followed by one of the two:
;        either     SY:[CurDir]MCEINI.xxx
;        or         SYS$LOGIN:MCEINI.xxx
;     depending on the next question about the MCE Init-file user default 
;     directory.
	.Goto	90$
.80$:
;     LB:'$INIDR'MCEINI.xxx, followed by SY:[CurDir]MCEINI.xxx,
.90$:
;
; where "xxx" is the name of the CLI defined for the terminal invoking 
; MCE and "CurDir" is the default directory at the startup of MCE.
        .Goto	130$
.100$:
        .Iff PLUS	.Goto	110$
;     LB:'$INIDR'MCEINI.CMD
;     followed by one of the two:
;        either     SY:[CurDir]MCEINI.CMD
;        or         SYS$LOGIN:MCEINI.CMD
;     depending on the next question about the MCE Init-file user default 
;     directory.
	.Goto	120$
.110$:
;     LB:'$INIDR'MCEINI.CMD, followed by SY:[CurDir]MCEINI.CMD,
.120$:
;
; where "CurDir" is the default directory at the startup of MCE.
.130$:
;
; This algorithm divides Commanddefinitions into 2 groups:
; A system-wide set in LB:'$INIDR', followed by a users private set.
;
	.IfNdf $INI	.Setf	$INI
	.Iff $INI	.Sets	X "N"
	.Ift $INI	.Sets	X "Y"
	.Ask [$INI] $INI MCEBLD -- Want the MCE Init-file support [D:'X'] ? 
;
.140$:
	.Iff $INI	.Goto	150$
	.Iff PLUS	.Goto	150$
;*****
	.IfNdf $SYL	.Goto	145$
	.Ift SAV ;                 -- SYS$LOGIN support included       : '$SYL'
	.Ift SAV	.Goto	150$
.145$:
;
; MCE can read the user''s Commanddefinitions from the current disk and
; directory or from the user''s login directory SYS$LOGIN: . MCE will
; check for the presence of Logical Name support before trying to read
; from SYS$LOGIN on your system and fall back to SY:[CurDir] if your
; system has no logical name support.
;
	.IfNdf $SYL	.Setf	$SYL
	.Iff $SYL	.Sets	X "N"
	.Ift $SYL	.Sets	X "Y"
	.Ask [$SYL] $SYL MCEBLD -- Want to read Commandfile from SYS$LOGIN: [D:'X'] ? 
;
.150$:
	.IfNdf $SYL	.Setf	$SYL
;*****
	.IfNdf $CMP	.Goto	160$
	.Ift SAV ;                 -- Compound Command support         : '$CMP'
	.Ift SAV	.Goto	170$
.160$:
;
; MCE allows definitions of compound Commands.
; Using the ampersand (&) sign one can define an MCE Command as a 
	.Iff $CLS	; sequence of multiple MCR Commands :
	.Ift $CLS	; sequence of multiple CLI Commands :
;
;               E.g.    +>STAT := TIM & PIP /LI & ACT /ALL ..... etc.
;
; or directly:  E.g.    +>MAC @TASKASM & TKB @TASKTKB
;
	.IfNdf $CMP	.Setf	$CMP
	.Iff $CMP	.Sets	X "N"
	.Ift $CMP	.Sets	X "Y"
	.Ask [$CMP] $CMP MCEBLD -- Want the compound Command support [D:'X'] ? 
;
.170$:
;*****
	.IfNdf $STA	.Goto	180$
	.Ift SAV ;                 -- Statusline support               : '$STA'
	.Ift SAV	.Goto	190$
.180$:
;
; It is possible to include statusline support.
; The statusline shows the different settings and FIFO-parameters of 
; MCE and can be switched on/off with MCE STATus on/off
; Line 24 is used for status information.
;
	.IfNdf $STA	.Setf	$STA
	.Iff $STA	.Sets	X "N"
	.Ift $STA	.Sets	X "Y"
	.Ask [$STA] $STA MCEBLD -- Want Statusline/Statusmessage support [D:'X'] ? 
.190$:
	.IfNdf $STADF	.Setf	$STADF
	.Iff $STADF	.Sets	X "N"
	.Ift $STADF	.Sets	X "Y"
	.Iff SAV .Ask [$STADF] $STADF MCEBLD -- Want statusline ON by default         [D:'X'] ? 
	.Ift SAV .Ift $STA ;                 -- Statusline ON by default         : '$STADF'
	.Iff Sav	;
;*****
	.IfNdf $SIL	.Goto	200$
	.Ift SAV ;                 -- Startup and Exit messages support: '$SIL'
	.Ift SAV	.Goto	210$
.200$:
;
; The startup and exit messages like :
;
	.Iff $CLS ;     "MCE -- MCR Commandline Editor 'VERS'"   and   "MCE -- Exit"
	.Ift $CLS ;     "MCE -- CLI Commandline Editor 'VERS'"   and   "MCE -- Exit"
;
; are optional.
;
	.IfNdf $SIL	.Setf	$SIL
	.Iff $SIL	.Sets	X "N"
	.Ift $SIL	.Sets	X "Y"
	.Ask [$SIL] $SIL MCEBLD -- Want Startup and exit messages [D:'X'] ? 
;
.210$:
	.Ift $PRO	.Goto	290$
;*****
	.IfNdf $RTVAL	.Goto	220$
	.IfNdf $HTVAL	.Goto	220$
	.Ift SAV	.Goto	230$
.220$:
;
; When starting MCE via a remote terminal (RT: or HT:) problems may occur
; if the local system is VMS with its Commandline editor enabled.
; MCE can detect if it was started via a remote terminal and can do
; 3 different things :
;
;	1. Give the following message:
;
;            MCE -- ** WARNING ** Started on a Remote Terminal.
;                   If your local system is OpenVMS with its Commandline 
;                   editor enabled please type "MCE EXIT"
;
;	2. Give the following message and exit :
;
;            MCE -- Started on a Remote Terminal. Exiting .....
;
;	3. Do nothing
;
	.IfNdf $RTVAL	.Setn	$RTVAL 1.
        .Askn [1.:3.:$RTVAL] $RTVAL MCEBLD -- Which option for RT: [D:'$RTVAL'] : 
	.IfNdf $HTVAL	.Setn	$HTVAL 1.
        .Askn [1.:3.:$HTVAL] $HTVAL MCEBLD -- Which option for HT: [D:'$HTVAL'] : 
;
.230$:
	.Setf	RTMESS
	.Setf	RTEXIT
	.Setf	HTMESS
	.Setf	HTEXIT
	.If $RTVAL = 1	.Sett	RTMESS
	.If $RTVAL = 2	.Sett	RTEXIT
	.If $HTVAL = 1	.Sett	HTMESS
	.If $HTVAL = 2	.Sett	HTEXIT
	.Ift SAV ;                 -- RT messages                      : 'RTMESS'
	.Ift SAV ;                 -- RT Exit                          : 'RTEXIT'
	.Ift SAV ;                 -- HT messages                      : 'HTMESS'
	.Ift SAV ;                 -- HT Exit                          : 'HTEXIT'
;*****
	.IfNdf $VT2	.Goto	240$
	.Ift SAV ;                 -- VT2plus support                  : '$VT2'
	.Ift SAV	.Goto	250$
.240$:
;
; VT2plus support enables the use of VT2xx, VT3xx, VT4xx and VT5xx
; terminals. The keys <F11>, <F12> and <F13> work as <ESC>, <BS> and 
; <LF>. The keys <HELP>, <DO> etc. can also be used and it is possible
; to define the Functionkeys <F6>..<F20> like :
;
;     "F6 := TIM"
;
; pushing <F6> gives the time of day then.
;
	.IfNdf $VT2	.Setf	$VT2
        .Iff $VT2	.Sets	X "N"
        .Ift $VT2	.Sets	X "Y"
        .Ask [$VT2] $VT2 MCEBLD -- Want the VT2plus support [D:'X'] ? 
;
.250$:
;*****
	.Iff $VT2	.Goto	270$
	.IfNdf $VT4	.Goto	260$
	.Ift SAV ;                 -- VT4plus support                  : '$VT4'
	.Ift SAV	.Goto	270$
.260$:
;
; On a VT4xx and a VT5xx terminal it is possible to use <F1>..<F5> as 
; normal Functionkeys.
; VT4plus support enables you to define those keys too if you answer "Y" 
; to the following question.
;
	.IfNdf $VT4	.Setf	$VT4
        .Iff $VT4	.Sets	X "N"
        .Ift $VT4	.Sets	X "Y"
	.Ask [$VT4] $VT4 MCEBLD -- Want the VT4plus support  [D:'X'] ? 
;
.270$:
;*****
	.IfNdf $TD2	.Goto	280$
	.Ift SAV ;                 -- Tandberg TDV2230 support         : '$TD2'
	.Ift SAV	.Goto	290$
.280$:
;
; The keys of a Tandberg TDV2230 terminal can also be defined.
;
	.IfNdf $TD2	.Setf	$TD2
        .Iff $TD2	.Sets	X "N"
        .Ift $TD2	.Sets	X "Y"
	.Ask [$TD2] $TD2 MCEBLD -- Want the Tandberg TDV2230 function key support [D:'X'] ? 
;
.290$:
;*****
	.IfNdf $EDT	.Goto	300$
	.Ift SAV ;                 -- EDT-Keypad support               : '$EDT'
	.Ift SAV	.Goto	310$
.300$:
;
	.Iff $PRO ; Some edit functions can be performed on the VTxxx keypad, similar
	.Ift $PRO ; Some edit functions can be performed on the PRO keypad, similar
; to EDT, KED and K52.
; The Keypad-editing can be switched on/off with MCE KEYPad on/off
;
	.IfNdf $EDT	.SetF	$EDT
        .Iff $EDT	.Sets	X "N"
        .Ift $EDT	.Sets	X "Y"
	.Ask [$EDT] $EDT MCEBLD -- Want the EDT-Keypad editing support   [D:'X'] ? 
.310$:
	.IfNdf $EDTDF	.SetF	$EDTDF
	.Iff $EDTDF	.Sets	X "N"
	.Ift $EDTDF	.Sets	X "Y"
	.Iff SAV .Ask [$EDTDF] $EDTDF MCEBLD -- Want EDT-Keypad editing ON by default [D:'X'] ? 
	.Ift SAV .Ift $EDT ;                 -- EDT-Keypad ON by default         : '$EDTDF'
	.Iff SAV ;
;*****
	.IfNdf $EXTPR	.Goto	320$
	.Ift SAV ;                 -- Extended Prompt support          : '$EXTPR'
	.Ift SAV	.Goto	330$
.320$:
;
; The MCE prompt can show if overstrike or insert mode is active
; by "+" and "-".
; It can also display if EDT-Keypad editing (when selected)
; is enabled when the statusline is off by ":"
;
;     e.g.    "+:>"
;
; The Extended Prompt can be switched on/off with MCE PROMpt on/off
;
	.IfNdf $EXTPR	.SetF	$EXTPR
        .Iff $EXTPR	.Sets	X "N"
        .Ift $EXTPR	.Sets	X "Y"
	.Ask [$EXTPR] $EXTPR MCEBLD -- Want the Extended Prompt           [D:'X'] ? 

.330$:
	.IfNdf $PRMDF	.SetF	$PRMDF
	.Iff $PRMDF	.Sets	X "N"
	.Ift $PRMDF	.Sets	X "Y"
	.Iff SAV .Ask [$PRMDF] $PRMDF MCEBLD -- Want Extended Prompt ON by default [D:'X'] ? 
	.Ift SAV .Ift $EXTPR ;                 -- Extended Prompt ON by default    : '$PRMDF'
	.Iff SAV ;
;*****
	.IfNdf $UPR	.Goto	340$
	.Ift SAV ;                 -- User Prompt support              : '$UPR'
	.Ift SAV	.Goto	350$
.340$:
;
; MCE can accept a User Prompt.
; This prompt can be specified with  MCE USPRompt <UserPrompt>.
; The maximum prompt size is 20 characters.
;
	.IfNdf $UPR	.SetF	$UPR
        .Iff $UPR	.Sets	X "N"
        .Ift $UPR	.Sets	X "Y"
	.Ask [$UPR] $UPR MCEBLD -- Want the User Prompt               [D:'X'] ? 
;
.350$:
;*****
	.IfNdf $PWD	.Goto	360$
	.Ift SAV ;                 -- Password Locking                 : '$PWD'
	.Ift SAV	.Goto	370$
.360$:
;
; MCE can lock a terminal with a password.
; Almost like the LOCK Command from Digital''s terminal servers.
; The maximum password-length is 8 characters.
;
	.IfNdf $PWD	.SetF	$PWD
        .Iff $PWD	.Sets	X "N"
        .Ift $PWD	.Sets	X "Y"
	.Ask [$PWD] $PWD MCEBLD -- Want the terminal password locking [D:'X'] ? 
;
.370$:
;*****
	.IfNdf $INSDF	.Goto	380$
	.IfNdf $OVSDF	.Goto	380$
	.Ift SAV ;                 -- Insert mode default              : '$INSDF'
	.Ift SAV ;                 -- Overstrike mode default          : '$OVSDF'
	.Ift SAV	.Goto	390$
.380$:
;
; By default overstrike or insert mode stays active until it is
.Iff $VT2 ; changed with <CTRL/A>.  MCE can be build so that it sets 
.Ift $VT2 ; changed with <CTRL/A> or <F14>. MCE can be build so that it sets
; one of the modes active by default when it prompts for a new 
; Command. This can be changed with the MCE INSErt on/off and the 
; MCE OVERstrike on/off Commands.
;
	.IfNdf $INSDF	.SetF	$INSDF
        .Iff $INSDF	.Sets	X "N"
        .Ift $INSDF	.Sets	X "Y"
	.Ask [$INSDF] $INSDF MCEBLD -- Want MCE to set insert mode back by default     [D:'X'] ? 
	.IfNdf $OVSDF	.SetF	$OVSDF
        .Iff $OVSDF	.Sets	X "N"
        .Ift $OVSDF	.Sets	X "Y"
	.Iff $INSDF .Ask [$OVSDF] $OVSDF MCEBLD -- Want MCE to set overstrike mode back by default [D:'X'] ? 
;
.390$:
;*****
	.IfNdf $OLDDF	.Goto	400$
	.Ift SAV ;                 -- Save OLD Commands                : '$OLDDF'
	.Ift SAV	.Goto	410$
.400$:
;
; Default "old" Commands (retrieved from the FIFO and not edited) are 
; saved again in the FIFO. MCE can be build so that it does not save
; them again.
; This mode can be changed with the  MCE SVOLd on/off Command.
;
;
	.IfNdf $OLDDF	.SetF	$OLDDF
        .Iff $OLDDF	.Sets	X "N"
        .Ift $OLDDF	.Sets	X "Y"
	.Ask [$OLDDF] $OLDDF MCEBLD -- Want MCE to save "Old" Commands by default [D:'X'] ? 
;
.410$:
;*****
	.IfNdf $INTDF	.Goto	420$
	.Ift SAV ;                 -- Save Internal Commands           : '$INTDF'
	.Ift SAV	.Goto	430$
.420$:
;
; Default internal Commands are saved in the FIFO. MCE can be build 
; so that it does not save them.
; This mode can be changed with the  MCE SVINtern on/off Command.
;
;
	.IfNdf $INTDF	.SetF	$INTDF
        .Iff $INTDF	.Sets	X "N"
        .Ift $INTDF	.Sets	X "Y"
	.Ask [$INTDF] $INTDF MCEBLD -- Want MCE to save Internal Commands by default [D:'X'] ? 
;
.430$:
	.Ift $PRO	.Goto	460$
;*****
	.IfNdf $TMO	.Goto	440$
	.Ift SAV ;                 -- Time-Out Support                 : '$TMO'
	.Ift SAV	.Goto	450$
.440$:
;
; When terminal Time-Out support is included the terminal is logged 
; out after a given Time-Out time (TT0: only exits MCE).
; Optionally you can select a fixed Time-Out time or select that the
; user can  change the time.
;
	.IfNdf $TMO	.SetF	$TMO
        .Iff $TMO	.Sets	X "N"
        .Ift $TMO	.Sets	X "Y"
	.Ask [$TMO] $TMO MCEBLD -- Want the terminal Time-Out support           [D:'X'] ? 
.;
.450$:
	.IfNdf $TMS	.SetF	$TMS
	.Ift SAV .Ift $TMO ;                 -- Time-Out Support change          : '$TMS'
        .Iff $TMS	.Sets	X "N"
        .Ift $TMS	.Sets	X "Y"
	.Iff SAV .Ift $TMO .Ask [$TMS] $TMS MCEBLD -- Want to enable the user to change the values [D:'X'] ? 

	.IfNdf $TMON	.SetN	$TMON 4.
	.Ift SAV .Ift $TMO ;                 -- Time-Out value                   : '$TMON'
	.Iff $TMS 	.SetS 	T "Enter number of Time-Out minutes        "
	.Ift $TMS 	.SetS 	T "Enter default number of Time-Out minutes"
	.Iff SAV .Ift $TMO .Askn [2.:999.:$TMON] $TMON MCEBLD -- 'T'     [2..999  D:'$TMON'] : 
	.IfNdf $TMODF 	.SetF	$TMODF
	.Ift SAV .Ift $TMO ;                 -- Time-Out default ON              : '$TMODF'
        .Iff $TMODF	.Sets	X "N"
        .Ift $TMODF	.Sets	X "Y"
.Iff SAV .Ift $TMO .Ift $TMS .Ask [$TMODF] $TMODF MCEBLD -- Want the Time-Out to be ON by default         [D:'X'] ? 
;
.460$:
;*****
	.IfNdf $MINCH	.Goto	470$
	.Ift SAV ;                 -- Minimum Commandline length       : '$MINCH%D'
	.Ift SAV	.Goto	480$
.470$:
;
; Only Commandlines with a length greater than or equal to a given 
; length are saved in the FIFO.
; The value can be changed with the MCE CMSZ n Command.
; Use a value of 79 if you don''t want to save at all.
;
	.IfNdf $MINCH	.SetN	$MINCH 4.
        .Askn [1.:79.:$MINCH] $MINCH MCEBLD -- Enter minimum Commandline length [1..79  D:'$MINCH%D'] : 
;
.480$:
;*****
	.IfNdf $MAXFI	.Goto	490$
	.Ift SAV ;                 -- Maximum FIFO length              : '$MAXFI%D'
	.Ift SAV	.Goto	500$
.490$:
;
; Specify the default maximum number of Commands which can be saved
; in the FIFO. The value can be changed with the MCE FISZ n Command.
; Note that the actual number of Commands that can be saved depends
; on the size of the Commands and the available MCE pool space.
; Information about MCE''s poolspace can be obtained by the 
; MCE FREE Command.
; More poolspace can be created by installing MCE with a larger 
; increment.  INS $MCE/INC=xxx
; A value of 2400 will be enough in most cases.
;
	.IfNdf $MAXFI	.Iff $STA	.SetN	$MAXFI 23.
	.IfNdf $MAXFI	.Ift $STA	.SetN	$MAXFI 22.
	.Askn [1.:99.:'$MAXFI%D'.] $MAXFI MCEBLD -- Enter maximum number of entries in FIFO [1..99  D:'$MAXFI%D'] : 
;
.500$:
        .Iff PLUS	.Goto	540$
;*****
	.IfNdf $MU	.Goto	510$
	.Ift SAV ;                 -- Multi User task                  : '$MU'
	.Ift SAV	.Goto	520$
.510$:
;
	.IfNdf $MU 	.SetF	$MU
        .Ask [$MU] $MU  MCEBLD -- Build MCE as a multi-user task   [D:'$MU'] ? 
.520$:
	.IfNdf $ID 	.Goto	530$
	.Ift SAV ;                 -- I&D Space task                   : '$ID'
	.Ift SAV	.Goto	540$
.530$:
;
	.IfNdf $ID	.SetF	$ID
        .Ask [$ID] $ID  MCEBLD -- Build MCE as an I & D Space task [D:'$ID'] ? 
.540$:
	.IfNdf $MU 	.SetF	$MU
	.IfNdf $ID	.SetF	$ID
        .If P1 <> "ALL"	.Goto	550$
        .Sett	$HLP
        .Sett	$COP
        .Goto	610$
.550$:
;
;*****
;
; A helpfile MCE.HLP customized to your selections is created 
; dynamically if you answer "Y" to the following question.
	.Iff $VT2 .Goto 560$
; Note that if you don''t build the helpfile now, you can''t use 
; the <NEXT-SCREEN> and <PREV-SCREEN> keys to walk through the helpfile.
.560$:
;
	.IfNdf $HLP 	.SetF	$HLP
        .Iff $HLP	.Sets	X "N"
        .Ift $HLP	.Sets	X "Y"
        .Ask [$HLP] $HLP MCEBLD -- Create helpfile on LB: [D:'X'] ? 
        .Ift $A$SV  .OR	.Iff $HLP	.Goto	600$
	.IfNdf $HLPDR	.Goto	570$
	.Ift SAV ;                 -- Help directory                   : '$HLPDR'
	.Ift SAV	.Goto	580$
.570$:
;
	.IfNdf $HLPDR	.Sets	$HLPDR "[1,2]"
	.Asks [::$HLPDR] $HLPDR MCEBLD -- What is your Help Directory [D:'$HLPDR'] : 
;
.580$:
;*****
	.IfNdf $HLPNW	.Goto	590$
	.Ift SAV ;                 -- VERSION 2 Helpfile               : '$HLPNW'
	.Ift SAV	.Goto	600$
.590$:
;
; The helpfile can be created in two different versions.
;
; VERSION 1 :  You can access this one by typing HELP MCE [topic.....] 
;              but you have to include a reference like :
;                    1 MCE
;                    @MCE
;              in  MCR.HLP and DCL.HLP
;
; VERSION 2 :  You can access this one by typing HELP /MCE [topic.....]
;              This version does not need any editing of MCR.HLP and 
;              DCL.HLP
;
	.IfNdf $HLPNW	.SetF	$HLPNW
        .Iff $HLPNW	.Sets	X "N"
        .Ift $HLPNW	.Sets	X "Y"
        .Ask [$HLPNW] $HLPNW MCEBLD -- Do you want VERSION 2 [D:'X'] ? 
.600$:
;
;*****
;
	.IfNdf $COP	.SetF	$COP
        .Iff $COP	.Sets	X "N"
        .Ift $COP	.Sets	X "Y"
        .Ask [$COP] $COP MCEBLD -- When ready and successful copy MCE.TSK to LB: device [D:'X'] ? 
	.IfNdf $SYSDR	.Sets	$SYSDR <LibUic>
	.Ift $COP .Asks [::$SYSDR] $SYSDR MCEBLD -- What is your Task Directory [D:'$SYSDR'] : 
	.IfNdf $INS	.SetF	$INS
        .Iff $INS	.Sets	X "N"
        .Ift $INS	.Sets	X "Y"
        .Ift $COP .Ask [$INS] $INS MCEBLD -- Install task [D:'X'] ? 
	.IfNdf $PRI	.SetF	$PRI
        .Iff $PRI	.Sets	X "N"
        .Ift $PRI	.Sets	X "Y"
        .Ask [$PRI] $PRI MCEBLD -- Print listing and map [D:'X'] ? 
.610$:
;
	.;
	.IfNdf $SRC	.SetS $SRC "MCE.MAC"
	.Iff SAV .Goto 615$
	.TestFile '$SRC'
	.If <FilErr> Ne 1	.Goto	612$
        .Ask Q MCEBLD -- Use the sourcefile '$SRC' [D:N] ? 
	.Ift Q	.Goto	615$
	.Goto	613$
.612$:
;MCEBLD -- Error ! file '$SRC'  not found !	
;
.613$:
	.AskS [::$SRC] $SRC MCEBLD -- File specification for MCE source [D:'$SRC'] : 
	.Goto	610$
.615$:

;MCEBLD -- All questions asked .....
;
	.IFF SAVOUT .GOTO 620$
;MCEBLD -- Creating saved answer file 'SAVFIL' 
        .Open 'SAVFIL'
	.Data .;
        .Data .;  MCE - Saved answer file 'SAVFIL'
        .Data .;
        .Data .; Created on '<Date>' '<Time>' by MCEBLD.CMD Version: 'VERS'
	.Data .;
	.Data .; MCE Ident code  'IDNPRE'
	.Data .;
	.Data	.Enable Global
	.Data 	.Set'$A$SV'	$A$SV	! ASV environment (Not used in normal cases)
	.Data	.Set'$PRO'	$PRO 	! Target is a PRO-3xx system (In test)
	.Data	.Set'$CLS'	$CLS	! Multiple CLI support
	.Data	.Set'$INI'	$INI	! Init-file support
	.Data	.Set'$SYL'	$SYL	! SYS$LOGIN support
	.Data	.Set'$CMP'	$CMP	! Compound Commandline support
	.Data	.Set'$STA'	$STA	! Statusline Commandline support
	.Data	.Set'$STADF'	$STADF	! Statusline ON Default
	.Data	.Set'$SIL'	$SIL	! Startup & Exit messages
	.Data	.SetN	$RTVAL	'$RTVAL'	! RT Handling value
	.Data	.SetN	$HTVAL	'$HTVAL'	! HT Handling value
	.Data	.Set'$VT2'	$VT2	! VT2Plus support
	.Data	.Set'$VT4'	$VT4	! VT4Plus support
	.Data	.Set'$TD2'	$TD2	! Tandberg TV2230 support
	.Data	.Set'$EDT'	$EDT	! Keypad editing support
	.Data	.Set'$EDTDF'	$EDTDF	! Keypad editing support default ON
	.Data	.Set'$EXTPR'	$EXTPR	! Extended Prompt support
	.Data	.Set'$PRMDF'	$PRMDF	! Extended Prompt support default ON
	.Data	.Set'$UPR'	$UPR	! User Prompt  support
	.Data	.Set'$PWD'	$PWD	! Password locking support
	.Data	.Set'$INSDF'	$INSDF	! Insert mode default
	.Data	.Set'$OVSDF'	$OVSDF	! Overstrike mode default
	.Data	.Set'$OLDDF'	$OLDDF	! Save OLD Commands default
	.Data	.Set'$INTDF'	$INTDF	! Save Internal Commands default
	.Data	.Set'$TMO'	$TMO	! Time-Out support
	.Data	.Set'$TMS'	$TMS	! Time-Out change support
	.Data	.SetN	$TMON	'$TMON%D'.	! Time-Out time
	.Data	.Set'$TMODF'	$TMODF	! Time-Out default ON
	.Data	.SetN	$MINCH	'$MINCH%D'.	! Minimal Command length to save
	.Data	.SetN	$MAXFI	'$MAXFI%D'.	! Max. FIFO length
	.Data	.Set'$MU'	$MU	! Multi-User
	.Data	.Set'$ID'	$ID	! I&D Space
	.Data	.Set'$HLP'	$HLP	! Create Helpfile
	.Data	.SetS	$HLPDR	"'$HLPDR'"	! Helpfile directory
	.Data	.Set'$HLPNW'	$HLPNW	! VERSION 2 Help
	.Data	.Set'$COP'	$COP	! Copy Taskimage
	.Data	.SetS	$SYSDR	"'$SYSDR'"	! System Directory
	.Data	.SetS	$SRC	"'$SRC'"	! Source file
	.Data	.Set'$INS'	$INS	! Install Task
	.Data	.Set'$PRI'	$PRI	! Print Listings
	.Close
        .Ift MCR 	PIP 'SAVFIL'/PU/NM
        .Iff MCR 	PURGE 'SAVFIL'
.620$:


        .Iff $HLP .Goto 650$
;MCEBLD -- Creating helpfile LB:'$HLPDR'MCE.HLP .....
.;
	.Iff $A$SV .Ift $HLPNW 	.Setn LEVEL 1
	.Iff $A$SV .Iff $HLPNW 	.Setn LEVEL 2
	.Ift $A$SV 		.Setn LEVEL 3
        .Open LB:'$HLPDR'MCE.HLP
			.Data MCE 'VERS' - Commandline Editor options :
			.Data - Support is included for the following options :
.Ift $SIL    		.Data   . Startup and exit messages
.Iff $PRO .Ift $VT2 .Iff $VT4    	.Data   . VT2plus support
.Iff $PRO .Ift $VT4    	.Data   . VT2plus and VT4plus support
.Ift $PRO 		.Data   . PRO Functionkeys
.Ift $TD2		.Data   . TDV2230 Functionkeys
.Ift $INI .Iff $SYL	.Data   . MCE Init-files
.Ift $INI .Ift $SYL	.Data   . MCE Init-files read from LB:'$INIDR' and SYS$LOGIN:
.Iff $PRO .Ift $CLS	.Data   . Multiple CLI
.Ift $EDT .Iff $EDTDF	.Data   . EDT-Keypad editing - default OFF
.Ift $EDT .Ift $EDTDF	.Data   . EDT-Keypad editing - default ON
.Ift $STA .Ift $STADF 	.Data   . Statusline - default ON
.Ift $STA .Iff $STADF 	.Data   . Statusline - default OFF
.Ift $OLDDF 		.Data   . Save "Old" Commands - default ON
.Iff $OLDDF 		.Data   . Save "Old" Commands - default OFF
.Ift $INTDF 		.Data   . Save Internal Commands - default ON
.Iff $INTDF 		.Data   . Save Internal Commands - default OFF
.Ift $INSDF 		.Data   . Auto Insert mode - default ON
.Ift $OVSDF 		.Data   . Auto Overstrike mode - default ON
.Ift $HLPNW 		.Data   . HELP /MCE
.Ift $CMP  		.Data   . Compound Commandlines
.Ift $TMO .Iff $TMS	.Data   . Terminal Time-Out ('$TMON%D'. minutes) fixed
.Ift $TMO .Ift $TMS .Iff $TMODF	.Data   . Terminal Time-Out ('$TMON%D'. minutes) - default OFF
.Ift $TMO .Ift $TMS .Ift $TMODF	.Data   . Terminal Time-Out ('$TMON%D'. minutes) - default ON
.Ift $EXTPR .Iff $PRMDF	.Data   . Extended Prompt - default OFF
.Ift $EXTPR .Ift $PRMDF	.Data   . Extended Prompt - default ON
.Iff $UPR .Ift $PWD	.Data   . Terminal Password Locking
.Ift $UPR .Iff $PWD	.Data   . User Prompt
.Ift $UPR .Ift $PWD	.Data   . User Prompt and Terminal Password Locking
.Ift RTMESS .Ift HTMESS .Data   . RT: and HT: detection (Message)
.Ift RTMESS .Iff HTMESS	.Data   . RT: detection (Message)
.Iff RTMESS .Ift HTMESS	.Data   . HT: detection (Message)
.Ift RTEXIT .Ift HTEXIT .Data   . RT: and HT: detection (Exit)
.Ift RTEXIT .Iff HTEXIT .Data   . RT: detection (Exit)
.Iff RTEXIT .Ift HTEXIT	.Data   . HT: detection (Exit)
.If $MINCH = 1		.Data - Default all Commands are saved. (CMSZ = 1)
.If $MINCH > 1		.Data - Default only Commands which contain '$MINCH%D' or more characters are saved.
			.Data   To change this use the "MCE CMSZ n" Command (see INTERNAL)
			.Data - Default the savebuffer can contain up to '$MAXFI%D' Commandlines.
			.Data   To change this value use the "MCE FISZ n" Command (see INTERNAL)
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; --KEYS1 ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			
.Enable Data
#KEYS1
.Disable Data
			.Data 'LEVEL' KEYS1
.Ift $EDT 		.Data MCE 'VERS' - Commandline Editor Non-keypad editing and cursormovement Commands
.Iff $EDT 		.Data MCE 'VERS' - Commandline Editor Editing and cursormovement Commands :
			.Data
			.Data  <LEFT>      or <CTRL/D> - Move Cursor Left
			.Data  <RIGHT>     or <CTRL/F> - Move Cursor Right
			.Data  <BACKSPACE> or <CTRL/H> - Move Cursor to Begin of Line
			.Data  <CTRL/E>                - Move Cursor to End of Line
			.Data  <TAB>       or <CTRL/I> - Move one Word to the right or move from EOL to BOL
			.Data  <DELETE>                - Delete Character Left of Cursor
			.Data  <CTRL/V>                - Delete Character at Cursor
			.Data  <LINEFEED>  or <CTRL/J> - Delete Word Left of Cursor
			.Data  <CTRL/W>                - Delete Word Right at Cursor
			.Data  <CTRL/U>                - Delete from Cursor to Begin of Line
			.Data  <CTRL/K>                - Delete from Cursor to End of Line
			.Data  <CTRL/C>                - Delete whole line
			.Data  <CTRL/R>                - Rewrite Line
.Iff $VT2		.Data  <CTRL/A>                - Switch between Overstrike and Insert mode
.Ift $VT2		.Data  <CTRL/A>    or  <F14>   - Switch between Overstrike and Insert mode
.Ift $EXTPR	 	.Data    If Extended Prompt is on the current mode is shown by first prompt character
.Ift $EXTPR 		.Data                                  "+" Insert mode.    "-" overstrike mode.
			.Data
.Iff $EDT 		.Data More help : KEYS2 COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS2 COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; --KEYS2 ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#KEYS2
.Disable Data
			.Data 'LEVEL' KEYS2
.Ift $EDT 		.Data MCE 'VERS' - Commandline Editor Non-keypad keys :
.Iff $EDT 		.Data MCE 'VERS' - Commandline Editor keys :
			.Data
			.Data Save and execute :
			.Data  <RETURN>    or <ENTER>    - Execute Command
.Ift $VT2 		.Data  <ESC><ESC>  or <DO>       - Execute Command without waiting
.Iff $VT2 		.Data  <ESC><ESC>                - Execute Command without waiting
			.Data  <CTRL/X>                  - Execute Cmd and leave FIFO-pointer where it is
			.Data  <CTRL/N>                  - Save Command without executing
			.Data  <CTRL/T>                  - Enable output from other tasks: Detach 10 sec.
			.Data  <CTRL/P>                  - Enable output from other tasks: Suspend MCE
.Ift $EDT		.Data Non-keypad Command buffer manipulation keys :
.Iff $EDT		.Data Command buffer manipulation keys :
			.Data  <PF4>       or <ESC>S     - Display contents of FIFO
			.Data  <UP>        or <CTRL/B>   - Retrieve previous Command
			.Data  <DOWN>                    - Reverse of <UP> (next Command)
.Iff $VT2 		.Data  <PF2>       or <ESC>Q     - Recall Command previously requested. (see RECALL)
.Ift $VT2 		.Data  <PF2> or <FIND> or <ESC>Q - Recall Command previously requested. (see RECALL)
.Ift $EDT		.Data Non-keypad Help keys :
.Iff $EDT		.Data Help keys:
.Ift $VT2 		.Data  <HELP> or <CTRL/?>        - Gives HELP about MCE
.Iff $VT2 		.Data  <CTRL/?>                  - Gives HELP about MCE
.Ift $VT2 		.Data  <PRV-SCREEN>/<NXT-SCREEN> - Gives Previous/Next HELP screen
.Ift $EDT		.Data Non-keypad Command translation keys :
.Iff $EDT		.Data Command translation keys :
			.Data  <PF1>       or <ESC>P     - Translate Command without execution
			.Data  <PF3>       or <ESC>R     - Show Command Translation Buffer
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- COMMANDLINES  ------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#COMMANDLINES
.Disable Data
			.Data 'LEVEL' COMMANDLINES
			.Data MCE 'VERS' - Commandline Editor Commandlines :
			.Data  The maximum length of Commandlines is 78 characters.
			.Data  If the Commandline starts with "MCE" an Internal Command is assumed. Other
.Iff $CLS		.Data  Commandlines are checked for translation and the result is spawned to MCR.
.Ift $CLS		.Data  Commandlines are checked for translation and the result is spawned to the
.Ift $CLS		.Data  current Commandline interpreter for the invoking terminal.
.Iff $CLS .Iff $PRO	.Data  Special action is performed with "BYE". (See INTERNAL)
.Ift $CLS		.Data  Special action is performed with "BYE" and "LOG[out]". (See INTERNAL)
.Ift $CMP		.Data  A Commandline can consist of a single Command or can contain more Commands
.Ift $CMP		.Data  separated by " &". (Note the space to let PIP /TD&/LI still work.)
.Ift $CMP		.Data  A Command behind a "&" will only be processed when the former was successful.
.Ift $CMP		.Data  A compound Commandline may also contain Internal Commands in a mixture with
.Ift $CMP		.Data  normal CLI Commands. Only the first Command is checked for translation.
			.Data
.If $MINCH = 1		.Data  Normally all Commandlines are saved in the FIFO-buffer. This may be changed
.If $MINCH = 1		.Data  with the "MCE CMSZ n" Command. (See INTERNAL)
.If $MINCH > 1		.Data  Normally all Commandlines which contain '$MINCH'. or more characters are saved
.If $MINCH > 1		.Data  in the FIFO-buffer. This may be changed with "MCE CMSZ n" (See INTERNAL)
			.Data  When '$MAXFI'. entries are present, or when no buffer space is available to hold
			.Data  more entries, the new Command is saved and the oldest disappears.
			.Data  Retrieved Commandlines from the FIFO are only saved again if they are
			.Data  edited or when the saving is enabled by "MCE SVOL ON" (Save "OLD" Commands)
			.Data  and this Commandline is not the newest in the FIFO. This prevents filling 
			.Data  up your FIFO with one Command by continuously repeating the last Command.
			.Data  Internal Commands are saved when this is enabled by "MCE SVIN ON".
			.Data  (Save "INTERNAL Commands)
.Iff $EDT 		.Data More help : KEYS  TRANS  FUNC  START  EXIT  INTERNAL  RECALL
.Ift $EDT 		.Data More help : KEYS  TRANS  FUNC  START  EXIT  INTERNAL  RECALL  KEYPAD
.; -- TRANS1  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#TRANS1
.Disable Data
			.Data 'LEVEL' TRANS1
			.Data MCE 'VERS' - Commandline Editor Command translations :
			.Data
			.Data  A Command may be defined by:
.Iff $CMP		.Data         +>CNAM := <TRANSLATION_OF_COMMAND>
.Ift $CMP  		.Data         +>CNAM := <TRANSL_OF_COMMAND> [& <TRANSL_OF_COMMAND> [& .....]]
			.Data  where CNAM is the Command name which will be substituted by the text at the
			.Data  right side of the ":=".
.Ift $CMP		.Data  A Command behind  " &" will only be processed when the former was successful.
			.Data  NOTE: The ":=" must be preceded and followed by at least a single space or TAB
			.Data  e.g.:  +>HE := HELP PIP        ! 
			.Data         +>HE                    ! Will request "HELP PIP"
.Iff $EDT		.Data  The <PF1> or <ESC>P key translates the Command without execution.
.Ift $EDT		.Data  With Keypad disabled <PF1> or <ESC>P translates the Command without execution.
			.Data
			.Data  If you enter a predefined Command followed by additional text, this additional
			.Data  text will normally be appended as a whole.
			.Data  e.g.:  +>HE /RE                ! Will request "HELP PIP /RE
			.Data  or:    +>HE /RE<PF1>           ! Will be translated and displayed
			.Data  result +>HELP PIP /RE
			.Data
			.Data  You may delete a Command translation entry by redefining it to null.
			.Data  e.g.:  +>HE :=                 ! Delete above definition
			.Data
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS2 FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS2 FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- TRANS2  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#TRANS2
.Disable Data
			.Data 'LEVEL' TRANS2
			.Data MCE 'VERS' - Commandline Editor Command translations (continued) :
			.Data
			.Data  Abbreviate Commands by separating the optional part by "*"
			.Data  e.g.:  +>HP*IP := HELP PIP
			.Data  This Command may now be requested with:
			.Data         +>HP or HPI or HPIP  etc.
			.Data
			.Data  More sophisticated is the Parameter-Substitution, similar to the
			.Data  indirect Commandfile processor.
			.Data  e.g.:  +>DIR*ECTORY := PIP ''P1''/LI
			.Data         +>COP*Y := PIP ''P2''/NV/CD=''P1''
			.Data         +>DIR                   ! Will be translated into "PIP /LI"
			.Data         +>DIREC FIL             ! Will be translated into "PIP FIL/LI"
			.Data         +>COPY A.CMD [200,200]  ! Will simulate DCL COPY Command
.Ift $INI 		.Data  Note that Commanddefinitions may be performed from the Commandfile
.Ift $INI .Iff $CLS .Iff $SYL .Data         LB:'$INIDR'MCEINI.CMD  and  SY:[CurDir]MCEINI.CMD
.Ift $INI .Ift $CLS .Iff $SYL .Data         LB:'$INIDR'MCEINI.xxx  and  SY:[CurDir]MCEINI.xxx
.Ift $INI .Iff $CLS .Ift $SYL .Data         LB:'$INIDR'MCEINI.CMD  and  SYS$LOGIN:MCEINI.CMD
.Ift $INI .Ift $CLS .Ift $SYL .Data         LB:'$INIDR'MCEINI.xxx  and  SYS$LOGIN:MCEINI.xxx
.Ift $INI 		.Data  which will always be read when MCE is started.
.Ift $INI .Iff $SYL	.Data         [CurDir] = the default directory at the startup of MCE.
.Ift $INI .Ift $CLS 	.Data         xxx      = CLI name
.Ift $INI 		.Data  Files are read in the order they are mentioned above.
			.Data
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- FUNC  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#FUNC
.Disable Data
			.Data 'LEVEL' FUNC
			.Data MCE 'VERS' - Commandline Editor Functionkeys :
			.Data
			.Data  You may request a Command with Functionkeys <PF1>, <PF2>, <PF3> or <PF4>
			.Data  It is also possible to request Commands with control keys. (e.g. <CTRL/G>)
.Ift $VT2 		.Data  On a VT2xx/VT3xx/VT4xx/VT5xx-Keyboard  you can also define the Functionkeys 
.Ift $VT2 .Iff $VT4	.Data  <F6>..<F20> and <FIND> <INSERT HERE> etc.
.Ift $VT2 .Ift $VT4	.Data  <F6>..<F20> and <FIND> <INSERT HERE> etc.  On a VT4xx also <F1>..<F5>
.Ift $TD2 		.Data  On a TDV2230 you can also define the Functionkeys <F1>..<F7>
			.Data  Define the Command translation as "''key'' := Command".
			.Data  e.g.   +>PF2 := TIM            ! Redefine <PF2> function key
			.Data         <PF2>                   !  to display the current time
.Ift $VT2 .OR .Ift $TD2 	.Data         +>F6 := ACT             ! Define F6 function key
.Ift $VT2 .OR .Ift $TD2 	.Data         <F6>                    !  to display the active tasks
.Ift $VT2 		.Data  The keys <FIND> etc. must be entered as F$a  where "a" is the  first char.
.Ift $VT2 		.Data  of the key function.  e.g.  "F$P" for <PREV-SCREEN>    (English text)
			.Data  Define a control key as follows :
			.Data  e.g.   +>^G := SET /DEF        ! Define <CTRL/G> key
			.Data         <CTRL/G>                !  to display the current directory
			.Data  Note that the following control-keys CANNOT be defined:
			.Data  <CTRL/M> = <RETURN>,  <CTRL/O>,  <CTRL/Q>,  <CTRL/S>,  <CTRL/[> = <ESC>
			.Data  Next to the rest of the Alphabetic characters the following keys can
			.Data  be defined : <CTRL/\>,  <CTRL/]>,  <CTRL/^>,  <CTRL/?>
.Iff $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  START  EXIT  INTERNAL  RECALL
.Ift $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  START  EXIT  INTERNAL  RECALL  KEYPAD
.; -- START ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#START
.Disable Data
			.Data 'LEVEL' START
			.Data MCE 'VERS' - Commandline Editor Startup
			.Data
			.Data  Invoke MCE with Command "MCE" (at best in LOGIN.CMD with ".XQT MCE").
.Iff $INI .Goto 630$
.Ift $CLS		.Data  A File of Commanddefinitions, CLI Commands and/or Internal Commands will be 
.Iff $CLS		.Data  A File of Commanddefinitions, MCR Commands and/or Internal Commands will be
			.Data  read at MCE startup time. The file may be specified in the form 
			.Data "MCE <startup_file>".
			.Data  If no startup file is specified in the Commandline (the normal case),
			.Data  files are read in this order:
.Ift $CLS 		.Data     LB:'$INIDR'MCEINI.xxx,        followed by
.Ift $CLS .Iff $SYL	.Data     SY:[CurDir]MCEINI.xxx,
.Ift $CLS .Ift $SYL	.Data     SYS$LOGIN:MCEINI.xxx,
.Ift $CLS 		.Data  Where "xxx" is the name of the CLI defined for the terminal invoking MCE
.Ift $CLS .Iff $SYL	.Data  and [CurDir] is the default directory at the startup of MCE.
.Iff $CLS 		.Data     LB:'$INIDR'MCEINI.CMD,        followed by
.Iff $CLS .Iff $SYL	.Data     SY:[CurDir]MCEINI.CMD,
.Iff $CLS .Ift $SYL	.Data     SYS$LOGIN:MCEINI.CMD,
.Iff $CLS .Iff $SYL	.Data  [CurDir] is the default directory at the startup of MCE.
			.Data  This algorithm divides Commanddefinitions into two groups:
			.Data  A system-wide set in LB:'$INIDR', followed by a users private set.
			.Data  Overriding the default filename in the Commandline invoking MCE offers
			.Data  the possibility to tailor an application specific Command set.
.630$:
			.Data
.Iff $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  EXIT  INTERNAL  RECALL
.Ift $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  EXIT  INTERNAL  RECALL  KEYPAD
.; -- EXIT ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#EXIT
.Disable Data
			.Data 'LEVEL' EXIT
			.Data MCE 'VERS' - Commandline Editor Exit
			.Data
			.Data   To exit MCE operations, use the "MCE EXIT" internal Command.
			.Data   or <CTRL/Y>
			.Data   More about internal Commands see help MCE INTERNAL.
			.Data
.Iff $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  START  INTERNAL  RECALL
.Ift $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  START  INTERNAL  RECALL  KEYPAD
.; -- INTERNAL -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#INTERNAL
.Disable Data
			.Data 'LEVEL' INTERNAL
			.Data MCE 'VERS' - Commandline Editor Internal Commands (MCE xxxx)
		        .Data    CLEA/PURG: Delete all Commands in Command FIFO/Translation buffer
		        .Data    CMSZ n   : Changes Minimal Commandline length to be saved to "n"
		        .Data    ECHO     : Commandlines are echoed on TI: (useful in Init-iles)
		        .Data    EXIT     : MCE task exit (return to the normal Command environment.)
		        .Data    FISZ n   : Changes FIFO-size to "n" (if enough memory)
		        .Data    FREE     : Display MCE Pool info (largest_block:Total_free_blocks:fragments)
			.Data    INSE xx  : Auto Insert mode on/off       (xx = on / off)
.Ift $EDT 		.Data    KEYP xx  : Set Keypad editing on/off     (xx = on / off)
.Ift $PWD	        .Data    LOCK     : Terminal password Locking
		        .Data    LIST/RING: FIFO is a list/ring : UP and DOWN stop/roll  at the end
			.Data    OVER xx  : Auto Overstrike mode on/off   (xx = on / off)
.Ift $EXTPR		.Data    PROM xx  : Extended Prompt on/off        (xx = on / off)
.Ift $INI 		.Data    READ file: Read Commands from specified file (same as CHAI file)
.Ift $INI 		.Data    REPL file: Combines PURGe and READ.
.Ift $STA 		.Data    STAT xx  : Statusline on/off/show        (xx = on / off / "blank")
		        .Data    SVIN xx  : Save internal Commands on/off (xx = on / off)
		        .Data    SVOL xx  : Save "old" Commands on/off    (xx = on / off)
.Ift $TMO .Ift $TMS       .Data    TIMO xxx : Sets Time-Out Value (ON/OFF or 2-999 minutes)
.Ift $UPR		.Data    USPR xx  : Define User Prompt          |  INTERNAL2  gives you an 
.Ift $UPR	        .Data    VERS     : Show MCE Version            |  explanation of internal Commands.
.Iff $UPR	        .Data    VERS     : Show MCE Version 
.Iff $UPR		.Data         INTERNAL2 gives you an explanation of internal Commands.
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL2 RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL2 RECALL KEYPAD
.; -- INTERNAL2 -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#INTERNAL2
.Disable Data
			.Data 'LEVEL' INTERNAL2
			.Data MCE 'VERS' - Commandline Editor Internal Commands (continued)
			.Data
.Iff $CLS .Iff $PRO	.Data   Two Command verbs are specially handled by MCE : "BYE" and "MCE".
.Iff $CLS .Iff $PRO	.Data   "BYE" is sent to MCR and MCE exits immediately.
.Ift $CLS		.Data   Three Command verbs are specially handled by MCE: "BYE", "LOG[out]" and "MCE".
.Ift $CLS		.Data   "BYE" and when in DCL "LOG[out]" result in a spawn of "BYE" to MCR and MCE
.Ift $CLS		.Data   exits immediately.
.Iff $PRO		.Data   Note that you may define any other string (e.g. GOODBYE) to result
.Iff $CLS .Iff $PRO	.Data   in BYE.
.Ift $CLS .Iff $PRO	.Data   in BYE or LOGOUT.
			.Data   Commands starting with "MCE" are treated as internal Commands and not passed
.Iff $CLS		.Data   to MCR. Following the verb "MCE " a four character action specifier
.Ift $CLS		.Data   to the CLI. Following the verb "MCE " a four character action specifier
.Ift $PRO		.Data   to the CLI. Following the verb "MCE " a four character action specifier
			.Data   defines the action wanted.
.Iff $INI .Goto 650$
			.Data   The READ and REPLACE options, if no file is specified, follow the
.Iff $CLS .Goto 640$
			.Data   the same filename convention as at startup: the files according
			.Data   to the current CLI are read in, i.e. the Command "MCE REPLace"
			.Data   effects in a MCE restart (but the FIFO-buffer is kept), useful
			.Data   after a SET TERMINAL <new_cli> Command.
.Ift $SYL		.Data   When a space is given as filename, only SYS$LOGIN:MCEINI.xxx is read.
.Iff $SYL		.Data   When a space is given as filename, only SY:[CurDir]MCEINI.xxx is read.
.Iff $SYL		.Data   [CurDir] is the default directory at the moment of the Command.
	.Goto 650$
.640$:
			.Data   the same filename convention as at startup: the Init-files
			.Data   are read in, i.e. the Command "MCE REPLace" effects in an MCE restart
			.Data   (but the FIFO-buffer is kept).
.Ift $SYL		.Data   When a space is given as filename, only SYS$LOGIN:MCEINI.xxx is read.
.Iff $SYL		.Data   When a space is given as filename, only SY:[CurDir]MCEINI.xxx is read.
.Iff $SYL		.Data   [CurDir] is the default directory at the moment of the Command.
.650$:
			.Data
.Iff $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.Ift $EDT 		.Data More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- RECALL -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#RECALL
.Disable Data
			.Data 'LEVEL' RECALL
			.Data MCE 'VERS' - Commandline Editor Recall function
			.Data
			.Data  Recalling a Command is done by entering the first part of a Command
			.Data  which was previously executed, terminated by the function key <PF2>,
.Iff $VT2		.Data  by <UP> if UPFInd is enabled or by <ESC>Q.
.Ift $VT2		.Data  by <UP> if UPFInd is enabled, by <ESC>Q or by <FIND>.
			.Data  This will find the last Command already executed starting with the
			.Data  string entered.  The Command may be edited or executed by pressing
			.Data  the return key. A second <PF2> keystroke searches further back in the
			.Data  FIFO. When no string is entered, the last defined string is taken.
			.Data  Note that the function key <PF2> may not have any superimposed
			.Data  translation defined (by defining "PF2 := .....").  Example :
			.Data     +>DIR X.DAT        ! Previously entered Command
			.Data     +>DMP X.DAT        !     "          "      "
			.Data
			.Data     +>D<PF2>           ! Will recall the last Command starting with "D":
			.Data     						+>DMP X.DAT
			.Data     +><PF2>            ! Will recall the for last Command:
			.Data     						+>DIR X.DAT
			.Data     +>DI<PF2>          ! Will recall the Command:
			.Data     						+>DIR X.DAT
			.Data
.Iff $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  START  EXIT  INTERNAL
.Ift $EDT 		.Data More help : KEYS  COMMANDLINES  TRANS  FUNC  START  EXIT  INTERNAL  KEYPAD
.Iff $EDT .Goto 660$
.; -- KEYPAD  -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.Sets MAXHLP HLPCHR[HLPNR:HLPNR]
			.Data 'LEVEL' MCE'MAXHLP'
			.Enable Data
#KEYPAD
.Disable Data
			.Data 'LEVEL' KEYPAD
			.Data MCE 'VERS' - Commandline Editor EDT-Keypad and Functionkeys :
			.Data  +--------+-----------------+    +--------+--------+--------+--------+
			.Data  |        |                 |    |\\\\\\\\|        |        | DelLin |
			.Data  |  Help  |  Execute NoWait |    |\\Gold\\| KPHelp | Recall | ------ | <F11>
			.Data  |        |                 |    |\\\\\\\\|        |        |\UndLin |  = ESC
			.Data  +--------+--------+--------+    +--------+--------+--------+--------+
			.Data  | (Find) | Insert | Re-    |    |        | ShoCmd | ShoFif | DelWrd | <F12>
			.Data  | Recall |  Here  |  move  |    | Transl | ------ | ------ | ------ |  = BegLin
			.Data  |        |        |        |    |        |\\Vers\\|\\Free\\|\UndWrd\|
			.Data  +--------+--------+--------+    +--------+--------+--------+--------+ <F13>
			.Data  |        |  Prev  |  Next  |    | Detach |        |  Cut   | DelChr |  = DelWrd
			.Data  | Select |  Help  |  Help  |    | ------ |        | ------ | ------ |    Right
			.Data  |        |(Screen)|(Screen)|    |\Suspnd\|        |\Paste\\|\UndChr\|
			.Data  +--------+--------+--------+    +--------+--------+--------+--------+ <F14>
			.Data           |  Prev  |             |        |  EOL   |        |        |  = Ins/Ov
			.Data           | Command|             |  Word  | ------ | Do Stay| Enter  |
			.Data           |        |             |        |\DelLin\|\       |        |
			.Data  +--------+--------+--------+    +--------+--------+--------+ ------ |
			.Data  |        |  Next  |        |    |    BegLine      | Select |\\\\\\\\|
			.Data  |  <-    | Command|   ->   |    | --------------- | ------ |\\Save\\|
			.Data  |        |        |        |    |\\\\ClrLine\\\\\\|\Reset\\|\\\\\\\\|
			.Data  +--------+--------+--------+    +-----------------+--------+--------+
.660$:
	.Close
        .Ift MCR 	PIP LB:'$HLPDR'MCE.HLP/PU/NM
        .Iff MCR	PURGE LB:'$HLPDR'MCE.HLP
.670$:
;MCEBLD -- Creating configuration prefixfile MCEPRE.MAC .....
        .Open MCEPRE.MAC
        .Data   .SBTTL MCE - Configuration prefixfile MCEPRE.MAC
        .Data ;
        .Data ; MCE Macro Prefixfile
        .Data ; Created on '<Date>' '<Time>' by MCEBLD.CMD Version: 'VERS'
	.Data ;
		.Data IDNPRE   = 'IDNPRE'    ; Identcode of MCEPRE.MAC
.Ift $A$SV      .Data A$SV     = 1     ; EUR - CRW/ASV support
.Ift $CLS    	.Data CLISUP   = 1     ; Multiple CLI support
.Ift $CMP    	.Data COMPND   = 1     ; Compound Command (&) support
.Ift $EDT    	.Data EDT      = 1     ; EDT-Keypad support included
.Ift $EDT .Iff $EDTDF 	.Data EDTDEF   = 0     ; EDT-Keypad off by default
.Ift $EDTDF 	.Data EDTDEF   = 1     ; EDT-Keypad on by default
.Ift $UPR 	.Data UPR      = 1     ; User Prompt
.Ift $PWD 	.Data PWD      = 1     ; Terminal password locking
.Ift $EXTPR 	.Data EXTNPR   = 1     ; Extended Prompt included
.Ift $EXTPR .Iff $PRMDF .Data PRMDEF   = 0     ; Extended Prompt off by default
.Ift $EXTPR .Ift $PRMDF .Data PRMDEF   = 1     ; Extended Prompt on by default
.Ift $PRO    	.Data PRO      = 1     ; PRO SYSTEM
.Ift $INI    	.Data FILE     = 1     ; MCE Init-file support included
.Ift $SYL	.Data SYLOGIN  = 1     ; Read MCEINI from SYS$LOGIN:
.Ift $HLPNW 	.Data HLPNEW   = 1     ; "HELP /" support
.Iff $INSDF 	.Data INSDEF   = 0     ; Not return to insert mode by default
.Ift $INSDF 	.Data INSDEF   = 1     ; Return to insert mode by default
.Iff $INTDF 	.Data INTDEF   = 0     ; Not save internal Commands by default
.Ift $INTDF 	.Data INTDEF   = 1     ; Save internal Commands by default
.Iff $OLDDF 	.Data OLDDEF   = 0     ; Not save old Commands by default
.Ift $OLDDF 	.Data OLDDEF   = 1     ; Save old Commands by default
.Iff $OVSDF 	.Data OVSDEF   = 0     ; Not return to overstr.-mode by default
.Ift $OVSDF 	.Data OVSDEF   = 1     ; Return to overstr.-mode by default
.Ift RTMESS	.Data RTMESS   = 1     ; RT: detection (Message)
.Ift RTEXIT	.Data RTEXIT   = 1     ; RT: detection (Exit)
.Ift HTMESS	.Data HTMESS   = 1     ; HT: detection (Message)
.Ift HTEXIT	.Data HTEXIT   = 1     ; HT: detection (Exit)
.Iff $SIL    	.Data SILENT   = 1     ; No Startup and exit messages
.Ift $STA    	.Data STATUS   = 1     ; Statusline support
.Ift $STA .Iff $STADF 	.Data STADEF   = 0     ; Statusline off by default
.Ift $STADF 	.Data STADEF   = 1     ; Statusline on by default
.Ift $VT2    	.Data VT2XX    = 1     ; VT2plus support included
.Ift $VT4    	.Data VT4XX    = 1     ; VT4plus support included
.Ift $TD2    	.Data TDV2XX   = 1     ; TDV2230 support included
.Ift $TMO   	.Data TMOTIM   = '$TMON'.     ; Time-Out support '$TMON'. Minutes.
.Ift $TMO .Ift $TMS	.Data TMOSET   = 0     ; Time-Out setable
.Ift $TMO .Ift $TMS .Iff $TMODF	.Data TMOON    = 0     ; Time-Out OFF by default
.Ift $TMO .Ift $TMS .Ift $TMODF	.Data TMOON    = 1     ; Time-Out ON by default
        .Data MAXFIF   = '$MAXFI%D'.	 ; Maximal number of entries in FIFO
	.Data MAXHLP   = '''MAXHLP'	 ; Highest available Helppage
	.Data MINCHR   = '$MINCH%D'.	 ; Minimal cmd-line length to be saved
        .Close
        .Ift MCR 	PIP MCEPRE.MAC/PU/NM
        .Iff MCR 	PURGE MCEPRE.MAC
;MCEBLD -- Creating MAC-Commandfile MCEASM.CMD .....
        .Open MCEASM.CMD
        .Data ;
        .Data ; MCE Macro buildfile
        .Data ; Created on '<Date>' '<Time>' by MCEBLD.CMD Version: 'VERS'
        .Data ;
        .Data MCE,MCE/CR/-SP=MCEPRE,'$SRC'
        .Close
        .Ift MCR 	PIP MCEASM.CMD/PU/NM
        .Iff MCR 	PURGE MCEASM.CMD
;MCEBLD -- Creating TKB-Commandfile MCETKB.CMD .....
        .Open MCETKB.CMD
        .Iff PLUS .Goto 680$
        .Sets LIBR "Suplib=FCSFSL:SV"   ; Assume FCSFSL
        .Testfile LB:[1,1]FCSFSL.TSK
        .If <FilErr> Eq 1 .Goto LINK2
.680$:
        .Sets LIBR "Libr=FCSRES:RO"     ; Assume FCSRES
        .Testfile LB:[1,1]FCSRES.TSK
        .If <FilErr> Eq 1 .Goto LINK2
        .Sets LIBR ";"
.LINK2:
.Enable Data
;
; MCE Link buildfile
; Created on '<Date>' '<Time>' by MCEBLD.CMD Version: 'VERS'
;
.Disable Data
.Iff $MU .Iff $ID .Data MCE/CP,MCE/-SP=MCE
.Ift $MU .Iff $ID .Data MCE/MU/CP,MCE/-SP=MCE
.Iff $MU .Ift $ID .Data MCE/ID/CP,MCE/-SP=MCE
.Ift $MU .Ift $ID .Data MCE/ID/MU/CP,MCE/-SP=MCE
.Enable Data
;
; Virtual memory library .....
;
LB:[1,1]VMLIB/LB:INIDM:EXTSK
/
Units=2
Asg=TI:1
Asg=SY:2
Pri=60
Task=...MCE
'LIBR'
Exttsk=2400  ; Can be extended to add more MCE-Poolspace
;
; Global definitions for 'older' RSX systems .....
;
;   Uncomment following line when TKB finds T.V2XX undefined .....
;
;Gbldef=T.V2xx:36
;
;   Uncomment following line when TKB finds SD.TI undefined .....
;
;Gbldef=SD.TI:6
;
/
.Disable Data
        .Close
    	.Ift MCR	PIP MCETKB.CMD/PU/NM
    	.Iff MCR	PURGE MCETKB.CMD
.MAC:
;MCEBLD -- Assembling MCE .....
	.;
    MAC @MCEASM
        .If <ExStat> Ne <Succes> .Goto 2000$
        .;
	.Ift MCR	PIP MCE.OBJ/PU/NM,MCE.LST
	.Iff MCR	PURGE MCE.OBJ,MCE.LST
.LINK:
;MCEBLD -- Building MCE .....
	.Ift MCR	TKB @MCETKB
	.Iff MCR	LINK @MCETKB
        .If <ExStat> Ne 1 .Goto 2000$
.;
    	.Ift MCR	PIP MCE.TSK/PU/NM,MCE.MAP
    	.Iff MCR	PURGE MCE.TSK,MCE.MAP
.;
	.IfNdf $COP	.SetF	$COP
        .Iff $COP .Goto 1000$
    	.Ift MCR	PIP LB:'$SYSDR'/NV/FO/CO=MCE.TSK
    	.Iff MCR	COPY/NEW/CONT    MCE.TSK LB:'$SYSDR'
        .Iff $INS .Goto 1000$
        .IfAct ...MCE           ABO ...MCE
        .IfIns ...MCE           REM ...MCE
    INS LB:'$SYSDR'MCE
.;
.1000$:
	.IfNdf $PRI	.SetF	$PRI
        .Ift $PRI .Ift MCR	PRI MCE/FLA=MCE.LST,MCE.MAP
        .Ift $PRI .Iff MCR	PRINT/FLAG/JOB=MCE MCE.LST,MCE.MAP
;MCEBLD -- Procedure done
        .Exit   <Succes>
.2000$:
;
;MCEBLD -- Something wrong !!!
;
        .Exit   <Warnin>
