#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Modifications Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 * mapch -- handle escapes within strings
 */

#include <stdio.h>
#include <lex.h>

mapch(delim, esc)
{
	register c, octv, n;

	if ((c = lexchar())==delim)
		return(EOF);
	if (c==EOF || c=='\n') {
		lexerror("Unterminated string");
		ungetc(c, lexin);
		return(EOF);
	}
	if (c!=esc)
		return(c);
	switch (c=lexchar()) {
	case 't':
		return('\t');
	case 'n':
		return('\n');
	case 'f':
		return('\f');
	case '\"': case '\'':
		return(c);
	case 'e':
		return('\e');
	case 'p':
		return(033);
	case 'r':
		return('\r');
	case '0': case '1': case '2': case '3':
	case '4': case '5': case '6': case '7':
		octv = c-'0';
		for (n = 1; (c = lexchar())>='0' && c<='7' && n<=3; n++)
			octv = octv*010 + (c-'0');
		ungetc(c, lexin);
		return(octv);
	case '\n':
		yyline++;
		return(mapch(delim, esc));
	}
	return(c);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       