#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * bas2.c
 */
#include <stdio.h>
#include "bas.h"

#define	STOP	0
#define END	1
#define GOTO	2
#define GOSUB	3
#define RETURN	4
#define PRINT	5
#define TRACE	6
#define REM	7
#define LET	8

#define	OFF	0
#define ON	1

static	char	*stab[] = {
	"stop",
	"end",
	"goto",
	"gosub",
	"return",
	"print",
	"trace",
	"rem",
	"let",
	NULL
};

static	char	*otab[] = {
	"off",
	"on",
	NULL
};

struct	gosub
{
	struct	text *g_lp;
	char	*g_cp;
};

struct	gosub	*gsp;
struct	gosub	gosub[NGOSUB];

int	cflag;
int	tflag;

run()
{
	register struct text *tp;
	register c, t;
	int n;

	gsp = gosub;
	cflag = 0;
	tflag = 0;
	tp = text;
	while (tp != NULL) {
	again:
		if (tflag) {
			putn(tp->t_lno);
			puts(": trace.\n");
		}
		lp = tp;
		cp = tp->t_text;
		do {
			if (cflag) {
				cflag = 0;
				err("Control C");
			}
			switch (t = match(stab)) {
	
			case STOP:
			case END:
				end();
				if (t == STOP)
					err("Stop");
				lp = NULL;
				return;
	
			case GOTO:
			case GOSUB:
				n = getln(-1);
				end();
				tp = text;
				while (tp!=NULL && tp->t_lno<n)
					tp = tp->t_fp;
				if (tp==NULL || tp->t_lno!=n)
					err("Line not found");
				if (t == GOSUB) {
					if (gsp >= &gosub[NGOSUB])
						err("Too many gosubs");
					gsp->g_lp = lp;
					gsp->g_cp = cp;
					++gsp;
				}
				goto again;
	
			case RETURN:
				end();
				if (gsp <= &gosub[0])
					err("Too many returns");
				--gsp;
				lp = gsp->g_lp;
				cp = gsp->g_cp;
				break;
	
			case PRINT:
				print();
				break;
	
			case TRACE:
				tflag = offon();
				break;

			case REM:
				goto skip;

			case LET:
			default:
				let();
			}
		} while ((c=get()) == ':');
		if (c != 0)
			err("Bad ending");
	skip:
		tp = lp->t_fp;
	}
	lp = NULL;
}

print()
{
	register c, f;

	c = get();
	f = 0;
	while (c!=0 && c!=':') {
		if (c == '"') {
			while ((c=*cp++) && c!='"')
				put(c);
			if (c == 0)
				err("Bad string");
		} else
			err("No expr yet");
		f = 0;
		if ((c=get())==',' || c==';') {
			if (c == ',') {
				if (col >= 72)
					put('\n');
				else
					do {
						put(' ');
					} while ((col&017) != 0);
			}
			c = get();
			f = 1;
		}
	}
	if (f == 0)
		put('\n');
	--cp;
}

let()
{
	err("No let yet");
}

offon()
{
	register t;

	if ((t=match(otab)) > ON)
		err("Bad off or on");
	return (t);
}

end()
{
	register c;

	if ((c=get())!=0 && c!=':')
		err("Bad ending");
	--cp;
}
                                                                                                                                                                                                                                                                                                                                                                                        