#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 *		cat file...
 *
 * Copy files to stdout.  Note: the program first looks for all
 * files, sorting the file names in ascending alphabetic order
 * (directory information is ignored).  The files are then
 * output in sorted order.
 *
 */

#include <stdio.h>
#define	MAX_NAMES	500		/* Max. file names		*/
int		debug;
char		filename[81];		/* Just file name		*/
char		fullname[81];		/* dev:[...] + filename		*/
char		dirname[81];		/* Just dev:[...]		*/
char		*wild_spec;
char		*text[MAX_NAMES];	/* store file names here	*/
char		**ttop = text;		/* Top of text pointer		*/
FILE		*infd;
int		isarg = FALSE;

main(argc, argv)
int		argc;
char		*argv[];
{

	register int		c;
	register int		i;
	register char		*ap;

	for (i = 1; i < argc; i++) {
		if (*(ap = argv[i]) == '-') {
			while ((c = tolower(*++ap)) != 0) {
				switch (c) {
				case 'd':
					debug++;
					break;

				default:
					bug("W", "Unknown switch '%c'\n",
							c);
					break;
				}
			}
		}
		else {
			wild_spec = argv[i];
			ttop = text;
			isarg = TRUE;
			getnames();
		}
	}
	if (isarg) {
		copyall();
	}
	else {
		copyfile(stdin);
	}
}

getnames()
/*
 * Find all files for wild_spec
 */
{
	register int		count;		/* Count files		*/
	register char		*wp;		/* -> wild_spec		*/
	register char		*dp;		/* -> dirname[]		*/

	if (debug)
		fprintf(stderr, "Wild card spec = \"%s\"\n", wild_spec);
	wp = wild_spec;
	dp = dirname;
	do {
		*dp++ = (count = *wp++);
	} while (count != 0 && count != ':');
	if (count == '[' || count == '(') {
		do {
			*dp++ = (count = *wp++);
		} while (count != 0 && count != ']' && count != ')');
	}
	*dp = 0;
fprintf("wild spec = \"%s\", dir = \"%s\"\n", wild_spec, dirname);
	if ((infd = fwild(wild_spec, "r")) == NULL) {
		bug("E", "Can't open \"%s\"\n", wild_spec);
		return(0);
	}
	for (count = 0; fnext(infd) != NULL; count++) {
		setname(infd);
		save();
		if (debug)
			fprintf(stderr, "Curr file = \"%s\"\n", fullname);
	}
	if (debug)
		fprintf(stderr, "%d files processed\n\n", count);
	if (count == 0)
		bug("W", "No files matched \"%s\"\n", wild_spec);
	return(count);
}

copyall()
/*
 * Copy all files
 */
{
	char			**textp;	/* Pointer to names	*/
	register char		*tp;		/* Pointer to a name	*/
	register char		*np;		/* Filename pointer	*/
	register int		c;		/* Current character	*/

	for (textp = text; textp < ttop; textp++) {
		/*
		 * Get directory part
		 */
		for (tp = *textp; (c = *tp++) != 0 && c != '\t';);
		if (c == 0)
			error("Illegal file name \"%s\"\n", filename);
		np = cpystr(fullname, tp);
		/*
		 * Copy in rest
		 */
		while (c != 0)
			*np++ = (c = *tp++);
		if ((infd = fopen(fullname, "r")) == NULL)
			bug("W", "Can't reopen \"%s\"\n", np);
		else {
			copyfile(infd);
			fclose(infd);
		}
	}
}

copyfile(fd)
register FILE	*fd;
/*
 * Copy loop
 */
{
	char	record[512];

	while (fgets(record, sizeof record, fd) != NULL)
		fputs(record, stdout);
}

setname(fd)
FILE 		*fd;
/*
 * Build file name
 */
{
	register char		*wp;
	register char		*np;
	register int		c;
	char			work[81];

	iovtoa(fd, work);
	/*
	 * Skip over device name
	 */
	for (wp = work; (c = *wp) && c != ':'; wp++);
	if (c)	wp++;
	else	wp = work;
	/*
	 * Skip over [UIC] or [PPN] if present
	 */
	if (*wp == '[' || *wp == '(') {
		while ((c = *wp++) && c != ']' && c != ')')
		if (c == 0) {
			fprintf(stderr, "?GETCMD-bad file name \"%s\"\n",
					work);
			wp--;
		}
	}
	cpystr(fullname, wp);
	/*
	 * Don't include version in sort argument, then append
	 * directory name.  Result is:
	 *	foo.bar<TAB>db0:[10,20]<NULL>
	 */
	for (wp = fullname; (c = *wp) && c != ';'; wp++);
	*wp++ = '\t';
	cpystr(wp, dirname);
}

save()
/*
 * Save fullname, add it to the text area (in sorted order)
 */
{
	register char	**textp;
	register char	**insert;
	register int	i;

	for (textp = text; textp < ttop; textp++) {
		if ((i = strcmp(*textp, fullname)) == 0) {
			fprintf("?GETCMD-E-Duplicate file name \"%s\"\n",
				fullname);
			return;
		}
		else if (i > 0)
			break;
	}
	insert = textp;
	textp = ttop;
	if (++ttop >= &text[MAX_NAMES])
		error("?GETCMD-F-Too many file names, %d max.\n", MAX_NAMES);

	while (textp >= insert) {
		textp[1] = *textp;
		textp--;
	}
	if ((*insert = malloc(strlen(fullname) + 1)) == NULL)
		error("?GETCMD-F-No room for \"%s\"\n", fullname);
	cpystr(*insert, fullname);
}
	



usage(s)
char	*s;
{
	bug("E", "%s.  For help, GETCMD ?\n", s);
	exit(1);
}

bug(severity, s)
char		*severity;
char		*s;
/*
 * Error messages
 */
{
	fprintf(stderr, "%cGETCMD-%s-%r",
		(*severity == 'W') ? '%' : '?', severity, &s);
}
                                                                                                                                                                                                      