  (* THE FOLLOWING IS A GROUP OF PROCEDURES THAT ALLOWS ACCESS TO RMS-11K
   INDEXED FILES.  THE FOLLOWING IS A DESCRIPTION OF THE ARGUMENTS:

   LUN     INTEGER VARIABLE SPECIFYING LOGICAL UNIT NUMBER - MUST BE SUPPLIED

   FILSPEC-ARRAY OF CHAR CONTAINING FILESPEC AND TERMINATED BY A NUL (BYTE(0))

   ACCESS  INTEGER VARIABLE DEFINING THE FILE ACCESS RIGHTS DESIRED
   ACCESS := 0     READ ONLY ACCESS (GET AND FIND)
   ACCESS := 1     EXTEND ACCESS (GET, FIND, AND PUT)
   ACCESS := 2     MODIFY ACCESS (GET, FIND, PUT AND UPDATE)
   ACCESS := 3     TOTAL ACCESS (GET, FIND, PUT, UPDATE AND DELETE)
   IF ARGUMENT IS NULL, ACCESS = 0

   SHARE   INTEGER VARIABLE SPECIFYING THE SHARED ACCESS FLAG
   SHARE := 0      NO SHARED ACCESS DESIRED
   SHARE := 1      SHARED ACCESS DESIRED
   IF ARGUMENT IS NULL, SHARE = 0

   STATUS - INTEGER VARIABLE FOR STATUS RETURNS - MUST BE SUPPLIED
   -1 NO LUN SUPPLIED
   -2 FILE ALREADY OPENED/CLOSED
   -3 INTERNAL ALLOCATION ERROR - PROBABLY TOO MANY FILES OPEN
   -4 ACCESS STREAM ALREADY CONNECTED/DISCONNECTED
   -5 ILLEGAL KEY NUMBER FOR THIS FILE
   -6 NO OPERATION POSSIBLE - NULL ARGUMENT OUT OF CONTEXT
   -7 PUT OPERATION IN RFA MODE (ILLEGAL)
   -8 ILLEGAL ACCESS MODE (PROBABLY BAD MODE PARAMETER)
   -9 ILLEGAL (UNRECOGNIZED) FILE ACCESS RIGHTS REQUESTED
   OTHER - ALL POSSIBLE RMS STATUS RETURNS (APPENDIX A, RMS-11
   MACRO PROGRAMMERS MANUAL)

   BUFFER - RECORD OR ARRAY OF CHAR TO SERVE AS RMS RECORD BUFFER

   RFA     ARRAY[1..3] OF INTEGER TO SUPPLY OR RECEIVE THE RECORD'S
   FILE ADDRESS DEPENDING ON CONTEXT.  IN CERTAIN CONTEXT, THIS
   ARGUMENT MAY BE NULL (I.E. KEYED ACCESS OPERATION)

   MODE    INTEGER VARIABLE SPECIFYING THE RECORD ACCESS MODE
   MODE := 0 SEQUENTIAL
   MODE := 1 RANDOM (KEY)
   MODE := 2 RFA

   KEYNUM  INTEGER VARIABLE SPECIFYING THE KEY NUMBER TO REFERENCE:
   0 = PRIMARY; 1 = 1ST ALTERNATE
   ETC.

   KEYBUF - RECORD OR ARRAY TO SERVE AS KEY BUFFER
   MAY BE SAME AS BUFFER

   KEYSIZE - INTEGER VARIABLE SPECIFYING THE SIZE IN BYTES OF THE KEYBUF.

   >>>>> NOTE <<<<<
   IN THOSE SITUATIONS WHERE NO STATUS RETURN IS POSSIBLE
   (E.G. INCORRECTLY FORMATTED CALL) THE RUN-TIME SYSTEM WILL TAKE AN
   INTERNAL SST FAULT VIA A TRAP OR EMT INSTRUCTION
   *)

  (*
   THE FOLLOWING CONSTANTS SHOULD BE DECLARED IN THE CONSTANT SECTION

   VALUES SHOULD BE MODIFIED TO REFLECT THE FILE BEING PROCESSED
   *)
  (*
   SPECMAX = 20;
   KEYSIZE0 = 2;
   KEYSIZE1 = 33;
   RECSIZE = 132;

   THE FOLLOWING TYPES MUST BE DEFINED IN THE MAIN PROGRAM

   TYPE

   FILESPECTYPE = PACKED ARRAY[1..SPECMAX] OF CHAR;
   RECTYPE = PACKED ARRAY[1..RECSIZE] OF CHAR;
   RFATYPE = ARRAY[1..3] OF INTEGER;
   KEYTYPE0 = PACKED ARRAY[1..KEYSIZE0] OF CHAR;
   KEYTYPE1 = PACKED ARRAY[1..KEYSIZE1] OF CHAR;
   ETC;

   *)

  PROCEDURE rmsope(VAR lun:integer;VAR filspec :filespectype;
		   VAR access,share,status : integer); FORTRAN;

  PROCEDURE rmsclo(VAR lun,status : integer); FORTRAN;

  PROCEDURE rmscon(VAR lun,keynum, mode : integer; VAR recbuf :rectype;
		   VAR recsiz, status :integer); FORTRAN;

  PROCEDURE rmsdis(VAR lun, status : integer); FORTRAN;

  PROCEDURE rmsget(VAR lun :integer; VAR rfa : rfatype;
		   VAR status : integer); FORTRAN;

  PROCEDURE rmsput(VAR lun :integer; VAR rfa : rfatype;
		   VAR status : integer); FORTRAN;

  PROCEDURE rmsfnd(VAR lun :integer; VAR rfa : rfatype;
		   VAR status : integer); FORTRAN;

  PROCEDURE rmsupd(VAR lun :integer; VAR rfa : rfatype;
		   VAR status : integer); FORTRAN;

  PROCEDURE rmsdel(VAR lun, status : integer); FORTRAN;

  PROCEDURE rmsrwd(VAR lun, status : integer); FORTRAN;

  PROCEDURE rmsrac(VAR lun, mode, status : integer); FORTRAN;

  PROCEDURE rmskey(VAR lun, keynum :integer; VAR keybuf : keytype;
		   VAR keysize, status :integer); FORTRAN;

  PROCEDURE rmsfre(VAR lun, status : integer); FORTRAN;

  PROCEDURE rmsfls(VAR lun, status : integer); FORTRAN;

  (* END OF RMS INTERFACE *)
 