#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#

#include <stdio.h>
#include <rsts.h>
#include <rserr.h>
 
 
rserror(errno)
/*
 * Fatal error exit.
 *
 * Print the RSTS error message on the keyboard, remove the current job
 * from the receiver table (just in case), close all channels, and exit. 
 */
{
	rs_err("?Fatal error: ", errno, "\r\n");
	rsexit();
}


rs_err(leadin, errno, trailer)
char	*leadin;		/* Leading message			*/
char	errno;			/* the RSTS error number		*/
char	*trailer;		/* Trailing message			*/
/*
 * Print error message "leadin <error text for errno> trailer"
 */
{
	char	outbuffer[30];

	clrfqx();
	firqb.fqfun = UU_ERR;
	firqb.fqfil = errno;
	rstsys(_UUO);
	strcpy(outbuffer, &firqb.fqfil);
	forcenl();
	print(leadin);
	print(outbuffer);
	print(trailer);
}
 
                                                                                             