package Train;

use strict;
use warnings;

my $fitquantum      = 2;
my $storefitquantum = 15;

use Class::MethodMaker [
    scalar => [
        qw/ length nextmin nextmax createplace createtime limithistory fithistory tendency swiref ison id name idreads onyardlead lastfit/,
        qw/ tendencyt weight trainlist/
    ],
    new => [qw/ new /],
];

sub findoverlaps {
    my ( $self, $wayside, $multiocc ) = @_;
    my $x0          = $self->nextmin;
    my $x9          = $self->nextmax;
    my $trainlength = $self->length;
    my $trklon      = $wayside->trklon;
    my $switch      = $wayside->switch;
    my $ijlocs      = $wayside->ijlocs;

    my $overlaps = $self->lookforoverlaps($wayside);

# Now loop over the overlaps, finding largest contiguous region where the train could possibly be based on the entry nextmin and nextmax. Ignore gaps around short track circuits, e.g. <110 feet.
    my $regions = $self->findcontigs($overlaps);

    $regions = $self->orderbytendency($regions);
    my $thisregion = $self->pickregion($regions);

    if ( !defined $thisregion ) {
        print "No overlap at all for train ", $self->name, "\n";
        print "He should have been on $x0 to $x9\n";
        my $history = $self->limithistory;
        push @$history, [ $wayside->t, -1, -1, 0, 0, $self->tendency, 0 ];
        splice( @$history, 0, -90 );    # keep last 90 seconds of history
    }
    else {
        my $history = $self->limithistory;
        my $x0      = $thisregion->[0];
        $x0 = $x0 - 50 if ( exists $ijlocs->{ $x0 + 0 } );
        my $x9 = $thisregion->[2];
        $x9 = $x9 + 50 if ( exists $ijlocs->{ $x9 + 0 } );
        if ( defined $self->swiref ) {
            my $seq = $self->swiref->{seq};
            if ( $seq == 2 ) {
                print "train ", $self->name,
                  " extending occupancy because seq is $seq\n";
                my $dire = $self->swiref->{dire};
                print "dire is $dire\n";
                if ( $dire eq "L" ) {
                    $x0 = $x0 - 600;
                }
                else {
                    $x9 = $x9 + 600;
                }
            }
            else {
                print "seq was $seq zorching the swiref\n";
                $self->swiref(undef);
            }
        }
        push @$history,
          [ $wayside->t, $x0, $x9 - $trainlength, 0, 0, $self->tendency, 0 ];
        splice( @$history, 0, -90 );    # keep last 90 seconds of history
    }
    if ( defined $thisregion ) {
        $self->ison( $thisregion->[3] );
        push @{ $multiocc->{ $thisregion->[3] } }, $self->name;
        for my $pointname ( split /,/, $self->ison ) {
            for ( $trklon->{$pointname} ) {
                $_->{trainhistory} = {}
                  if !defined $_->{trainhistory};
                my $trainhistref = $_->{trainhistory};
                my $id           = "?";
                $id = $self->id if defined $self->id;
                $trainhistref->{ $self->name } = join " ", $wayside->t, $id;
                my @past =
                  sort { $trainhistref->{$a} cmp $trainhistref->{$b} }
                  keys %$trainhistref;
                for ( splice( @past, 0, -10 ) ) {
                    ;
                    delete $trainhistref->{$_};
                }

  #                        print "last ten trains to step on ", $_->{pointname},
  #                          " are ", ( join ",", @past ), "\n";
            }
        }
    }
    return;
}

sub lookforoverlaps {
    my ( $self, $wayside ) = @_;
    my $x0           = $self->nextmin;
    my $x9           = $self->nextmax;
    my $tcbykft      = $wayside->tcbykft;
    my $plathastrain = $wayside->plathastrain;
    my $overlaps;
    my %walked;
    for ( int( $x0 / 1000 ) .. int( $x9 / 1000 ) ) {

        for ( @{ $tcbykft->{$_} } ) {
            next if exists $walked{ $_->{pointname} };
            my $l0 = $_->{trklon};
            my $l9 = $_->{trklon} + $_->{trklen};
            next if $x0 > $l9;
            next if $x9 < $l0;
            next if ${ $_->{state} } eq "0";
            $overlaps->{ $_->{trklon} } = $_;
            $plathastrain->{ $_->{platform} }++
              if exists $_->{platform};
            $walked{ $_->{pointname} }++;
            my $walk = $_;

            while ( defined $walk->{left}
                && ${ $walk->{left}->{state} } ne "0" )
            {
                $walk = $walk->{left};
                $overlaps->{ $walk->{trklon} } = $walk;
                $plathastrain->{ $walk->{platform} }++
                  if exists $walk->{platform};
                $walked{ $walk->{pointname} }++;
            }
            $walk = $_;
            while ( defined $walk->{right}
                && ${ $walk->{right}->{state} } ne "0" )
            {
                $walk = $walk->{right};
                $overlaps->{ $walk->{trklon} } = $walk;
                $plathastrain->{ $walk->{platform} }++
                  if exists $walk->{platform};
                $walked{ $walk->{pointname} }++;
            }
        }
    }
    return $overlaps;
}

sub findcontigs {
    my ( $self, $overlaps ) = @_;
    my ( $x0, $x9 ) = ( $self->nextmin, $self->nextmax );
    my $regionft;
    my $regions = [];
    my $regionx0;
    my $prevtc9;
    my @tclist;
    my @sk = sort { $a <=> $b } keys %$overlaps;

    for my $tc0 (@sk) {
        if ( !defined $prevtc9 || $tc0 > $prevtc9 + 1 ) {
            push @$regions,
              [ $regionx0, $regionft, $prevtc9, ( join ",", @tclist ) ]
              if $regionft;
            $regionft = 0;
            $regionx0 = $tc0;
            @tclist   = ();
        }
        my $ovfeet = 0;
        push @tclist, $overlaps->{$tc0}->{pointname};
        my $tc9 = $tc0 + $overlaps->{$tc0}->{trklen};
        if ( $tc0 <= $x0 && $tc9 >= $x9 ) {
            $ovfeet += ( $x9 - $x0 );
        }
        elsif ( $tc0 <= $x0 && $x0 <= $tc9 && $tc9 <= $x9 ) {
            $ovfeet += ( $tc9 - $x0 );
        }
        elsif ( $tc0 >= $x0 && $tc0 <= $x9 && $tc9 >= $x9 ) {
            $ovfeet += ( $x9 - $tc0 );
        }
        elsif ($x0 <= $tc0
            && $tc0 <= $x9
            && $x0 <= $tc9
            && $tc9 <= $x9 )
        {
            $ovfeet += ( $tc9 - $tc0 );
        }
        $regionft += $ovfeet;
        $prevtc9 = $tc9;
    }
    push @$regions, [ $regionx0, $regionft, $prevtc9, ( join ",", @tclist ) ]
      if $regionft;
    return $regions;
}

sub orderbytendency {
    my ( $self, $regions ) = @_;

    return $regions if ( scalar @$regions ) < 2;

    print "There were ", scalar @$regions, " to choose from\n";
    if ( !defined $self->tendency ) {
        print "tendency was undefined\n";
    }
    else {
        print "tendency was ", $self->tendency, "\n";
    }

# If the train has been assigned a positive or negative tendency, reorder so the first one is the furthest one ahead in expected direction of travel
    if ( defined $self->tendency && $self->tendency < 0 ) {

        #Nothing to do, already sorted so first one is the least
    }
    elsif ( defined $self->tendency && $self->tendency > 0 ) {
        $regions = [ reverse @$regions ];
    }
    else {

# Reorder the regions so the first one is the one furthest ahead in the normal direction of travel
        if (@$regions) {
            my $lon = $regions->[0][0];
            my $i   = int( $lon / 1000000 );
            my $d   = ( $i + 0 ) % 2;
            print "d is $d\n";
            if ($d) { $regions = [ reverse @$regions ]; }
        }
    }
    return $regions;
}

sub pickregion {
    my ( $self, $regions ) = @_;
    my $posregion     = undef;
    my $biggestregion = undef;
    for (@$regions) {
        if ( $_->[1] > $self->length && !defined $posregion ) {
            $posregion = $_;
        }
        if ( !defined $biggestregion ) {
            $biggestregion = $_;
        }
        if ( $_->[1] > $biggestregion->[1] ) {
            $biggestregion = $_;
        }
    }
    my $thisregion = $posregion;
    $thisregion = $biggestregion
      if !defined $posregion
          || ( defined $self->tendency
              && $self->tendency == 0 );
    return $thisregion;
}

sub label {
    my ( $self, $wayside, $multiocc ) = @_;
    my $trklon = $wayside->trklon;
    my $ison   = $self->ison;
    return
      if ( exists $multiocc->{$ison} && scalar @{ $multiocc->{$ison} } > 1 )
      ;    #Must be a lone train here
    for ( split /,/, $ison ) {
        if (   exists $trklon->{$_}{idstate}
            && ${ $trklon->{$_}{idstate} } =~ /^\d+$/
            && ${ $trklon->{$_}{idstate} } > 0 )
        {
            $self->idreads( [] )
              if !defined $self->idreads;
            my $idreads = $self->idreads;
            push @{$idreads}, ${ $trklon->{$_}{idstate} };

            #	    print "ID state is ",${ $trklon->{$_}{idstate} };
            splice( @$idreads, 0, -20 );
            my %idhisto;
            for ( @{$idreads} ) {
                $idhisto{$_}++;
            }
            my $id =
              ( sort { $idhisto{$b} <=> $idhisto{$a} } keys %idhisto )[0];
            $self->id($id) if $id;

#             print "Decided ID of ",$self->name," is $id with ",$idhisto{$id}," of ",scalar @{$idreads}," votes \n";
        }
    }
    return;
}

sub yardleadcheck {

    my ( $self, $wayside ) = @_;

    # Find trains at an yardlead, let them go away on the yard lead
    my $tcs    = $self->ison;
    my $trklon = $wayside->trklon;
    my $i      = 0;
    for ( split /,/, $tcs ) {
        if ( defined $trklon->{$_}{landmark}
            && $trklon->{$_}{landmark} =~ /yard/i )
        {
            $i++;
        }
    }
    my $history = $self->limithistory;
    $history->[-1][4] = $i;
}

sub handlefail {
    my ( $self, $wayside, $multiocc ) = @_;
    my $history = $self->limithistory;
    my $ibc     = 0;
    for ( reverse @$history ) {
        print "looking back $ibc multiocc was ", $_->[6], "\n";
        return if $_->[6];
        $ibc++;
        last if $ibc > 10;
    }
    if ( $self->onyardlead ) {
        print "Could have been on yard lead, letting disappear quietly\n";
        return;
    }
    my $x  = ( $self->nextmin + $self->nextmax ) / 2;
    my $t2 = $wayside->t - int( $fitquantum / 2 );
    $x  = int($x);
    $t2 = int($t2);
    my $xa  = $x - 400;
    my $xb  = $x + 400;
    my $t2a = $t2 - 4;
    my $t2b = $t2 + 4;
    print
"DUPESEARCH is SELECT time,trklon from fitfails where (time between $t2a and $t2b) and (trklon between $xa and $xb\n";
    my $dbh      = Database->new->dbh;
    my $dupefind = $dbh->selectall_arrayref(
"SELECT time,trklon from fitfails where (time between $t2a and $t2b) and (trklon between $xa and $xb)"
    );

    if ($dupefind) {
        print "DUPEFIND returned with $dupefind and ",
          scalar @$dupefind,
          " events\n";
        for (@$dupefind) {
            print "a DUPE found, not reissuing\n";
            return;
        }
    }
    my $nid = $self->nextids;
    my $newfail = $dbh->prepare(
"INSERT into fitfails (fitnum,time,trklon,color,badness,trainlength,trainname,trainid,nextids) values (?,?,?,?,?,?,?,?,?)"
    ) or die $dbh->errstr;
    $newfail->execute( 0, $t2, $x, 'red', $self->length, $self->length,
        $self->name, $self->id, $nid )
      or die $dbh->errstr;

    my $t = $wayside->t;
    $self->strictfit( $wayside, $multiocc, 1 );
    my $t21 = $t - 21;
    my $t20 = $t - 20;
    my $x21;
    my $x20;
    print "looking for $t20\n";
    if ( defined $self->lastfit ) {

        for ( @{ $self->lastfit } ) {
            if ( $_->[0] == $t20 ) {
                $x20 = $_->[1];
            }
            elsif ( $_->[0] == $t21 ) {
                $x21 = $_->[1];
            }
        }
    }
    if ( !defined $x20 || !defined $x21 ) {
        print "didn't find $t20 or $t21\n";
        return;
    }
    my $v20  = $x20 - $x21;
    my $l    = $self->length;
    my $name = $self->name;
    print "invoking ./measurebadness $x $t2 $l $t20 $x21 $v20 $name";
    print `./measurebadness $x $t2 $l $t20 $x21 $v20 $name`;

    my @htxt;
    my $tcc;
    my $trklon = $wayside->trklon;
    for ( sort keys %$trklon ) {
        my $i   = $trklon->{$_};
        my $icc = $i->{pointname};
        if ( abs( $i->{trklon} - $x ) < 2000 ) {

            # spread the joy
            $trklon->{$icc}{trainhistory} = {}
              if !defined $trklon->{$icc}{trainhistory};
            my $trainhistref = $trklon->{$icc}{trainhistory};
            if ( !exists $trainhistref->{ $self->name } ) {
                $trainhistref->{ $self->name } = join " ", $t2, $self->id;
            }
        }
        $tcc = $i->{pointname}
          if $x >= ( $i->{trklon} ) && $x <= ( $i->{trklon} + $i->{trklen} );
    }
    if ( defined $tcc ) {
        push @htxt, "This and previous trains to move over $tcc";
        my $trainhistref = $trklon->{$tcc}{trainhistory};
        if ( defined $trainhistref ) {
            my @past = sort {
                ( split / /, $trainhistref->{$a} )[0]
                  <=> ( split / /, $trainhistref->{$b} )[0]
              }
              keys %$trainhistref;
            for (@past) {
                my ( $pt, $pid ) = split / /, $trainhistref->{$_};
                print "name is $_ pt is $pt pid is $pid\n";
                print
"the query is SELECT trklon,badness from fitfails where trainname='$_'";
                my $pastfind = $dbh->selectall_arrayref(
                    "SELECT trklon,badness from fitfails where trainname='$_'"
                );
                my $badness = "----";
                print "looking for a lon near $x\n";
                for (@$pastfind) {
                    print "a find was ", ( join " ", @$_ ), "\n";
                    $badness = $_->[1] if abs( $_->[0] - $x ) < 1000;
                }
                my $tstr;
                if ( ( scalar localtime $pt ) =~ /(\d+\:\d+\:\d+)/ ) {
                    $tstr = $1;
                }
                push @htxt, ( join " ", $tstr, $pid, $badness );
            }
        }
    }

    my $hth = $dbh->prepare(
        q{
  update fitfails set historytext=? where time=? and trklon=?
}
    ) or die $dbh->errstr;

    $hth->execute( ( join "\n", @htxt ), $t2, $x )
      or die $dbh->errstr;
    print "invoking ./rtalert $x $t2 $l $t20 $x21 $v20 $name";
    print `./rtalert $x $t2 $l $t20 $x21 $v20 $name`;
    print "invoking ./pdfpanelemail $x $t2 $l $t20 $x21 $v20 $name";
    print
      `./pdfpanelemail $x $t2 $l $t20 $x21 $v20 $name >> pdfpanel.log 2>&1 &`;

}

use Math::GLPK qw(:constants);
use Math::MatrixSparse;

sub strictfit {
    my ( $self, $wayside, $multiocc, $lastgasp ) = @_;
    $lastgasp = 0 if !defined $lastgasp;
    my $t = $wayside->t;
    if ( $t % $fitquantum == 0 || defined $self->tendency || $lastgasp ) {

        my $bugout  = 0;
        my $history = $self->limithistory;
        if ($lastgasp) {
            for ( 1 .. 4 ) {
                pop @$history;
            }
        }
        return 0 if ( scalar @$history ) < 3;
        $self->onyardlead( $history->[-1][4]
              || $history->[-2][4]
              || $history->[-3][4] );
        my @newlims;
        my $secstouse = scalar @$history;
        $secstouse = 36 if $secstouse > 36;
        $secstouse = 30 if $secstouse > 30 && !$lastgasp;

        my $storefitflag = $lastgasp;
        $storefitflag++
          if (
            ( ( $t - $self->createtime ) % $storefitquantum ) < $fitquantum );

        #        $storefitflag = $lastgasp;

        my $dim = $fitquantum + $secstouse;
        next if ( $dim < 2 + $fitquantum );
        my $lp = lp($dim);
        my $bias;
        for ( 0 .. $dim - 1 ) {
            my $sec = $_ - $secstouse;
            my ( $tt, $xmin, $xmax, $barf ) = @{ $history->[$sec] };
            if (   $_ < $dim - $fitquantum
                && $barf == 0 )
            {
                $bias = $xmin if !defined $bias;
                $lp->col_bnds( $_ + 1, $LPX_DB, $xmin - $bias, $xmax - $bias );
                $bugout++ if $xmin > $xmax;
            }
            else {
                $lp->col_bnds( $_ + 1, $LPX_FR, 0, 0 );
            }
        }
        my @solutions;
        for my $optimize ( [ $LPX_MIN, "nextmin" ], [ $LPX_MAX, "nextmax" ] ) {
            $lp->obj_dir( $optimize->[0] );
            $lp->int_parm( $LPX_K_PRESOL, 0 );
            $lp->int_parm( $LPX_K_DUAL,   1 );
            $lp->int_parm( $LPX_K_MSGLEV, 0 );
            $lp->simplex if !$bugout;
            if ( $bugout || !$lp->is_optimal ) {
                $bugout++;
                last;
            }
            my $limit = $lp->get_obj_val + $bias;
            if ( $optimize->[1] eq "nextmax" ) {
                $limit += $self->length;
            }
            else {
                $limit = $limit;
            }
            push @newlims, [ $optimize->[1], $limit ];
            push @solutions, $lp->get_opt_sol if $storefitflag;
        }
        $self->storefit( $history->[ -$secstouse ]->[0],
            $bias, $dim - $fitquantum, @solutions )
          if ( $storefitflag && scalar @solutions );

        if ($bugout) {
            for ( 1 .. $fitquantum ) {
                $history->[ -$_ ][3] = 1;
            }
            for (@$history) {
                print join "\t", (@$_)[ 0 .. 3 ];
                print "\n";
            }
            print "Recommending deleteion of train ", $self->name, "\n";
            return -1;
        }
        else {
            if ( ( ( $t - $self->createtime ) % $storefitquantum ) <
                $fitquantum )
            {
            }
            $self->nextmin( $newlims[0][1] );
            $self->nextmax( $newlims[1][1] );
            return 0;
        }
    }
    return 0;
}

sub storefit {
    my ( $self, $t0, $bias, $n, @solutions ) = @_;
    my $ns = scalar @solutions;
    return if !$ns;
    my ( $trklon0, $trklon9 );
    my $fitbin;
    my $lx;
    my $lastfit;
    for my $i ( 0 .. $n ) {
        my $x = 0;
        my $t = $t0 + $i;
        for (@solutions) {
            $x += ( $bias + $_->element( $i + 1, 1 ) ) / $ns;
        }
        push @$lastfit, [ $t, $x ];
        if ( !$i ) {
            $fitbin = pack( "NN", $t0, int($x) );
            $lx = int($x);
        }
        else {
            my $delt = int( $x - $lx );
            $delt = 127  if $delt > 127;
            $delt = -127 if $delt < -127;
            $fitbin .= pack( "c", $delt );
            $lx += $delt;
        }
        $trklon0 = $x if !defined $trklon0 || $x < $trklon0;
        $trklon9 = $x if !defined $trklon9 || $x > $trklon9;
    }
    $self->lastfit($lastfit);
    my $dbh = Database->new->dbh;
    my $lth = $dbh->prepare(
        q{
  INSERT INTO fits (time0,time9,trklon0,trklon9,width,fitbin,trainname,fitby) VALUES (?,?,?,?,?,?,?,?)
	}
    ) or die $dbh->errstr;
    $lth->execute( $t0, $t0 + $n, $trklon0, $trklon9, $self->length, $fitbin,
        $self->name, "periodic" )
      or die $dbh->errstr;
}

use Memoize;

memoize('lp');

sub lp {
    my ($dim) = @_;
    my $lp = Math::GLPK->new();
    $lp->add_cols($dim);
    $lp->add_rows( $dim - 2 + $dim - 1 );
    for ( 1 .. $dim - 2 ) {
        $lp->row_bnds( $_, $LPX_DB, -5, 5 );
    }
    for ( 1 .. $dim - 1 ) {
        $lp->row_bnds( $_ + ( $dim - 2 ), $LPX_DB, -120, 120 );
    }
    $lp->objective( om($dim) );
    $lp->constraint( cms($dim) );
    return $lp;
}

memoize('om');

sub om {
    my ($dim) = @_;
    my $om = Math::MatrixSparse->new;
    $om->assign( 1, $dim, 1 );
    return $om;
}

memoize('cms');

sub cms {
    my ($dim) = @_;
    my $cms = Math::MatrixSparse->new;
    for my $i ( 1 .. $dim - 2 ) {
        $cms->assign( $i, $i,     1 );
        $cms->assign( $i, $i + 1, -2 );
        $cms->assign( $i, $i + 2, 1 );
    }
    for my $i ( 1 .. $dim - 1 ) {
        $cms->assign( $dim - 2 + $i, $i,     -1 );
        $cms->assign( $dim - 2 + $i, $i + 1, 1 );
    }
    return $cms;
}

sub nextids {
    my ($self) = @_;
    my $trainname = $self->name;
    my $trainlist = $self->trainlist;
    print "nextids trainname $trainname\n";
    my $xlos = ($self->nextmin + $self->nextmax)/ 2;
    my $m = int($xlos/1000000);
    print "xlos $xlos m $m\n";
    my %trainsbyx;
    print "there are ",(scalar keys %{ $trainlist->trains })," trains in the trainlist\n";
    while ( my ( $name, $train ) = each( %{ $trainlist->trains } ) ) {
      print "checking $train $name\n";
      my $cand = 1;
      $cand = 0 if $name eq $trainname;
      my $x = int( ( $train->nextmin + $train->nextmax )/2);
      print "x is $x\n";
      $cand = 0 if $x<$m*1000000; $cand = 0 if $x>$m*1000000+900000;
      print "is in right m\n" if $cand;
      if ($m % 2) {
        $cand=0 if $x>$xlos;
      } else {
        $cand=0 if $x<$xlos;
      }
      if ($cand) {
        print "is a candidate\n";
        $trainsbyx{$x} = $train->id;
      }
    }
# if m is odd, we want the biggest x's less than LOS train x
# if m is even, we want the smallest x's less than LOS train x
    my @s = sort { $a <=> $b } keys %trainsbyx;
    if ($m % 2) {
      @s = reverse @s;
    }
    print "sorted list of x's is ",(join ",",@s),"\n";
    my $id1 = ""; my $id2 = "";
    if (defined $s[0] && defined $trainsbyx{$s[0]}) {
        $id1 = $trainsbyx{$s[0]};
    }
    if (defined $s[1] && defined $trainsbyx{$s[1]}) {
        $id2 = $trainsbyx{$s[1]};
    }
    my $v = join ",",$id1,$id2;
    return $v;
}


1;
