#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * asm82.c
 * Expressions.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Read an expression.
 * Return its value.
 * All expressions are evaluated
 * left to right; parentheses
 * may be used to alter the order
 * of evaluation.
 */
expr()
{
	register int c;
	int l, r;

	if(!term(&l))
		return(0);
	while(validop(c=getnb())) {
		if(!term(&r)) {
			err('e');
			return(l);
		}
		switch(c) {

		case '+':
			l += r;
			break;

		case '-':
			l -= r;
			break;

		case '*':
			l *= r;
			break;

		case '%':
			l /= r;
			break;

		case '&':
			l &= r;
			break;

		case '|':
			l |= r;
		}
	}
	putback(c);
	return(l);
}

/*
 * Check for valid arithmetic
 * operators.
 */
validop(c)
{
	switch(c) {

	case '+':
	case '-':
	case '*':
	case '%':
	case '&':
	case '|':
		return(1);

	default:
		return(0);
	}
}

/*
 * Get a term.
 * Store its value in the
 * indicated place.
 * Return true if a term is
 * found.
 * If no term is found no
 * characters are read and
 * false is returned.
 */
term(vp)
int *vp;
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	/*
	 * Number.
	 */
	if((c=getnb())>='0' && c<='9') {
		*vp = getnum(c);
		return(1);

	/*
	 * Id.
	 */
	} else if(alpha(c)) {
		getid(c, id);
		sp = lookup(id, ust);
		if(sp->s_type == S_UND)
			err('u');
		*vp = sp->s_value;
		return(1);

	/*
	 * Unary ops.
	 */
	} else if(c=='-' || c=='!') {
		if(!term(vp)) {
			err('e');
			return(0);
		} else if(c == '-')
			*vp = -*vp;
		else
			*vp = ~*vp;

	/*
	 * Parentheses.
	 */
	} else if(c == '(') {
		*vp = expr();
		if(getnb() != ')')
			err('(');
		return(1);

	/*
	 * Character constant.
	 */
	} else if(c == '\'') {
		*vp = getmap();
		if(getnb() != '\'')
			err('\'');
		return(1);

	/*
	 * None.
	 */
	} else {
		putback(c);
		return(0);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               