	TITLE	8086 DEMONSTRATION PROGRAM
	SBTTL	MACRO DEFINITIONS
 
ENTER:	MACRO
	PUSH	BP
	MOV	BP,SP
	ENDM
 
EXIT:	MACRO	N
	POP	BP
	IF	N=0
	RET
	ELSE
	RET	N
	ENDIF
	ENDM
 
INTSVC:	MACRO	MESS,LEN,@1
	PUSH	ES		; 214
	PUSH	DS		;
	MOV	DS,CS:@DATFR
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSH	SI
	PUSH	DI
	CALL	@1
	POP	DI
	POP	SI
	POP	BX
	POP	DX
	POP	CX
	POP	AX
	POP	DS
	POP	ES
	IRET
 
@1:	PUSH	BP
	MOV	BP,SP
	LEA	AX,CS:MESS	; 215
	PUSH	CS
	PUSH	AX
	MOV	AL,LEN
	PUSH	AX
	CALL	SIOUTS
	ENDM
 
	EJECT
	SBTTL	PARAMETER STACK OFFSETS
;
;	************************
;	* PARAMETER STACK AREA *
;	************************
 
PSTK:	DSEG
 
	ORG	4
C:	DSB	1
 
	ORG	4
DEFBAS:	DSB	1
 
	ORG	4
H:	DSB	1
 
	ORG	4
N:	DSB	1
 
	ORG	4
W:	DSW	1
 
	ORG	4
BB:	DSB	1
 
	ORG	6
STRPTR: DSW	1
 
 
;
;	UTILITY CONSTANTS
;
OFFH	EQU	0FFH
ASCR	EQU	0DH	; CARR RET
ASLF	EQU	0AH	; LINE FEED
ASBL	EQU	20H	; BLANK
@STKOFF EQU	30H	; STACK OFFSET
 
	EJECT
	SBTTL	GLOBAL VARIABLE DEFINITIONS
;
;	*******************************
;	* GLOBAL VARIABLE DEFINITIONS *
;	*******************************
 
VARS:	DSEG
 
STR:	DSB	0
 
	ORG	0
 
ARG1:	DSW	2
 
SAVE:	DSW	1
 
WW:	DSW	1
 
COUNT:	DSW	1
 
CHAR:	DSB	1
 
I2:	DSB	1
 
B:	DSB	1
 
OPER:	DSB	1
 
I1:	DSB	1
 
T:	DSB	1
 
I3:	DSB	1
	EJECT
	SBTTL	ARRAY STORAGE AREA
;
;	**************************************
;	* ARRAY STORAGE AREA  (CODE SEGMENT) *
;	**************************************
 
DEMO:	CSEG	DEMO86
 
SIOCMD:	DB	'GSD'
 
ASCII:	DB	'0123456789ABCDEF'
 
LC13:	DB	'SUBSTITUTE FAILED'
LC24:	DB	'DIVIDE ERROR'
LC30:	DB	'NON MASKABLE INTR'
LC41:	DB	'OVERFLOW'
LC49:	DB	'INTERRUPT 32'
LC55:	DB	'INTERRUPT 33'
LC61:	DB	'INTERRUPT 34'
LC6D:	DB	'INTERRUPT 35'
LC79:	DB	'INTERRUPT 36'
LC85:	DB	'INTERRUPT 37'
LC91:	DB	'INTERRUPT 38'
LC9D:	DB	'INTERRUPT 39'
LCA9:	DB	'DEMO-86 VER 1.0'
 
@STKFR:	DW	100H
@DATFR: DW	17EH
	EJECT
	SBTTL	MAIN LINE PROGRAM CODE
;	*********************
;	* MAIN PROGRAM CODE *
;	*********************
DEMO86:
	CLI
	MOV	SS,CS:@STKFR	; 280
	MOV	SP,@STKOFF
	MOV	BP,SP
	MOV	DS,CS:@DATFR
	STI
MAINPR:
	MOV	AX,07D0H	; 280
	MOV	SP,AX
	CALL	INTINIT		; 281
	CALL	SIOINIT		; 282
	CALL	SIOGCH		; 283
	CALL	NEWLINE		; 284
	LEA	AX,CS:LCA9	; 285
	PUSH	CS
	PUSH	AX
	MOV	AL,15
	PUSH	AX
	CALL	SIOUTS
NXTCMD:
	MOV	SP,@STKOFF	; 286
	MOV	BP,SP
	MOV	DS,CS:@DATFR
@58:	MOV	AL,0FFH
	RCR	AL,1
	JNB	ERROR
	MOV	AX,7D0H		; 287
	MOV	SP,AX
	CALL	GETCMND		; 288
	MOV	AH,0
	MOV	BX,AX
	SHL	BX,1
	JMP	CS:@60[BX]
@25:	CALL	SIOGO		; 289
	JMP	@58
@26:	CALL	EXAMEM		; 290
	JMP	@58
@27:	CALL	DISPLAY		; 291
	JMP	@58
 
@60:	DW	@25	; BRANCH TABLE
	DW	@26
	DW	@27
	EJECT
;	******************
;	*  COMMAND ERROR *
;	******************
 
ERROR:	MOV	SP,@STKOFF	; 293
	MOV	BP,SP
	MOV	DS,CS:@DATFR
	MOV	AX,7D0H		; 294
	MOV	SP,AX
	MOV	AL,2AH		; 295
	PUSH	AX
	CALL	SIOUTC
	JMP	NXTCMD		; 296
	EJECT
	SBTTL	BASIC I/O CODE SECTION
;	**************************
;	* BASIC I/O CODE SECTION *
;	**************************
 
DELAY:
	ENTER
@28:	CMP	[BP].C,0H
	JBE	@29
 
	SUB	[BP].C,1H	; 14
	JMP	@28	; 15
@29:
	EXIT	2
 
INTINI:
	ENTER
	MOV	AL,37H	; 18
	OUT	0H
	MOV	AL,1H	; 19
	PUSH	AX
	CALL	DELAY
	MOV	AL,0H	; 20
	OUT	2H
	MOV	AL,1H	; 21
	PUSH	AX
	CALL	DELAY
	MOV	AL,1	; 22
	OUT	2H
	EXIT	0
 
 
SIOINI:
	ENTER
	MOV	AL,80H	; 25
	OUT	23H
	MOV	AL,2H	; 26
	PUSH	AX
	CALL	DELAY
	MOV	AL,0H	; 27
	OUT	23H
	MOV	AL,2H	; 28
	PUSH	AX
	CALL	DELAY
	MOV	AL,40H	; 29
	OUT	23H
	MOV	AL,2H	; 30
	PUSH	AX
	CALL	DELAY
	MOV	AL,0CFH	; 31
	OUT	23H
	MOV	AL,2H	;32
	PUSH	AX
	CALL	DELAY
	MOV	AL,25H	; 33
	OUT	23H
 
	EXIT	0
 
SIOUTC:
	ENTER
@30:	IN	23H
	TEST	AL,1H
	JZ	@30
	MOV	AL,[BP].C	; 39
	OUT	21H
	EXIT	2
 
 
SIOUTB:
	PUSH	BP	; 41
	MOV	BP,SP
	MOV	BL,[BP].BB  ; 43
	MOV	CL,4H
	SHR	BL,CL
	AND	BL,0FH
	MOV	BH,0
	PUSH	CS:ASCII[BX]
	CALL	SIOUTC
	MOV	BL,[BP].BB  ; 44
	AND	BL,0FH
	MOV	BH,0H	
	PUSH	CS:ASCII[BX]
	CALL	SIOUTC
	POP	BP	; 45
	RET	2H
 
 
SIOUTW:
	PUSH	BP	; 46
	MOV 	BP,SP
	MOV	AX,[BP].W	; 48
	MOV	AL,AH
	PUSH	AX
	CALL	SIOUTB
	MOV	AX,[BP].W	;49
	PUSH	AX
	CALL	SIOUTB
	POP	BP		; 50
	RET	2H
 
 
SIOUTS:
	PUSH	BP		; 51
	MOV	BP,SP
	MOV	I2,0H		; 53
@32:	MOV	AL,[BP].N
	SUB	AL,1H
	CMP	I2,AL
	JA	@33
	MOV	AL,I2		; 54
	MOV	AH,0H
	MOV	SI,AX
	LES	BX,[BP].STRPTR
	PUSH	ES:[BX].STR[SI]
	CALL	SIOUTC
	ADD	I2,1		; 55
	JNZ	@32
@33:	POP	BP		; 56
	RET	6H
 
 
SIOGCH:
	PUSH	BP		; 57
	MOV	BP,SP
@34:	IN	23H
	TEST	AL,2H
	JZ	@34
	IN	21H		; 60
	AND	AL,7FH
	MOV	CHAR,AL
	CMP	AL,20H		; 61
	JB	@1
	PUSH	CHAR		; 62
	CALL	SIOUTC
@1:	POP	BP		; 63
	RET
 
 
VALHEX:
	PUSH	BP		; 64
	MOV	BP,SP
	MOV	CL,30H		; 66
	MOV	AL,[BP].H
	CMP	CL,AL
	MOV	AL,0FFH
	JBE	$+3
	INC	AX
	MOV	CL,[BP].H
	PUSH	AX
	CMP	CL,39H
	MOV	AL,0FFH
	JBE	$+3H
	INC	AX
	POP	DX
	AND	AL,DL
	MOV	DL,41H
	PUSH	AX
	CMP	DL,CL
	MOV	AL,0FFH
	JBE	$+3
	INC 	AX
	PUSH	AX
	CMP	CL,46H
	MOV	AL,0FFH
	JBE	$+3H
	INC	AX
	POP	CX
	AND	AL,CL
	POP	CX
	OR	AL,CL
	RCR	AL,1
	JNB	@2
	MOV	AL,0FFH		; 67
	JMP	@31
@2:	MOV	AL,0		; 68
@31:	EXIT	2
 
 
SIOHEX:
	PUSH	BP		; 70
	MOV	BP,SP
	MOV	AL,[BP].C	; 72
	SUB	AL,30H
	MOV	[BP].C,AL
	CMP	AL,9		; 73
	JA	@4
	MOV	AL,[BP].C	; 74
	JMP	@3
@4:	MOV	AL,[BP].C	; 75
	SUB	AL,7
@3:	POP	BP		; 76
	RET	2
 
 
GETBYT:
	PUSH	BP		; 77
	MOV	BP,SP
	PUSH	CHAR		; 79
	CALL	VALHEX
	NOT	AL
	RCR	AL,1
	JNB	$+5
	JMP	ERROR
	MOV	B,0		; 81
@36:	PUSH	CHAR		; 82
	CALL	VALHEX
	RCR	AL,1
	JNB	@37
	MOV	AL,B		; 83
	MOV	CL,4
	SHL	AL,CL
	PUSH 	AX
	PUSH	CHAR
	CALL	SIOHEX
	POP	CX
	ADD	AL,CL
	MOV	B,AL
	CALL	SIOGCH		; 84
	JMP	@36		; 85
@37:	MOV	AL,CHAR		; 86
	CMP	AL,0DH
	MOV	AL,0FFH
	JZ	$+3
	INC	AX
	PUSH	AX
	CMP	CHAR,20H
	MOV	AL,0FFH
	JZ	$+3
	INC 	AX
	POP	CX
	OR	AL,CL
	PUSH	AX
	CMP	CHAR,2CH
	MOV	AL,0FFH
	JZ	$+3H
	INC 	AX
	POP 	CX
	OR	AL,CL
	RCR	AL,1
	JB	$+5
	JMP	ERROR
	MOV	AL,B		; 87
	POP	BP
	RET	
 
 
GETWRD:
	PUSH	BP		; 90
	MOV	BP,SP
	MOV	OPER,2BH	; 92
	MOV	WW,0		; 93
	MOV	SAVE,0		; 94
@38:	MOV	AL,0FFH		; 95
	RCR	AL,1
	JB	$+5
	JMP	@39	
@40:	PUSH	CHAR		; 96
	CALL	VALHEX
	RCR	AL,1
	JNB	@41
	MOV	AX,SAVE		; 97	
	MOV	CL,4
	SHL	AX,CL
	PUSH	AX	
	PUSH	CHAR
	CALL	SIOHEX
	MOV	AH,0
	POP	CX
	ADD	AX,CX
	MOV	SAVE,AX
	CALL	SIOGCH		; 98
	JMP	@40		; 99
@41:	CMP	OPER,2BH	; 100
	JNZ	@8
	MOV	AX,SAVE		; 101
	ADD	WW,AX
	JMP	@9
@8:	MOV	AX,SAVE		; 102
	SUB	WW,AX
@9:	MOV	AL,CHAR		; 103
	CMP	AL,0DH
	MOV	AL,0FFH
	JZ	$+3
	INC	AX
	MOV	CL,CHAR
	PUSH	AX
	CMP	CL,3AH
	MOV	AL,OFFH	
	JZ	$+3
	INC	AX
	POP	DX
	OR	AL,DL
	PUSH	AX
	CMP	CL,2CH
	MOV	AL,0FFH
	JZ	$+3
	INC 	AX
	POP	DX
	OR	AL,DL
	PUSH	AX
	CMP	CL,20H
	MOV	AL,OFFH
	JZ	$+3
	INC	AX
	POP	CX	
	OR	AL,CL
	RCR	AL,1
	JNB	@10
	MOV	AX,WW		; 104
	POP	BP
	RET
@10:	CMP	CHAR,2BH	;105
	MOV	AL,OFFH		
	JZ	$+3H
	INC	AX
	PUSH	AX
	CMP	CHAR,2DH
	MOV	AL,0FFH
	JZ	$+3
	INC	AX
	POP	CX	
	OR	AL,CL
	RCR	AL,1
	JB	$+5
	JMP	ERROR
	MOV	AL,CHAR		; 107
	MOV	OPER,AL	
	MOV	SAVE,0		; 108
	CALL	SIOGCH		; 111
	JMP	@38		; 112
@39:	POP	BP		; 113
	RET
 
 
GETADDR:
	PUSH	BP		; 114
	MOV	BP,SP
	MOV	AX,[BP].DEFBAS	; 116
@5:	MOV	ARG1+2,AX
	CALL	GETWRD		; 117
	MOV	ARG1,AX
	CMP	CHAR,3AH	; 118
	JNZ	@@43
	CALL	SIOGCH		; 119
	MOV	AX,ARG1		; 120
	JMP	@5
@@43:	POP	BP		; 122
	RET	2H
  
	EJECT
	SBTTL	UTILITY MODULES
;
;	*************
;	* UTILITIES *
;	*************
SIOBLNKS:
	PUSH	BP		; 124
	MOV	BP,SP
	MOV	I1,1		; 126
@44:	MOV	AL,I1	
	CMP	AL,[BP].N
	JA	@45
	MOV	AL,20H		; 127
	PUSH	AX
	CALL	SIOUTC
	ADD	I1,1		; 128
	JNZ	@44
@45:	POP	BP		; 129
	RET	2
 
 
SIOCRLF:
	PUSH	BP		; 130
	MOV	BP,SP
	MOV	AL,ASCR		; 131
	PUSH	AX
	CALL	SIOUTC
	MOV	AL,0AH		; 132
	PUSH	AX
	CALL	SIOUTC
	POP	BP		; 133
	RET
 
 
NEWLINE:
	PUSH	BP		; 134
	MOV	BP,SP
	CALL	SIOCRLF		; 135
	MOV	AL,2		; 136
	PUSH	AX
	CALL	SIOBLNKS
	POP	BP		; 137
	RET
	EJECT
	SBTTL	COMMAND PARSING ROUTINES
;
;	*********************
;	* COMMANDS ROUTINES *
;	*********************
SIOGO:
	PUSH	BP		; 138
	MOV	BP,SP
@6:	CALL	SIOGCH		; 139
	CMP	CHAR,ASBL
	JZ	@6
	MOV	AX,0		; 143
	PUSH	AX
	CALL	GETADDR
	CMP	CHAR,ASCR	; 144
	JZ	$+5
	JMP	ERROR
	CALL	SIOCRLF		; 146
	CALL	^ARG1		; 147
	POP	BP		; 148
	RET
 
 
EXAMEM:
	PUSH	BP		; 149
	MOV	BP,SP
@7:	CALL	SIOGCH		; 151
	CMP	CHAR,ASBL
	JZ	@7		; 152
	MOV	AX,0		; 155
	PUSH	AX
	CALL	GETADDR	
	CMP	CHAR,ASCR	; 156
	JZ	$+5	
	JMP	ERROR
@50:	MOV	AL,0FFH		; 157
	RCR	AL,1
	JB	$+5
	JMP	@51
	CALL	NEWLINE		; 159
	PUSH	ARG1		; 160
	CALL	SIOUTW
	MOV	AL,'-'		; 161
	PUSH	AX
	CALL	SIOUTC	
	LES	BX,ARG1		; 162
	PUSH	ES:ARG1[BX]
	CALL	SIOUTB
	MOV	AL,'-'		; 163
	PUSH	AX
	CALL	SIOUTC
	CALL	SIOGCH		; 164
	MOV	AL,CHAR		; 165
	CMP	AL,','
	MOV	AL,0FFH
	JNZ	$+3
	INC	AX
	PUSH	AX
	CMP	CHAR,ASBL
	MOV	AL,0FFH
	JNZ	$+3
	INC	AX
	POP	CX
	AND	AL,CL
	PUSH	AX
	CMP	CHAR,ASCR
	MOV	AL,0FH
	JNZ	$+3
	INC	AX
	POP	CX
	AND	AL,CL
	RCR	AL,1
	JNB	@15
	CALL	GETBYT		; 167
	MOV	T,AL
	MOV	AL,T		; 168
	LES	BX,ARG1
	MOV	ES:ARG1[BX],AL
	LES	BX,ARG1		; 169
	MOV	AL,ES:ARG1[BX]
	CMP	AL,T
	JZ	@15
	MOV	AL,2		; 170
	PUSH	AX
	CALL	SIOBLNKS
	LEA	AX,CS:LC13	; 172
	PUSH	CS	 
	PUSH	AX
	MOV	AL,11H
	PUSH	AX
	CALL	SIOUTS
	JMP	ERROR		; 173
@15:	ADD	ARG1,1		; 176
	JMP	@50		; 177
@51:	POP	BP
	RET
 
 
DISPLAY:
	PUSH	BP		; 179
	MOV	BP,SP
@11:	CALL	SIOGCH		; 181
	CMP	CHAR,ASBL	; 182
	JZ	@11	
	MOV	AX,0		; 185
	PUSH	AX
	CALL	GETADDR
	CMP	CHAR,ASCR	; 186
	JNZ	@17
	MOV	COUNT,1		; 187
	JMP	@18
@17:	CMP	CHAR,':'	; 189
	JNZ	$+5
	JMP	ERROR
	CALL	SIOGCH		; 191
	CALL	GETWRD		; 192
	MOV	COUNT,AX
	CMP	CHAR,ASCR	; 193
	JZ	$+5
	JMP	ERROR
@18:	CALL 	NEWLINE		; 196
	PUSH	ARG1		; 197
	CALL	SIOUTW
	MOV	AL,3		; 198
	PUSH	AX
	CALL	SIOBLNKS
	CMP	COUNT,1		; 199
	JBE	@54
	MOV	AX,ARG1		; 200
	AND	AX,0FFH
	MOV	CX,3H
	MUL	CX
@12:	PUSH	AX
	CALL	SIOBLNKS
@54:	CMP	COUNT,0		; 201
	JBE	@55
	LES	BX,ARG1		; 202
	PUSH	ES:ARG1[BX]
	CALL	SIOUTB
	MOV	AL,' '		; 203
	PUSH	AX
	CALL	SIOUTC
	ADD	ARG1,1		; 204
	MOV	AX,COUNT	; 205
	SUB	AX,1
	MOV	COUNT,AX
	OR	AX,AX		; 206
	MOV	AL,OFFH
	JA	$+3
	INC	AX
	MOV	CX,ARG1
	AND	CX,0FH
	PUSH	AX
	OR	CX,CX
	MOV	AL,0FFH
	JZ	$+3
	INC	AX
	POP	CX
	AND 	AL,CL
	RCR	AL,1
	JNB	@54
	CALL	NEWLINE		; 208
	PUSH	ARG1		; 209
	CALL	SIOUTW		; 
	MOV	AL,3H		; 210
	JMP	@12
@55:	POP	BP		; 213
	RET
	EJECT
	SBTTL	INTERRUPT SERVICE SECTION
;	*****************************
;	* INTERRUPT SERVICE SECTION *
;	*****************************
 
DIVERR:
	INTSVC	LC24,12
	JMP	NXTCMD
 
 
NMI:				; 214
	INTSVC	LC30,17
	CALL	NEWLINE		; 220
	POP	BP		; 221
	RET
  
  
OFLERR:				; 223
	INTSVC	LC41,8
	JMP	NXTCMD		; 225
 
 
INT32:				; 227
	INTSVC	LC49,12
	CALL	NEWLINE		; 229
	POP	BP
	RET			; 231
 
	MACLST
INT33:				; 232
	INTSVC	LC55,12
	CALL	NEWLINE		; 234
	POP	BP
	RET
  
 
INT34:				; 238
	INTSVC	LC61,12
	CALL	NEWLINE		; 242
	POP	BP
	RET
 
	MACOFF
 
INT35:				; 243
	INTSVC  LC6D,12
	CALL	NEWLINE		; 245
	POP	BP
	RET
 
 
INT36:
	INTSVC	LC79,12
	CALL	NEWLINE		; 250
	POP	BP
	RET
 
 
INT37:				; 254
	INTSVC	LC85,12
	CALL	NEWLINE		; 257
	POP	BP
	RET
 
 
INT38:				; 259
	INTSVC	LC91,12
	CALL	NEWLINE		; 263
	POP	BP
	RET
 
 
INT39:				; 264
	INTSVC	LC9D,12
	CALL	NEWLINE		; 267
	POP	BP
	RET
	EJECT
	SBTTL	COMMAND DISPATCH MODULE
;
;	*****************************************
;	*					*
;	*	COMMAND DISPATCH MODULE		*
;	*	=======================		*
;	*					*
;	*****************************************
 
GETCMND:
	ENTER
	CALL	SIOCRLF		; 271
	MOV	AL,'.'		; 272
	PUSH	AX
	CALL	SIOUTC
	CALL	SIOGCH		; 273
	MOV	I3,0		; 274
@56:	CMP	I3,2
	JBE	$+5
	JMP	ERROR
	MOV	AL,CHAR		; 275
	MOV	BL,I3
	MOV	BH,0
	CMP	AL,CS:SIOCMD[BX]
	JNZ	@23
	MOV	AL,I3		; 276
	EXIT	0
 
@23:	ADD	I3,1		; 277
	JNZ	@56
	JMP	ERROR		; 278
 
	END	DEMO86
 