  Program MatrixInversion;

(* This Pascal program is a translation of three algorithms
  from the COLLECTED ALGORITHMS OF THE ACM, used for a 
  comparison to corresponding programs translated into
  FORTRAN and BASIC.

  ALGORITHM 52 - A Set of Test Matrices
                 John R. Herndon - April 1961 pp. 180

  ALGORITHM 230- Matrix Permutation
                 J. Boothroyd - Vol 7, Number 6, June, 1964, pp. 347

  ALGORITHM 231- Matrix Inversion
                 J. Boothroyd - Vol 7, Number 6, June, 1963, pp. 347

*)

CONST
  Epsilon 	=	 1E-6;

TYPE
  MatrixIndex 	=	 0..50;
  Matrix 	=	 ARRAY[MatrixIndex,MatrixIndex] OF Real;
  Vector	=	 ARRAY[MatrixIndex] OF Integer;

VAR
  Starter	:	char;
  a		:	Matrix;
  n		:	MatrixIndex;
  Singular	:	Boolean;

  PROCEDURE InvertMatrix(VAR a:Matrix; n:MatrixIndex;
                         Epsilon:Real;VAR Sing:Boolean);
(* ALGORITHM 231 -
This procedure inverts a matrix in its own space  using
the Gauss-Jordan method with complete matrix pivoting. I.e.
at each stage the pivot has the largest absolute value of
any element in the remaining matrix. The coordinates of the
successive matrix pivots used at each stage of the reduction
are recorded in the successive element positions of the row 
and column index vectors, r and c. These are later used by a 
specific modification of algorithm 230  to rearrange the rows
and columns of the matrix. 
*)
  LABEL    1;
  VAR
    i,j,k,l,
    pivi,pivj,p,t	:	Integer;
    pivot,w		:	Real;
    r,c,Tag,Loc		:	Vector;

   BEGIN(*InvertMatrix*)
     (*Set Row and Column Vectors.*)
     FOR i := 1 TO n DO BEGIN
	r[i] := i; c[i] := i
        END ;

     (*Find initial pivot. *)
     pivi := 1; pivj := 1;
     FOR i:= 1 TO n DO
        FOR j:= 1 TO n DO
           IF abs(a[i,j]) > abs(a[pivi,pivj]) THEN BEGIN
              pivi := i; pivj := j
              END ;

     (*Start reduction.*)
     FOR i:= 1 TO n DO BEGIN
	l := r[i]; r[i] := r[pivi]; r[pivi] := l;
	l := c[i]; c[i] := c[pivj]; c[pivj] := l;
	IF Epsilon> abs(a[r[i],c[i]]) THEN BEGIN
	    sing := true;goto 1;
            END;
	FOR j:= n DOWNTO 1 DO
           IF j<>i THEN a[r[i],c[j]] := a[r[i],c[j]] / a[r[i],c[i]];
	a[r[i],c[i]] := 1.0 / a[r[i],c[i]];
	pivot := 0;
	FOR k:= 1 TO n DO
         IF k <> i THEN BEGIN
	    FOR j := n DOWNTO 1 DO
                  IF j <> i THEN BEGIN
                    a[r[k],c[j]] := a[r[k],c[j]]-a[r[i],c[j]]*a[r[k],c[i]];
                    IF (k>i) THEN
                      IF (j>i) THEN
                         IF (abs(a[r[k],c[j]]) >= abs(pivot)) THEN BEGIN
                            pivi := k;  pivj := j;  pivot := a[r[k],c[j]];
                            END(*if*)
                    END(*if,for*);
	    a[r[k],c[i]] := - a[r[i],c[i]] * a[r[k],c[i]]
            END(*for-k*)
        END(*for-i, reduction*);


     (* The following program parts represent two
     specific calls to algorithm 230.
     *)
     (*Now rearrange Row.*)
     FOR i := 1 TO n DO BEGIN
	Tag[i] :=  i; Loc[i] :=i;
        END;
     FOR i := 1 TO n DO BEGIN
	t := r[i]; j := Loc[t]; k := c[i];
	IF j<>k THEN BEGIN
          FOR p := 1 TO n DO BEGIN
             w := a[j,p];  a[j,p] := a[k,p];  a[k,p] := w;
             END;
          Tag[j] := Tag[k]; Tag[k] := t;
          Loc[t] := Loc[Tag[j]]; Loc[Tag[j]] := j;
          END;
        END;

     (* Now rearrange columns.*)
     FOR i := 1 TO n DO BEGIN
	Tag[i] := i;  Loc[i] := i;
        END;
     FOR i := 1 TO n DO BEGIN
	t := c[i]; j := Loc[t];	k := r[i];
	IF j<>k THEN BEGIN
	    FOR p:= 1 TO n DO BEGIN
	       w := a[p,j]; a[p,j] := a[p,k];  a[p,k] := w;
               END;
  	    Tag[j] := Tag[k]; Tag[k] := t; Loc[t] := Loc[Tag[j]];
	    Loc[Tag[j]] := j;
            END
        END;
   1:END(*InvertMatrix*);
  PROCEDURE  BuildTestMatrix(n:MatrixIndex;VAR a:Matrix);
(* Algorithm 52 -
This procedure places in  A  an  n by n  matrix
whose inverse and eigenvalues are known. The n-th
row and the n-th column of the inverse are the set:
1,2,3,...,n. The matrix formed by deleting the n-th
row and the n-th column of the inverse is the identity
matrix of order n-1.
 *)
  VAR
    i,j	:	Integer;
    c,d	:	Real;
   BEGIN
     c := n*(n+1.0)*(n+n-5.0)/6.0;  d := 1.0/c;  a[n,n] := -d;
     FOR i:= 1 TO n-1 DO BEGIN
	a[n,i] := d*i;	a[i,n] := a[n,i];  a[i,i] := d*(c-i*i);
	FOR j := 1 TO i-1 DO BEGIN
	   a[j,i] := -d*i*j;  a[i,j] := a[j,i]
           END;
        END;
   END(*BuildTestMatrix*);

 BEGIN(*main*)
   n := 50 (*preset size of Matrix to maximum*);
   BuildTestMatrix(n,a);
   Write('.'); read(starter);
   InvertMatrix(a,n,Epsilon,singular);
 END.
 